/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.ui.WcmInstrTextArea;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WcmOSChooserDialog
extends VWModalDialog
implements ActionListener {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected int m_status = 2;
    private Container m_contentPane = null;
    private JPanel m_instrPanel = null;
    private VWAddRemovePanel m_addRemovePanel = null;
    private Object[] m_selection = null;
    private Vector m_availLibs = null;
    private JButton m_OKButton = new JButton(WcmResourceString.s_ok);
    private JButton m_cancelButton = new JButton(WcmResourceString.s_cancel);

    public WcmOSChooserDialog(Frame parent) {
        super(parent);
    }

    public void init(Vector libs) {
        this.m_contentPane = this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout(10, 0));
        this.setTitle(WcmResource.s_invalidLib);
        this.m_availLibs = (Vector)libs.clone();
        Dimension dim = WcmStringUtil.stringToDimension(WcmResource.s_invalidOSDialogDim);
        if (dim == null) {
            dim = new Dimension(550, 300);
        }
        this.setSize(dim);
        this.setVisible(false);
        this.m_addRemovePanel = new VWAddRemovePanel(10);
        this.m_addRemovePanel.setAvailableItemName(WcmResource.s_availLibsStr);
        this.m_addRemovePanel.setSelectedItemName(WcmResource.s_selectedLibsStr);
        this.m_addRemovePanel.initializeLists(libs.toArray(), null);
        this.m_contentPane.add("Center", (Component)this.m_addRemovePanel);
        JPanel buttonPanel = new JPanel();
        this.m_OKButton.setSelected(true);
        buttonPanel.add(this.m_OKButton);
        buttonPanel.add(this.m_cancelButton);
        this.getRootPane().setDefaultButton(this.m_OKButton);
        this.m_contentPane.add("South", buttonPanel);
        this.m_OKButton.addActionListener(this);
        this.m_cancelButton.addActionListener(this);
        this.m_status = 2;
    }

    public void reset() {
        this.m_addRemovePanel.initializeLists(this.m_availLibs.toArray(), null);
    }

    public void setBadOSName(String badOSName) {
        if (this.m_instrPanel != null) {
            this.m_contentPane.remove(this.m_instrPanel);
        }
        this.m_instrPanel = new JPanel(new GridBagLayout());
        String iStr = new String(WcmResource.s_libDoesntExist.toString(badOSName) + "  " + WcmResource.s_OSChooserMsg);
        WcmInstrTextArea instrText = new WcmInstrTextArea(iStr);
        instrText.setBackground(this.getBackground());
        this.m_instrPanel.add((Component)instrText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.m_contentPane.add("North", this.m_instrPanel);
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public int getStatus() {
        return this.m_status;
    }

    public Object[] getSelection() {
        return this.m_selection;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_OKButton) {
            this.m_status = 1;
            this.m_selection = this.m_addRemovePanel.getSelectedItems();
            this.setVisible(false);
        } else if (event.getSource() == this.m_cancelButton) {
            this.m_status = 2;
            this.m_selection = null;
            this.setVisible(false);
        }
    }
}

