/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.Domain;
import com.filenet.wcm.api.Domains;
import com.filenet.wcm.api.EntireNetwork;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.client.search.ui.IWcmFileEventListener;
import com.filenet.wcm.apps.client.search.ui.IWcmModifyEventListener;
import com.filenet.wcm.apps.client.search.ui.WcmFileOpenEvent;
import com.filenet.wcm.apps.client.search.ui.WcmFileSaveEvent;
import com.filenet.wcm.apps.client.search.ui.WcmInstrTextArea;
import com.filenet.wcm.apps.client.search.ui.WcmLibraryAddRemovePanel;
import com.filenet.wcm.apps.client.search.ui.WcmModifyEvent;
import com.filenet.wcm.apps.client.search.ui.WcmOSChooserDialog;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSearchLibrary;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.util.ObjectStoreFilteringUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WcmLibraryPanel
extends JPanel
implements IWcmFileEventListener {
    private JPanel m_instrPanel = new JPanel(new GridBagLayout());
    private WcmInstrTextArea m_instrText = new WcmInstrTextArea(WcmResource.s_libraryInstrStr);
    private WcmLibraryAddRemovePanel m_addRemovePanel;
    private Session m_session = null;
    private Container m_mainContainer = null;
    private ObjectStores m_libs = null;
    private boolean m_libsChanged = false;
    private Vector m_modifyEventListeners = new Vector();
    public WcmSearchAuthCore m_parent = null;
    private WcmOSChooserDialog m_osDlg = null;
    private boolean m_fileOpened = false;
    private ObjectStoreFilteringUtil m_objectStoreFilter = new ObjectStoreFilteringUtil("");

    public WcmLibraryPanel(WcmSearchAuthCore parent) {
        try {
            this.m_parent = parent;
            this.setLayout(new BorderLayout());
            this.m_instrText.setBackground(this.getBackground());
            this.m_instrPanel.add((Component)this.m_instrText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.add("First", this.m_instrPanel);
            this.add("After", new JPanel());
            this.add("Before", new JPanel());
            this.m_addRemovePanel = new WcmLibraryAddRemovePanel(this, 10, this.m_parent);
            this.m_addRemovePanel.setAvailableItemName(WcmResource.s_availLibsStr);
            this.m_addRemovePanel.setSelectedItemName(WcmResource.s_selectedLibsStr);
            this.add("Center", (Component)((Object)this.m_addRemovePanel));
            this.add("Last", new JPanel());
            this.m_osDlg = new WcmOSChooserDialog(this.m_parent.getParentFrame());
        }
        catch (Exception e) {
            System.out.println("Caught an error in WcmLibraryPanel(): " + e.getMessage());
        }
    }

    public void updateEnvironment(Object[] list) {
        if (list.length > 0) {
            this.m_parent.enableAddNewAction(true);
            this.fireModifyEvent();
        } else {
            this.m_parent.enableAddNewAction(false);
        }
        this.m_libsChanged = true;
    }

    public void setMainContainer(Container mainContainer) {
        this.m_mainContainer = mainContainer;
    }

    public void setSession(Session session) throws WcmException {
        try {
            this.m_session = session;
            if (this.m_session != null) {
                EntireNetwork net = ObjectFactory.getEntireNetwork((Session)session);
                Domains doms = net.getDomains();
                Iterator it = doms.iterator();
                Domain dom = (Domain)it.next();
                this.m_libs = dom.getObjectStores();
                if (this.m_libs.size() <= 0) {
                    JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_noLibsAvail);
                    return;
                }
                this.m_libs = this.filterObjectStore(this.m_libs);
                PropertyUtil util = new PropertyUtil();
                this.m_libs = PropertyUtil.sort(this.m_libs);
                if (this.m_parent.getNetworkItem() != null) {
                    this.m_parent.getNetworkItem().initObjectStores(this.m_libs);
                }
                this.m_addRemovePanel.initializeLists(this.m_libs, null);
                this.m_libsChanged = true;
                this.m_addRemovePanel.requestFocus();
                this.m_osDlg.init(this.m_addRemovePanel.getAvailableList());
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmLibraryPanel.errorInSession", "An error occurred setting the session: {0}", (Object)e.getMessage());
        }
    }

    public void setObjectStoreFilterList(String objectStoreFilterList) {
        this.m_objectStoreFilter.setObjectStoreFilterList(objectStoreFilterList);
    }

    private ObjectStores filterObjectStore(ObjectStores libs) throws WcmException {
        try {
            if (this.m_objectStoreFilter != null && this.m_objectStoreFilter.isInit()) {
                return this.m_objectStoreFilter.filterObjectStores(libs);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmLibraryPanel.errorInFilterObjectStores", "An error occurred filtering objectstores: {0}", (Object)e.getMessage());
        }
        return libs;
    }

    public boolean oracleOSIncluded() throws WcmException {
        String itemName = null;
        try {
            Object[] list = this.m_addRemovePanel.getSelectedItems();
            if (list.length > 0) {
                for (int i = 0; i < list.length; ++i) {
                    VerboseLibrary item = (VerboseLibrary)list[i];
                    itemName = item.getName();
                    if (!item.isOracle()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            throw new WcmException("client.WcmLibraryPanel.supportsContentSearching", "{0}", (Object)ex.getMessage());
        }
    }

    public Vector getLibraryList() {
        Vector<Object> libs = new Vector<Object>();
        Object[] list = this.m_addRemovePanel.getSelectedItems();
        if (list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                libs.addElement(list[i]);
            }
        }
        this.m_libsChanged = false;
        return libs;
    }

    public int isMultiOS() {
        int retVal = 0;
        Object[] list = this.m_addRemovePanel.getSelectedItems();
        if (list.length > 1) {
            retVal = 2;
        } else if (list.length == 1) {
            retVal = 1;
        }
        list = null;
        return retVal;
    }

    public boolean hasLibSelectionChanged() {
        return this.m_libsChanged;
    }

    public boolean isFileOpened() {
        return this.m_fileOpened;
    }

    public void clear() {
        try {
            if (this.m_libs != null) {
                this.m_addRemovePanel.initializeLists(this.m_libs, null);
                this.m_libsChanged = true;
                this.fireUnModifyEvent();
            }
            this.m_fileOpened = false;
        }
        catch (Exception e) {
            System.out.println("Caught error in clear(): " + e.getMessage());
        }
    }

    private void setSelectedLibraryList(Vector libs) throws WcmException {
        if (libs != null) {
            ObjectStore libObj = null;
            ObjectStores libCollection = ObjectFactory.getObjectStores();
            StringBuffer badLibList = null;
            for (WcmSearchLibrary lib : libs) {
                try {
                    libObj = ObjectFactory.getObjectStore((String)lib.getId(), (Session)this.m_session);
                    String name = libObj.getName();
                    libCollection.add((Object)libObj);
                }
                catch (Exception e) {
                    if (badLibList == null) {
                        badLibList = new StringBuffer(lib.getName());
                        continue;
                    }
                    badLibList.append(", ");
                    badLibList.append(lib.getName());
                }
            }
            if (badLibList != null) {
                this.m_osDlg.setBadOSName(badLibList.toString());
                this.m_osDlg.setVisible(true);
                Object[] libsSelected = this.m_osDlg.getSelection();
                this.m_osDlg.reset();
                if (libsSelected.length == 0) {
                    JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_noSelectedLibs + "\n" + WcmResource.s_cantOpenSearch);
                    throw new WcmException("client.WcmLibraryPanel.noOS", "No object stores selected.");
                }
                for (int i = 0; i < libsSelected.length; ++i) {
                    VerboseLibrary vLib = (VerboseLibrary)libsSelected[i];
                    if (vLib == null) continue;
                    try {
                        libObj = ObjectFactory.getObjectStore((String)vLib.getId(), (Session)this.m_session);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_libDoesntExist.toString(vLib.getName()) + "\n" + WcmResource.s_cantOpenSearch);
                        throw new WcmException("client.WcmLibraryPanel.invalidOS", "Invalid object store: {0}.", (Object)vLib.getName());
                    }
                    libCollection.add((Object)libObj);
                }
            }
            this.m_addRemovePanel.initializeLists(this.m_libs, libCollection);
            this.updateEnvironment(this.m_addRemovePanel.getSelectedItems());
            this.m_libsChanged = true;
        }
    }

    public void fileOpened(WcmFileOpenEvent event) {
        try {
            Vector libs = event.getFile().getLibraries();
            this.setSelectedLibraryList(libs);
            this.m_libsChanged = true;
            this.m_fileOpened = true;
            this.m_parent.updatePropertyList();
            this.m_parent.updateSelectedLibs();
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmLibraryPanel::fileOpened(): " + e.getMessage());
            this.clear();
        }
    }

    public void fileSave(WcmFileSaveEvent event) {
        this.m_fileOpened = false;
    }

    public void addModifyEventListener(IWcmModifyEventListener listener) {
        this.m_modifyEventListeners.addElement(listener);
    }

    public void removeModifyEventListener(IWcmModifyEventListener listener) {
        this.m_modifyEventListeners.removeElement(listener);
    }

    public void fireModifyEvent() {
        WcmModifyEvent event = new WcmModifyEvent(this);
        for (int i = 0; i < this.m_modifyEventListeners.size(); ++i) {
            ((IWcmModifyEventListener)this.m_modifyEventListeners.elementAt(i)).tabModified(event);
        }
    }

    public void fireUnModifyEvent() {
        WcmModifyEvent event = new WcmModifyEvent(this);
        for (int i = 0; i < this.m_modifyEventListeners.size(); ++i) {
            ((IWcmModifyEventListener)this.m_modifyEventListeners.elementAt(i)).tabUnModified(event);
        }
    }

    public boolean isLibrarySelected(String libName) {
        Vector libs = new Vector();
        Object[] list = this.m_addRemovePanel.getSelectedItems();
        if (list.length > 0) {
            for (int i = 0; i < list.length; ++i) {
                if (!((VerboseLibrary)list[i]).getName().equalsIgnoreCase(libName)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetLibsChangedFlag(boolean val) {
        this.m_libsChanged = val;
    }
}

