/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.apps.client.search.ui.WcmLibraryPanel;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JOptionPane;

public class WcmLibraryAddRemovePanel
extends VWAddRemovePanel {
    private WcmLibraryPanel m_parent;
    private WcmSearchAuthCore m_grandParent;
    private Vector m_availList = new Vector();

    public WcmLibraryAddRemovePanel(WcmLibraryPanel parent, int nFlags, WcmSearchAuthCore grandParent) {
        super(nFlags);
        this.m_parent = parent;
        this.m_grandParent = grandParent;
        this.setListCellRenderer(new DefaultListCellRenderer());
        this.enableSorting(1280);
    }

    public void initializeLists(ObjectStores avail, ObjectStores sel) {
        try {
            Iterator it = null;
            Vector<String> availListOfNames = new Vector<String>();
            boolean counter = true;
            ObjectStore lib2 = null;
            VerboseLibrary vLib = null;
            this.m_availList = new Vector();
            Vector<VerboseLibrary> selList = new Vector<VerboseLibrary>();
            if (avail != null) {
                for (ObjectStore lib2 : avail) {
                    try {
                        vLib = new VerboseLibrary(lib2);
                        this.m_availList.addElement(vLib);
                        availListOfNames.addElement(vLib.getName());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.m_grandParent.getParentFrame(), e.getMessage());
                    }
                }
            }
            if (sel != null) {
                int index = 0;
                for (ObjectStore lib2 : sel) {
                    try {
                        vLib = new VerboseLibrary(lib2);
                        selList.addElement(vLib);
                        index = availListOfNames.indexOf(vLib.getName());
                        if (index == -1) continue;
                        this.m_availList.remove(index);
                        availListOfNames.remove(index);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.m_grandParent.getParentFrame(), e.getMessage());
                    }
                }
            }
            super.initializeLists(this.m_availList.toArray(), selList.toArray());
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmLibraryAddRemovePanel::initializeLists(): " + e.getMessage());
        }
    }

    public Vector getAvailableList() {
        return (Vector)this.m_availList.clone();
    }

    private void handleEvents() {
        try {
            StringBuffer errorMsg = new StringBuffer(WcmResource.s_invalidOSList);
            boolean foundInvalidOS = false;
            Object[] list = this.getSelectedItems();
            Vector<VerboseLibrary> selList = new Vector<VerboseLibrary>();
            this.m_grandParent.setStatusBarMsg(WcmResource.s_validatingLibs);
            this.m_grandParent.setWaitCursor();
            for (int i = 0; i < list.length; ++i) {
                VerboseLibrary vLib = (VerboseLibrary)list[i];
                if (!vLib.isValid()) {
                    foundInvalidOS = true;
                    errorMsg.append("\n    ");
                    errorMsg.append(vLib.getName());
                    if (!this.m_availList.contains(vLib)) continue;
                    this.m_availList.remove(vLib);
                    continue;
                }
                selList.add(vLib);
            }
            if (foundInvalidOS) {
                JOptionPane.showMessageDialog(this.m_grandParent.getParentFrame(), errorMsg.toString(), WcmResource.s_searchAuthStr, 0);
                super.initializeLists(this.m_availList.toArray(), selList.toArray());
            }
            this.m_grandParent.setDefaultCursor();
            this.m_grandParent.performClearProperties(selList.size() == 0);
            this.m_parent.updateEnvironment(selList.toArray());
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmLibraryAddRemovePanel::handleEvents(): " + e.getMessage());
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object object = event.getSource();
            if (!this.m_grandParent.askUserToSavePropertiesOrCancel(false)) {
                return;
            }
            super.actionPerformed(event);
            this.handleEvents();
        }
        catch (Exception e) {
            System.out.println("Caught an error in actionPerformed(): " + e.getMessage());
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        try {
            if (!this.m_grandParent.askUserToSavePropertiesOrCancel(false)) {
                return;
            }
            super.doubleClickedItem(event);
            this.handleEvents();
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmLibraryAddRemovePanel::doubleClickedItem(): " + e.getMessage());
        }
    }

    public void requestFocus() {
        this.m_availableList.requestFocus();
        this.m_availableList.setSelectedIndex(0);
    }
}

