/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.ui.IWcmFileEventListener;
import com.filenet.wcm.apps.client.search.ui.IWcmModifyEventListener;
import com.filenet.wcm.apps.client.search.ui.WcmFileSaveEvent;
import com.filenet.wcm.apps.client.search.ui.WcmInstrTextArea;
import com.filenet.wcm.apps.client.search.ui.WcmModifyEvent;
import com.filenet.wcm.apps.client.search.ui.WcmPasteXML;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import filenet.vw.toolkit.utils.datatransfer.IVWCBData;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class WcmGenericTablePanel
extends JPanel
implements IWcmFileEventListener,
TableModelListener,
KeyListener {
    protected final int HEIGHT_OFFSET = 2;
    protected WcmSearchAuthCore m_parent = null;
    protected VWTable m_table;
    protected JPanel m_instrPanel = new JPanel(new GridBagLayout());
    protected WcmInstrTextArea m_instrText = new WcmInstrTextArea();
    protected Vector m_modifyEventListeners = new Vector();

    public WcmGenericTablePanel() {
        this.m_instrText.setBackground(this.getBackground());
        this.m_instrPanel.add((Component)this.m_instrText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    public void setInstrText(String text) {
        this.m_instrText.setText(text);
    }

    public void fileSave(WcmFileSaveEvent event) {
        this.stopEditing();
    }

    public void tableChanged(TableModelEvent e) {
        this.fireModifyEvent();
    }

    protected boolean stopEditing() {
        if (this.m_table == null) {
            return true;
        }
        return this.m_parent.stopEditing((JTable)this.m_table);
    }

    public void addModifyEventListener(IWcmModifyEventListener listener) {
        this.m_modifyEventListeners.addElement(listener);
    }

    public void removeModifyEventListener(IWcmModifyEventListener listener) {
        this.m_modifyEventListeners.removeElement(listener);
    }

    public void fireModifyEvent() {
        WcmModifyEvent event = new WcmModifyEvent(this);
        for (int i = 0; i < this.m_modifyEventListeners.size(); ++i) {
            ((IWcmModifyEventListener)this.m_modifyEventListeners.elementAt(i)).tabModified(event);
        }
    }

    public void fireUnModifyEvent() {
        WcmModifyEvent event = new WcmModifyEvent(this);
        for (int i = 0; i < this.m_modifyEventListeners.size(); ++i) {
            ((IWcmModifyEventListener)this.m_modifyEventListeners.elementAt(i)).tabUnModified(event);
        }
    }

    protected abstract void performPaste();

    protected abstract void performCopy(boolean var1);

    public void keyPressed(KeyEvent e) {
        try {
            Component comp;
            if (e.getModifiers() == 2 && e.getKeyCode() == 86) {
                Object obj = e.getSource();
                Transferable transferData = null;
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = cb.getContents(this);
                if (contents != null && contents instanceof Transferable) {
                    transferData = contents;
                }
                if (transferData != null) {
                    String xmlString = ((IVWCBData)transferData.getTransferData(WcmPasteXML.PASTEXML_DATAFLAVOR)).getContent();
                    if (xmlString != null && xmlString.length() > 0) {
                        if (obj instanceof VWTable) {
                            this.performPaste();
                        }
                        e.consume();
                    }
                } else if (obj instanceof VWTable) {
                    e.consume();
                }
            } else if (e.getModifiers() == 2 && e.getKeyCode() == 67) {
                Object obj = e.getSource();
                if (obj instanceof JTextField) {
                    JTextField jtf = (JTextField)obj;
                    String selText = jtf.getSelectedText();
                    if (selText == null) {
                        this.performCopy(false);
                        e.consume();
                    }
                } else if (obj instanceof VWTable) {
                    this.performCopy(false);
                    e.consume();
                }
            } else if (e.getModifiers() == 2 && e.getKeyCode() == 88) {
                Object obj = e.getSource();
                if (obj instanceof JTextField) {
                    JTextField jtf = (JTextField)obj;
                    String selText = jtf.getSelectedText();
                    if (selText == null) {
                        this.performCopy(true);
                        e.consume();
                    }
                } else if (obj instanceof VWTable) {
                    this.performCopy(true);
                    e.consume();
                }
            } else if (!(e.getSource() instanceof JTextField) && (comp = this.m_table.getEditorComponent()) instanceof JComboBox) {
                JComboBox boxComp = (JComboBox)comp;
                boxComp.requestFocus();
                boxComp.processKeyEvent(e);
                e.consume();
            }
        }
        catch (Exception ex) {
            System.out.println("Error in keyPressed(): " + ex.getMessage());
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

