/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.SearchPropertyDescriptions;
import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.BidiComboBox;
import com.filenet.wcm.apps.client.search.ui.IWcmResetEventListener;
import com.filenet.wcm.apps.client.search.ui.WcmColumnHeader;
import com.filenet.wcm.apps.client.search.ui.WcmFileOpenEvent;
import com.filenet.wcm.apps.client.search.ui.WcmFormatResultsModel;
import com.filenet.wcm.apps.client.search.ui.WcmGenericTablePanel;
import com.filenet.wcm.apps.client.search.ui.WcmPasteUtil;
import com.filenet.wcm.apps.client.search.ui.WcmPropMap;
import com.filenet.wcm.apps.client.search.ui.WcmPropertyCellRenderer;
import com.filenet.wcm.apps.client.search.ui.WcmPropertyRenderer;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmResetEvent;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.datatransfer.VWTransferable;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.w3c.dom.Node;

public class WcmFormatResultsPanel
extends WcmGenericTablePanel
implements ActionListener,
ListSelectionListener,
ClipboardOwner {
    private static final String SELECTPROPALL = "selectpropall";
    private static final int PROPERTY_COL_SIZE = 170;
    private static final int ALIGNMENT_COL_SIZE = 80;
    private static final int ORDER_COL_SIZE = 70;
    private static final int LEVEL_COL_SIZE = 60;
    private JPanel m_tablePanel = new JPanel();
    private JScrollPane m_tableScrollPane = null;
    private WcmFormatResultsModel m_model;
    private JPanel m_helperBtnPanel = new JPanel();
    private AbstractButton m_addButton = null;
    private AbstractButton m_removeButton = null;
    private AbstractButton m_upButton = null;
    private AbstractButton m_downButton = null;
    private AbstractButton m_resetButton = null;
    private Vector m_resetEventListeners = new Vector();
    private Vector m_sPropDescs = null;
    private boolean m_hasModelChanged = false;
    private boolean m_isAutoFillingState;

    public WcmFormatResultsPanel(WcmSearchAuthCore parent) {
        this.m_parent = parent;
        this.setLayout(new BorderLayout());
        this.setInstrText(WcmResource.s_resultsInstrStr);
        this.add("First", this.m_instrPanel);
        this.add("Before", new JPanel());
        this.add("After", new JPanel());
        this.add("Last", new JPanel());
        this.m_helperBtnPanel.setLayout(new FlowLayout(this.m_parent.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT ? 2 : 0));
        this.m_addButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/InsertRow24.gif", WcmResource.s_insertRow, false, this);
        this.m_removeButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/DeleteRow24.gif", WcmResource.s_deleteRow, false, this);
        this.m_upButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/Up24.gif", WcmResource.s_upTooltip, false, this);
        this.m_downButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/Down24.gif", WcmResource.s_downTooltip, false, this);
        this.m_resetButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/ResetCriteria24.gif", WcmResource.s_resetTooltip, false, this);
        this.m_addButton.setEnabled(false);
        this.m_removeButton.setEnabled(false);
        this.m_upButton.setEnabled(false);
        this.m_downButton.setEnabled(false);
        this.m_tablePanel.setLayout(new BorderLayout());
        this.m_tablePanel.add("First", this.m_helperBtnPanel);
        this.m_model = new WcmFormatResultsModel(this);
        this.m_table = new VWTable((TableModel)this.m_model);
        this.m_tableScrollPane = new JScrollPane((Component)this.m_table);
        this.m_tablePanel.add("Center", this.m_tableScrollPane);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setGridColor(Color.gray);
        this.m_table.setShowGrid(true);
        this.m_table.setRowHeight(this.m_table.getRowHeight() + 2);
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(1);
        if (tcCol != null) {
            tcCol.setCellEditor(new DefaultCellEditor(this.getAlignmentComboBox()));
            tcCol.setPreferredWidth(80);
        }
        if ((tcCol = this.m_table.getColumnModel().getColumn(2)) != null) {
            tcCol.setCellEditor(new DefaultCellEditor(this.getOrderComboBox()));
            tcCol.setPreferredWidth(70);
        }
        if ((tcCol = this.m_table.getColumnModel().getColumn(3)) != null) {
            JTextField jtf = new JTextField();
            tcCol.setCellEditor(new DefaultCellEditor(jtf));
            jtf.addKeyListener(this);
            tcCol.setPreferredWidth(60);
        }
        this.updatePropertyColumn();
        this.add("Center", this.m_tablePanel);
        this.m_table.addKeyListener((KeyListener)this);
        this.m_model.addTableModelListener(this);
    }

    public void setPropertyDescList(SearchPropertyDescriptions docList, SearchPropertyDescriptions folderList, SearchPropertyDescriptions customObjList, boolean[] objType) {
        try {
            WcmPropMap propertyMap = new WcmPropMap();
            propertyMap.createUnionList(docList, folderList, customObjList, objType, false, true, true, true);
            this.m_model.setPropertyDescList(propertyMap);
            this.m_sPropDescs = propertyMap.getSearchPropertyDescriptions();
            this.updatePropertyColumn();
        }
        catch (Exception e) {
            System.out.println("Caught an error in setPropertyDescList(): " + e.getMessage());
        }
    }

    public void updatePropertyColumn() {
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(0);
        if (tcCol != null) {
            TableCellEditor ceditor = tcCol.getCellEditor();
            if (ceditor != null) {
                ceditor.stopCellEditing();
            }
            WcmPropertyCellRenderer pCellRenderer = new WcmPropertyCellRenderer();
            pCellRenderer.setVerticalAlignment(1);
            pCellRenderer.setBackground(new Color(255, 255, 255));
            pCellRenderer.setOpaque(true);
            pCellRenderer.applyComponentOrientation(this.m_parent.getComponentOrientation());
            tcCol.setCellRenderer(pCellRenderer);
            tcCol.setCellEditor(new DefaultCellEditor(this.getPropertyComboBox()));
            tcCol.setPreferredWidth(170);
        }
    }

    public JComboBox getPropertyComboBox() {
        JComboBox<Object> pComboBox = null;
        try {
            pComboBox = new JComboBox<Object>();
            TableColumn col = this.m_table.getColumnModel().getColumn(0);
            WcmPropertyRenderer pRender = new WcmPropertyRenderer(col);
            pRender.setVerticalTextPosition(1);
            pRender.setBackground(new Color(255, 255, 255));
            pRender.setOpaque(true);
            pComboBox.setRenderer(pRender);
            pComboBox.applyComponentOrientation(this.m_parent.getComponentOrientation());
            if (this.m_sPropDescs != null && this.m_sPropDescs.size() > 0) {
                for (WcmWrappedPD sProp : this.m_sPropDescs) {
                    pComboBox.addItem(sProp);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to get the Property Combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public JComboBox getAlignmentComboBox() {
        BidiComboBox pComboBox = null;
        try {
            pComboBox = new BidiComboBox(this.m_parent.getComponentOrientation());
            pComboBox.addItem(WcmResource.s_leftStr);
            pComboBox.addItem(WcmResource.s_centerStr);
            pComboBox.addItem(WcmResource.s_rightStr);
        }
        catch (Exception ex) {
            System.out.println("Failed to get the Alignment combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public JComboBox getOrderComboBox() {
        BidiComboBox pComboBox = null;
        try {
            pComboBox = new BidiComboBox(this.m_parent.getComponentOrientation());
            pComboBox.addItem(WcmResource.s_noneStr);
            pComboBox.addItem(WcmResource.s_ascendingStr);
            pComboBox.addItem(WcmResource.s_descendingStr);
        }
        catch (Exception ex) {
            System.out.println("Failed to get the Order combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public Vector getSelectClause() {
        Vector<WcmColumnHeader> selectList = new Vector<WcmColumnHeader>();
        try {
            if (this.m_model.getRowCount() > 0) {
                for (int i = 1; i < this.m_model.getRowCount(); ++i) {
                    selectList.addElement(this.m_model.getItemAt(i - 1));
                }
            } else {
                WcmColumnHeader selectAll = new WcmColumnHeader();
                selectAll.setPropertyLabel(SELECTPROPALL);
                selectList.addElement(selectAll);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in getSelectClause(): " + e.getMessage());
        }
        return selectList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedProps(Vector selectedProps) {
        try {
            this.m_isAutoFillingState = true;
            if (selectedProps != null) {
                boolean propertyIndex = false;
                WcmWrappedPD vProp = null;
                WcmColumnHeader colHeader = null;
                Vector<WcmColumnHeader> colHeaderList = new Vector<WcmColumnHeader>();
                for (WcmCondition item : selectedProps) {
                    String propName;
                    if (item == null || (propName = item.getProperty()).length() <= 0) continue;
                    vProp = item.getPropDesc();
                    if (vProp == null) {
                        colHeader = new WcmColumnHeader();
                        colHeader.setPropertyName(propName);
                    } else {
                        colHeader = new WcmColumnHeader(vProp);
                        colHeader.setPropertyName(propName);
                        colHeader.initializePropertyID();
                        colHeader.setViewAlignment(WcmResource.s_leftStr);
                        colHeader.setViewOrder(WcmResource.s_noneStr);
                        colHeader.setSortPriority(0);
                    }
                    colHeaderList.addElement(colHeader);
                }
                Vector origList = this.getSelectClause();
                if (origList == null) {
                    this.setSelectClause(colHeaderList);
                } else if (!origList.equals(colHeaderList) && !this.m_hasModelChanged) {
                    this.setSelectClause(colHeaderList);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in setSelectedProps(): " + e.getMessage());
        }
        finally {
            this.m_isAutoFillingState = false;
        }
    }

    public void removeBlankRows() {
        this.m_model.removeBlankRows();
    }

    public void addResetEventListener(IWcmResetEventListener listener) {
        this.m_resetEventListeners.addElement(listener);
    }

    public void removeResetEventListener(IWcmResetEventListener listener) {
        this.m_resetEventListeners.removeElement(listener);
    }

    public void fireResetEvent() {
        WcmResetEvent event = new WcmResetEvent(this);
        for (int i = 0; i < this.m_resetEventListeners.size(); ++i) {
            ((IWcmResetEventListener)this.m_resetEventListeners.elementAt(i)).formatResultsReset(event);
        }
    }

    public void clear() {
        this.stopEditing();
        this.m_model.clearModel();
        this.enableActions(false);
        this.m_hasModelChanged = false;
    }

    private void insertNewElements(Vector origList, Vector newList) {
        try {
            if (origList == null || newList == null) {
                return;
            }
            Iterator it = null;
            Vector<String> selNames = new Vector<String>();
            for (WcmColumnHeader item : origList) {
                if (item == null) continue;
                selNames.addElement(item.getPropertyName());
            }
            for (WcmColumnHeader item : newList) {
                if (selNames.contains(item.getPropertyName())) continue;
                origList.addElement(item);
            }
            this.setSelectClause(origList);
        }
        catch (Exception e) {
            System.out.println("Error occurred in insertNewElement(): " + e.getMessage());
        }
    }

    private void setSelectClause(Vector selectClause) throws WcmException {
        try {
            if (selectClause != null) {
                int rowIndex = 0;
                this.m_model.clearModel();
                for (WcmColumnHeader item : selectClause) {
                    if (item == null || !this.m_model.isItemAvailable(item) || this.isPropertyDuplicated(item)) continue;
                    this.m_model.insertRow(rowIndex);
                    this.m_model.setItemAt(item, rowIndex++);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof WcmException) {
                throw (WcmException)e;
            }
            System.out.println("Error occurred in setSelectClause(): " + e.getMessage());
        }
    }

    private void openSelectClause(Vector selectClause) throws WcmException {
        try {
            if (selectClause != null) {
                int rowIndex = 0;
                this.m_model.clearModel();
                for (WcmColumnHeader item : selectClause) {
                    if (item == null || this.isPropertyDuplicated(item) || this.m_model.checkItemValidity(item) == -1) continue;
                    this.m_model.insertRow(rowIndex);
                    this.m_model.setItemAt(item, rowIndex++);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof WcmException) {
                throw (WcmException)e;
            }
            System.out.println("Error occurred in setSelectClause(): " + e.getMessage());
        }
    }

    private boolean isPropertyDuplicated(WcmColumnHeader item) {
        try {
            int nRowCnt = this.m_model.getRowCount() - 1;
            for (int i = 0; i < nRowCnt; ++i) {
                WcmColumnHeader wch = this.m_model.getItemAt(i);
                if (wch == null) {
                    return false;
                }
                String propName = wch.getPropertyName();
                if (item.getPropertyName().compareToIgnoreCase(propName) != 0) continue;
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred in isPropertyExist(): " + e.getMessage());
        }
        return false;
    }

    public void doInsert() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int nRowIndex = this.m_table.getSelectedRow();
            this.m_table.clearSelection();
            if (nRowIndex >= 0 && nRowIndex < this.m_table.getRowCount()) {
                this.m_model.insertRow(nRowIndex);
                this.m_table.setRowSelectionInterval(nRowIndex, nRowIndex);
            } else {
                this.enableActions(false);
                this.m_hasModelChanged = true;
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    private void copySelection(StringBuffer xmlStream) {
        try {
            int[] sz = this.m_table.getSelectedRows();
            if (sz.length > 0) {
                Object[] objSet = new Object[sz.length];
                for (int i = 0; i < sz.length; ++i) {
                    objSet[i] = this.m_model.getItemAt(sz[i]);
                }
                WcmPasteUtil pasteUtil = new WcmPasteUtil();
                String xmlString = pasteUtil.makeString(objSet);
                xmlStream.append(xmlString);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in copySelection(): " + e.getMessage());
        }
    }

    public void performCopy(boolean bDelete) {
        StringBuffer xmlStream = null;
        try {
            VWTransferable transferData;
            xmlStream = new StringBuffer();
            this.copySelection(xmlStream);
            if (bDelete) {
                this.doDelete();
            }
            if (xmlStream != null && (transferData = new VWTransferable(xmlStream.toString())) != null) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents((Transferable)transferData, this);
            }
            this.m_parent.enablePaste(true, 4);
        }
        catch (Exception e) {
            System.out.println("Error occurred in performCopy(): " + e.getMessage());
        }
    }

    public void performPaste() {
        Transferable transferData = null;
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = cb.getContents(this);
            if (contents != null && contents instanceof Transferable) {
                transferData = contents;
            }
            if (transferData == null) {
                return;
            }
            WcmPasteUtil pasteUtil = new WcmPasteUtil();
            String xmlString = (String)transferData.getTransferData(DataFlavor.stringFlavor);
            Object[] newItems = pasteUtil.parseString(xmlString);
            if (newItems != null && newItems.length > 0 && newItems[0] instanceof WcmColumnHeader) {
                int i;
                int[] rows = this.m_table.getSelectedRows();
                int sel = this.m_table.getSelectedRow();
                for (i = rows.length - 1; i >= 0; --i) {
                    this.m_model.deleteItem(rows[i]);
                }
                if (sel >= 0 && sel < this.m_table.getRowCount()) {
                    this.m_table.setRowSelectionInterval(sel, sel);
                }
                for (i = 0; i < newItems.length; ++i) {
                    int index = this.m_table.getSelectedRow();
                    this.m_model.insertRow(index);
                    WcmColumnHeader newItem = (WcmColumnHeader)newItems[i];
                    this.m_model.setItemAt(newItem, index);
                    this.redrawPropertyComboBox(newItem);
                    this.m_table.setRowSelectionInterval(index + 1, index + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in performPaste(): " + e.getMessage());
        }
    }

    private void redrawPropertyComboBox(WcmColumnHeader item) {
        DefaultCellEditor ceditor;
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(0);
        if (tcCol != null && (ceditor = (DefaultCellEditor)tcCol.getCellEditor()) != null) {
            JComboBox comp = (JComboBox)ceditor.getComponent();
            comp.getModel().setSelectedItem(item.getPropertyDescription());
        }
    }

    public void doDelete() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            int sel = this.m_table.getSelectedRow();
            for (int i = rows.length - 1; i >= 0; --i) {
                this.m_model.deleteItem(rows[i]);
                if (rows[i] != this.m_model.getRowCount() - 1) continue;
                this.cancelRowEditing(rows[i]);
            }
            if (sel == this.m_table.getRowCount() - 1) {
                --sel;
            }
            if (sel >= 0 && sel < this.m_table.getRowCount()) {
                this.m_table.setRowSelectionInterval(sel, sel);
            } else {
                this.enableActions(false);
                this.m_hasModelChanged = true;
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void doUp() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            if (rows[0] > 0) {
                this.m_table.removeRowSelectionInterval(rows[0], rows[rows.length - 1]);
                for (int i = 0; i < rows.length; ++i) {
                    this.m_model.moveUp(rows[i]);
                    this.m_table.addRowSelectionInterval(rows[i] - 1, rows[i] - 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void doDown() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            if (rows[rows.length - 1] < this.m_table.getRowCount() - 2) {
                this.m_table.removeRowSelectionInterval(rows[0], rows[rows.length - 1]);
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.m_model.moveDown(rows[i]);
                    this.m_table.addRowSelectionInterval(rows[i] + 1, rows[i] + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void doReset() {
        try {
            this.m_hasModelChanged = false;
            this.fireResetEvent();
            this.enableActions(false);
        }
        catch (Exception e) {
            System.out.println("Error occurred in doReset(): " + e.getMessage());
        }
    }

    public void fileOpened(WcmFileOpenEvent event) {
        try {
            boolean arePropertiesDiff;
            Vector selectClause = event.getFile().getSelectClause();
            this.openSelectClause(selectClause);
            Node whereClause = null;
            Vector searchCriteriaClause = null;
            if (whereClause != null) {
                WcmQTree propertyTree = new WcmQTree(whereClause);
                searchCriteriaClause = propertyTree.getAllLeaves();
            }
            if (!(arePropertiesDiff = this.checkPropertiesDiff(selectClause, searchCriteriaClause))) {
                this.setHasModelChanged(false);
            } else {
                this.setHasModelChanged(true);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in fileOpened: " + e.getMessage());
            this.m_parent.performNewItemAction(false, true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_addButton) {
            this.doInsert();
        } else if (event.getSource() == this.m_removeButton) {
            this.doDelete();
        } else if (event.getSource() == this.m_resetButton) {
            this.doReset();
        } else if (event.getSource() == this.m_upButton) {
            this.doUp();
        } else if (event.getSource() == this.m_downButton) {
            this.doDown();
        }
    }

    public void tableChanged(TableModelEvent e) {
        if (!this.m_hasModelChanged) {
            this.m_hasModelChanged = !this.m_isAutoFillingState;
        }
        super.tableChanged(e);
    }

    private boolean checkPropertiesDiff(Vector selectClause, Vector criteriaClause) {
        if (selectClause == null && criteriaClause == null) {
            return false;
        }
        if (selectClause == null && criteriaClause != null) {
            return !criteriaClause.isEmpty();
        }
        if (selectClause != null && criteriaClause == null) {
            return !selectClause.isEmpty();
        }
        if (selectClause.size() != criteriaClause.size()) {
            return true;
        }
        for (WcmColumnHeader item : selectClause) {
            String propName = item.getPropertyName();
            boolean bMatched = false;
            for (WcmCondition itemCondition : criteriaClause) {
                if (propName.compareToIgnoreCase(itemCondition.getProperty()) != 0) continue;
                bMatched = true;
            }
            if (bMatched) continue;
            return true;
        }
        return false;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.enableActions(true);
    }

    private void cancelRowEditing(int rowIdx) {
        for (int column = 0; column < this.m_table.getColumnCount(); ++column) {
            TableCellEditor cellEditor;
            if (!this.m_table.isCellEditable(rowIdx, column) || (cellEditor = this.m_table.getCellEditor(rowIdx, column)) == null) continue;
            cellEditor.cancelCellEditing();
        }
    }

    private void enableActions(boolean enable) {
        this.m_addButton.setEnabled(enable);
        this.m_removeButton.setEnabled(enable);
        this.m_parent.enableCutCopyPaste(enable, 4);
        if (enable) {
            int[] rows = this.m_table.getSelectedRows();
            int realLast = this.m_table.getRowCount() - 2;
            if (rows.length > 0) {
                this.m_upButton.setEnabled(rows[0] > 0 & rows[0] <= realLast);
                this.m_downButton.setEnabled(rows[rows.length - 1] < realLast);
            }
        } else {
            this.m_upButton.setEnabled(false);
            this.m_downButton.setEnabled(false);
        }
    }

    public boolean rowSelected() {
        return this.m_table.getSelectedRow() >= 0;
    }

    public int validatePriorityLevel() {
        return this.m_model.validatePriorityLevel();
    }

    public boolean isModelChanged() {
        return this.m_hasModelChanged;
    }

    public void setHasModelChanged(boolean bVal) {
        this.m_hasModelChanged = bVal;
    }

    public void lostOwnership(Clipboard clipboard, Transferable content) {
    }
}

