/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.WcmColumnHeader;
import com.filenet.wcm.apps.client.search.ui.WcmFormatResultsPanel;
import com.filenet.wcm.apps.client.search.ui.WcmPropInfo;
import com.filenet.wcm.apps.client.search.ui.WcmPropMap;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class WcmFormatResultsModel
extends AbstractTableModel {
    private final int NUM_COLUMNS = 4;
    public static final int PROPERTY_COL = 0;
    public static final int ALIGNMENT_COL = 1;
    public static final int ORDER_COL = 2;
    public static final int LEVEL_COL = 3;
    protected Vector m_rowData = null;
    protected int m_nRows = 0;
    private WcmPropMap m_propertyMap = null;
    private int m_highestLevel = 0;
    private String m_property = null;
    private String m_alignment = null;
    private String m_order = null;
    private String m_level = null;
    private WcmFormatResultsPanel m_dialogPanel;
    private static final int VALPROP_ERR_SYMNAME = 1;
    private static final int VALPROP_ERR_SORTING_INFO = 2;
    private static final int VALPROP_ERR_NON_SORTABLE = 3;
    private static final int VALPROP_NO_ERR = 0;

    public WcmFormatResultsModel(WcmFormatResultsPanel dlgPanel) {
        this.m_dialogPanel = dlgPanel;
        try {
            this.m_rowData = new Vector();
            ++this.m_nRows;
        }
        catch (Exception e) {
            System.out.println("An error occurred while constructing object: " + e.getMessage());
        }
    }

    public void clearModel() {
        this.m_rowData = new Vector();
        this.fireTableRowsDeleted(0, this.m_nRows);
        this.m_nRows = 0;
        this.m_highestLevel = 0;
    }

    public void setPropertyDescList(WcmPropMap propertyMap) {
        try {
            this.m_propertyMap = new WcmPropMap(propertyMap);
        }
        catch (Exception e) {
            System.out.println("Error caught in setPropertyDescList(): " + e.getMessage());
        }
    }

    public void copyItem(int nRowIndex) throws WcmException {
        WcmColumnHeader fieldDef = null;
        WcmColumnHeader newFieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null && (newFieldDef = fieldDef) != null) {
                this.m_rowData.addElement(newFieldDef);
                ++this.m_nRows;
                nRowIndex = this.getRowCount() - 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.errorInCopy", "An error occurred in copyItem(): {0}", (Object)e.getMessage());
        }
    }

    public void deleteItem(int nRowIndex) throws WcmException {
        WcmColumnHeader fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                --this.m_nRows;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.errorInDelete", "An error occurred in deleteItem(): {0}", (Object)e.getMessage());
        }
    }

    public void insertRow(int nRowIndex) throws WcmException {
        try {
            WcmColumnHeader fieldDef = new WcmColumnHeader();
            if (fieldDef != null) {
                fieldDef.initializePropertyID();
                fieldDef.setViewAlignment(WcmResource.s_leftStr);
                fieldDef.setViewOrder(WcmResource.s_noneStr);
                fieldDef.setSortPriority(0);
                this.m_rowData.insertElementAt(fieldDef, nRowIndex);
                ++this.m_nRows;
                this.fireTableRowsInserted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.errorInInsert", "An error occurred in insertItem(): {0}", (Object)e.getMessage());
        }
    }

    public void moveUp(int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex <= 0 || nRowIndex > this.m_rowData.size() - 1) {
                return;
            }
            WcmColumnHeader movingRow = (WcmColumnHeader)this.m_rowData.get(nRowIndex);
            WcmColumnHeader upperRow = (WcmColumnHeader)this.m_rowData.get(nRowIndex - 1);
            this.m_rowData.setElementAt(movingRow, nRowIndex - 1);
            this.m_rowData.setElementAt(upperRow, nRowIndex);
            this.fireTableRowsUpdated(nRowIndex - 1, nRowIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WcmException("client.WcmFormatResultsModel.errorInMoveUp", "An error occurred in moveUp(): {0}", (Object)e.getMessage());
        }
    }

    public void moveDown(int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex >= this.m_rowData.size() - 1) {
                return;
            }
            WcmColumnHeader movingRow = (WcmColumnHeader)this.m_rowData.get(nRowIndex);
            WcmColumnHeader lowerRow = (WcmColumnHeader)this.m_rowData.get(nRowIndex + 1);
            this.m_rowData.setElementAt(movingRow, nRowIndex + 1);
            this.m_rowData.setElementAt(lowerRow, nRowIndex);
            this.fireTableRowsUpdated(nRowIndex, nRowIndex + 1);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.errorInMoveUp", "An error occurred in moveUp(): {0}", (Object)e.getMessage());
        }
    }

    protected void removeBlankRows() {
        try {
            if (this.m_rowData == null) {
                return;
            }
            int dataSz = this.m_rowData.size();
            WcmColumnHeader fieldDef = null;
            for (int i = dataSz - 1; i >= 0; --i) {
                fieldDef = this.getItemAt(i);
                if (!fieldDef.isEmpty()) continue;
                this.deleteItem(i);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmFormatResultsModel::removeBlankRows(): " + e.getMessage());
        }
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        try {
            if (nColumnIndex == 0) {
                return true;
            }
            WcmColumnHeader fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                if (nColumnIndex == 1) {
                    return true;
                }
                if (!fieldDef.isOrderable()) {
                    return false;
                }
                return nColumnIndex != 3 || fieldDef.getViewOrder() != null && !fieldDef.getViewOrder().equalsIgnoreCase(WcmResource.s_noneStr);
            }
            return false;
        }
        catch (Exception e) {
            System.out.println("Caught error in isCellEditable(): " + e.getMessage());
            return true;
        }
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return WcmResource.s_propertyStr;
            }
            case 1: {
                return WcmResource.s_alignmentStr;
            }
            case 2: {
                return WcmResource.s_orderStr;
            }
            case 3: {
                return WcmResource.s_levelStr;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return WcmWrappedPD.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        WcmColumnHeader fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (fieldDef != null && fieldDef.getPropertyDescription() != null) {
                        return fieldDef.getPropertyDescription();
                    }
                    return null;
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getViewAlignment();
                    }
                    return this.m_alignment;
                }
                case 2: {
                    if (fieldDef != null) {
                        return fieldDef.getViewOrder();
                    }
                    return this.m_order;
                }
                case 3: {
                    if (fieldDef != null) {
                        return fieldDef.getLevelStr();
                    }
                    return this.m_level;
                }
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("An error occurred in getValueAt(): " + e.getMessage());
            return null;
        }
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateProperty(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateAlignment(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateOrder(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdateLevel(aValue, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred in setValueAt(): " + e.getMessage());
        }
    }

    private void onUpdateProperty(Object aValue, int nRowIndex) throws WcmException {
        WcmColumnHeader fieldDef = null;
        String property = null;
        WcmWrappedPD propDesc = null;
        try {
            if (aValue == null) {
                return;
            }
            if (aValue instanceof WcmWrappedPD) {
                propDesc = (WcmWrappedPD)aValue;
                property = propDesc.getDisplayName();
            } else {
                System.out.println("Property is not of type WcmWrappedPD");
            }
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setPropertyLabel(property);
                if (propDesc != null) {
                    fieldDef.setPropertyDescription(propDesc);
                    fieldDef.setPropertyName(propDesc.getName());
                    if (fieldDef.getViewAlignment() == null) {
                        fieldDef.setViewAlignment(WcmResource.s_leftStr);
                        fieldDef.setViewOrder(WcmResource.s_noneStr);
                        fieldDef.setSortPriority(0);
                    }
                    if (!fieldDef.isOrderable()) {
                        fieldDef.setViewOrder(WcmResource.s_noneStr);
                    }
                }
            } else {
                this.m_property = property;
                fieldDef = propDesc != null ? new WcmColumnHeader(propDesc) : new WcmColumnHeader();
                fieldDef.initializePropertyID();
                fieldDef.setPropertyLabel(property);
                if (propDesc != null) {
                    fieldDef.setPropertyName(propDesc.getName());
                    fieldDef.setObjType(propDesc.getObjType());
                }
                fieldDef.setViewAlignment(WcmResource.s_leftStr);
                fieldDef.setViewOrder(WcmResource.s_noneStr);
                fieldDef.setSortPriority(0);
                this.m_rowData.addElement(fieldDef);
                ++this.m_nRows;
                this.m_property = null;
                this.m_alignment = null;
                this.m_order = null;
                this.m_level = null;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.UpdateProperty", "An error occurred while in onUpdateProperty(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateAlignment(Object aValue, int nRowIndex) throws WcmException {
        WcmColumnHeader fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setViewAlignment(aValue.toString());
            } else {
                this.m_alignment = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.UpdateAlignment", "An error occurred while in onUpdateAlignment(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateOrder(Object aValue, int nRowIndex) throws WcmException {
        WcmColumnHeader fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            String order = aValue.toString();
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setViewOrder(order);
            } else {
                this.m_order = order;
            }
            if (WcmString.compareIgnoreCase(order, WcmResource.s_ascendingStr) == 0 || WcmString.compareIgnoreCase(order, WcmResource.s_descendingStr) == 0) {
                if (fieldDef != null) {
                    fieldDef.setSortPriority(this.calculateNextLevel(nRowIndex));
                } else {
                    this.m_level = new Integer(this.calculateNextLevel(nRowIndex)).toString();
                }
            } else {
                int oldLevel = fieldDef.getSortPriority();
                if (oldLevel > 0) {
                    --this.m_highestLevel;
                }
                this.setValueAt("0", nRowIndex, 3);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.UpdateOrder", "An error occurred while in onUpdateOrder(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateLevel(Object aValue, int nRowIndex) {
        WcmColumnHeader fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                int newLev = new Integer(aValue.toString());
                if (!fieldDef.getViewOrder().equalsIgnoreCase(WcmResource.s_noneStr) && newLev <= 0) {
                    JOptionPane.showMessageDialog(this.m_dialogPanel, WcmResource.s_positiveInts, WcmResource.s_invalidPriority, 0);
                } else {
                    fieldDef.setSortPriority(newLev);
                }
            } else {
                this.m_level = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.m_dialogPanel, WcmResource.s_positiveInts, WcmResource.s_invalidPriority, 0);
        }
    }

    private int calculateNextLevel(int nRowIndex) throws WcmException {
        try {
            int level = 0;
            String currLevel = (String)this.getValueAt(nRowIndex, 3);
            if (currLevel.length() > 0) {
                level = new Integer(currLevel);
            }
            if (level > 0) {
                return level;
            }
            ++this.m_highestLevel;
        }
        catch (Exception e) {
            System.out.println("Caught error in calculateNextLevel(): " + e.getMessage());
            throw new WcmException("client.WcmFormatResultsModel.CalculateNextLevel", "An error occurred while in calculateNextLevel(): {0}", (Object)e.getMessage());
        }
        return this.m_highestLevel;
    }

    protected void setItemAt(WcmColumnHeader item, int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return;
            }
            if (nRowIndex < this.m_rowData.size()) {
                if (item.getPropertyDescription() == null) {
                    PropertyDescription pDesc = this.m_propertyMap.getPropInfoBySymName(item.getPropertyName()).getPropertyDescription();
                    item.setPropertyDescription(new WcmWrappedPD(pDesc, item.getObjType()));
                }
                this.m_rowData.setElementAt(item, nRowIndex);
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.errorInGettingItem", "An error occurred in getItemAt(): {0}", (Object)e.getMessage());
        }
    }

    protected WcmColumnHeader getItemAt(int nRowIndex) throws WcmException {
        WcmColumnHeader fieldDef = null;
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return null;
            }
            if (nRowIndex < this.m_rowData.size()) {
                fieldDef = (WcmColumnHeader)this.m_rowData.elementAt(nRowIndex);
            }
            return fieldDef;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFormatResultsModel.errorInGettingItem", "An error occurred in getItemAt(): {0}", (Object)e.getMessage());
        }
    }

    public int validatePriorityLevel() {
        if (!this.validatePriorityDuplication()) {
            return 1;
        }
        if (!this.validatePriorityLimit()) {
            return 2;
        }
        return 0;
    }

    public boolean validatePriorityDuplication() {
        WcmColumnHeader fieldDef_a = null;
        WcmColumnHeader fieldDef_b = null;
        for (int i = 0; i < this.m_rowData.size(); ++i) {
            int lev_a;
            fieldDef_a = (WcmColumnHeader)this.m_rowData.elementAt(i);
            if (fieldDef_a == null || (lev_a = fieldDef_a.getSortPriority()) == 0) continue;
            for (int j = i + 1; j < this.m_rowData.size(); ++j) {
                int lev_b;
                fieldDef_b = (WcmColumnHeader)this.m_rowData.elementAt(j);
                if (fieldDef_b == null || lev_a != (lev_b = fieldDef_b.getSortPriority())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validatePriorityLimit() {
        WcmColumnHeader fieldDef = null;
        int nNumRows = this.m_rowData.size();
        for (int i = 0; i < nNumRows; ++i) {
            int level;
            fieldDef = (WcmColumnHeader)this.m_rowData.elementAt(i);
            if (fieldDef == null || (level = fieldDef.getSortPriority()) == 0 || level <= nNumRows) continue;
            return false;
        }
        return true;
    }

    public boolean isItemAvailable(WcmColumnHeader item) {
        String propSymName = item.getPropertyName();
        if (propSymName == null) {
            return false;
        }
        WcmPropInfo propInfo = this.m_propertyMap.getPropInfoBySymName(propSymName);
        return propInfo != null;
    }

    public int checkItemValidity(WcmColumnHeader item) throws WcmException {
        int errId = this.validateProperty(item);
        if (errId == 1) {
            int retVal = this.handleInvalidProps(item);
            if (retVal == 0) {
                return -1;
            }
            if (retVal == 2) {
                throw new WcmException("client.WcmFormatResultsModel.invalidProperty", "Failed to open due to invalid property: {0}", (Object)item.getPropertyLabel());
            }
        } else if (errId == 3 || errId == 2) {
            this.handleInvalidSort(item, errId);
        }
        return 0;
    }

    private int validateProperty(WcmColumnHeader item) {
        String propSymName = item.getPropertyName();
        String propLabel = item.getPropertyLabel();
        if (propSymName == null) {
            return 1;
        }
        WcmPropInfo propInfo = this.m_propertyMap.getPropInfoBySymName(propSymName);
        if (propInfo == null) {
            return 1;
        }
        if (propInfo.getLabel().compareToIgnoreCase(propLabel) != 0) {
            item.setPropertyLabel(propInfo.getLabel());
        }
        if (!propInfo.getIsOrderable()) {
            if (item.getXMLOrder().compareToIgnoreCase("none") != 0 || item.getSortPriority() != 0) {
                return 3;
            }
        } else {
            if (item.getXMLOrder().compareToIgnoreCase("none") == 0 && item.getSortPriority() != 0) {
                return 2;
            }
            if (item.getXMLOrder().compareToIgnoreCase("none") != 0 && item.getXMLOrder().compareToIgnoreCase("ascending") != 0 && item.getXMLOrder().compareToIgnoreCase("descending") != 0) {
                return 2;
            }
        }
        return 0;
    }

    private int handleInvalidProps(WcmColumnHeader item) {
        String msg = WcmResource.s_invalidProperty.toString(item.getPropertyLabel());
        msg = msg + WcmResource.s_invalidProperty2;
        return JOptionPane.showOptionDialog(this.m_dialogPanel, msg, WcmResource.s_searchAuthStr, 2, 3, null, null, null);
    }

    private void handleInvalidSort(WcmColumnHeader item, int errId) {
        String msg = "";
        if (errId == 3) {
            msg = WcmResource.s_invalidPropertySort1.toString(item.getPropertyLabel());
            msg = msg + WcmResource.s_invalidPropertySort2;
        } else if (errId == 2) {
            msg = WcmResource.s_invalidPropertySort.toString(item.getPropertyLabel());
            msg = msg + WcmResource.s_invalidPropertySort2;
        }
        int dlgRet = JOptionPane.showOptionDialog(this.m_dialogPanel, msg, WcmResource.s_searchAuthStr, 2, 3, null, null, null);
        try {
            if (dlgRet == 0) {
                item.setXMLOrder("none");
                item.setSortPriority(0);
                WcmPropInfo propInfo = this.m_propertyMap.getPropInfoBySymName(item.getPropertyName());
                if (propInfo != null) {
                    item.setIsOrderable(propInfo.getIsOrderable());
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error occurred in WcmFormatResultsModel::handleInvalidSort(): " + ex.getMessage());
        }
    }
}

