/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.client.search.ui.BidiComboBox;
import com.filenet.wcm.apps.client.search.ui.WcmBoolTableCellRenderer;
import com.filenet.wcm.apps.client.search.ui.WcmFileOpenEvent;
import com.filenet.wcm.apps.client.search.ui.WcmFoldersModel;
import com.filenet.wcm.apps.client.search.ui.WcmGenericTablePanel;
import com.filenet.wcm.apps.client.search.ui.WcmPasteUtil;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSearchFolder;
import com.filenet.wcm.apps.client.search.ui.WcmSearchOptionsRec;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.ui.WcmDlg;
import com.filenet.wcm.toolkit.client.ui.WcmDlgFactory;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.util.WcmTabbedErrorUtil;
import filenet.vw.toolkit.utils.datatransfer.VWTransferable;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class WcmFoldersPanel
extends WcmGenericTablePanel
implements ActionListener,
ListSelectionListener,
ClipboardOwner {
    private final int VIEW_COL_SIZE = 60;
    private final int FOLDERS_COL_SIZE = 240;
    private final int INCLUDE_COL_SIZE = 60;
    private JPanel m_tablePanel = new JPanel();
    private WcmFoldersModel m_model;
    private Container m_mainContainer = null;
    private AbstractButton m_selectFolder = null;
    private AbstractButton m_addButton = null;
    private AbstractButton m_removeButton = null;
    private ObjectStores m_libsList = null;
    private boolean m_foldersChanged = false;
    private WcmDlgItem m_netItem = null;
    private WcmDlgItem m_browseContext = null;
    private Session m_session = null;
    private boolean m_dispAllVersionsMsg = true;
    private boolean m_viewColEnabled = true;

    public WcmFoldersPanel(WcmSearchAuthCore parent) {
        try {
            this.setLayout(new BorderLayout());
            this.m_parent = parent;
            this.setInstrText(WcmResource.s_folderInstrStr);
            this.add("First", this.m_instrPanel);
            this.m_tablePanel.setLayout(new BorderLayout());
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(this.m_parent.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT ? 2 : 0));
            this.m_selectFolder = this.m_parent.createPanelButton(buttonPanel, "action/button/SelectFolder24.gif", WcmResource.s_selectAFolderStr, false, this);
            this.m_addButton = this.m_parent.createPanelButton(buttonPanel, "action/button/InsertRow24.gif", WcmResource.s_insertRow, false, this);
            this.m_removeButton = this.m_parent.createPanelButton(buttonPanel, "action/button/DeleteRow24.gif", WcmResource.s_deleteRow, false, this);
            this.m_addButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            this.m_tablePanel.add("First", buttonPanel);
            this.m_tablePanel.add("Before", new JPanel());
            this.m_tablePanel.add("After", new JPanel());
            this.m_tablePanel.add("Last", new JPanel());
            this.m_model = new WcmFoldersModel(this.m_parent.getLibraryPanel(), this);
            this.m_table = new VWTable((TableModel)this.m_model);
            this.m_table.setRowSelectionAllowed(true);
            this.m_table.setGridColor(Color.gray);
            this.m_table.setShowGrid(true);
            this.m_table.getSelectionModel().addListSelectionListener(this);
            this.m_tablePanel.add("Center", new JScrollPane((Component)this.m_table));
            this.m_table.setRowHeight(this.m_table.getRowHeight() + 2);
            this.m_table.addKeyListener((KeyListener)this);
            TableColumn tcCol = this.m_table.getColumnModel().getColumn(0);
            if (tcCol != null) {
                tcCol.setCellEditor(new DefaultCellEditor(this.getViewComboBox()));
                Integer width = new Integer(WcmResource.s_viewColWidth);
                if (width > 0) {
                    tcCol.setPreferredWidth(width);
                } else {
                    tcCol.setPreferredWidth(60);
                }
            }
            if ((tcCol = this.m_table.getColumnModel().getColumn(2)) != null) {
                tcCol.setPreferredWidth(60);
                tcCol.setCellRenderer(new WcmBoolTableCellRenderer());
            }
            if ((tcCol = this.m_table.getColumnModel().getColumn(1)) != null) {
                JTextField jtf = new JTextField();
                tcCol.setCellEditor(new DefaultCellEditor(jtf));
                jtf.addKeyListener(this);
                tcCol.setPreferredWidth(240);
            }
            this.add("Center", this.m_tablePanel);
            this.m_model.addTableModelListener(this);
        }
        catch (Exception e) {
            System.out.println("Caught an error in WcmFolderPanel(): " + e.getMessage());
        }
    }

    public void setSession(Session session) {
        if (session != null) {
            this.m_session = session;
        }
    }

    public Session getSession() {
        return this.m_session;
    }

    public void setMainContainer(Container mainContainer) {
        this.m_mainContainer = mainContainer;
    }

    public void setSelectedLibs(Vector libs) {
        if (libs != null) {
            this.m_libsList = ObjectFactory.getObjectStores();
            for (VerboseLibrary vLib : libs) {
                ObjectStore lib = vLib.getLibrary();
                if (lib == null) continue;
                this.m_libsList.add((Object)lib);
            }
        }
    }

    public boolean getDispAllVersionsMsg() {
        return this.m_dispAllVersionsMsg;
    }

    public void setDispAllVersionsMsg(boolean value) {
        this.m_dispAllVersionsMsg = value;
    }

    public void removeBlankRows() {
        this.m_model.removeBlankRows();
    }

    public void setNetworkItem(WcmDlgItem netItem) {
        this.m_netItem = netItem;
    }

    public JComboBox getViewComboBox() {
        BidiComboBox pComboBox = null;
        try {
            pComboBox = new BidiComboBox(this.m_parent.getComponentOrientation());
            pComboBox.addItem(WcmResource.s_editableStr);
            pComboBox.addItem(WcmResource.s_hiddenStr);
        }
        catch (Exception ex) {
            System.out.println("Failed to setup the View combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public boolean hasFolderSelectionChanged() {
        return this.m_foldersChanged;
    }

    public Vector getFolderList() {
        try {
            Vector<WcmSearchFolder> folderList = new Vector<WcmSearchFolder>();
            for (int i = 0; i < this.m_model.getRowCount(); ++i) {
                WcmSearchFolder item = this.m_model.getItemAt(i);
                if (item == null) continue;
                folderList.addElement(item);
            }
            return folderList;
        }
        catch (Exception e) {
            System.out.println("Caught an error in getFolderList(): " + e.getMessage());
            return null;
        }
    }

    public void clear() {
        this.stopEditing();
        this.m_model.clearModel();
        this.m_addButton.setEnabled(false);
        this.m_removeButton.setEnabled(false);
    }

    public void enableViewColumn(boolean enable) {
        TableColumn tc = this.m_table.getColumnModel().getColumn(0);
        this.m_model.enableViewColumn(enable);
        this.m_viewColEnabled = enable;
        if (enable) {
            Integer width = new Integer(WcmResource.s_viewColWidth);
            if (width > 0) {
                tc.setMaxWidth(width);
                tc.setPreferredWidth(width);
            } else {
                tc.setMaxWidth(60);
                tc.setPreferredWidth(60);
            }
            tc.setCellEditor(new DefaultCellEditor(this.getViewComboBox()));
        } else {
            tc.setPreferredWidth(0);
            tc.setMaxWidth(0);
            tc.setCellEditor(null);
        }
        this.m_table.refreshUI();
    }

    private Vector validateFolders(Vector folders) {
        Vector<WcmSearchFolder> returnFolders = new Vector<WcmSearchFolder>();
        try {
            boolean rowCounter = false;
            Vector<WcmSearchFolder> errorFolders = new Vector<WcmSearchFolder>();
            if (folders != null && folders.size() > 0) {
                for (WcmSearchFolder item : folders) {
                    if (item == null) continue;
                    if (item.isValid(this.m_session)) {
                        returnFolders.add(item);
                        continue;
                    }
                    errorFolders.add(item);
                }
                if (errorFolders.size() > 0) {
                    WcmTabbedErrorUtil foldMessage = new WcmTabbedErrorUtil(this.m_parent.getParentFrame());
                    foldMessage.addRow(0, WcmResource.s_invalidFolders);
                    for (WcmSearchFolder item : errorFolders) {
                        foldMessage.addRow(1, item.getFolderPath());
                        foldMessage.addRow(2, item.getError());
                    }
                    foldMessage.setTitle(WcmResource.s_searchAuthStr);
                    foldMessage.show();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in setFolders(): " + e.getMessage());
        }
        if (returnFolders.size() < folders.size()) {
            this.m_foldersChanged = true;
        }
        return returnFolders;
    }

    private void copySelection(StringBuffer xmlStream) {
        try {
            int[] sz = this.m_table.getSelectedRows();
            if (sz.length > 0) {
                Object[] objSet = new Object[sz.length];
                for (int i = 0; i < sz.length; ++i) {
                    objSet[i] = this.m_model.getItemAt(sz[i]);
                }
                WcmPasteUtil pasteUtil = new WcmPasteUtil();
                String xmlString = pasteUtil.makeString(objSet);
                xmlStream.append(xmlString);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in copySelection(): " + e.getMessage());
        }
    }

    public void performCopy(boolean bDelete) {
        StringBuffer xmlStream = null;
        try {
            VWTransferable transferData;
            xmlStream = new StringBuffer();
            this.copySelection(xmlStream);
            if (bDelete) {
                this.performDelete();
            }
            if (xmlStream != null && (transferData = new VWTransferable(xmlStream.toString())) != null) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents((Transferable)transferData, this);
            }
            this.m_parent.enablePaste(true, 2);
        }
        catch (Exception e) {
            System.out.println("Error occurred in performCopy(): " + e.getMessage());
        }
    }

    public void performPaste() {
        Transferable transferData = null;
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = cb.getContents(this);
            if (contents != null && contents instanceof Transferable) {
                transferData = contents;
            }
            if (transferData == null) {
                return;
            }
            WcmPasteUtil pasteUtil = new WcmPasteUtil();
            String xmlString = (String)transferData.getTransferData(DataFlavor.stringFlavor);
            Object[] newItems = pasteUtil.parseString(xmlString);
            if (newItems != null && newItems.length > 0 && newItems[0] instanceof WcmSearchFolder) {
                int i;
                int[] rows = this.m_table.getSelectedRows();
                int sel = this.m_table.getSelectedRow();
                for (i = rows.length - 1; i >= 0; --i) {
                    this.m_model.deleteItem(rows[i]);
                }
                if (sel >= 0 && sel < this.m_table.getRowCount()) {
                    this.m_table.setRowSelectionInterval(sel, sel);
                }
                for (i = 0; i < newItems.length; ++i) {
                    int index = this.m_table.getSelectedRow();
                    if (index < 0) {
                        index = 0;
                    }
                    WcmSearchFolder newItem = (WcmSearchFolder)newItems[i];
                    this.m_model.insertRow(index);
                    this.m_model.setItemAt(newItem, index);
                    if (index < 0 || index >= this.m_table.getRowCount()) continue;
                    this.m_table.setRowSelectionInterval(index + 1, index + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in performPaste(): " + e.getMessage());
        }
    }

    public void performInsert() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int sel = this.m_table.getSelectedRow();
            this.m_table.clearSelection();
            if (sel >= 0 && sel < this.m_table.getRowCount()) {
                this.m_model.insertRow(sel);
                this.m_table.setRowSelectionInterval(sel, sel);
            } else {
                this.m_addButton.setEnabled(false);
                this.m_removeButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in performInsert(): " + e.getMessage());
        }
    }

    public void performDelete() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            int sel = this.m_table.getSelectedRow();
            for (int i = rows.length - 1; i >= 0; --i) {
                this.m_model.deleteItem(rows[i]);
            }
            if (sel == this.m_table.getRowCount() - 1) {
                --sel;
            }
            if (sel >= 0 && sel < this.m_table.getRowCount()) {
                this.m_table.setRowSelectionInterval(sel, sel);
            } else {
                this.m_addButton.setEnabled(false);
                this.m_removeButton.setEnabled(false);
                this.m_parent.enableCutCopyPaste(false, 2);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in performDelete(): " + e.getMessage());
        }
    }

    public void showAllVersionsWithSubfoldersMsg() {
        WcmSearchOptionsRec optRec = this.m_parent.getOptionsDialog().getValues();
        if (optRec != null) {
            if (optRec.m_versionSelection == 3 && this.m_dispAllVersionsMsg) {
                JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_allversionsWithFolders);
            }
        }
        this.m_dispAllVersionsMsg = false;
    }

    private void performSelectLibraries() {
        try {
            WcmDlgItem item;
            WcmDlg dlg = WcmDlgFactory.getBrowseDialog(this.m_netItem, this.m_browseContext, WcmResourceString.s_open, new int[]{4, 2});
            dlg.setTitle(WcmResource.s_selectAFolderStr);
            if (this.m_libsList.size() <= 0) {
                JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_noSelectedLibs);
                this.parentFrameRequestFocus();
                return;
            }
            dlg.setVisibleObjectStores(this.m_libsList);
            dlg.setBrowseMode(1);
            this.m_parent.setWaitCursor();
            int retVal = dlg.showDialog(this.m_parent.getParentFrame());
            this.m_parent.setDefaultCursor();
            if (retVal == 0 && (item = dlg.getSelectedItem()) != null) {
                if (item.getObjectStoreLabel() == null) {
                    JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), "Please select a folder");
                    this.parentFrameRequestFocus();
                    return;
                }
                this.m_browseContext = item;
                this.showAllVersionsWithSubfoldersMsg();
                String label = new String(item.getPathname());
                WcmSearchFolder folder = new WcmSearchFolder(label, false);
                folder.initializeItemID();
                if (this.m_viewColEnabled) {
                    folder.setView(1);
                } else {
                    folder.setView(2);
                }
                folder.setId(item.getId());
                folder.setCrossLibraries(false);
                int selRow = this.m_table.getSelectedRow();
                if (selRow >= 0) {
                    if (selRow < this.m_model.getRowCount() - 1) {
                        WcmSearchFolder selFolder = this.m_model.getItemAt(selRow);
                        if (selFolder.getFolder() != null) {
                            selFolder.updateFolder(folder.getFolder(), folder.getLibraryName());
                            selFolder.setId(this.m_model.lookupFolderId(folder.getLibraryName(), folder.getFolder(), this.m_session));
                            this.m_model.setFolderAt(selFolder, selRow);
                        } else {
                            this.m_model.setFolder(folder);
                        }
                    } else {
                        this.m_model.setFolder(folder);
                    }
                } else {
                    this.m_model.setFolder(folder);
                }
            }
            this.m_foldersChanged = true;
        }
        catch (Exception e) {
            System.out.println("Error occurred when opening the folder browse dlg: " + e.getMessage());
        }
        this.parentFrameRequestFocus();
    }

    public void fileOpened(WcmFileOpenEvent event) {
        try {
            Vector folders = this.validateFolders(event.getFile().getFolders());
            this.m_model.setFolders(folders);
            if (!this.m_foldersChanged) {
                this.fireUnModifyEvent();
            }
        }
        catch (Exception e) {
            System.out.println("Caught an error while reading the folders from the stored search: " + e.getMessage());
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performSimpleValidation() {
        try {
            Vector folders = this.getFolderList();
            if (folders == null || folders.isEmpty()) {
                return true;
            }
            for (WcmSearchFolder item : folders) {
                try {
                    if (item.isValid(this.m_session)) continue;
                    return false;
                }
                catch (Exception e) {
                    System.out.println("Validation failed: " + item.getError());
                    return false;
                    return true;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in performSimpleValidation(): " + e.getMessage());
            return false;
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() == this.m_selectFolder) {
                int sel = this.m_table.getSelectedRow();
                this.m_parent.stopEditing((JTable)this.m_table);
                this.performSelectLibraries();
                if (sel >= 0) {
                    this.m_table.clearSelection();
                    this.m_table.setRowSelectionInterval(sel, sel);
                }
            } else if (event.getSource() == this.m_addButton) {
                this.performInsert();
            } else if (event.getSource() == this.m_removeButton) {
                this.performDelete();
            }
        }
        catch (Exception e) {
            System.out.println("Caught an error in actionPerformed(): " + e.getMessage());
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (this.m_table.getSelectedRow() >= 0) {
            this.m_addButton.setEnabled(true);
            this.m_removeButton.setEnabled(true);
            this.m_parent.enableCutCopyPaste(true, 2);
        }
    }

    public boolean rowSelected() {
        return this.m_table.getSelectedRow() >= 0;
    }

    private void parentFrameRequestFocus() {
        if (this.m_parent != null) {
            this.m_parent.parentFrameRequestFocus();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable content) {
    }
}

