/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.client.search.ui.IWcmModel;
import com.filenet.wcm.apps.client.search.ui.WcmFoldersPanel;
import com.filenet.wcm.apps.client.search.ui.WcmLibraryPanel;
import com.filenet.wcm.apps.client.search.ui.WcmSearchFolder;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class WcmFoldersModel
extends AbstractTableModel
implements IWcmModel {
    private final int NUM_COLUMNS = 3;
    public static final int VIEW_COL = 0;
    public static final int FOLDER_COL = 1;
    public static final int INCLUDE_SUBFOLDERS_COL = 2;
    private final int FOLDNAME_NO_ERR = 0;
    private final int FOLDNAME_ERR_MULTISLASH = 1;
    private final int FOLDNAME_ERR_BADCHAR = 2;
    private Vector m_rowData = null;
    private int m_nRows = 0;
    private boolean m_viewColEnabled = true;
    private String m_view = null;
    private String m_folder = null;
    private boolean m_bIncludeSubfolders = false;
    private WcmLibraryPanel m_libraryPanel;
    private WcmFoldersPanel m_foldersPanel;

    public WcmFoldersModel(WcmLibraryPanel libPanel, WcmFoldersPanel folderPanel) throws WcmException {
        this.m_libraryPanel = libPanel;
        this.m_foldersPanel = folderPanel;
        try {
            this.m_rowData = new Vector();
            ++this.m_nRows;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorInConstructor", "An error occurred while constructing object: {0}", (Object)e.getMessage());
        }
    }

    public void clearModel() {
        this.m_rowData = new Vector();
        this.fireTableRowsDeleted(0, this.m_nRows);
        this.m_nRows = 0;
    }

    public void copyItem(int nRowIndex) throws WcmException {
        WcmSearchFolder fieldDef = null;
        WcmSearchFolder newFieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null && (newFieldDef = fieldDef) != null) {
                this.m_rowData.addElement(newFieldDef);
                ++this.m_nRows;
                nRowIndex = this.getRowCount() - 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorInCopy", "An error occurred while copying a row: {0}", (Object)e.getMessage());
        }
    }

    public void deleteItem(int nRowIndex) throws WcmException {
        WcmSearchFolder fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                --this.m_nRows;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorInDelete", "An error occurred while deleting a row: {0}", (Object)e.getMessage());
        }
    }

    public void insertRow(int nRowIndex) throws WcmException {
        try {
            WcmSearchFolder fieldDef = new WcmSearchFolder();
            fieldDef.initializeItemID();
            if (fieldDef != null) {
                this.m_rowData.insertElementAt(fieldDef, nRowIndex);
                ++this.m_nRows;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorInInsert", "An error occurred while inserting a row: {0}", (Object)e.getMessage());
        }
    }

    public void enableViewColumn(boolean enable) {
        this.m_viewColEnabled = enable;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                if (this.m_viewColEnabled) {
                    return WcmResource.s_viewStr;
                }
                return new String("");
            }
            case 1: {
                return WcmResource.s_foldersStr;
            }
            case 2: {
                return WcmResource.s_includeSubfoldersStr;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        WcmSearchFolder fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (fieldDef != null) {
                        return fieldDef.getDisplayableViewStr();
                    }
                    return this.m_view;
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getFolderPath();
                    }
                    return this.m_folder;
                }
                case 2: {
                    if (fieldDef != null) {
                        return new Boolean(fieldDef.getIncludeSubfolders());
                    }
                    return new Boolean(this.m_bIncludeSubfolders);
                }
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("Caught an error in getValueAt(): " + e.getMessage());
            return null;
        }
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateView(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateFolders(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateIncludeSubfolders(aValue, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught an error in setValueAt(): " + e.getMessage());
        }
    }

    protected void removeBlankRows() {
        try {
            if (this.m_rowData == null) {
                return;
            }
            int dataSz = this.m_rowData.size();
            WcmSearchFolder fieldDef = null;
            for (int i = dataSz - 1; i >= 0; --i) {
                fieldDef = this.getItemAt(i);
                if (!fieldDef.isEmpty()) continue;
                this.deleteItem(i);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmFormatResultsModel::removeBlankRows(): " + e.getMessage());
        }
    }

    public void setFolders(Vector folders) {
        int rowCounter = 0;
        try {
            for (WcmSearchFolder item : folders) {
                this.insertRow(rowCounter);
                this.setItemAt(item, rowCounter);
                ++rowCounter;
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in setFolders(): " + e.getMessage());
        }
    }

    public void setFolder(WcmSearchFolder folder) {
        try {
            if (folder != null) {
                int rowCounter = this.getRowCount() - 1;
                this.insertRow(rowCounter);
                this.setItemAt(folder, rowCounter);
                this.m_view = null;
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in setFolder(): " + e.getMessage());
        }
    }

    public void setFolderAt(WcmSearchFolder folder, int nRowIndex) {
        try {
            if (folder != null) {
                int rowCounter = this.getRowCount() - 1;
                if (nRowIndex >= 0 && nRowIndex <= rowCounter) {
                    this.setItemAt(folder, nRowIndex);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in setFolderAt(): " + e.getMessage());
        }
    }

    private void onUpdateView(Object aValue, int nRowIndex) throws WcmException {
        WcmSearchFolder fieldDef = null;
        try {
            if (!this.m_viewColEnabled) {
                aValue = new String(WcmResource.s_hiddenStr);
            }
            if (aValue == null) {
                return;
            }
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setView(aValue.toString());
            } else {
                fieldDef = new WcmSearchFolder();
                fieldDef.initializeItemID();
                fieldDef.setView(aValue.toString());
                this.m_rowData.addElement(fieldDef);
                ++this.m_nRows;
                this.fireTableRowsInserted(nRowIndex + 1, nRowIndex + 1);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.UpdateView", "An error occurred while in onUpdateView(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateFolders(Object aValue, int nRowIndex) throws WcmException {
        WcmSearchFolder fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            String folderPath = aValue.toString();
            if (folderPath.compareTo("") == 0) {
                this.deleteItem(nRowIndex);
                return;
            }
            this.m_foldersPanel.m_parent.setStatusBarMsg(WcmResource.s_validatingFolder);
            String libName = null;
            int idx = folderPath.indexOf(":");
            if (idx >= 0 && !this.m_libraryPanel.isLibrarySelected(libName = folderPath.substring(0, idx))) {
                JOptionPane.showMessageDialog(this.m_foldersPanel, WcmResource.s_onlySelLibs, WcmResource.s_invalidOSName, 0);
                this.m_foldersPanel.m_parent.setStatusBarMsg(WcmResource.s_readyStr);
                return;
            }
            String folderName = new String(folderPath.substring(idx + 1));
            int FoldNameStatus = this.checkFolderNameValid(folderName);
            if (FoldNameStatus != 0) {
                String msg = "";
                if (FoldNameStatus == this.FOLDNAME_ERR_BADCHAR) {
                    msg = WcmResource.s_invalidFolderName;
                } else if (FoldNameStatus == this.FOLDNAME_ERR_MULTISLASH) {
                    msg = WcmResource.s_invalidFolderName2;
                }
                JOptionPane.showMessageDialog(this.m_foldersPanel, msg, WcmResource.s_invalidFolderTitle, 0);
                this.m_foldersPanel.m_parent.setStatusBarMsg(WcmResource.s_readyStr);
                return;
            }
            String folderID = null;
            if (libName != null) {
                folderID = this.lookupFolderId(libName, folderName, this.m_foldersPanel.getSession());
                if (folderID.length() == 0) {
                    this.m_foldersPanel.m_parent.setStatusBarMsg(WcmResource.s_readyStr);
                    return;
                }
            } else {
                folderID = new String("");
            }
            this.m_foldersPanel.showAllVersionsWithSubfoldersMsg();
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.updateFolder(folderPath.substring(idx + 1), libName);
                if (folderID != null) {
                    fieldDef.setId(folderID);
                }
            } else {
                this.m_folder = folderPath.substring(idx + 1);
                fieldDef = new WcmSearchFolder(this.m_folder, this.m_bIncludeSubfolders);
                fieldDef.initializeItemID();
                fieldDef.setLibraryName(libName);
                if (folderID != null) {
                    fieldDef.setId(folderID);
                }
                if (this.m_view != null) {
                    fieldDef.setView(this.m_view);
                } else if (this.m_viewColEnabled) {
                    fieldDef.setView(1);
                } else {
                    fieldDef.setView(2);
                }
                this.m_rowData.addElement(fieldDef);
                ++this.m_nRows;
                this.m_view = null;
                this.m_folder = "";
                this.m_bIncludeSubfolders = false;
                this.fireTableRowsInserted(nRowIndex + 1, nRowIndex + 1);
            }
            this.m_foldersPanel.m_parent.setStatusBarMsg(WcmResource.s_readyStr);
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorInUpdateFolders", "An error occurred while saving the folder data in row #{0}: {1}", new Integer(nRowIndex), (Object)e.getMessage());
        }
    }

    private void onUpdateIncludeSubfolders(Object aValue, int nRowIndex) throws WcmException {
        WcmSearchFolder fieldDef = null;
        boolean inclSubfolders = false;
        try {
            if (aValue == null) {
                return;
            }
            inclSubfolders = (Boolean)aValue;
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setIncludeSubfolders(inclSubfolders);
            } else {
                this.m_bIncludeSubfolders = inclSubfolders;
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorIncludeSubfolders", "An error occurred while saving the include Subfolders data in row #{0}: {1}", new Integer(nRowIndex), (Object)e.getMessage());
        }
    }

    public String lookupFolderId(String libName, String folder, Session session) {
        try {
            if (libName != null && folder != null && WcmString.compareIgnoreCase(libName, "") != 0 && WcmString.compareIgnoreCase(folder, "") != 0) {
                ObjectStore OS = ObjectFactory.getObjectStore((String)libName, (Session)session);
                Folder folderObj = (Folder)OS.getObject(2, folder);
                String id = folderObj.getId();
                return id;
            }
        }
        catch (Exception e) {
            String msg = WcmResource.s_cantGetFolder.toString(folder);
            JOptionPane.showMessageDialog(this.m_foldersPanel, msg, WcmResource.s_invalidFolderTitle, 0);
            return new String("");
        }
        return new String("");
    }

    public void setItemAt(WcmSearchFolder item, int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return;
            }
            if (nRowIndex < this.m_rowData.size()) {
                this.m_rowData.setElementAt(item, nRowIndex);
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorGetItemAt", "An error occurred retrieving the data in row #{0}: {1}", new Integer(nRowIndex), (Object)e.getMessage());
        }
    }

    public WcmSearchFolder getItemAt(int nRowIndex) throws WcmException {
        WcmSearchFolder fieldDef = null;
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return null;
            }
            if (nRowIndex < this.m_rowData.size()) {
                fieldDef = (WcmSearchFolder)this.m_rowData.elementAt(nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmFoldersModel.errorGetItemAt", "An error occurred retrieving the data in row #{0}: {1}", new Integer(nRowIndex), (Object)e.getMessage());
        }
        return fieldDef;
    }

    private int checkFolderNameValid(String fname) {
        char[] chBad = new char[]{'*', '?', '\"', '<', '>', '|'};
        char[] chSlash = new char[]{'/', '\\'};
        int startPos = 0;
        if (fname == null || fname.length() == 0) {
            return 0;
        }
        if (fname.startsWith("\\") || fname.startsWith("/")) {
            startPos = 1;
        }
        if (fname.length() > 1 && (fname.charAt(1) == chSlash[0] || fname.charAt(1) == chSlash[1])) {
            return 1;
        }
        for (int i = 0; i < chBad.length; ++i) {
            if (fname.indexOf(chBad[i], startPos) < 0) continue;
            return 2;
        }
        return 0;
    }
}

