/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchCriteriaPanel;
import com.filenet.wcm.apps.client.search.ui.WcmSearchModel;
import com.filenet.wcm.apps.client.search.ui.WcmZoneDlg;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.CBRSearchParser;
import com.filenet.wcm.toolkit.util.CBRSearchType;
import com.filenet.wcm.toolkit.util.CBRSearchXMLUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.Vector;
import javax.swing.JOptionPane;

public class WcmContentsModel
extends WcmSearchModel {
    private final int NUM_COLUMNS = 3;
    public static final int VIEW_COL = 0;
    public static final int WORDS_COL = 1;
    public static final int MODIFIERS_COL = 2;
    private String m_view = null;
    private String m_words = null;
    private String m_modifier = null;
    private String m_zone = null;
    private static final WcmString INVALID_MODIFIER = new WcmString("toolkit.WcmContentModel.invalidModifier", "{0} is not a supported modifier.");

    public WcmContentsModel(int initialMode, WcmSearchCriteriaPanel dlgPanel) throws WcmException {
        super(initialMode, dlgPanel);
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return WcmResource.s_viewStr;
            }
            case 1: {
                return WcmResource.s_wordsStr;
            }
            case 2: {
                return WcmResource.s_modifiersStr;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        WcmCondition fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (fieldDef != null) {
                        return fieldDef.getDisplayableViewStr();
                    }
                    return this.m_view;
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getProperty();
                    }
                    return this.m_words;
                }
                case 2: {
                    if (fieldDef != null) {
                        return fieldDef.getDisplayableOperator();
                    }
                    return this.m_modifier;
                }
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("An error occurred in getValueAt(" + nRowIndex + ", " + nColumnIndex + "): " + e.getMessage());
            return null;
        }
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateView(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateWords(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateModifiers(aValue, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred in setValueAt(): " + e.getMessage());
        }
    }

    public void setTree(WcmQTree tree) {
        int rowIndex = 0;
        try {
            super.setTree(tree);
            Vector leaves = tree.getAllLeaves();
            for (WcmCondition item : leaves) {
                WcmCondition itemCopy = new WcmCondition(item);
                this.insertRow(rowIndex, false);
                this.setItemAt(itemCopy, rowIndex);
                ++rowIndex;
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
        catch (Exception e) {
            System.out.println("Caught exception in setTree(): " + e.getMessage());
        }
    }

    public boolean validate() {
        boolean isValid;
        StringBuffer errorMsgBuffer = new StringBuffer();
        for (int i = 0; i < this.m_rowData.size(); ++i) {
            String errorMsg = this.validateCondition(i);
            if (errorMsg == null) continue;
            errorMsgBuffer.append(errorMsg);
        }
        boolean bl = isValid = errorMsgBuffer.length() == 0;
        if (!isValid) {
            JOptionPane.showMessageDialog(this.m_dialogPanel, errorMsgBuffer.toString(), WcmResource.s_invalidContentCond, 0);
        }
        return isValid;
    }

    public String validateCondition(int index) {
        StringBuffer errorMsgBuffer = new StringBuffer();
        try {
            WcmCondition condition = this.getItemAt(index);
            CBRSearchType cbrSearchType = this.m_dialogPanel.m_parent.getCBRSearchType();
            CBRSearchParser parser = CBRSearchXMLUtil.getCBRSearchParser(cbrSearchType, null);
            boolean hadError = condition.hasError();
            condition.setHasError(false);
            if (!CBRSearchXMLUtil.isModifierCompatible(this.m_dialogPanel.m_parent.getCBRSearchType(), condition.getOperator())) {
                condition.setHasError(true);
                errorMsgBuffer.append(WcmResource.s_lineStr);
                errorMsgBuffer.append(index + 1);
                errorMsgBuffer.append(": ");
                errorMsgBuffer.append(INVALID_MODIFIER.toString(condition.getOperator()));
                errorMsgBuffer.append("\n");
            }
            int view = condition.getView();
            boolean required = this.m_currentMode == 1 || view == 4 || view == 3;
            String errorMsg = parser.validate(condition.getProperty(), condition.getOperator(), required);
            if (errorMsg != null) {
                condition.setHasError(true);
                errorMsgBuffer.append(WcmResource.s_lineStr);
                errorMsgBuffer.append(index + 1);
                errorMsgBuffer.append(": ");
                errorMsgBuffer.append(errorMsg);
                errorMsgBuffer.append("\n");
            }
            if (condition.hasError() != hadError) {
                this.fireTableRowsUpdated(index, index);
            }
        }
        catch (WcmException e) {
            System.out.println("Failed to validate condition: " + e.getMessage());
        }
        return errorMsgBuffer.length() > 0 ? errorMsgBuffer.toString() : null;
    }

    private void createNewRecord(int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        try {
            fieldDef = new WcmCondition();
            this.m_rowData.addElement(fieldDef);
            ++this.m_nRows;
            fieldDef.initializePropertyID();
            if (this.m_view == null) {
                if (this.m_currentMode == 1) {
                    fieldDef.setView(3);
                } else if (this.m_currentMode == 2) {
                    fieldDef.setView(2);
                }
            } else {
                fieldDef.setView(this.m_view);
            }
            if (this.m_words != null) {
                fieldDef.setProperty(this.m_words);
            }
            if (this.m_zone != null) {
                fieldDef.setZone(this.m_zone);
            }
            if (this.m_modifier != null) {
                fieldDef.setOperator(this.m_modifier);
            }
            fieldDef.setValueFieldNotRequired();
            fieldDef.setIsPropertyCondition(false);
            this.m_tree.appendNode(fieldDef, this.m_isDefaultAnd);
            this.m_view = null;
            this.m_words = null;
            this.m_modifier = null;
            this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
        }
        catch (Exception e) {
            System.out.println("Caught exception in createNewRecord(): " + e.getMessage());
        }
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    private void onUpdateView(Object aValue, int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            String view = new String(aValue.toString());
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setView(view);
            } else {
                this.m_view = view;
                this.createNewRecord(nRowIndex);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmContentsModel.errorInUpdateView", "An error occurred while in onUpdateView(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateWords(Object aValue, int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        boolean singleWordCBR = false;
        try {
            if (aValue == null) {
                return;
            }
            String words = new String(aValue.toString());
            int index = (words = words.trim()).indexOf(32);
            if (index <= 0) {
                singleWordCBR = true;
            }
            if ((fieldDef = this.getItemAt(nRowIndex)) != null) {
                fieldDef.setProperty(aValue.toString());
                if (fieldDef.getNearList() != null) {
                    this.setupNearClause(nRowIndex);
                }
                fieldDef.setSingleWordCBR(singleWordCBR);
            } else {
                this.m_words = aValue.toString();
                this.createNewRecord(nRowIndex);
                fieldDef = this.getItemAt(nRowIndex);
                if (fieldDef != null) {
                    fieldDef.setSingleWordCBR(singleWordCBR);
                    if (this.m_modifier == null && fieldDef.getOperator().length() == 0) {
                        if (singleWordCBR) {
                            fieldDef.setOperator(WcmResource.s_verityNoneStr);
                        } else {
                            fieldDef.setOperator(WcmResource.s_allStr);
                        }
                    }
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmContentsModel.errorInUpdateWords", "An error occurred while in onUpdateWords(): {0}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onUpdateModifiers(Object aValue, int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        Object zone = null;
        try {
            if (aValue == null) {
                return;
            }
            String modifier = new String(aValue.toString());
            if (WcmString.compareIgnoreCase(modifier, WcmResource.s_inZoneStr) == 0) {
                WcmZoneDlg zoneDlg = new WcmZoneDlg(this.m_dialogPanel.m_parent.getParentFrame());
                zoneDlg.init();
                zoneDlg.setVisible(true);
                if (zoneDlg.getStatus() != 1) return;
                this.m_zone = zoneDlg.getText();
            } else {
                this.m_zone = new String("");
            }
            modifier = CBRSearchXMLUtil.convertToInternalModifier(modifier);
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setOperator(modifier);
                if (this.m_zone != null) {
                    fieldDef.setZone(this.m_zone);
                }
            } else {
                this.m_modifier = modifier;
                this.createNewRecord(nRowIndex);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmContentsModel.errorInUpdateModifiers", "An error occurred while in onUpdateModifiers(): {0}", (Object)e.getMessage());
        }
    }

    private void setupNearClause(int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        boolean phrase = false;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                phrase = new Boolean(fieldDef.getOperator());
                if (phrase) {
                    fieldDef.setNearList(null);
                } else {
                    String words = new String(fieldDef.getProperty());
                    int index = (words = words.trim()).indexOf(32);
                    if (index > 0) {
                        Vector<WcmCondition> nearList = new Vector<WcmCondition>();
                        while (index != -1) {
                            WcmCondition word = new WcmCondition();
                            word.initializePropertyID();
                            word.setView(fieldDef.getView());
                            word.setProperty(words.substring(0, index));
                            word.setOperator("false");
                            nearList.addElement(word);
                            words = words.substring(index + 1);
                            words = words.trim();
                            index = words.indexOf(32);
                        }
                        WcmCondition lastWord = new WcmCondition();
                        lastWord.initializePropertyID();
                        lastWord.setView(fieldDef.getView());
                        lastWord.setProperty(words);
                        lastWord.setOperator("false");
                        nearList.addElement(lastWord);
                        fieldDef.setNearList(nearList);
                    } else {
                        fieldDef.setNearList(null);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmContentsModel.errorInNearClause", "An error occurred while in setupNearClause(): {0}", (Object)e.getMessage());
        }
    }
}

