/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import filenet.vw.toolkit.utils.datatransfer.IVWCBData;
import java.awt.datatransfer.DataFlavor;

public class WcmColumnHeader
implements IVWCBData {
    public static final DataFlavor HEADER_DATAFLAVOR = new DataFlavor(WcmColumnHeader.class, "Column Header");
    public static final String XML_LEFT = "left";
    public static final String XML_RIGHT = "right";
    public static final String XML_CENTER = "center";
    public static final String XML_NONE = "none";
    public static final String XML_ASC = "ascending";
    public static final String XML_DESC = "descending";
    private int m_itemId = 0;
    private String m_propertyName = null;
    private WcmWrappedPD m_propertyDesc = null;
    private String m_propertyLabel = null;
    private String m_alignment = null;
    private String m_sortOrder = null;
    private int m_sortPriority = 0;
    private boolean m_isOrderable = true;
    private int m_sourceObjType = 1;
    private static int m_idCounter = 0;

    public WcmColumnHeader() {
    }

    public WcmColumnHeader(WcmWrappedPD propDesc) throws WcmException {
        try {
            this.m_propertyDesc = propDesc;
            this.initProperties();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmColumnHeader.constructor1", "Error occurred constructing WcmProperty with a PropertyDescription {0}", (Object)e.getMessage());
        }
    }

    public WcmColumnHeader(SearchPropertyDescription propDesc) throws WcmException {
        try {
            this.m_propertyDesc = new WcmWrappedPD(propDesc);
            this.initProperties();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmColumnHeader.constructor2", "Error occurred constructing WcmProperty with a PropertyDescription {0}", (Object)e.getMessage());
        }
    }

    public WcmColumnHeader(WcmColumnHeader otherCondition) {
        this.m_itemId = otherCondition.m_itemId;
        this.m_propertyName = otherCondition.m_propertyName;
        this.m_propertyDesc = otherCondition.m_propertyDesc;
        this.m_propertyLabel = otherCondition.m_propertyLabel;
        this.m_alignment = otherCondition.m_alignment;
        this.m_sortOrder = otherCondition.m_sortOrder;
        this.m_sortPriority = otherCondition.m_sortPriority;
        this.m_isOrderable = otherCondition.m_isOrderable;
        this.m_sourceObjType = otherCondition.m_sourceObjType;
    }

    public void initializePropertyID() {
        this.m_itemId = ++m_idCounter;
    }

    public boolean isEmpty() {
        return this.m_propertyName == null && this.m_alignment == null && this.m_sortOrder == null && this.m_propertyDesc == null;
    }

    public boolean isOrderable() {
        return this.m_isOrderable;
    }

    public void setIsOrderable(boolean isOrderable) {
        this.m_isOrderable = isOrderable;
    }

    public int getItemId() {
        return this.m_itemId;
    }

    public void setItemId(int id) {
        this.m_itemId = id;
    }

    public String getPropertyName() {
        return this.m_propertyName;
    }

    public void setPropertyName(String name) {
        this.m_propertyName = name;
    }

    public void setObjType(int objType) {
        this.m_sourceObjType = objType;
        if (this.m_propertyDesc != null) {
            this.m_propertyDesc.setSourceObjType(objType);
        }
    }

    public int getObjType() {
        return this.m_sourceObjType;
    }

    public WcmWrappedPD getPropertyDescription() {
        return this.m_propertyDesc;
    }

    public void setPropertyDescription(WcmWrappedPD propDesc) {
        try {
            this.m_propertyDesc = propDesc;
            this.initProperties();
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmColumnHeader::setPropertyDescription(): " + e.getMessage());
        }
    }

    public void setPropertyDescription(SearchPropertyDescription propDesc) {
        this.setPropertyDescription(new WcmWrappedPD(propDesc));
    }

    public String getPropertyLabel() {
        return this.m_propertyLabel;
    }

    public void setPropertyLabel(String label) {
        this.m_propertyLabel = label;
    }

    public String getXMLAlignment() {
        return this.m_alignment;
    }

    public String getViewAlignment() {
        if (this.m_alignment != null) {
            if (WcmString.compareIgnoreCase(this.m_alignment, XML_LEFT) == 0) {
                return new String(WcmResource.s_leftStr);
            }
            if (WcmString.compareIgnoreCase(this.m_alignment, XML_RIGHT) == 0) {
                return new String(WcmResource.s_rightStr);
            }
            if (WcmString.compareIgnoreCase(this.m_alignment, XML_CENTER) == 0) {
                return new String(WcmResource.s_centerStr);
            }
        }
        return new String("");
    }

    public void setXMLAlignment(String alignment) throws WcmException {
        if (WcmString.compareIgnoreCase(alignment, XML_LEFT) != 0 && WcmString.compareIgnoreCase(alignment, XML_RIGHT) != 0 && WcmString.compareIgnoreCase(alignment, XML_CENTER) != 0) {
            throw new WcmException("client.WcmColumnHeader.setAlignment", "Incorrect alignment setting: {0}", (Object)alignment);
        }
        this.m_alignment = alignment;
    }

    public void setViewAlignment(String alignment) throws WcmException {
        if (WcmString.compareIgnoreCase(alignment, WcmResource.s_leftStr) == 0) {
            this.m_alignment = XML_LEFT;
        } else if (WcmString.compareIgnoreCase(alignment, WcmResource.s_rightStr) == 0) {
            this.m_alignment = XML_RIGHT;
        } else if (WcmString.compareIgnoreCase(alignment, WcmResource.s_centerStr) == 0) {
            this.m_alignment = XML_CENTER;
        } else {
            throw new WcmException("client.WcmColumnHeader.setAlignment", "Incorrect alignment setting: {0}", (Object)alignment);
        }
    }

    public String getXMLOrder() {
        return this.m_sortOrder;
    }

    public String getViewOrder() {
        if (this.m_sortOrder != null) {
            if (WcmString.compareIgnoreCase(this.m_sortOrder, XML_NONE) == 0) {
                return new String(WcmResource.s_noneStr);
            }
            if (WcmString.compareIgnoreCase(this.m_sortOrder, XML_ASC) == 0) {
                return new String(WcmResource.s_ascendingStr);
            }
            if (WcmString.compareIgnoreCase(this.m_sortOrder, XML_DESC) == 0) {
                return new String(WcmResource.s_descendingStr);
            }
        }
        return new String("");
    }

    public void setXMLOrder(String order) throws WcmException {
        if (WcmString.compareIgnoreCase(order, XML_NONE) != 0 && WcmString.compareIgnoreCase(order, XML_ASC) != 0 && WcmString.compareIgnoreCase(order, XML_DESC) != 0) {
            throw new WcmException("client.WcmColumnHeader.setOrder", "Incorrect sort order setting: {0}", (Object)order);
        }
        this.m_sortOrder = order;
    }

    public void setViewOrder(String order) throws WcmException {
        if (WcmString.compareIgnoreCase(order, WcmResource.s_noneStr) == 0) {
            this.m_sortOrder = XML_NONE;
        } else if (WcmString.compareIgnoreCase(order, WcmResource.s_ascendingStr) == 0) {
            this.m_sortOrder = XML_ASC;
        } else if (WcmString.compareIgnoreCase(order, WcmResource.s_descendingStr) == 0) {
            this.m_sortOrder = XML_DESC;
        } else {
            throw new WcmException("client.WcmColumnHeader.setOrder", "Incorrect sort order setting: {0}", (Object)order);
        }
    }

    public int getSortPriority() {
        return this.m_sortPriority;
    }

    public void setSortPriority(int level) {
        this.m_sortPriority = level;
    }

    public String getLevelStr() {
        String level = new String("0");
        if (this.m_sortPriority != 0) {
            level = new Integer(this.m_sortPriority).toString();
        }
        return level;
    }

    private void initProperties() throws Exception {
        this.m_propertyName = this.m_propertyDesc.getName();
        this.m_propertyLabel = this.m_propertyDesc.getDisplayName();
        this.m_isOrderable = this.m_propertyDesc.getPropertyDesc().getPropertyBooleanValue("IsOrderable");
    }

    public String toString() {
        String tempStr = new String();
        tempStr = new Integer(this.m_itemId).toString() + ";";
        tempStr = tempStr + this.m_propertyName + ";";
        tempStr = tempStr + this.m_propertyLabel + ";";
        tempStr = tempStr + this.m_alignment + ";";
        tempStr = tempStr + this.m_sortOrder + ";";
        tempStr = tempStr + new Integer(this.m_sortPriority).toString();
        return tempStr;
    }

    public void setContent(String content) {
        if (content.length() == 0) {
            return;
        }
        String itemId = this.getNextParam(content);
        if (WcmString.compareIgnoreCase(itemId, "null") == 0) {
            this.initializePropertyID();
        } else {
            this.m_itemId = new Integer(itemId);
        }
        content = this.removeParam(content, itemId);
        this.m_propertyName = this.getNextParam(content);
        content = this.removeParam(content, this.m_propertyName);
        this.m_propertyLabel = this.getNextParam(content);
        content = this.removeParam(content, this.m_propertyLabel);
        this.m_alignment = this.getNextParam(content);
        content = this.removeParam(content, this.m_alignment);
        this.m_sortOrder = this.getNextParam(content);
        content = this.removeParam(content, this.m_sortOrder);
        String level = this.getNextParam(content);
        if (level.length() > 0) {
            this.m_sortPriority = new Integer(level);
        }
    }

    private String getNextParam(String buf) {
        int semiColonLoc = 0;
        semiColonLoc = buf.indexOf(";");
        if (semiColonLoc == -1) {
            return buf;
        }
        return buf.substring(0, semiColonLoc);
    }

    private String removeParam(String buf, String param) {
        if (buf == null) {
            return null;
        }
        if (WcmString.compareIgnoreCase(buf, param) == 0) {
            return null;
        }
        int len = param.length();
        if (len == -1) {
            return buf;
        }
        return buf.substring(len + 1, buf.length());
    }

    public String getContent() {
        return this.toString();
    }

    public DataFlavor getDataFlavor() {
        return HEADER_DATAFLAVOR;
    }
}

