/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.impl.BaseObjectImpl;
import com.filenet.wcm.apps.client.search.ui.WcmClassCellRenderer;
import com.filenet.wcm.apps.client.util.StringUtil;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;

public class WcmClassDescComboBox
extends JComboBox {
    private WcmClassRenderer m_renderer = null;
    private ClassDescriptions m_classes = null;

    public void WcmClassDescComboBox() {
        this.init(null);
    }

    public void WcmClassDescComboBox(ClassDescriptions classes) {
        this.init(classes);
    }

    public void setClassDescriptions(ClassDescriptions classes) {
        this.init(classes);
    }

    public WcmClassCellRenderer getClassCellRenderer() {
        return new WcmClassCellRenderer();
    }

    private void init(ClassDescriptions classes) {
        this.m_renderer = new WcmClassRenderer(this);
        this.m_renderer.setVerticalTextPosition(1);
        this.m_renderer.setBackground(new Color(255, 255, 255));
        this.m_renderer.setOpaque(true);
        this.setRenderer(this.m_renderer);
        this.removeAllItems();
        try {
            this.m_classes = PropertyUtil.sort(classes);
        }
        catch (Exception e) {
            System.out.println("Couldn't sort the class descriptions.  Displaying them as is.  Exception: " + e.getMessage());
        }
        if (this.m_classes != null && this.m_classes.size() > 0) {
            for (ClassDescription cDesc : this.m_classes) {
                try {
                    this.addItem(cDesc);
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean selectWithKeyChar(char keyChar) {
        StringBuffer userChar = new StringBuffer();
        userChar.append(keyChar);
        try {
            ClassDescription foundObj = PropertyUtil.findClassDesc(userChar.toString(), this.m_classes);
            int index = this.m_classes.indexOf((Object)foundObj);
            if (index != -1) {
                this.setSelectedIndex(index);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public class WcmClassRenderer
    extends DefaultListCellRenderer {
        private JComboBox comboBox;

        public WcmClassRenderer(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon propIcon = null;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Object internalValue = value;
            if (value != null && value instanceof ClassDescription) {
                ClassDescription info = (ClassDescription)value;
                if (info != null) {
                    ObjectStores oss = ((BaseObjectImpl)info).getSearchObjectStores();
                    int nObjType = -1;
                    try {
                        nObjType = info.getPropertyIntValue("InstanceType");
                        if (nObjType == 1) {
                            propIcon = WcmImageLoader.createImageIcon("type/GenericDocument16.gif");
                        } else if (nObjType == 2) {
                            propIcon = WcmImageLoader.createImageIcon("type/Folder16.gif");
                        } else if (nObjType == 15) {
                            propIcon = WcmImageLoader.createImageIcon("type/CustomObject16.gif");
                        }
                        if (propIcon != null) {
                            this.setIcon(propIcon);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String text = null;
                    try {
                        text = info.getPropertyStringValue("DisplayName");
                    }
                    catch (PropertyNotFoundException e) {
                        text = "";
                    }
                    this.setToolTipText(text);
                    int availableWidth = this.comboBox.getWidth() - 50;
                    text = StringUtil.truncateText(text, availableWidth, this);
                    this.setText(text);
                } else {
                    this.setText(new String(""));
                }
            }
            return this;
        }
    }
}

