/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSearchOptionsRec;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.util.WcmHelp;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class WcmAuthOptionsDialog
extends VWModalDialog
implements ActionListener {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    protected int m_status = 2;
    private WcmSearchOptionsRec m_optionsRec = new WcmSearchOptionsRec();
    private WcmSearchOptionsRec m_oldOptions = null;
    private Container m_contentPane;
    private JCheckBox m_showMaxReturnedBox;
    private JCheckBox m_showOperatorsBox;
    private JCheckBox m_showLogicalOperatorsBox;
    private JCheckBox m_enableVersionsBox;
    private ButtonGroup m_searchVersionsGroup;
    private JRadioButton m_currentVerBtn;
    private JRadioButton m_releasedVerBtn;
    private JRadioButton m_allVersionsBtn;
    private JCheckBox m_rankContentBox;
    private JCheckBox m_docSummaryBox;
    private JLabel m_intraGridLabel;
    private ButtonGroup m_intraGridGroup;
    private JRadioButton m_intraAndBtn;
    private JRadioButton m_intraOrBtn;
    private JLabel m_mergePropsLabel;
    private ButtonGroup m_mergePropsGroup;
    private JRadioButton m_intersectionBtn;
    private JRadioButton m_unionBtn;
    private JButton m_OKButton;
    private JButton m_cancelButton;
    private JButton m_helpButton;
    private JTabbedPane m_tabbedPane;
    private JPanel m_genericPanel;
    private JPanel m_criteriaPanel;
    private JPanel m_templatePanel;
    private boolean m_hasSubFolders;
    private boolean m_hasMergeTypeChanged;
    private boolean m_OSHasBeenSelected;
    private Frame m_parentFrame;
    private WcmSearchAuthCore m_parent;

    public WcmAuthOptionsDialog(Frame parentFrame, WcmSearchAuthCore parent) {
        super(parentFrame);
        this.m_showMaxReturnedBox = new JCheckBox(WcmResource.s_showMaxReturnedStr, this.m_optionsRec.m_showMaxReturned);
        this.m_showOperatorsBox = new JCheckBox(WcmResource.s_showOperatorsStr, this.m_optionsRec.m_showOperators);
        this.m_showLogicalOperatorsBox = new JCheckBox(WcmResource.s_showLogicalOperatorsStr, this.m_optionsRec.m_showLogicalOperators);
        this.m_enableVersionsBox = new JCheckBox(WcmResource.s_enableVersionsStr);
        this.m_searchVersionsGroup = new ButtonGroup();
        this.m_currentVerBtn = new JRadioButton(WcmResource.s_currentVerStr);
        this.m_releasedVerBtn = new JRadioButton(WcmResource.s_releasedVersionStr);
        this.m_allVersionsBtn = new JRadioButton(WcmResource.s_allVersionsStr);
        this.m_rankContentBox = new JCheckBox(WcmResource.s_rankContentStr, this.m_optionsRec.m_rankContent);
        this.m_docSummaryBox = new JCheckBox(WcmResource.s_docSummaryStr, this.m_optionsRec.m_docSummary);
        this.m_intraGridLabel = new JLabel(WcmResource.s_intraGridStr);
        this.m_intraGridGroup = new ButtonGroup();
        this.m_intraAndBtn = new JRadioButton(WcmResource.s_andStr, this.m_optionsRec.m_intraGridAnd);
        this.m_intraOrBtn = new JRadioButton(WcmResource.s_orStr, !this.m_optionsRec.m_intraGridAnd);
        this.m_mergePropsLabel = new JLabel(WcmResource.s_mergePropsStr);
        this.m_mergePropsGroup = new ButtonGroup();
        this.m_intersectionBtn = new JRadioButton(WcmResource.s_intersectionStr, !this.m_optionsRec.m_union);
        this.m_unionBtn = new JRadioButton(WcmResource.s_unionStr, this.m_optionsRec.m_union);
        this.m_OKButton = new JButton(WcmResourceString.s_ok);
        this.m_cancelButton = new JButton(WcmResourceString.s_cancel);
        this.m_helpButton = new JButton(WcmResource.s_help);
        this.m_tabbedPane = new JTabbedPane();
        this.m_genericPanel = new JPanel();
        this.m_criteriaPanel = new JPanel();
        this.m_templatePanel = new JPanel();
        this.m_hasSubFolders = false;
        this.m_hasMergeTypeChanged = false;
        this.m_OSHasBeenSelected = false;
        this.m_parentFrame = null;
        this.m_parent = null;
        this.m_parentFrame = parentFrame;
        this.m_parent = parent;
    }

    public void init() {
        this.m_contentPane = this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout(10, 10));
        this.setTitle(WcmResource.s_searchAuthOptionsStr);
        Dimension dim = WcmStringUtil.stringToDimension(WcmResource.s_toolsOptionsDlgDim);
        if (dim == null) {
            dim = new Dimension(505, 340);
        }
        this.setSize(dim);
        this.setVisible(false);
        this.m_mergePropsGroup.add(this.m_intersectionBtn);
        this.m_mergePropsGroup.add(this.m_unionBtn);
        this.m_intraGridGroup.add(this.m_intraAndBtn);
        this.m_intraGridGroup.add(this.m_intraOrBtn);
        this.m_searchVersionsGroup.add(this.m_currentVerBtn);
        this.m_searchVersionsGroup.add(this.m_releasedVerBtn);
        this.m_searchVersionsGroup.add(this.m_allVersionsBtn);
        GridBagConstraints standard = new GridBagConstraints();
        standard.gridx = 0;
        standard.gridy = 1;
        standard.anchor = 21;
        standard.fill = 0;
        standard.insets = new Insets(0, 20, 0, 0);
        GridBagConstraints inset = new GridBagConstraints();
        inset.gridx = 0;
        inset.anchor = 21;
        inset.fill = 0;
        inset.insets = new Insets(0, 40, 0, 0);
        int align = this.m_parent.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT ? 0 : 2;
        JPanel genericSubPanel = new JPanel(new GridBagLayout());
        genericSubPanel.add((Component)this.m_mergePropsLabel, standard);
        genericSubPanel.add((Component)this.m_intersectionBtn, inset);
        genericSubPanel.add((Component)this.m_unionBtn, inset);
        standard.gridy = 4;
        genericSubPanel.add((Component)this.m_rankContentBox, standard);
        standard.gridy = 5;
        genericSubPanel.add((Component)this.m_docSummaryBox, standard);
        standard.gridy = 6;
        genericSubPanel.add((Component)this.m_enableVersionsBox, standard);
        genericSubPanel.add((Component)this.m_currentVerBtn, inset);
        genericSubPanel.add((Component)this.m_releasedVerBtn, inset);
        genericSubPanel.add((Component)this.m_allVersionsBtn, inset);
        this.m_genericPanel.setLayout(new FlowLayout(align, 10, 20));
        this.m_genericPanel.add(genericSubPanel);
        JPanel criteriaSubPanel = new JPanel(new GridBagLayout());
        criteriaSubPanel.add((Component)this.m_intraGridLabel, standard);
        criteriaSubPanel.add((Component)this.m_intraAndBtn, inset);
        criteriaSubPanel.add((Component)this.m_intraOrBtn, inset);
        this.m_criteriaPanel.setLayout(new FlowLayout(align, 10, 20));
        this.m_criteriaPanel.add(criteriaSubPanel);
        JPanel templateSubPanel = new JPanel(new GridBagLayout());
        templateSubPanel.add((Component)this.m_showMaxReturnedBox, standard);
        standard.gridy = 2;
        templateSubPanel.add((Component)this.m_showOperatorsBox, standard);
        standard.gridy = 3;
        templateSubPanel.add((Component)this.m_showLogicalOperatorsBox, standard);
        this.m_templatePanel.setLayout(new FlowLayout(align, 10, 20));
        this.m_templatePanel.add(templateSubPanel);
        JScrollPane scrollableGenericPanel = new JScrollPane(this.m_genericPanel, 20, 30);
        scrollableGenericPanel.setBorder(BorderFactory.createEmptyBorder());
        this.m_tabbedPane.add(WcmResource.s_generalOptionsStr, scrollableGenericPanel);
        this.m_tabbedPane.add(WcmResource.s_criteriaOptionsStr, this.m_criteriaPanel);
        this.m_tabbedPane.add(WcmResource.s_templateOptionsStr, this.m_templatePanel);
        this.m_contentPane.add("Center", this.m_tabbedPane);
        JPanel buttonPanel = new JPanel();
        this.m_OKButton.setSelected(true);
        this.m_OKButton.setMnemonic(WcmResourceString.okMonic.charAt(0));
        this.m_cancelButton.setMnemonic(WcmResourceString.cancelMonic.charAt(0));
        this.m_helpButton.setMnemonic(WcmResourceString.s_menuHelpNMonic.charAt(0));
        buttonPanel.add(this.m_OKButton);
        buttonPanel.add(this.m_cancelButton);
        buttonPanel.add(this.m_helpButton);
        this.getRootPane().setDefaultButton(this.m_OKButton);
        this.m_contentPane.add("Last", buttonPanel);
        this.m_OKButton.addActionListener(this);
        this.m_cancelButton.addActionListener(this);
        this.m_helpButton.addActionListener(this);
        this.m_enableVersionsBox.addActionListener(this);
        this.m_allVersionsBtn.addActionListener(this);
        this.m_intersectionBtn.addActionListener(this);
        this.m_unionBtn.addActionListener(this);
        this.m_status = 2;
    }

    public void enableRankContent(boolean enable) {
        this.m_rankContentBox.setEnabled(enable);
    }

    public void enableVersionSelection(boolean enable) {
        this.m_enableVersionsBox.setEnabled(enable);
        if (enable && this.m_enableVersionsBox.isSelected()) {
            this.m_currentVerBtn.setEnabled(enable);
            this.m_releasedVerBtn.setEnabled(enable);
            this.m_allVersionsBtn.setEnabled(enable);
        } else if (!enable) {
            this.m_currentVerBtn.setEnabled(enable);
            this.m_releasedVerBtn.setEnabled(enable);
            this.m_allVersionsBtn.setEnabled(enable);
        }
    }

    public void setValues(WcmSearchOptionsRec values) {
        this.m_optionsRec = values;
        this.resetUItoMatchAttributes();
    }

    public WcmSearchOptionsRec getValues() {
        return this.m_optionsRec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setVersionSelection(int value) throws WcmException {
        if (value < 0) throw new WcmException("client.WcmAuthOptionsDialog.invalidVersionSel", "Invalid Version Selection value: {0}", new Integer(value));
        if (value > 3) throw new WcmException("client.WcmAuthOptionsDialog.invalidVersionSel", "Invalid Version Selection value: {0}", new Integer(value));
        if (value == 0) {
            this.m_enableVersionsBox.setSelected(false);
            this.m_currentVerBtn.setEnabled(false);
            this.m_releasedVerBtn.setEnabled(false);
            this.m_allVersionsBtn.setEnabled(false);
            return;
        } else if (value == 1) {
            this.m_enableVersionsBox.setSelected(true);
            this.m_currentVerBtn.setSelected(true);
            this.m_currentVerBtn.setEnabled(true);
            this.m_releasedVerBtn.setEnabled(true);
            this.m_allVersionsBtn.setEnabled(true);
            return;
        } else if (value == 2) {
            this.m_enableVersionsBox.setSelected(true);
            this.m_releasedVerBtn.setSelected(true);
            this.m_currentVerBtn.setEnabled(true);
            this.m_releasedVerBtn.setEnabled(true);
            this.m_allVersionsBtn.setEnabled(true);
            return;
        } else {
            if (value != 3) return;
            this.m_enableVersionsBox.setSelected(true);
            this.m_allVersionsBtn.setSelected(true);
            this.m_currentVerBtn.setEnabled(true);
            this.m_releasedVerBtn.setEnabled(true);
            this.m_allVersionsBtn.setEnabled(true);
        }
    }

    public int getVersionSelection() {
        return this.m_optionsRec.m_versionSelection;
    }

    public void setIntraGridAnd(boolean value) {
        this.m_optionsRec.m_intraGridAnd = value;
    }

    public boolean getIntraGridAnd() {
        return this.m_optionsRec.m_intraGridAnd;
    }

    public void setShowMaxReturned(boolean value) {
        this.m_optionsRec.m_showMaxReturned = value;
    }

    public boolean getShowMaxReturned() {
        return this.m_optionsRec.m_showMaxReturned;
    }

    public void setShowOperators(boolean value) {
        this.m_optionsRec.m_showOperators = value;
    }

    public boolean getShowOperators() {
        return this.m_optionsRec.m_showOperators;
    }

    public void setShowLogicalOperators(boolean value) {
        this.m_optionsRec.m_showLogicalOperators = value;
    }

    public boolean getShowLogicalOperators() {
        return this.m_optionsRec.m_showLogicalOperators;
    }

    public void setHasSubFolders(boolean value) {
        this.m_hasSubFolders = value;
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public int getStatus() {
        return this.m_status;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_OKButton) {
            if (!this.updateAttributes()) {
                return;
            }
            this.m_status = 1;
            this.setVisible(false);
        } else if (event.getSource() == this.m_cancelButton) {
            this.setVisible(false);
            this.m_status = 2;
            this.resetUItoMatchAttributes();
        } else if (event.getSource() == this.m_helpButton) {
            WcmHelp.displayPage(WcmResourceString.s_helpSearchOptions);
        } else if (event.getSource() == this.m_enableVersionsBox) {
            if (this.m_enableVersionsBox.isSelected()) {
                this.m_currentVerBtn.setEnabled(true);
                this.m_releasedVerBtn.setEnabled(true);
                this.m_allVersionsBtn.setEnabled(true);
            } else {
                this.m_currentVerBtn.setEnabled(false);
                this.m_releasedVerBtn.setEnabled(false);
                this.m_allVersionsBtn.setEnabled(false);
            }
            this.displaySubFolderAndAllVersionsMsg();
        } else if (event.getSource() == this.m_allVersionsBtn) {
            this.displaySubFolderAndAllVersionsMsg();
        } else if (event.getSource() == this.m_intersectionBtn || event.getSource() == this.m_unionBtn) {
            this.m_hasMergeTypeChanged = true;
        }
    }

    public void setOSHasBeenSelected(boolean hasBeenSelected) {
        this.m_OSHasBeenSelected = hasBeenSelected;
    }

    public boolean hasMergeTypeChanged() {
        return this.m_hasMergeTypeChanged;
    }

    private void displaySubFolderAndAllVersionsMsg() {
        if (this.m_hasSubFolders && this.m_enableVersionsBox.isSelected() && this.m_allVersionsBtn.isSelected()) {
            JOptionPane.showMessageDialog(this.m_parentFrame, WcmResource.s_allversionsWithFolders);
        }
    }

    private boolean checkIntersectionAction() {
        if (!this.m_parent.askUserToSavePropertiesOrCancel(true)) {
            return false;
        }
        this.m_parent.setWaitCursor();
        this.m_parent.performClearProperties(false);
        this.m_parent.updatePropertyList();
        this.m_parent.setDefaultCursor();
        this.m_hasMergeTypeChanged = false;
        return true;
    }

    private boolean updateAttributes() {
        this.m_oldOptions = new WcmSearchOptionsRec(this.m_optionsRec);
        if (this.m_enableVersionsBox.isSelected()) {
            if (this.m_currentVerBtn.isSelected()) {
                this.m_optionsRec.m_versionSelection = 1;
            } else if (this.m_releasedVerBtn.isSelected()) {
                this.m_optionsRec.m_versionSelection = 2;
            } else if (this.m_allVersionsBtn.isSelected()) {
                this.m_optionsRec.m_versionSelection = 3;
            }
        } else {
            this.m_optionsRec.m_versionSelection = 0;
        }
        this.m_optionsRec.m_intraGridAnd = this.m_intraAndBtn.isSelected();
        this.m_optionsRec.m_union = this.m_unionBtn.isSelected();
        this.m_optionsRec.m_showMaxReturned = this.m_showMaxReturnedBox.isSelected();
        this.m_optionsRec.m_showOperators = this.m_showOperatorsBox.isSelected();
        this.m_optionsRec.m_showLogicalOperators = this.m_showLogicalOperatorsBox.isSelected();
        this.m_optionsRec.m_rankContent = this.m_rankContentBox.isSelected();
        this.m_optionsRec.m_docSummary = this.m_docSummaryBox.isSelected();
        if (this.m_hasMergeTypeChanged && this.m_OSHasBeenSelected && !this.checkIntersectionAction()) {
            this.m_optionsRec = null;
            this.m_optionsRec = new WcmSearchOptionsRec(this.m_oldOptions);
            return false;
        }
        return true;
    }

    private void resetUItoMatchAttributes() {
        this.m_intraAndBtn.setSelected(this.m_optionsRec.m_intraGridAnd);
        this.m_intraOrBtn.setSelected(!this.m_optionsRec.m_intraGridAnd);
        this.m_intersectionBtn.setSelected(!this.m_optionsRec.m_union);
        this.m_unionBtn.setSelected(this.m_optionsRec.m_union);
        this.m_showMaxReturnedBox.setSelected(this.m_optionsRec.m_showMaxReturned);
        this.m_showOperatorsBox.setSelected(this.m_optionsRec.m_showOperators);
        this.m_showLogicalOperatorsBox.setSelected(this.m_optionsRec.m_showLogicalOperators);
        this.m_rankContentBox.setSelected(this.m_optionsRec.m_rankContent);
        this.m_docSummaryBox.setSelected(this.m_optionsRec.m_docSummary);
        try {
            this.setVersionSelection(this.m_optionsRec.m_versionSelection);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

