/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.ui.WcmBoolOperator;
import com.filenet.wcm.apps.client.search.ui.WcmBoolOperatorNode;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.toolkit.util.WcmException;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class WcmAndOrTree {
    private Vector m_ops;
    private WcmBoolOperatorNode m_treeRoot;
    private Stack m_parseStack = new Stack();
    private int leafCount = 0;
    private int lastCondition = 0;
    private boolean m_isDefaultToAnd = true;

    public WcmAndOrTree() {
        this.m_ops = new Vector();
        this.m_treeRoot = new WcmBoolOperatorNode();
        this.init();
    }

    public void init() {
        this.m_treeRoot.clear();
        this.m_ops.clear();
        this.m_parseStack.clear();
        this.leafCount = 0;
        this.lastCondition = 0;
        this.m_treeRoot = this.m_isDefaultToAnd ? new WcmBoolOperatorNode(1, 0, 1) : new WcmBoolOperatorNode(2, 0, 1);
        this.m_parseStack.push(this.m_treeRoot);
    }

    public void setDefaultLogicalOperator(boolean isAnd) {
        this.m_isDefaultToAnd = isAnd;
    }

    public void startBoolean(int op) throws WcmException {
        try {
            this.m_parseStack.push(new WcmBoolOperatorNode(op, this.leafCount, -1));
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInStartBoolean", "An error occurred in startBoolean(): {0}", (Object)e.getMessage());
        }
    }

    public void endBoolean(int op) throws WcmException {
        try {
            WcmBoolOperatorNode node;
            if (!this.m_parseStack.empty() && (node = (WcmBoolOperatorNode)this.m_parseStack.pop()).getRowEnd() == -1 && node.getOperator() == op) {
                node.setRowEnd(this.leafCount);
                WcmBoolOperatorNode parent = (WcmBoolOperatorNode)this.m_parseStack.pop();
                if (parent.getOperator() != node.getOperator()) {
                    parent.m_children.addElement(node);
                } else if (parent.getRowEnd() != -1 && parent.getRowEnd() < node.getRowEnd()) {
                    parent.m_children.addElement(node);
                } else {
                    for (WcmBoolOperatorNode grandchildNot : node.m_children) {
                        parent.m_children.addElement(grandchildNot);
                    }
                }
                this.m_parseStack.push(parent);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInEndBoolean", "An error occurred in endBoolean(): {0}", (Object)e.getMessage());
        }
    }

    public void complete() throws WcmException {
        int endConditionNumber = this.lastCondition;
        try {
            if (this.m_parseStack.size() != 1) {
                return;
            }
            WcmBoolOperatorNode parseRoot = this.m_treeRoot;
            this.markLevels(this.m_treeRoot);
            if (this.m_treeRoot.m_children.size() == 1) {
                WcmBoolOperatorNode maybeRoot = (WcmBoolOperatorNode)this.m_treeRoot.m_children.firstElement();
                if (maybeRoot.getRowBegin() == 0 && maybeRoot.getRowEnd() == this.leafCount) {
                    parseRoot = maybeRoot;
                } else if (maybeRoot.getOperator() == 1 && this.m_isDefaultToAnd || maybeRoot.getOperator() == 2 && !this.m_isDefaultToAnd) {
                    parseRoot = maybeRoot;
                }
            } else if (this.m_treeRoot.m_children.size() > 1) {
                throw new WcmException("client.WcmAndOrTree.tooManyChildren", "The root node has too many children.");
            }
            this.buildOperatorTable(parseRoot);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInComplete", "An error occurred in complete(): {0}", (Object)e.getMessage());
        }
    }

    public void buildFromTree(WcmQTree tree) throws WcmException {
        try {
            this.init();
            this.extractAndOrNodes((DefaultMutableTreeNode)tree.getRoot().getFirstChild());
            this.complete();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInBuildFromTree", "An error occurred in buildFromTree(): {0}", (Object)e.getMessage());
        }
    }

    public int getNumberOfLevels() {
        return this.m_ops.size();
    }

    public int getNumberOfOperators(int levelNum) throws WcmException {
        try {
            if (levelNum > this.getNumberOfLevels()) {
                throw new WcmException("client.WcmAndOrTree.levelOutOfBounds", "The level, {0}, is out of range.", new Integer(levelNum));
            }
            Vector levelVector = (Vector)this.m_ops.get(levelNum);
            return levelVector.size();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInGetNumOfOperators", "An error occurred in getNumberOfOperators(): {0}", (Object)e.getMessage());
        }
    }

    public int getRowBeginInfo(int levelNum, int operatorNum) throws WcmException {
        try {
            if (levelNum >= this.getNumberOfLevels()) {
                throw new WcmException("client.WcmAndOrTree.levelOutOfBounds2", "The level, {0}, is out of range.", new Integer(levelNum));
            }
            if (operatorNum >= this.getNumberOfOperators(levelNum)) {
                throw new WcmException("client.WcmAndOrTree.operatorsOutOfBounds", "The number of operators, {0}, is out of range.", new Integer(operatorNum));
            }
            Vector levelVector = (Vector)this.m_ops.get(levelNum);
            WcmBoolOperator node = (WcmBoolOperator)levelVector.get(operatorNum);
            return node.getRowBegin();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInGetRowBeginInfo", "An error occurred while inside getRowBeginInfo(): {0}", (Object)e.getMessage());
        }
    }

    public int getRowEndInfo(int levelNum, int operatorNum) throws WcmException {
        try {
            if (levelNum >= this.getNumberOfLevels()) {
                throw new WcmException("client.WcmAndOrTree.levelOutOfBounds2", "The level, {0}, is out of range.", new Integer(levelNum));
            }
            if (operatorNum >= this.getNumberOfOperators(levelNum)) {
                throw new WcmException("client.WcmAndOrTree.operatorsOutOfBounds", "The number of operators, {0}, is out of range.", new Integer(operatorNum));
            }
            Vector levelVector = (Vector)this.m_ops.get(levelNum);
            WcmBoolOperator node = (WcmBoolOperator)levelVector.get(operatorNum);
            return node.getRowEnd();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInGetRowEndInfo", "An error occurred while inside getRowEndInfo(): {0}", (Object)e.getMessage());
        }
    }

    public int getOperatorInfo(int levelNum, int operatorNum) throws WcmException {
        try {
            if (levelNum >= this.getNumberOfLevels()) {
                throw new WcmException("client.WcmAndOrTree.levelOutOfBounds2", "The level, {0}, is out of range.", new Integer(levelNum));
            }
            if (operatorNum >= this.getNumberOfOperators(levelNum)) {
                throw new WcmException("client.WcmAndOrTree.operatorsOutOfBounds", "The number of operators, {0}, is out of range.", new Integer(operatorNum));
            }
            Vector levelVector = (Vector)this.m_ops.get(levelNum);
            WcmBoolOperator node = (WcmBoolOperator)levelVector.get(operatorNum);
            return node.getOperator();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInGetOperatorInfo", "An error occurred while inside getOperatorInfo(): {0}", (Object)e.getMessage());
        }
    }

    private int markLevels(WcmBoolOperatorNode root) throws WcmException {
        int levelNum = -1;
        try {
            Iterator it = root.m_children.iterator();
            while (it.hasNext()) {
                levelNum = Math.max(levelNum, this.markLevels((WcmBoolOperatorNode)it.next()));
            }
            root.setLevel(++levelNum);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInMarkLevels", "An error occurred in markLevels(): {0}", (Object)e.getMessage());
        }
        return levelNum;
    }

    private void buildOperatorTable(WcmBoolOperatorNode root) throws WcmException {
        try {
            Iterator it = root.m_children.iterator();
            while (it.hasNext()) {
                this.buildOperatorTable((WcmBoolOperatorNode)it.next());
            }
            if (root.getLevel() >= this.m_ops.size()) {
                if (root.getLevel() == this.m_ops.size()) {
                    // empty if block
                }
                Vector emptyVector = new Vector();
                this.m_ops.addElement(emptyVector);
            }
            Vector levelVector = (Vector)this.m_ops.get(root.getLevel());
            levelVector.addElement(root);
            this.m_ops.set(root.getLevel(), levelVector);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInBuildOperatorTable", "An error occurred in buildOperatorTable(): {0}", (Object)e.getMessage());
        }
    }

    private void extractAndOrNodes(DefaultMutableTreeNode root) throws WcmException {
        String operatorStr = null;
        WcmCondition condition = null;
        int childCount = 0;
        int bOp = 0;
        DefaultMutableTreeNode node = null;
        try {
            if (root == null) {
                return;
            }
            childCount = root.getChildCount();
            if (childCount == 0) {
                ++this.leafCount;
                return;
            }
            condition = (WcmCondition)root.getUserObject();
            operatorStr = condition.getProperty();
            if (operatorStr == "AND") {
                bOp = 1;
                this.startBoolean(bOp);
            } else if (operatorStr == "OR") {
                bOp = 2;
                this.startBoolean(bOp);
            }
            for (int i = 0; i < childCount; ++i) {
                node = (DefaultMutableTreeNode)root.getChildAt(i);
                this.extractAndOrNodes(node);
            }
            this.endBoolean(bOp);
            ++this.lastCondition;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmAndOrTree.errorInExtractAndOrNodes", "An error occurred in extractAndOrNodes(): {0}", (Object)e.getMessage());
        }
    }

    public void printStack() {
        try {
            System.out.println("************************");
            System.out.println("Printing stack...");
            for (WcmBoolOperatorNode node : this.m_parseStack) {
                System.out.println("node: " + node);
            }
            System.out.println("************************");
        }
        catch (Exception e) {
            System.out.println("Caught error in printStack(): " + e.getMessage());
        }
    }

    public void printTree() {
        try {
            boolean righthandEdge = false;
            int nLevels = this.getNumberOfLevels();
            System.out.println("---> # levels = " + nLevels);
            for (int ii = 0; ii < nLevels; ++ii) {
                for (int jj = 0; jj < this.getNumberOfOperators(ii); ++jj) {
                    int rowBegin = this.getRowBeginInfo(ii, jj);
                    int rowEnd = this.getRowEndInfo(ii, jj);
                    int op = this.getOperatorInfo(ii, jj);
                    System.out.print(ii + "; " + jj + "; begin=" + rowBegin + ", end=" + rowEnd + ", op=");
                    if (op == 1) {
                        System.out.println("AND");
                        continue;
                    }
                    if (op == 2) {
                        System.out.println("OR");
                        continue;
                    }
                    System.out.println("UNKNOWN");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in printTree(): " + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            WcmQTree myTree = new WcmQTree();
            myTree.runGroupingTest();
            myTree.printTree();
            System.out.println("====================================");
            System.out.println();
            WcmAndOrTree andOrTree = new WcmAndOrTree();
            andOrTree.setDefaultLogicalOperator(true);
            andOrTree.init();
            andOrTree.buildFromTree(myTree);
            System.out.println();
            System.out.println("====================================");
            andOrTree.printTree();
        }
        catch (Exception e) {
            System.out.println("Caught an error during WcmAndOrTree unit testing: " + e.getMessage());
        }
    }
}

