/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.ui.WcmAndOrTree;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchModel;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class WcmAndOrPanel
extends JPanel
implements TableModelListener {
    private static final int OPERATOR_WIDTH = 14;
    private static final int HALF_AND = 13;
    private static final int HALF_OR = 9;
    private static final int DEFAULT_WIDTH = 40;
    private static final int DEFAULT_HEIGHT = 50;
    private WcmAndOrTree m_andOrMap = null;
    private int m_rowHeight = 0;
    private int m_numOfRows = 0;
    private boolean m_isDefaultToAnd = true;
    private boolean m_isPaintEnabled = false;
    private Dimension m_currentDim = null;
    private Image m_andIcon = WcmImageLoader.createImageIcon("state/And.gif").getImage();
    private Image m_orIcon = WcmImageLoader.createImageIcon("state/Or.gif").getImage();
    private Color m_andColor = new Color(0, 0, 128);
    private Color m_orColor = new Color(0, 128, 128);

    public WcmAndOrPanel() {
        super(null, true);
        this.m_currentDim = new Dimension(40, 50);
        this.setPreferredSize(this.m_currentDim);
        this.m_andOrMap = new WcmAndOrTree();
    }

    public void setRowHeight(int height) {
        this.m_rowHeight = height;
    }

    public void paintComponent(Graphics g) {
        try {
            boolean isLTR;
            super.paintComponent(g);
            int nLevels = this.m_andOrMap.getNumberOfLevels();
            boolean bl = isLTR = this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT;
            if (nLevels == 0) {
                if (this.m_isDefaultToAnd) {
                    g.setColor(this.m_andColor);
                } else {
                    g.setColor(this.m_orColor);
                }
                int x = isLTR ? 0 : this.m_currentDim.width - 14;
                g.fillRect(x, 0, 14, this.m_rowHeight - 1);
            } else {
                int newWidth = nLevels * 14;
                if (newWidth < 40) {
                    newWidth = 40;
                }
                this.m_currentDim.width = newWidth;
                this.setPreferredSize(this.m_currentDim);
                for (int ii = 0; ii < nLevels; ++ii) {
                    int x = isLTR ? ii * 14 : newWidth - (ii + 1) * 14;
                    for (int jj = 0; jj < this.m_andOrMap.getNumberOfOperators(ii); ++jj) {
                        int rowBegin = this.m_andOrMap.getRowBeginInfo(ii, jj);
                        int rowEnd = this.m_andOrMap.getRowEndInfo(ii, jj);
                        int op = this.m_andOrMap.getOperatorInfo(ii, jj);
                        if (rowBegin < 0 || rowEnd < 0 || op == 0) continue;
                        if (op == 1) {
                            g.setColor(this.m_andColor);
                        } else if (op == 2) {
                            g.setColor(this.m_orColor);
                        }
                        int y = rowBegin * this.m_rowHeight;
                        int w = 13;
                        int h = (rowEnd - rowBegin) * this.m_rowHeight - 1;
                        g.fillRect(x, y, w, h);
                        if (h < 2 * this.m_rowHeight - 1) continue;
                        if (op == 1) {
                            if (h >= 3 * this.m_rowHeight - 1) {
                                y += h / 2 - 13;
                            }
                            g.drawImage(this.m_andIcon, x, y, this);
                            continue;
                        }
                        if (op != 2) continue;
                        g.drawImage(this.m_orIcon, x, y += h / 2 - 9, this);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught an exception in paintComponent(): " + e.getMessage());
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 0: 
            case 1: {
                WcmSearchModel source = (WcmSearchModel)event.getSource();
                this.m_isDefaultToAnd = source.getDefaultLogicalOperator();
                this.updateAndOrDisplay(source.getTree());
                break;
            }
        }
    }

    public void setPaintEnabled(boolean enablePainting) {
        this.m_isPaintEnabled = enablePainting;
    }

    private void updateAndOrDisplay(WcmQTree tree) {
        try {
            this.m_andOrMap.setDefaultLogicalOperator(this.m_isDefaultToAnd);
            this.m_andOrMap.init();
            if (tree.getRoot().getChildCount() == 0) {
                return;
            }
            this.m_andOrMap.buildFromTree(tree);
            if (this.m_isPaintEnabled) {
                this.paintComponent(this.getGraphics());
            }
        }
        catch (Exception e) {
            System.out.println("Error was caught in updateAndOrDisplay(): " + e.getMessage());
        }
    }
}

