/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.BidiComboBox;
import com.filenet.wcm.apps.client.search.ui.WcmAndOrPanel;
import com.filenet.wcm.apps.client.search.ui.WcmContentsModel;
import com.filenet.wcm.apps.client.search.ui.WcmOperatorEditor;
import com.filenet.wcm.apps.client.search.ui.WcmOperatorRenderer;
import com.filenet.wcm.apps.client.search.ui.WcmPasteUtil;
import com.filenet.wcm.apps.client.search.ui.WcmPasteXML;
import com.filenet.wcm.apps.client.search.ui.WcmPropertyCellRenderer;
import com.filenet.wcm.apps.client.search.ui.WcmPropertyRenderer;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSearchCriteriaPanel;
import com.filenet.wcm.apps.client.search.ui.WcmSearchModel;
import com.filenet.wcm.apps.client.search.ui.WcmValueEditor;
import com.filenet.wcm.apps.client.search.ui.WcmValueRenderer;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.CBRSearchType;
import com.filenet.wcm.toolkit.util.WcmException;
import filenet.vw.toolkit.utils.datatransfer.IVWCBData;
import filenet.vw.toolkit.utils.datatransfer.VWTransferable;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class WcmAndOrPane
extends JScrollPane
implements ListSelectionListener,
KeyListener,
MouseMotionListener,
ClipboardOwner {
    private final int VIEW_COL = 0;
    private final int PROPERTY_COL = 1;
    private final int OPERATOR_COL = 2;
    private final int VALUE_COL = 3;
    private final int VIEW_COL_SIZE = 60;
    private final int PROPERTY_COL_SIZE = 120;
    private final int OPERATOR_COL_SIZE = 120;
    private final int VALUE_COL_SIZE = 120;
    private final int WORD_COL_SIZE = 310;
    private final int MODIFIERS_COL_SIZE = 60;
    private final int ROW_HEIGHT_OFFSET = 2;
    private JPanel m_mainPanel;
    private WcmAndOrPanel m_andOrPanel;
    private VWTable m_table;
    private WcmSearchModel m_model;
    private String m_name;
    private boolean m_bHasFocus = false;
    private WcmSearchCriteriaPanel m_parent;
    private WcmSearchAuthCore m_grandParent;
    private Vector m_commonPropDescs = null;
    private Vector m_docPropDescs = null;
    private Vector m_folderPropDescs = null;
    private Vector m_customObjPropDescs = null;
    private Object[] m_propDescIndex = new Object[4];
    private int m_currentView = 0;

    public WcmAndOrPane(WcmSearchModel dm, String name, WcmSearchCriteriaPanel parent, WcmSearchAuthCore grandParent) {
        this.m_parent = parent;
        this.m_grandParent = grandParent;
        this.m_table = new VWTable((TableModel)dm);
        this.m_name = new String(name);
        this.m_model = dm;
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.getSelectionModel().setSelectionMode(2);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.getTableHeader().addMouseMotionListener(this);
        this.m_table.setGridColor(Color.gray);
        this.m_table.setShowGrid(true);
        this.initColumns();
        this.setRowHeight();
        this.m_mainPanel = new JPanel(new GridBagLayout());
        this.m_andOrPanel = new WcmAndOrPanel();
        GridBagConstraints table = new GridBagConstraints();
        table.gridwidth = 1;
        table.gridx = 0;
        table.gridy = 0;
        table.fill = 1;
        table.weightx = 1.0;
        table.weighty = 1.0;
        GridBagConstraints andOrPanel = new GridBagConstraints();
        andOrPanel.gridwidth = 1;
        andOrPanel.gridx = 1;
        andOrPanel.gridy = 0;
        andOrPanel.fill = 1;
        andOrPanel.weightx = 0.0;
        andOrPanel.weighty = 1.0;
        this.m_mainPanel.add((Component)this.m_table, table);
        this.m_mainPanel.add((Component)this.m_andOrPanel, andOrPanel);
        this.m_andOrPanel.setRowHeight(this.m_table.getRowHeight());
        String cornerKey = this.m_parent.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        this.setPreferredSize(new Dimension(460, 60));
        this.setViewportView(this.m_mainPanel);
        this.setColumnHeaderView(this.m_table.getTableHeader());
        this.setCorner(cornerKey, new JButton());
        this.setHorizontalScrollBarPolicy(30);
        this.m_table.addKeyListener((KeyListener)this);
        this.m_model.addTableModelListener(this.m_andOrPanel);
    }

    public void setModel(WcmSearchModel dm, int view) {
        this.m_table.setModel((TableModel)dm);
        this.m_model = dm;
        this.m_model.addTableModelListener(this.m_andOrPanel);
        this.m_currentView = view;
        this.initColumns();
    }

    public void initColumns() {
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(0);
        if (tcCol != null) {
            tcCol.setCellEditor(new DefaultCellEditor(this.getViewComboBox()));
            Integer width = new Integer(WcmResource.s_viewColWidth);
            if (width > 0) {
                tcCol.setPreferredWidth(width);
            } else {
                tcCol.setPreferredWidth(60);
            }
        }
        if (this.m_name.equals("property")) {
            WcmValueRenderer pvr = new WcmValueRenderer();
            pvr.setVerticalAlignment(1);
            pvr.setBackground(new Color(255, 255, 255));
            pvr.setOpaque(true);
            WcmValueRenderer valueRender = pvr;
            WcmOperatorRenderer por = new WcmOperatorRenderer();
            por.setVerticalAlignment(1);
            por.setBackground(new Color(255, 255, 255));
            por.setOpaque(true);
            WcmOperatorRenderer operatorRender = por;
            this.updatePropertyColumn();
            tcCol = this.m_table.getColumnModel().getColumn(2);
            if (tcCol != null) {
                tcCol.setCellRenderer(operatorRender);
                tcCol.setCellEditor(new WcmOperatorEditor());
                tcCol.setPreferredWidth(120);
            }
            if ((tcCol = this.m_table.getColumnModel().getColumn(3)) != null) {
                tcCol.setCellRenderer(valueRender);
                WcmValueEditor ved = new WcmValueEditor();
                tcCol.setCellEditor(ved);
                ved.addKeyListener(this);
                tcCol.setPreferredWidth(120);
            }
        } else {
            tcCol = this.m_table.getColumnModel().getColumn(1);
            if (tcCol != null) {
                JTextField jtf = new JTextField();
                tcCol.setCellEditor(new DefaultCellEditor(jtf));
                jtf.addKeyListener(this);
                tcCol.setPreferredWidth(310);
            }
            this.populateModifiersColumn();
            boolean bKLAdded = false;
            EventListener[] klList = this.m_table.getListeners(KeyListener.class);
            if (klList != null) {
                for (int j = 0; j < klList.length; ++j) {
                    if (klList[j] != this) continue;
                    bKLAdded = true;
                }
            }
            if (!bKLAdded) {
                this.m_table.addKeyListener((KeyListener)this);
            }
            this.m_table.setDefaultRenderer(String.class, (TableCellRenderer)new ContentTableCellRenderer(this.m_table.getDefaultRenderer(String.class)));
        }
    }

    public void populateModifiersColumn() {
        TableColumn tableCol = this.m_table.getColumnModel().getColumn(2);
        if (tableCol != null) {
            tableCol.setCellEditor(new DefaultCellEditor(this.getModifiersComboBox()));
        }
    }

    public void setPaintEnabled(boolean enablePainting) {
        this.m_andOrPanel.setPaintEnabled(enablePainting);
    }

    public void setPropertyDescList(Vector commonList, Vector docList, Vector folderList, Vector customObjList) {
        this.m_commonPropDescs = commonList;
        this.m_docPropDescs = docList;
        this.m_folderPropDescs = folderList;
        this.m_customObjPropDescs = customObjList;
    }

    public void setObjectTypes(boolean[] objTypes) {
        this.m_propDescIndex = new Object[4];
        int curPDIndex = 0;
        int objTypeCount = 0;
        for (int i = 0; i < 3; ++i) {
            if (!objTypes[i]) continue;
            ++objTypeCount;
        }
        if (objTypeCount > 1) {
            this.m_propDescIndex[curPDIndex++] = this.m_commonPropDescs;
        }
        if (objTypes[0]) {
            this.m_propDescIndex[curPDIndex++] = this.m_docPropDescs;
        }
        if (objTypes[1]) {
            this.m_propDescIndex[curPDIndex++] = this.m_folderPropDescs;
        }
        if (objTypes[2]) {
            this.m_propDescIndex[curPDIndex++] = this.m_customObjPropDescs;
        }
    }

    public void updatePropertyColumn() {
        TableColumn tcCol = null;
        if (this.m_name.equals("property") && (tcCol = this.m_table.getColumnModel().getColumn(1)) != null) {
            TableCellEditor ceditor = tcCol.getCellEditor();
            if (ceditor != null) {
                ceditor.stopCellEditing();
            }
            WcmPropertyCellRenderer pCellRenderer = new WcmPropertyCellRenderer();
            pCellRenderer.setVerticalAlignment(1);
            pCellRenderer.setBackground(new Color(255, 255, 255));
            pCellRenderer.setOpaque(true);
            tcCol.setCellRenderer(pCellRenderer);
            tcCol.setCellEditor(new DefaultCellEditor(this.getPropertyComboBox()));
            tcCol.setPreferredWidth(120);
        }
    }

    public JComboBox getViewComboBox() {
        BidiComboBox pComboBox = null;
        try {
            pComboBox = new BidiComboBox(this.m_parent.getComponentOrientation());
            pComboBox.addItem(WcmResource.s_requiredStr);
            pComboBox.addItem(WcmResource.s_editableStr);
            pComboBox.addItem(WcmResource.s_readOnlyStr);
            pComboBox.addItem(WcmResource.s_hiddenStr);
        }
        catch (Exception ex) {
            System.out.println("Failed to setup the View combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public JComboBox getPropertyComboBox() {
        JComboBox<Object> pComboBox = null;
        Vector sPropDescs = null;
        try {
            pComboBox = new JComboBox<Object>();
            TableColumn col = this.m_table.getColumnModel().getColumn(1);
            WcmPropertyRenderer pRender = new WcmPropertyRenderer(col);
            pRender.setVerticalTextPosition(1);
            pRender.setBackground(new Color(255, 255, 255));
            pRender.setOpaque(true);
            pComboBox.setRenderer(pRender);
            pComboBox.applyComponentOrientation(this.m_parent.getComponentOrientation());
            sPropDescs = (Vector)this.m_propDescIndex[this.m_currentView];
            if (sPropDescs != null && sPropDescs.size() > 0) {
                for (WcmWrappedPD sProp : sPropDescs) {
                    pComboBox.addItem(sProp);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to get the Property Combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public JComboBox getModifiersComboBox() {
        BidiComboBox pComboBox = null;
        boolean isVerity = this.m_grandParent.getCBRSearchType() == CBRSearchType.VERITY;
        try {
            pComboBox = new BidiComboBox(this.m_parent.getComponentOrientation());
            pComboBox.addItem(WcmResource.s_verityNoneStr);
            pComboBox.addItem(WcmResource.s_allStr);
            pComboBox.addItem(WcmResource.s_anyStr);
            if (isVerity) {
                pComboBox.addItem(WcmResource.s_inZoneStr);
            }
            pComboBox.addItem(WcmResource.s_nearStr);
            if (isVerity) {
                pComboBox.addItem(WcmResource.s_paragraphStr);
                pComboBox.addItem(WcmResource.s_sentenceStr);
                pComboBox.addItem(WcmResource.s_vqlStr);
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to setup the Modifiers combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public boolean hasFocus() {
        return this.m_bHasFocus;
    }

    public void setHasFocus(boolean focus) {
        this.m_bHasFocus = focus;
    }

    public void setTree(WcmQTree tree) throws WcmException {
        this.m_model.setTree(tree);
    }

    public WcmQTree getTree() {
        return this.m_model.getTree();
    }

    public void clear() {
        this.m_model.clearModel();
        this.initColumns();
    }

    public void doAnd() {
        try {
            int nRowBegin = 0;
            int nRowEnd = 0;
            int[] rows = this.m_table.getSelectedRows();
            nRowBegin = rows[0];
            nRowEnd = rows[rows.length - 1];
            if (this.m_table.getSelectedRowCount() >= 2) {
                this.m_model.setAnd(nRowBegin, nRowEnd);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void doOr() {
        int nRowBegin = 0;
        int nRowEnd = 0;
        try {
            int[] rows = this.m_table.getSelectedRows();
            nRowBegin = rows[0];
            nRowEnd = rows[rows.length - 1];
            if (this.m_table.getSelectedRowCount() >= 2) {
                this.m_model.setOr(nRowBegin, nRowEnd);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void doInsert() {
        try {
            this.m_grandParent.stopEditing((JTable)this.m_table);
            int nRowIndex = this.m_table.getSelectedRow();
            this.m_table.clearSelection();
            if (nRowIndex >= 0 && nRowIndex < this.m_table.getRowCount()) {
                this.m_model.insertRow(nRowIndex, true);
                this.m_table.setRowSelectionInterval(nRowIndex, nRowIndex);
            } else {
                this.m_parent.enableActions(false);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void doDelete() {
        try {
            this.m_grandParent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            int sel = this.m_table.getSelectedRow();
            for (int i = 0; i < rows.length; ++i) {
                if (!this.m_model.isCellEditable(rows[i], 0)) continue;
                this.m_model.deleteItem(rows[i]);
                for (int j = i + 1; j < rows.length; ++j) {
                    if (rows[j] > rows[i]) {
                        int n = j;
                        rows[n] = rows[n] - 1;
                    }
                    if (rows[j] >= 0) continue;
                    rows[j] = 0;
                }
            }
            if (sel == this.m_table.getRowCount() - 1) {
                --sel;
            }
            if (sel >= 0 && sel < this.m_table.getRowCount()) {
                this.m_table.setRowSelectionInterval(sel, sel);
            } else {
                this.m_parent.enableActions(false);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    private void setRowHeight() {
        try {
            JComboBox viewBox = this.getViewComboBox();
            int fontHeight = viewBox.getFontMetrics(viewBox.getFont()).getHeight();
            if (fontHeight > 0) {
                this.m_table.setRowHeight(fontHeight + 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void copySelection(StringBuffer xmlStream) {
        try {
            int[] sz = this.m_table.getSelectedRows();
            if (sz.length > 0) {
                Object[] objSet = new Object[sz.length];
                for (int i = 0; i < sz.length; ++i) {
                    objSet[i] = this.m_model.getItemAt(sz[i]);
                    if (objSet[i] == null || !(objSet[i] instanceof WcmCondition) || this.m_name.compareToIgnoreCase("property") == 0) continue;
                    ((WcmCondition)objSet[i]).setIsPropertyCondition(false);
                }
                WcmPasteUtil pasteUtil = new WcmPasteUtil();
                String xmlString = pasteUtil.makeString(objSet);
                xmlStream.append(xmlString);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in copySelection(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void performCopy(boolean bDelete) {
        StringBuffer xmlStream = null;
        try {
            VWTransferable transferData;
            xmlStream = new StringBuffer();
            this.copySelection(xmlStream);
            if (bDelete) {
                this.doDelete();
            }
            if (xmlStream != null && (transferData = new VWTransferable(xmlStream.toString())) != null) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents((Transferable)transferData, this);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in performCopy(): " + e.getMessage());
        }
    }

    public void performPaste() {
        Transferable transferData = null;
        try {
            WcmCondition itemOne;
            this.m_grandParent.stopEditing((JTable)this.m_table);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = cb.getContents(this);
            if (contents != null && contents instanceof Transferable) {
                transferData = contents;
            }
            if (transferData == null) {
                return;
            }
            WcmPasteUtil pasteUtil = new WcmPasteUtil();
            String xmlString = (String)transferData.getTransferData(DataFlavor.stringFlavor);
            Object[] newItems = pasteUtil.parseString(xmlString);
            if (newItems != null && newItems.length > 0 && newItems[0] instanceof WcmCondition && ((itemOne = (WcmCondition)newItems[0]).getIsPropertyCondition() && this.m_name.compareToIgnoreCase("property") == 0 || !itemOne.getIsPropertyCondition() && this.m_name.compareToIgnoreCase("content") == 0)) {
                int i;
                int[] rows = this.m_table.getSelectedRows();
                int sel = this.m_table.getSelectedRow();
                for (i = 0; i < rows.length; ++i) {
                    this.m_model.deleteItem(rows[i]);
                    for (int j = i + 1; j < rows.length; ++j) {
                        if (rows[j] > rows[i]) {
                            int n = j;
                            rows[n] = rows[n] - 1;
                        }
                        if (rows[j] >= 0) continue;
                        rows[j] = 0;
                    }
                }
                if (sel >= 0 && sel < this.m_table.getRowCount()) {
                    this.m_table.setRowSelectionInterval(sel, sel);
                }
                for (i = 0; i < newItems.length; ++i) {
                    int index = this.m_table.getSelectedRow();
                    if (index < 0) continue;
                    this.m_model.insertRow(index, true);
                    WcmCondition newItem = (WcmCondition)newItems[i];
                    this.m_model.addRecord(newItem, index);
                    if (newItem.getIsPropertyCondition()) {
                        this.redrawPropertyComboBox(newItem);
                    }
                    this.redrawViewComboBox(newItem);
                    this.m_table.setRowSelectionInterval(index + 1, index + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in performPaste(): " + e.getMessage());
        }
    }

    private void redrawPropertyComboBox(WcmCondition item) {
        DefaultCellEditor ceditor;
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(1);
        if (tcCol != null && (ceditor = (DefaultCellEditor)tcCol.getCellEditor()) != null) {
            JComboBox comp = (JComboBox)ceditor.getComponent();
            comp.getModel().setSelectedItem(item.getPropDesc());
        }
    }

    private void redrawViewComboBox(WcmCondition item) {
        DefaultCellEditor ceditor;
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(0);
        if (tcCol != null && (ceditor = (DefaultCellEditor)tcCol.getCellEditor()) != null) {
            JComboBox comp = (JComboBox)ceditor.getComponent();
            comp.getModel().setSelectedItem(item.getViewStr());
        }
    }

    public void setDefaultLogicalOperator(boolean isAnd) {
        this.m_model.setDefaultLogicalOperator(isAnd);
    }

    public void clearSelection() {
        this.m_table.clearSelection();
    }

    public String getName() {
        return this.m_name;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.m_table.getSelectionModel().removeListSelectionListener(this);
            this.m_parent.onListSelectionChanged(this, event);
            this.m_table.getSelectionModel().addListSelectionListener(this);
            if (this.m_table.getSelectedRow() >= 0) {
                this.m_parent.enableActions(true);
            }
        }
    }

    public boolean rowSelected() {
        return this.m_table.getSelectedRow() >= 0;
    }

    public boolean stopEditing() {
        if (this.m_table == null) {
            return true;
        }
        return this.m_grandParent.stopEditing((JTable)this.m_table);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        try {
            if (e.getModifiers() == 2 && e.getKeyCode() == 86) {
                String xmlString;
                Object obj = e.getSource();
                Transferable transferData = null;
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = cb.getContents(this);
                if (contents != null && contents instanceof Transferable) {
                    transferData = contents;
                }
                if (transferData != null && (xmlString = ((IVWCBData)transferData.getTransferData(WcmPasteXML.PASTEXML_DATAFLAVOR)).getContent()) != null && xmlString.length() > 0) {
                    if (obj instanceof VWTable) {
                        this.performPaste();
                    }
                    e.consume();
                }
            } else if (e.getModifiers() == 2 && e.getKeyCode() == 67) {
                Object obj = e.getSource();
                if (obj instanceof JTextComponent) {
                    JTextComponent jtf = (JTextComponent)obj;
                    String selText = jtf.getSelectedText();
                    if (selText == null) {
                        this.performCopy(false);
                        e.consume();
                    }
                } else if (obj instanceof VWTable) {
                    this.performCopy(false);
                    e.consume();
                }
            } else if (e.getModifiers() == 2 && e.getKeyCode() == 88) {
                Object obj = e.getSource();
                if (obj instanceof JTextComponent) {
                    JTextComponent jtf = (JTextComponent)obj;
                    String selText = jtf.getSelectedText();
                    if (selText == null) {
                        this.performCopy(true);
                        e.consume();
                    }
                } else if (obj instanceof VWTable) {
                    this.performCopy(true);
                    e.consume();
                }
            } else {
                Component comp = this.m_table.getEditorComponent();
                if (comp instanceof JComboBox) {
                    JComboBox boxComp = (JComboBox)comp;
                    boxComp.requestFocus();
                    boxComp.processKeyEvent(e);
                    e.consume();
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error in WcmAndOrPane::keyPressed(): " + ex.getMessage());
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.m_table.getScrollableTracksViewportWidth();
        int col = this.m_table.getSelectedColumn();
        int row = this.m_table.getSelectedRow();
        this.m_model.setValueAt(this.m_model.getValueAt(row, col), row, col);
        this.m_model.checkCompleteness();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void lostOwnership(Clipboard clipboard, Transferable content) {
    }

    public static class ContentTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final Color ERROR_COLOR = new Color(255, 204, 204);
        private TableCellRenderer cellRenderer;

        public ContentTableCellRenderer(TableCellRenderer cellRenderer) {
            this.cellRenderer = cellRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                component.setBackground(UIManager.getLookAndFeelDefaults().getColor("Table.selectionBackground"));
            } else {
                WcmContentsModel model = (WcmContentsModel)table.getModel();
                try {
                    WcmCondition condition = model.getItemAt(row);
                    component.setBackground(condition != null && condition.hasError() ? ERROR_COLOR : Color.WHITE);
                }
                catch (WcmException e) {
                    component.setBackground(Color.WHITE);
                    System.out.println("Failed to get condition: " + e.getMessage());
                }
            }
            return component;
        }
    }
}

