/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.base;

import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import filenet.vw.toolkit.utils.datatransfer.IVWCBData;
import java.awt.datatransfer.DataFlavor;
import java.util.Vector;

public class WcmCondition
implements IVWCBData {
    public static final DataFlavor CONDITION_DATAFLAVOR = new DataFlavor(WcmCondition.class, "Condition");
    public static final int VIEW_UNINITIALIZED = 0;
    public static final int VIEW_REQUIRED = 1;
    public static final int VIEW_EDITABLE = 2;
    public static final int VIEW_READONLY = 3;
    public static final int VIEW_HIDDEN = 4;
    private static final String VIEW_UNINITIALIZED_STRING = "Uninitialized";
    private static final String VIEW_REQUIRED_STRING = new String(WcmResource.s_requiredStr);
    private static final String VIEW_EDITABLE_STRING = new String(WcmResource.s_editableStr);
    private static final String VIEW_READONLY_STRING = new String(WcmResource.s_readOnlyStr);
    private static final String VIEW_HIDDEN_STRING = new String(WcmResource.s_hiddenStr);
    private static final String XML_REQUIRED_STRING = "required";
    private static final String XML_EDITABLE_STRING = "editable";
    private static final String XML_READONLY_STRING = "readonly";
    private static final String XML_HIDDEN_STRING = "hidden";
    private static final String NEAR_ITEMS_TAG = "near items=";
    private static int m_idCounter = 0;
    private int conditionID = 0;
    private String conditionProperty = null;
    private String conditionLabel = null;
    private String conditionOperator = null;
    private String conditionValue = null;
    private int conditionView = 0;
    private Vector m_nearList = null;
    private String conditionZone = null;
    private boolean isValueFieldRequired = true;
    private boolean isPropertyCondition = true;
    private boolean m_singleWordCBR = false;
    private boolean m_isCommonCondition = false;
    private WcmWrappedPD propDesc = null;
    private boolean hasError = false;

    public WcmCondition() {
        this.conditionView = 0;
        this.conditionProperty = new String("");
        this.conditionLabel = new String("");
        this.conditionOperator = new String("");
        this.conditionValue = new String("");
        this.conditionZone = new String("");
        this.isValueFieldRequired = true;
        this.isPropertyCondition = true;
        this.m_singleWordCBR = false;
    }

    public WcmCondition(int view, String prop, String label, String op, String value) {
        this.conditionView = view;
        this.conditionProperty = prop;
        this.conditionLabel = label;
        this.conditionOperator = op;
        this.conditionValue = value;
        this.isValueFieldRequired = true;
        this.isPropertyCondition = true;
        this.m_singleWordCBR = false;
        this.conditionZone = new String("");
    }

    public WcmCondition(String view, String prop, String label, String op, String value) throws WcmException {
        this.setView(view);
        this.conditionProperty = prop;
        this.conditionLabel = label;
        this.conditionOperator = op;
        this.conditionValue = value;
        this.isValueFieldRequired = true;
        this.isPropertyCondition = true;
        this.m_singleWordCBR = false;
        this.conditionZone = new String("");
    }

    public WcmCondition(WcmCondition otherCondition) {
        this.conditionView = otherCondition.conditionView;
        this.conditionProperty = otherCondition.conditionProperty;
        this.conditionLabel = otherCondition.conditionLabel;
        this.conditionOperator = otherCondition.conditionOperator;
        this.conditionValue = otherCondition.conditionValue;
        this.conditionZone = otherCondition.conditionZone;
        this.isValueFieldRequired = otherCondition.isValueFieldRequired;
        this.isPropertyCondition = otherCondition.isPropertyCondition;
        this.propDesc = otherCondition.propDesc;
        this.conditionID = otherCondition.conditionID;
        this.m_nearList = otherCondition.m_nearList;
        this.m_singleWordCBR = otherCondition.m_singleWordCBR;
        this.m_isCommonCondition = otherCondition.m_isCommonCondition;
    }

    public void setHasError(boolean hasError) {
        this.hasError = hasError;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public int getView() {
        return this.conditionView;
    }

    public void setView(int newView) throws WcmException {
        if (newView != 1) {
            if (newView != 2) {
                if (newView != 3) {
                    if (newView == 4) {
                    } else {
                        throw new WcmException("client.WcmCondition.invalidView", "\"{0}\" is not a valid view", (Object)this.getViewString(newView));
                    }
                }
            }
        }
        this.conditionView = newView;
        this.setViewInNearList(newView);
    }

    public void setView(String newView) throws WcmException {
        if (WcmString.compareIgnoreCase(newView, VIEW_REQUIRED_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_REQUIRED_STRING) == 0) {
            this.conditionView = 1;
        } else if (WcmString.compareIgnoreCase(newView, VIEW_EDITABLE_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_EDITABLE_STRING) == 0) {
            this.conditionView = 2;
        } else if (WcmString.compareIgnoreCase(newView, VIEW_READONLY_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_READONLY_STRING) == 0) {
            this.conditionView = 3;
        } else if (WcmString.compareIgnoreCase(newView, VIEW_HIDDEN_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_HIDDEN_STRING) == 0) {
            this.conditionView = 4;
        } else {
            throw new WcmException("client.WcmCondition.invalidView", "\"{0}\" is not a valid view", (Object)newView);
        }
        this.setViewInNearList(this.conditionView);
    }

    protected void setViewInNearList(int newView) throws WcmException {
        block6: {
            block5: {
                if (newView == 1) break block5;
                if (newView == 2) break block5;
                if (newView == 3) break block5;
                if (newView != 4) break block6;
            }
            if (this.m_nearList != null && this.m_nearList.size() > 0) {
                for (WcmCondition item : this.m_nearList) {
                    item.setView(newView);
                }
            }
        }
    }

    public String getDisplayableViewStr() {
        switch (this.conditionView) {
            case 1: {
                return VIEW_REQUIRED_STRING;
            }
            case 2: {
                return VIEW_EDITABLE_STRING;
            }
            case 3: {
                return VIEW_READONLY_STRING;
            }
            case 4: {
                return VIEW_HIDDEN_STRING;
            }
        }
        return new String("");
    }

    public String getViewStr() {
        return this.getViewString(this.conditionView);
    }

    public String getProperty() {
        return this.conditionProperty;
    }

    public void setProperty(String newProperty) {
        this.conditionProperty = newProperty;
    }

    public String getPropertyLabel() {
        return this.conditionLabel;
    }

    public void setPropertyLabel(String newLabel) {
        this.conditionLabel = newLabel;
    }

    public String getOperator() {
        return this.conditionOperator;
    }

    public String getDisplayableOperator() {
        if (this.conditionOperator != null) {
            if (WcmString.compareIgnoreCase(this.conditionOperator, "In Zone") == 0) {
                StringBuffer buf = new StringBuffer(WcmResource.s_inZoneStr);
                buf.append(": ");
                buf.append(this.conditionZone);
                return buf.toString();
            }
            if (WcmString.compareIgnoreCase(this.conditionOperator, "None") == 0) {
                return new String(WcmResource.s_verityNoneStr);
            }
            if (WcmString.compareIgnoreCase(this.conditionOperator, "All") == 0) {
                return new String(WcmResource.s_allStr);
            }
            if (WcmString.compareIgnoreCase(this.conditionOperator, "Any") == 0) {
                return new String(WcmResource.s_anyStr);
            }
            if (WcmString.compareIgnoreCase(this.conditionOperator, "Near") == 0) {
                return new String(WcmResource.s_nearStr);
            }
            if (WcmString.compareIgnoreCase(this.conditionOperator, "Paragraph") == 0) {
                return new String(WcmResource.s_paragraphStr);
            }
            if (WcmString.compareIgnoreCase(this.conditionOperator, "Sentence") == 0) {
                return new String(WcmResource.s_sentenceStr);
            }
            if (WcmString.compareIgnoreCase(this.conditionOperator, "VQL") == 0) {
                return new String(WcmResource.s_vqlStr);
            }
            return this.conditionOperator;
        }
        return this.conditionOperator;
    }

    public void setOperator(String newOperator) {
        this.conditionOperator = newOperator;
    }

    public String getZone() {
        return this.conditionZone;
    }

    public void setZone(String newZone) {
        this.conditionZone = newZone;
    }

    public String getValue() {
        return this.conditionValue;
    }

    public boolean getIsPropertyCondition() {
        return this.isPropertyCondition;
    }

    public boolean isOVP() {
        if (this.propDesc != null) {
            return this.propDesc.isOVP();
        }
        return false;
    }

    public void setValue(String newValue) throws WcmException {
        if (!this.isValueFieldRequired && !newValue.equals(new String(""))) {
            throw new WcmException("client.WcmCondition.InvalidValue", "Value field must be empty.");
        }
        this.conditionValue = newValue;
    }

    public void initializePropertyID() {
        this.conditionID = ++m_idCounter;
    }

    public void setID(int id) {
        this.conditionID = id;
    }

    public int getID() {
        return this.conditionID;
    }

    public void setValueFieldNotRequired() {
        this.isValueFieldRequired = false;
    }

    public void setIsPropertyCondition(boolean isPropCondition) {
        this.isPropertyCondition = isPropCondition;
    }

    public void setIsCommonCondition(boolean isCommonCondition) {
        this.m_isCommonCondition = isCommonCondition;
    }

    public boolean isCommonCondition() {
        return this.m_isCommonCondition;
    }

    public void setPropDesc(WcmWrappedPD pDesc) {
        this.propDesc = pDesc;
    }

    public WcmWrappedPD getPropDesc() {
        return this.propDesc;
    }

    public void setNearList(Vector nearList) {
        this.m_nearList = nearList;
    }

    public Vector getNearList() {
        return this.m_nearList;
    }

    public boolean isSingleWordCBR() {
        return this.m_singleWordCBR;
    }

    public void setSingleWordCBR(boolean singleWord) {
        this.m_singleWordCBR = singleWord;
    }

    public boolean equals(WcmCondition equalCondition) {
        boolean returnValue = false;
        if (this.conditionView == equalCondition.conditionView && this.conditionProperty.equals(equalCondition.conditionProperty) && this.conditionLabel.equals(equalCondition.conditionLabel) && this.conditionOperator.equals(equalCondition.conditionOperator) && this.conditionValue.equals(equalCondition.conditionValue) && this.isValueFieldRequired == equalCondition.isValueFieldRequired && this.conditionZone.equals(equalCondition.conditionZone)) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isEmpty() {
        if (!this.isValueFieldRequired) {
            if (this.conditionView == 0 && this.conditionProperty.length() == 0 && this.conditionOperator.length() == 0) {
                return true;
            }
        } else if (this.conditionView == 0 && this.conditionProperty.length() == 0 && this.conditionOperator.length() == 0 && this.conditionValue.length() == 0) {
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(int curMode) {
        block10: {
            block9: {
                if (!this.isValueFieldRequired) {
                    return this.isContentValid(curMode);
                }
                if (this.conditionView == 0 && this.conditionProperty.length() == 0 && this.conditionOperator.length() == 0 && this.conditionValue.length() == 0) {
                    return true;
                }
                if (this.conditionView == 0) {
                    return false;
                }
                if (this.m_isCommonCondition) {
                    return true;
                }
                if (this.conditionView == 4) break block9;
                if (this.conditionView != 3) break block10;
            }
            if (this.conditionProperty.length() != 0 && this.conditionOperator.length() != 0 && this.conditionValue != null && this.conditionValue.length() != 0) {
                return true;
            }
            if (this.conditionProperty.length() == 0 || this.conditionOperator.length() == 0) return false;
            if (this.isOperatorNullOrNotNull()) {
                return true;
            }
            if (!this.isOperatorDefinedOrNotDefined()) return false;
            return true;
        }
        if (this.conditionProperty.length() == 0 || this.conditionOperator.length() == 0) return false;
        if (curMode != 1) return true;
        return this.isOperatorNullOrNotNull() || this.conditionValue != null && this.conditionValue.length() > 0;
    }

    private boolean isContentValid(int curMode) {
        block7: {
            block6: {
                if (this.conditionView == 0 && this.conditionProperty.length() == 0 && this.conditionOperator.length() == 0) {
                    return true;
                }
                if (this.conditionView == 0) {
                    return false;
                }
                if (this.conditionView == 4) break block6;
                if (this.conditionView != 3) break block7;
            }
            return this.conditionProperty.length() != 0 && this.conditionOperator.length() != 0;
        }
        if (curMode == 1 && this.conditionProperty.length() == 0) {
            return false;
        }
        return this.conditionOperator.length() != 0;
    }

    private boolean isOperatorNullOrNotNull() {
        if (this.conditionOperator.length() == 0) {
            return false;
        }
        return WcmString.compareIgnoreCase(WcmResourceString.s_isNullStr, this.conditionOperator) == 0 || WcmString.compareIgnoreCase(WcmResourceString.s_isNotNullStr, this.conditionOperator) == 0;
    }

    private boolean isOperatorDefinedOrNotDefined() {
        if (this.conditionOperator.length() == 0) {
            return false;
        }
        return WcmString.compareIgnoreCase(WcmResourceString.s_isDefinedStr, this.conditionOperator) == 0 || WcmString.compareIgnoreCase(WcmResourceString.s_isNotDefinedStr, this.conditionOperator) == 0;
    }

    public WcmCondition getCondition() {
        WcmCondition newone = new WcmCondition(this);
        return newone;
    }

    public String getViewString(int view) {
        switch (view) {
            case 1: {
                return XML_REQUIRED_STRING;
            }
            case 2: {
                return XML_EDITABLE_STRING;
            }
            case 3: {
                return XML_READONLY_STRING;
            }
            case 4: {
                return XML_HIDDEN_STRING;
            }
        }
        return VIEW_UNINITIALIZED_STRING;
    }

    public int getViewInt(WcmString view) {
        int viewInt = 0;
        viewInt = view.equals(new WcmString("client.WcmCondition.required", VIEW_REQUIRED_STRING)) ? 1 : (view.equals(new WcmString("client.WcmCondition.editable", VIEW_EDITABLE_STRING)) ? 2 : (view.equals(new WcmString("client.WcmCondition.readOnly", VIEW_READONLY_STRING)) ? 3 : (view.equals(new WcmString("client.WcmCondition.hidden", VIEW_HIDDEN_STRING)) ? 4 : 0)));
        return viewInt;
    }

    public String toString() {
        String result = this.getID() + ";" + this.getViewString(this.conditionView) + ";" + this.getProperty() + ";" + this.getPropertyLabel() + ";" + this.getOperator() + ";" + this.getZone() + ";" + this.isPropertyCondition;
        if (this.isValueFieldRequired) {
            result = result + ";" + this.getValue();
        }
        if (this.m_nearList != null) {
            result = result + ";near items=";
            for (WcmCondition item : this.m_nearList) {
                result = result + ";" + item.getProperty();
            }
        }
        return result;
    }

    public void setContent(String content) {
        try {
            if (content.length() == 0) {
                return;
            }
            String itemId = this.getNextParam(content);
            if (WcmString.compareIgnoreCase(itemId, "null") == 0) {
                this.initializePropertyID();
            } else {
                this.conditionID = new Integer(itemId);
            }
            content = this.removeParam(content, itemId);
            String view = this.getNextParam(content);
            if (view != null) {
                this.setView(view);
            }
            content = this.removeParam(content, view);
            this.conditionProperty = this.getNextParam(content);
            content = this.removeParam(content, this.conditionProperty);
            this.conditionLabel = this.getNextParam(content);
            content = this.removeParam(content, this.conditionLabel);
            this.conditionOperator = this.getNextParam(content);
            content = this.removeParam(content, this.conditionOperator);
            this.conditionZone = this.getNextParam(content);
            content = this.removeParam(content, this.conditionZone);
            String strIsPropertyCondition = this.getNextParam(content);
            Boolean bPropCondition = new Boolean(strIsPropertyCondition);
            this.isPropertyCondition = bPropCondition;
            content = this.removeParam(content, strIsPropertyCondition);
            boolean foundNearTag = false;
            String nextParam = this.getNextParam(content);
            if (nextParam == null) {
                this.setValueFieldNotRequired();
                this.conditionValue = null;
            } else if (WcmString.compareIgnoreCase(nextParam, NEAR_ITEMS_TAG) == 0) {
                this.setValueFieldNotRequired();
                this.conditionValue = null;
                content = this.removeParam(content, nextParam);
                foundNearTag = true;
            } else {
                this.conditionValue = nextParam;
                content = this.removeParam(content, nextParam);
            }
            if (content == null) {
                return;
            }
            if (!foundNearTag) {
                nextParam = this.getNextParam(content);
                if (nextParam == null) {
                    return;
                }
                if (WcmString.compareIgnoreCase(nextParam, NEAR_ITEMS_TAG) == 0) {
                    foundNearTag = true;
                }
            }
            if (foundNearTag) {
                this.m_nearList = new Vector();
                nextParam = this.getNextParam(content);
                while (nextParam != null) {
                    WcmCondition item = new WcmCondition();
                    item.setProperty(nextParam);
                    this.m_nearList.addElement(item);
                    content = this.removeParam(content, nextParam);
                    nextParam = this.getNextParam(content);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in setContent(): " + e.getMessage());
        }
    }

    private String getNextParam(String buf) {
        int semiColonLoc = 0;
        if (buf == null) {
            return null;
        }
        semiColonLoc = buf.indexOf(";");
        if (semiColonLoc == -1) {
            return buf;
        }
        return buf.substring(0, semiColonLoc);
    }

    private String removeParam(String buf, String param) {
        if (buf == null) {
            return null;
        }
        if (WcmString.compareIgnoreCase(buf, param) == 0) {
            return null;
        }
        int len = param.length();
        if (len == -1) {
            return buf;
        }
        return buf.substring(len + 1, buf.length());
    }

    public String getContent() {
        return this.toString();
    }

    public DataFlavor getDataFlavor() {
        return CONDITION_DATAFLAVOR;
    }

    private void argsTest(String[] args, int testMode) throws Exception {
        WcmCondition cond1 = new WcmCondition();
        if (args[0] != null && args[1] != null && args[2] != null) {
            if (args[0].equals(new String("false"))) {
                cond1.setValueFieldNotRequired();
            }
            Integer view = new Integer(args[1]);
            cond1.setView(view);
            cond1.setProperty(args[2]);
            cond1.setOperator(args[3]);
            if (args[4] != null) {
                cond1.setValue(args[4]);
            }
            if (cond1.isValid(testMode)) {
                System.out.println("\n\nCondition is VALID");
            } else {
                System.out.println("\n\nCondition is INVALID");
            }
            System.out.println("do Gets:\n\tview\t\t= " + cond1.getViewString(cond1.conditionView) + "\n\tproperty\t= " + cond1.getProperty() + "\n\toperator\t= " + cond1.getOperator() + "\n\tvalue\t\t= " + cond1.getValue() + "\n\tisValueRequired = " + cond1.isValueFieldRequired);
            System.out.println(cond1.toString());
        } else {
            System.out.println("Formate:\n1. value field required true or false\n2. view (required, editable, readonly, hidden)\n3. property \n4. operator \n5. value \n");
        }
    }

    private static void setContentTest() throws Exception {
        int counter = 1;
        WcmCondition item1 = new WcmCondition();
        System.out.println("Trying a simple condition...");
        item1.setID(counter++);
        item1.setView(1);
        item1.setProperty(new String("Date"));
        item1.setOperator("is equal");
        item1.setValue("today");
        WcmCondition newItem = new WcmCondition();
        newItem.setContent(item1.toString());
        System.out.println("Orig condition = " + item1);
        System.out.println("New condition = " + newItem);
        System.out.println("Trying a complex condition...");
        WcmCondition near1 = new WcmCondition();
        WcmCondition near2 = new WcmCondition();
        WcmCondition near3 = new WcmCondition();
        near1.setID(counter++);
        near1.setView(1);
        near1.setProperty(new String("Chicken"));
        near1.setOperator("false");
        near2.setID(counter++);
        near2.setView(1);
        near2.setProperty(new String("with"));
        near2.setOperator("false");
        near3.setID(counter++);
        near3.setView(1);
        near3.setProperty(new String("vegetables"));
        near3.setOperator(new String("false"));
        Vector<WcmCondition> nearList = new Vector<WcmCondition>();
        nearList.addElement(near1);
        nearList.addElement(near2);
        nearList.addElement(near3);
        WcmCondition item2 = new WcmCondition();
        item2.setID(counter++);
        item2.setView(1);
        item2.setProperty(new String("Chicken with vegetables"));
        item2.setOperator(new String("false"));
        item2.setValueFieldNotRequired();
        item2.setNearList(nearList);
        WcmCondition newItem2 = new WcmCondition();
        newItem2.setContent(item2.toString());
        System.out.println("Orig condition = " + item2);
        System.out.println("New condition = " + newItem2);
        System.out.println("Trying a condition without a value...");
        WcmCondition item3 = new WcmCondition();
        item3.setID(counter++);
        item3.setView(1);
        item3.setProperty(new String("Chicken with vegetables"));
        item3.setOperator(new String("false"));
        item3.setValueFieldNotRequired();
        WcmCondition newItem3 = new WcmCondition();
        newItem3.setContent(item3.toString());
        System.out.println("Orig condition = " + item3);
        System.out.println("New condition = " + newItem3);
    }

    private static void nearItemsTest() throws Exception {
        int counter = 1;
        WcmCondition item1 = new WcmCondition();
        WcmCondition item2 = new WcmCondition();
        WcmCondition item3 = new WcmCondition();
        item1.setID(counter++);
        item1.setView(1);
        item1.setProperty(new String("Chicken"));
        item1.setOperator("false");
        item2.setID(counter++);
        item2.setView(1);
        item2.setProperty(new String("with"));
        item2.setOperator("false");
        item3.setID(counter++);
        item3.setView(1);
        item3.setProperty(new String("vegetables"));
        item3.setOperator(new String("false"));
        Vector<WcmCondition> nearList = new Vector<WcmCondition>();
        nearList.addElement(item1);
        nearList.addElement(item2);
        nearList.addElement(item3);
        WcmCondition contentItem = new WcmCondition();
        contentItem.setID(counter++);
        contentItem.setView(1);
        contentItem.setProperty(new String("Chicken with vegetables"));
        contentItem.setOperator(new String("false"));
        contentItem.setNearList(nearList);
        System.out.println("print the content condition...");
        System.out.println(contentItem);
        System.out.println("Printing the near list...");
        Vector newNearList = contentItem.getNearList();
        if (newNearList != null) {
            for (WcmCondition item : newNearList) {
                System.out.println("-->" + item);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Begin testing...");
        WcmCondition.setContentTest();
        System.out.println("Done testing...");
    }
}

