/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.BaseObject;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PublishTemplate;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.TransportInputStream;
import com.filenet.wcm.api.User;
import com.filenet.wcm.apps.client.publish.PublishTemplateContentConverter;
import com.filenet.wcm.apps.client.publish.ui.GeneralPublishPanel;
import com.filenet.wcm.apps.client.publish.ui.PropertiesToApplyPanel;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthController;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthData;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataEvent;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataListener;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthPanel;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthResource;
import com.filenet.wcm.apps.client.publish.ui.RepublishInstructionsPanel;
import com.filenet.wcm.apps.client.publish.ui.SecurityToApplyPanel;
import com.filenet.wcm.apps.client.publish.ui.WcmAskCheckinCancelCheckoutDialog;
import com.filenet.wcm.apps.client.util.api.VerboseClassDescription;
import com.filenet.wcm.apps.client.util.api.VerboseFolder;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.apps.client.util.api.VerbosePublishTemplate;
import com.filenet.wcm.apps.server.util.prefs.DefaultPrefsObjects;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.WcmAboutBox;
import com.filenet.wcm.toolkit.client.ui.WcmAuthCore;
import com.filenet.wcm.toolkit.client.ui.WcmDlg;
import com.filenet.wcm.toolkit.client.ui.WcmDlgFactory;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.common.WcmStatusBar;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmHelp;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import javax.swing.AbstractButton;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import netscape.javascript.JSObject;

public class WcmPublishAuthCore
extends WcmAuthCore
implements ItemListener,
ActionListener,
IVWFrameInterface,
MenuListener,
PublishAuthDataListener,
PublishAuthController {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String DOMAIN = "domain";
    private Frame parentFrame;
    private Container mainContainer;
    private Container contentPane;
    private JRootPane rootPane;
    private JApplet parentApplet;
    private Session session;
    private WcmDlgItem entireNetworkDlgItem;
    private AbstractButton newButton;
    private AbstractButton fileNETOpenButton;
    private AbstractButton fileNETCheckinButton;
    private AbstractButton fileNETAddButton;
    private AbstractButton fileNETSaveButton;
    private AbstractButton fileNETCancelCheckoutButton;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem newItem;
    private JMenuItem fileNETOpenItem;
    private JMenuItem fileNETAddItem;
    private JMenuItem fileNETCheckinItem;
    private JMenuItem fileNETCancelCheckoutItem;
    private JMenuItem exitItem;
    private JMenu helpMenu;
    private JMenuItem contentsItem;
    private JMenuItem aboutItem;
    protected WcmStatusBar statusBar;
    JTabbedPane tabbedPane;
    PublishAuthPanel[] tabPanels;
    PublishAuthTabsSelectionModel tabsSelectionModel;
    private PublishAuthData data;
    private WcmAboutBox m_aboutBox;
    private VerboseLibrary currentLibrary;
    private ClassDescription pubTemplClassDesc;
    private WcmSitePrefs m_sitePreferences;
    private boolean debugOutput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(VWSessionInfo sessionInfo) {
        block17: {
            String curStatusBarMsg;
            block16: {
                Cursor curCursor = null;
                curStatusBarMsg = null;
                try {
                    this.mainContainer = sessionInfo.getParentContainer();
                    this.parentApplet = sessionInfo.getParentApplet();
                    if (this.mainContainer instanceof JApplet) {
                        this.rootPane = ((JApplet)this.mainContainer).getRootPane();
                        this.contentPane = ((JApplet)this.mainContainer).getContentPane();
                    } else if (this.mainContainer instanceof JFrame) {
                        this.rootPane = ((JFrame)this.mainContainer).getRootPane();
                        this.contentPane = ((JFrame)this.mainContainer).getContentPane();
                    }
                    this.parentFrame = VWModalDialog.getParentFrameUsingContainer((Container)this.mainContainer);
                    RepaintManager repaintManager = RepaintManager.currentManager(this.mainContainer);
                    if (repaintManager != null && !repaintManager.isDoubleBufferingEnabled()) {
                        repaintManager.setDoubleBufferingEnabled(true);
                    }
                    this.contentPane.setLayout(new BorderLayout());
                    this.initMenuBar();
                    this.initApplicationPane();
                    this.statusBar.setMsgText(WcmResourceString.s_ready);
                    this.mainContainer.setCursor(Cursor.getDefaultCursor());
                    this.initToolBar();
                    this.m_aboutBox = new WcmAboutBox(this.parentFrame);
                    ImageIcon icon = WcmImageLoader.createImageIcon("application/PublishDesigner32.gif");
                    this.m_aboutBox.init(PublishAuthResource.s_aboutPublishAuth, PublishAuthResource.s_publishAuthTitle, icon);
                    this.data = new PublishAuthData(this.session, this.m_sitePreferences);
                    this.data.addPublishAuthDataListener(this);
                    this.setDataOnTabs(this.data);
                    this.configureComponents();
                    this.updateTitleBar(WcmResourceString.s_untitled);
                    this.repaintContainer();
                    curStatusBarMsg = this.setStatusBarMsg(PublishAuthResource.s_loggingOnStr);
                    curCursor = this.setWaitCursor();
                    String token = sessionInfo.getProperty("token");
                    this.session = token == null ? this.makeSessionFromUserName(sessionInfo) : this.getSession(sessionInfo, "Publishing Designer", token);
                    if (this.session != null) {
                        this.setAppCursor(curCursor);
                        curCursor = null;
                        this.setStatusBarMsg(curStatusBarMsg);
                        curStatusBarMsg = null;
                        String prefToken = sessionInfo.getProperty("sitePreferences");
                        if (prefToken != null) {
                            this.m_sitePreferences = new WcmSitePrefs();
                            String xml = URLDecoder.decode(prefToken);
                            this.m_sitePreferences.load(xml);
                            String defPrefToken = sessionInfo.getProperty("defaultPrefsObjects");
                            if (defPrefToken != null) {
                                DefaultPrefsObjects defPrefsObjects = new DefaultPrefsObjects();
                                String defxml = URLDecoder.decode(defPrefToken);
                                defPrefsObjects.load(defxml);
                                this.m_sitePreferences.setDefaultPrefsObjects(defPrefsObjects);
                            }
                        }
                        this.loadComponentsInTabs();
                        this.tabPanels[0].requestFocus();
                        this.repaintContainer();
                    } else {
                        WcmErrorUtil.showErrorMessage(this.parentFrame, WcmResourceString.s_terminateSess.toString(this.m_sessErrText), PublishAuthResource.s_publishAuthTitle);
                        this.performExitItemAction(true);
                    }
                    if (curCursor == null) break block16;
                    this.setAppCursor(curCursor);
                }
                catch (Exception ex) {
                    this.tempTrace("Error occurred during initialization: " + ex.getMessage());
                    ex.printStackTrace();
                    break block17;
                }
                finally {
                    if (curCursor != null) {
                        this.setAppCursor(curCursor);
                        curCursor = null;
                    }
                    if (curStatusBarMsg != null) {
                        this.setStatusBarMsg(curStatusBarMsg);
                        curStatusBarMsg = null;
                    }
                }
                curCursor = null;
            }
            if (curStatusBarMsg != null) {
                this.setStatusBarMsg(curStatusBarMsg);
                curStatusBarMsg = null;
            }
        }
    }

    public void destroy() {
        this.performExitItemAction(false);
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.newItem || object == this.newButton) {
            this.performNewItemAction();
        } else if (object == this.fileNETOpenItem || object == this.fileNETOpenButton) {
            this.performFileNETOpenItemAction();
        } else if (object == this.fileNETAddItem || object == this.fileNETAddButton) {
            this.performFileNETAddItemAction();
        } else if (object == this.fileNETCheckinItem || object == this.fileNETCheckinButton) {
            this.performFileNETCheckinItemAction();
        } else if (object == this.fileNETCancelCheckoutItem || object == this.fileNETCancelCheckoutButton) {
            this.performFileNETCancelCheckoutItemAction();
        } else if (object == this.exitItem) {
            this.performExitItemAction(true);
        } else if (object == this.contentsItem) {
            this.performContentsItemAction();
        } else if (object == this.aboutItem) {
            this.performAboutItemAction();
        }
        if (this.parentFrame != null) {
            this.parentFrame.requestFocus();
        }
        System.gc();
    }

    public void windowClosing(WindowEvent event) {
    }

    public void menuCanceled(MenuEvent event) {
    }

    public void menuDeselected(MenuEvent event) {
    }

    public void menuSelected(MenuEvent event) {
    }

    public void dataChanged(PublishAuthDataEvent e) {
        if (e.getSource() == this.data) {
            this.tempTrace("WcmPublishAuthCore.dataChanged() called for data");
            int changeType = e.getType();
            if ((changeType & 0x10) != 0) {
                if (this.data.getLibrary() != null) {
                    if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(this.data.getLibrary().getId()) != 0) {
                        this.invalidateCurrentLibrary();
                    }
                } else {
                    this.invalidateCurrentLibrary();
                }
            }
            if (this.currentLibrary == null && this.data.getLibrary() != null) {
                this.currentLibrary = this.data.getLibrary();
            }
            if ((changeType & 2) != 0) {
                String name = this.data.getTitle();
                if (name == null) {
                    name = WcmResourceString.s_untitled;
                }
                this.updateTitleBar(name);
            }
            this.configureComponents();
        }
    }

    public Session getSession() {
        return this.session;
    }

    public WcmDlgItem getEntireNetworkDlgItem() throws WcmException {
        if (this.entireNetworkDlgItem == null) {
            this.loadEntireNetworkDlgItem();
        }
        return this.entireNetworkDlgItem;
    }

    public boolean isTabActive(PublishAuthPanel aTab) {
        boolean isActive = false;
        int selectedTab = this.tabsSelectionModel.getSelectedIndex();
        if (selectedTab >= 0 && this.tabPanels[selectedTab] == aTab) {
            isActive = true;
        }
        return isActive;
    }

    public boolean cancelCurrentTemplateCheckout() {
        return this.doCancelTemplateCheckout();
    }

    public String setStatusBarMsg(String statusMsg) {
        String curMsg = this.statusBar.getMsgText();
        this.statusBar.setMsgText(statusMsg);
        return curMsg;
    }

    public Cursor setWaitCursor() {
        return this.setAppCursor(Cursor.getPredefinedCursor(3));
    }

    public Cursor setAppCursor(Cursor cursor) {
        Cursor curCursor = this.mainContainer.getCursor();
        this.mainContainer.setCursor(cursor);
        return curCursor;
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public boolean validateObjectStoreChangingToWithTabs(VerboseLibrary vlib) {
        boolean valid = true;
        for (int i = 0; i < this.tabPanels.length && (valid = this.tabPanels[i].validateObjectStoreChangingTo(vlib)); ++i) {
        }
        return valid;
    }

    public WcmSitePrefs getSitePreferences() {
        return this.m_sitePreferences;
    }

    private void initApplicationPane() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane();
        this.tabsSelectionModel = new PublishAuthTabsSelectionModel();
        this.tabbedPane.setModel(this.tabsSelectionModel);
        PublishAuthPanel[] tempTabPanels = new PublishAuthPanel[]{new GeneralPublishPanel(this), new PropertiesToApplyPanel(this), new SecurityToApplyPanel(this), new RepublishInstructionsPanel(this)};
        for (int i = 0; i < tempTabPanels.length; ++i) {
            this.tabbedPane.add(tempTabPanels[i]);
        }
        this.tabbedPane.setTitleAt(0, PublishAuthResource.s_generalPublishTabTitle);
        this.tabbedPane.setTitleAt(1, PublishAuthResource.s_propertiesToApplyTabTitle);
        this.tabbedPane.setTitleAt(2, PublishAuthResource.s_securityToApplyTabTitle);
        this.tabbedPane.setTitleAt(3, PublishAuthResource.s_republishInstructionsTabTitle);
        mainPanel.add("Center", this.tabbedPane);
        this.contentPane.add("Center", mainPanel);
        this.statusBar = new WcmStatusBar();
        this.statusBar.setMsgText(WcmResourceString.s_ready);
        this.contentPane.add("South", this.statusBar);
        this.tabPanels = tempTabPanels;
    }

    private void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.initFileMenu();
        this.initHelpMenu();
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.removeAll();
        }
        if (this.fileMenu.getMenuComponentCount() > 0) {
            this.menuBar.add(this.fileMenu);
        }
        if (this.helpMenu.getMenuComponentCount() > 0) {
            this.menuBar.add(this.helpMenu);
        }
        this.rootPane.setJMenuBar(this.menuBar);
    }

    private void initFileMenu() {
        this.fileMenu = new JMenu();
        this.newItem = new JMenuItem();
        this.fileNETOpenItem = new JMenuItem();
        this.fileNETAddItem = new JMenuItem();
        this.fileNETCheckinItem = new JMenuItem();
        this.fileNETCancelCheckoutItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.fileMenu.setText(WcmResourceString.s_menuFile);
        this.fileMenu.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuFileNMonic));
        this.newItem.setHorizontalTextPosition(4);
        this.newItem.setText(WcmResourceString.s_menuNew);
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuNewNMonic));
        this.newItem.addActionListener(this);
        this.fileMenu.add(this.newItem);
        this.fileMenu.add(new JSeparator());
        this.fileNETOpenItem.setText(WcmResourceString.s_menuFnOpen);
        this.fileNETOpenItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuFnOpenNMonic));
        this.fileNETOpenItem.addActionListener(this);
        this.fileMenu.add(this.fileNETOpenItem);
        this.fileNETAddItem.setText(WcmResourceString.s_menuFnAdd);
        this.fileNETAddItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuFnAddNMonic));
        this.fileNETAddItem.addActionListener(this);
        this.fileMenu.add(this.fileNETAddItem);
        this.fileNETCheckinItem.setText(WcmResourceString.s_menuFnCheckin);
        this.fileNETCheckinItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuFnCheckinNMonic));
        this.fileNETCheckinItem.addActionListener(this);
        this.fileNETCheckinItem.setEnabled(false);
        this.fileMenu.add(this.fileNETCheckinItem);
        this.fileNETCancelCheckoutItem.setText(WcmResourceString.s_menuFnCancelCheckout);
        this.fileNETCancelCheckoutItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuFnCancelCheckoutNMonic));
        this.fileNETCancelCheckoutItem.addActionListener(this);
        this.fileNETCancelCheckoutItem.setEnabled(false);
        this.fileMenu.add(this.fileNETCancelCheckoutItem);
        this.fileMenu.add(new JSeparator());
        this.exitItem.setText(WcmResourceString.s_menuExit);
        this.exitItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuExitNMonic));
        this.exitItem.addActionListener(this);
        this.fileMenu.add(this.exitItem);
    }

    private void initHelpMenu() {
        this.helpMenu = new JMenu();
        this.contentsItem = new JMenuItem();
        this.aboutItem = new JMenuItem();
        this.helpMenu.setText(WcmResourceString.s_menuHelp);
        this.helpMenu.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuHelpNMonic));
        this.contentsItem.setHorizontalTextPosition(4);
        this.contentsItem.setText(WcmResourceString.s_menuContents);
        this.contentsItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuContentsNMonic));
        this.contentsItem.addActionListener(this);
        this.helpMenu.add(this.contentsItem);
        this.aboutItem.setHorizontalTextPosition(4);
        this.aboutItem.setText(WcmResourceString.s_menuAbout);
        this.aboutItem.setMnemonic(VWStringUtils.stringToMnemonic((String)WcmResourceString.s_menuAboutNMonic));
        this.aboutItem.addActionListener(this);
        this.helpMenu.add(this.aboutItem);
    }

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    private void initToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setMargin(new Insets(0, 0, 0, 0));
        this.newButton = this.addToolBarButton(toolBar, "action/button/New24.gif", WcmResourceString.s_menuNewTooltip, false, this);
        this.newButton.setFocusPainted(true);
        WcmImageLoader.addToolbarSeparator(toolBar);
        this.fileNETOpenButton = this.addToolBarButton(toolBar, "action/button/Checkout24.gif", WcmResourceString.s_menuFnOpenTooltip, false, this);
        this.fileNETAddButton = this.addToolBarButton(toolBar, "action/button/LibraryAdd24.gif", WcmResourceString.s_menuFnAddTooltip, false, this);
        this.fileNETCheckinButton = this.addToolBarButton(toolBar, "action/button/Checkin24.gif", WcmResourceString.s_menuFnCheckinTooltip, false, this);
        this.fileNETCheckinButton.setEnabled(false);
        this.fileNETCancelCheckoutButton = this.addToolBarButton(toolBar, "action/button/CancelCheckout24.gif", WcmResourceString.s_menuFnCancelCheckoutTooltip, false, this);
        this.fileNETCancelCheckoutButton.setEnabled(false);
        this.fileNETOpenButton.setFocusPainted(true);
        this.fileNETAddButton.setFocusPainted(true);
        this.fileNETCheckinButton.setFocusPainted(true);
        this.fileNETCancelCheckoutButton.setFocusPainted(true);
        toolBar.putClientProperty("JToolbar.isRollover", Boolean.TRUE);
        this.contentPane.add((Component)toolBar, "North");
    }

    private AbstractButton addToolBarButton(JToolBar toolBar, String fileName, String toolTip, boolean bUseToggleButton, ActionListener actionListener) {
        AbstractButton button = null;
        button = WcmImageLoader.createToolBarButton(fileName, toolTip, bUseToggleButton);
        if (button != null) {
            toolBar.add(button);
            button.setRolloverEnabled(true);
            if (actionListener != null) {
                button.addActionListener(actionListener);
            }
        }
        return button;
    }

    private void configureComponents() {
        this.tempTrace("WcmPublishAuthCore.configureComponents() called");
        VerbosePublishTemplate vpubTempl = this.data.getPublishTemplate();
        VerboseLibrary vlib = this.data.getLibrary();
        VerboseFolder vfoldLoc = this.data.getLocationFolder();
        if (vlib == null && this.tabsSelectionModel.getSelectedIndex() != 0) {
            this.tabsSelectionModel.setSelectedIndexDirect(0);
        }
        for (int i = 0; i < this.tabPanels.length; ++i) {
            if (i == 0) {
                this.tabbedPane.setEnabledAt(i, true);
                continue;
            }
            if (vlib == null) {
                this.tabbedPane.setEnabledAt(i, false);
                continue;
            }
            this.tabbedPane.setEnabledAt(i, true);
        }
        boolean toEnable = false;
        toEnable = vfoldLoc != null;
        this.fileNETAddItem.setEnabled(toEnable);
        this.fileNETAddButton.setEnabled(toEnable);
        toEnable = vpubTempl != null && vpubTempl.getIsReserved();
        this.fileNETCheckinItem.setEnabled(toEnable);
        this.fileNETCheckinButton.setEnabled(toEnable);
        this.fileNETCancelCheckoutItem.setEnabled(toEnable);
        this.fileNETCancelCheckoutButton.setEnabled(toEnable);
    }

    private Session makeSessionFromUserName(VWSessionInfo sessionInfo) {
        Session session = null;
        try {
            String username = sessionInfo.getProperty(USERNAME);
            String password = sessionInfo.getProperty(PASSWORD);
            if (username != null && password != null) {
                session = ObjectFactory.getSession((String)"Publishing Designer", (String)"Clear", (String)username, (String)password);
                session.setLocale(sessionInfo.getBrowserLocale());
                User user = session.verify();
                if (user != null) {
                    this.m_userName = user.getPropertyStringValue("ShortName");
                }
                return session;
            }
            this.m_sessErrText = WcmResourceString.s_noSess;
            JOptionPane.showMessageDialog(this.parentFrame, this.m_sessErrText, PublishAuthResource.s_publishAuthTitle, 0);
        }
        catch (Exception e) {
            this.m_sessErrText = e.getMessage();
            this.tempTrace("Caught error in makeSession(): " + e.getMessage());
        }
        return null;
    }

    private void loadEntireNetworkDlgItem() throws WcmException {
        this.tempTrace("loadEntireNetworkDlgItem() called.  session: " + this.session);
        if (this.entireNetworkDlgItem == null) {
            this.entireNetworkDlgItem = WcmDlgFactory.getEntireNetworkItem(this.session, this.m_sitePreferences);
        }
    }

    private void setDataOnTabs(PublishAuthData data) {
        for (int i = 0; i < this.tabPanels.length; ++i) {
            this.tabPanels[i].setData(data);
        }
    }

    private void loadComponentsInTabs() {
        for (int i = 0; i < this.tabPanels.length; ++i) {
            this.tabPanels[i].loadComponents();
        }
    }

    private boolean applyChangesToTabs() {
        boolean successful = true;
        for (int i = 0; i < this.tabPanels.length && (successful = this.tabPanels[i].applyChanges()); ++i) {
        }
        return successful;
    }

    private void setData(PublishAuthData tempData) {
        String name;
        this.tempTrace("WcmPublishAuthCore.setData() called");
        if (tempData.getLibrary() != null) {
            if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(tempData.getLibrary().getId()) != 0) {
                this.invalidateCurrentLibrary();
            }
        } else {
            this.invalidateCurrentLibrary();
        }
        if (this.currentLibrary == null && tempData.getLibrary() != null) {
            this.currentLibrary = tempData.getLibrary();
        }
        if ((name = tempData.getTitle()) == null) {
            name = WcmResourceString.s_untitled;
        }
        this.updateTitleBar(name);
        if (this.data != null) {
            this.data.removePublishAuthDataListener(this);
        }
        tempData.addPublishAuthDataListener(this);
        this.data = tempData;
        this.configureComponents();
        this.setDataOnTabs(this.data);
    }

    private void invalidateCurrentLibrary() {
        this.currentLibrary = null;
        this.pubTemplClassDesc = null;
    }

    private void loadPubTemplClassDesc() throws BaseException {
        if (this.pubTemplClassDesc == null) {
            VerboseLibrary vlib = this.data.getLibrary();
            VerboseClassDescription vcd = vlib.getDocumentClassDescriptionFromId("{FBA25CE9-A06A-4F79-8A23-E09AE54DD7CD}");
            this.pubTemplClassDesc = vcd.getClassDescription();
        }
    }

    private boolean calculateModified() {
        boolean calculatedModified = false;
        for (int i = 0; i < this.tabPanels.length && !(calculatedModified = this.tabPanels[i].calculateModified()); ++i) {
        }
        return calculatedModified;
    }

    private void updateTitleBar(String templateTitle) {
        if (templateTitle != null) {
            this.statusBar.setFileNameText(templateTitle);
            this.statusBar.paintImmediately(this.statusBar.getBounds());
        }
    }

    private void repaintContainer() {
        if (this.mainContainer != null) {
            this.mainContainer.invalidate();
            this.mainContainer.validate();
            this.mainContainer.repaint();
        }
    }

    private void performNewItemAction() {
        this.tempTrace("performNewItemAction() called");
        CurrentTemplateHandlingResult result = this.handleCurrentTemplate();
        if (result.successful) {
            PublishAuthData tempData = new PublishAuthData(this.session, this.m_sitePreferences);
            this.setData(tempData);
        } else {
            if (result.updatedTemplate != null) {
                try {
                    result.updatedTemplate.refresh(true);
                }
                catch (Exception ex) {
                    WcmErrorUtil.showErrorMessage(this.parentFrame, ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
                    ex.printStackTrace();
                }
            }
            if (result.updatedTemplate != null) {
                this.data.setPublishTemplate(result.updatedTemplate);
            }
        }
    }

    private void performFileNETOpenItemAction() {
        CurrentTemplateHandlingResult result = this.handleCurrentTemplate();
        if (result.successful) {
            try {
                if (this.entireNetworkDlgItem == null) {
                    this.loadEntireNetworkDlgItem();
                }
                WcmDlg browseDlg = WcmDlgFactory.getBrowseDialog(this.entireNetworkDlgItem, null, WcmResourceString.s_open, new int[]{-101});
                browseDlg.setBrowseMode(2);
                browseDlg.setTitle(PublishAuthResource.s_openTemplateTitle);
                int stat = browseDlg.showDialog(this.parentFrame);
                if (stat == 0) {
                    WcmDlgItem dlgItem = browseDlg.getSelectedItem();
                    dlgItem.getParent().clearContents();
                    ReadableMetadataObject wcmObj = dlgItem.getWcmObject();
                    if (!(wcmObj instanceof PublishTemplate)) {
                        throw new RuntimeException("Open didn't return a Publish Template!");
                    }
                    PublishTemplate pubTempl = (PublishTemplate)wcmObj;
                    TransportInputStream stream = pubTempl.getContent();
                    PublishTemplateContentConverter contentConverter = new PublishTemplateContentConverter((InputStream)stream);
                    String templVersion = contentConverter.getPublishTemplateVersion();
                    if (templVersion == null || templVersion.compareToIgnoreCase("2") == 0) {
                        short nApplySecForm = contentConverter.getNewPublishApplySecurityFrom();
                        if (nApplySecForm != 2) {
                            if (nApplySecForm != 1) {
                                if (nApplySecForm != 4 && contentConverter.getApplySecurityPermissionCount() > 0) {
                                    JOptionPane.showMessageDialog(this.parentFrame, WcmResourceString.s_openOldVersionPubTemplate, PublishAuthResource.s_publishAuthTitle, 0);
                                    PublishAuthData tempData = new PublishAuthData(this.session, this.m_sitePreferences);
                                    this.setData(tempData);
                                    return;
                                }
                            }
                        }
                    }
                    VerbosePublishTemplate vpubTempl = new VerbosePublishTemplate(pubTempl);
                    boolean maintainPubTempl = true;
                    if (browseDlg.getSelectedMode() == 1) {
                        if (!vpubTempl.getIsReserved() && !vpubTempl.getIsReservation()) {
                            PublishTemplate resPubTempl = (PublishTemplate)pubTempl.checkout();
                            vpubTempl.refresh(true);
                        }
                    } else {
                        boolean assumeCheckout = this.testAssumeCheckout(vpubTempl);
                        if (!assumeCheckout) {
                            maintainPubTempl = false;
                        }
                    }
                    PublishAuthData tempData = new PublishAuthData(this.session, this.m_sitePreferences, vpubTempl, maintainPubTempl);
                    this.setData(tempData);
                } else {
                    if (stat == -1) {
                        // empty if block
                    }
                    result.successful = false;
                }
            }
            catch (Exception ex) {
                String errMsg = PublishAuthResource.s_errorOpen.toString(ex.getLocalizedMessage());
                WcmErrorUtil.showErrorMessage(this.parentFrame, errMsg, PublishAuthResource.s_publishAuthTitle);
                ex.printStackTrace();
                result.successful = false;
            }
        }
        if (!result.successful) {
            if (result.updatedTemplate != null) {
                try {
                    result.updatedTemplate.refresh(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (result.updatedTemplate != null) {
                this.data.setPublishTemplate(result.updatedTemplate);
            }
        }
    }

    private void performFileNETAddItemAction() {
        CurrentTemplateHandlingResult result = new CurrentTemplateHandlingResult();
        result.successful = true;
        boolean modified = this.data.isModified();
        if (!modified) {
            modified = this.calculateModified();
        }
        try {
            VerbosePublishTemplate vpubTempl = this.data.getPublishTemplate();
            if (vpubTempl != null && vpubTempl.getIsReserved()) {
                result = this.handleCurrentTemplateCheckout(result, modified);
            }
            this.setStatusBarMsg(WcmResourceString.s_addingNew);
            if (result.successful) {
                result.successful = this.applyChangesToTabs();
                if (result.successful) {
                    result = this.doAddTemplate(result);
                }
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(this.parentFrame, ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
            result.successful = false;
        }
        if (result.updatedTemplate != null) {
            try {
                result.updatedTemplate.refresh(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result.successful = false;
            }
        }
        if (result.updatedTemplate != null) {
            this.data.setPublishTemplate(result.updatedTemplate);
        }
        if (result.successful) {
            this.data.clearModified();
        }
        this.setStatusBarMsg(WcmResourceString.s_ready);
    }

    private void performFileNETCheckinItemAction() {
        CurrentTemplateHandlingResult result = new CurrentTemplateHandlingResult();
        result.successful = true;
        try {
            result.successful = this.applyChangesToTabs();
            if (result.successful) {
                this.setStatusBarMsg(WcmResourceString.s_checkingIn);
                result = this.doCheckinTemplate(result);
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(this.parentFrame, ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
            result.successful = false;
        }
        if (result.updatedTemplate != null) {
            try {
                result.updatedTemplate.refresh(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result.successful = false;
            }
        }
        if (result.updatedTemplate != null) {
            this.data.setPublishTemplate(result.updatedTemplate);
        }
        if (result.successful) {
            this.data.clearModified();
        }
        this.setStatusBarMsg(WcmResourceString.s_ready);
    }

    private void performFileNETCancelCheckoutItemAction() {
        CurrentTemplateHandlingResult result = new CurrentTemplateHandlingResult();
        result.successful = true;
        boolean modified = this.data.isModified();
        if (!modified) {
            modified = this.calculateModified();
        }
        if (modified) {
            result = this.handleCurrentTemplateCheckout(result, modified);
        } else {
            try {
                this.setStatusBarMsg(WcmResourceString.s_cancelingCheckout);
                result.successful = this.doCancelTemplateCheckout();
                if (result.successful) {
                    result.updatedTemplate = this.data.getPublishTemplate();
                }
            }
            catch (Exception ex) {
                WcmErrorUtil.showErrorMessage(this.parentFrame, ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
                ex.printStackTrace();
                result.successful = false;
            }
        }
        if (result.updatedTemplate != null) {
            try {
                result.updatedTemplate.refresh(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (result.updatedTemplate != null) {
            this.data.setPublishTemplate(result.updatedTemplate, false);
        }
        this.setStatusBarMsg(WcmResourceString.s_ready);
    }

    private void performExitItemAction(boolean bCloseWindow) {
        try {
            if (!bCloseWindow) {
                return;
            }
            CurrentTemplateHandlingResult result = this.handleCurrentTemplate();
            if (result.successful) {
                if (this.mainContainer != null && this.mainContainer instanceof VWBaseAppLauncherApplet) {
                    ((VWBaseAppLauncherApplet)this.mainContainer).closeWindow();
                } else if (this.mainContainer != null && this.mainContainer instanceof JApplet) {
                    JApplet applet = (JApplet)this.mainContainer;
                    if (applet != null && applet.isActive()) {
                        JSObject window = JSObject.getWindow((Applet)applet);
                        window.call("CloseWindow", null);
                        applet.setEnabled(false);
                    }
                } else if (this.mainContainer != null && this.mainContainer instanceof JFrame) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)this.mainContainer, 201));
                }
            }
        }
        catch (Exception ex) {
            this.tempTrace("Failure occurred while exiting: " + ex.getMessage());
        }
    }

    private void performContentsItemAction() {
        WcmHelp.displayPage(WcmResourceString.s_helpPublishDesigner);
    }

    private void performAboutItemAction() {
        this.m_aboutBox.setVisible(true);
    }

    private CurrentTemplateHandlingResult handleCurrentTemplate() {
        this.tempTrace("handleCurrentTemplate() called");
        CurrentTemplateHandlingResult result = new CurrentTemplateHandlingResult();
        result.successful = true;
        boolean modified = this.data.isModified();
        if (!modified) {
            modified = this.calculateModified();
        }
        if (modified) {
            VerbosePublishTemplate vpubTempl = this.data.getPublishTemplate();
            if (vpubTempl != null && vpubTempl.getIsReserved()) {
                WcmAskCheckinCancelCheckoutDialog dlg = new WcmAskCheckinCancelCheckoutDialog(this.parentFrame, PublishAuthResource.s_publishAuthTitle, modified);
                dlg.show();
                if (dlg.getRetStatus() == WcmAskCheckinCancelCheckoutDialog.CHECKIN) {
                    result.successful = this.applyChangesToTabs();
                    if (result.successful) {
                        result = this.doCheckinTemplate(result);
                    }
                } else if (dlg.getRetStatus() == WcmAskCheckinCancelCheckoutDialog.CANCEL_CHECKOUT) {
                    result.successful = this.doCancelTemplateCheckout();
                    if (result.successful) {
                        result.updatedTemplate = this.data.getPublishTemplate();
                    }
                } else {
                    result.successful = false;
                }
            } else {
                VerboseFolder vfoldLoc = this.data.getLocationFolder();
                if (vfoldLoc == null) {
                    Object[] options = new Object[]{WcmResourceString.s_yes, WcmResourceString.s_no};
                    int opt = JOptionPane.showOptionDialog(this.parentFrame, PublishAuthResource.s_askDiscardChanges, PublishAuthResource.s_publishAuthTitle, 0, 3, null, options, options[0]);
                    if (opt != 0) {
                        result.successful = false;
                    }
                } else {
                    Object[] options = new Object[]{WcmResourceString.s_yes, WcmResourceString.s_no, WcmResourceString.s_cancel};
                    int opt = JOptionPane.showOptionDialog(this.parentFrame, PublishAuthResource.s_askSaveChanges, PublishAuthResource.s_publishAuthTitle, 1, 3, null, options, options[0]);
                    if (opt == 0) {
                        result.successful = this.applyChangesToTabs();
                        if (result.successful) {
                            result = this.doAddTemplate(result);
                        }
                    } else if (opt == 2) {
                        result.successful = false;
                    }
                }
            }
        } else {
            VerbosePublishTemplate vpubTempl = this.data.getPublishTemplate();
            if (vpubTempl != null && vpubTempl.getIsReserved()) {
                WcmAskCheckinCancelCheckoutDialog dlg = new WcmAskCheckinCancelCheckoutDialog(this.parentFrame, PublishAuthResource.s_publishAuthTitle, modified);
                dlg.show();
                if (dlg.getRetStatus() == WcmAskCheckinCancelCheckoutDialog.CHECKIN) {
                    result.successful = this.applyChangesToTabs();
                    if (result.successful) {
                        result = this.doCheckinTemplate(result);
                    }
                } else if (dlg.getRetStatus() == WcmAskCheckinCancelCheckoutDialog.CANCEL_CHECKOUT) {
                    result.successful = this.doCancelTemplateCheckout();
                    if (result.successful) {
                        result.updatedTemplate = vpubTempl;
                    }
                } else {
                    result.successful = false;
                }
            }
        }
        return result;
    }

    private CurrentTemplateHandlingResult handleCurrentTemplateCheckout(CurrentTemplateHandlingResult result, boolean modified) {
        WcmAskCheckinCancelCheckoutDialog dlg = new WcmAskCheckinCancelCheckoutDialog(this.parentFrame, PublishAuthResource.s_publishAuthTitle, modified);
        dlg.show();
        if (dlg.getRetStatus() == WcmAskCheckinCancelCheckoutDialog.CHECKIN) {
            result.successful = this.applyChangesToTabs();
            if (result.successful) {
                result = this.doCheckinTemplate(result);
            }
        } else if (dlg.getRetStatus() == WcmAskCheckinCancelCheckoutDialog.CANCEL_CHECKOUT) {
            result.successful = this.doCancelTemplateCheckout();
            if (result.successful) {
                result.updatedTemplate = this.data.getPublishTemplate();
            }
        } else {
            result.successful = false;
        }
        return result;
    }

    private boolean doCancelTemplateCheckout() {
        boolean successful = true;
        try {
            VerbosePublishTemplate vpubTempl = this.data.getPublishTemplate();
            vpubTempl.getReservation().getPublishTemplate().cancelCheckout();
            WcmDlgItemImpl enwImpl = (WcmDlgItemImpl)this.entireNetworkDlgItem;
            enwImpl.setObjectStoreDirty(this.currentLibrary.getId());
        }
        catch (Exception ex) {
            String errMsg = PublishAuthResource.s_errorCancelCheckout.toString(ex.getLocalizedMessage());
            WcmErrorUtil.showErrorMessage(this.parentFrame, errMsg, PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
            successful = false;
        }
        return successful;
    }

    private CurrentTemplateHandlingResult doCheckinTemplate(CurrentTemplateHandlingResult result) {
        if (result == null) {
            result = new CurrentTemplateHandlingResult();
            result.successful = true;
        }
        try {
            Property prop;
            VerbosePublishTemplate vpubTempl = this.data.getPublishTemplate();
            String libId = this.data.getLibrary().getLibrary().getId();
            VerbosePublishTemplate reservation = vpubTempl.getReservation();
            String xml = this.data.getContentConverter().toString();
            this.tempTrace("[ Beginning of template content XML ]");
            this.tempTrace(xml);
            this.tempTrace("[ End of template content XML ]");
            ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-16LE"));
            Properties props = ObjectFactory.getProperties();
            if (this.data.getDescription() != null) {
                prop = ObjectFactory.getProperty((String)"Description");
                prop.setValue(this.data.getDescription());
                props.add((Object)prop);
            }
            if (this.data.getTitle() != null) {
                prop = ObjectFactory.getProperty((String)"DocumentTitle");
                prop.setValue(this.data.getTitle());
                props.add((Object)prop);
            }
            WcmDlg checkinWiz = WcmDlgFactory.getCheckinDialog(this.parentFrame, this.getEntireNetworkDlgItem(), (BaseObject)reservation.getPublishTemplate(), stream, xml.getBytes().length, props);
            checkinWiz.setTitle(PublishAuthResource.s_checkinTemplateTitle);
            int stat = checkinWiz.showDialog(this.parentFrame);
            if (stat == 0) {
                result.updatedTemplate = reservation;
            } else {
                if (stat == -1) {
                    // empty if block
                }
                result.successful = false;
            }
        }
        catch (Exception ex) {
            String errMsg = PublishAuthResource.s_errorCheckin.toString(ex.getLocalizedMessage());
            WcmErrorUtil.showErrorMessage(this.parentFrame, errMsg, PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
            result.successful = false;
        }
        return result;
    }

    private CurrentTemplateHandlingResult doAddTemplate(CurrentTemplateHandlingResult result) {
        block11: {
            if (result == null) {
                result = new CurrentTemplateHandlingResult();
                result.successful = true;
            }
            try {
                Property prop;
                String libId = this.data.getLibrary().getLibrary().getId();
                String xml = this.data.getContentConverter().toString();
                this.tempTrace("[ Beginning of template content XML ]");
                this.tempTrace(xml);
                this.tempTrace("[ End of template content XML ]");
                byte[] buf = xml.getBytes("UTF-16LE");
                ByteArrayInputStream stream = new ByteArrayInputStream(buf);
                if (this.pubTemplClassDesc == null) {
                    this.loadPubTemplClassDesc();
                }
                Properties props = ObjectFactory.getProperties();
                if (this.data.getDescription() != null) {
                    prop = ObjectFactory.getProperty((String)"Description");
                    prop.setValue(this.data.getDescription());
                    props.add((Object)prop);
                }
                if (this.data.getTitle() != null) {
                    prop = ObjectFactory.getProperty((String)"DocumentTitle");
                    prop.setValue(this.data.getTitle());
                    props.add((Object)prop);
                }
                WcmDlgItem libDlgItem = this.getEntireNetworkDlgItem().getChildById(this.currentLibrary.getId());
                WcmDlg addWiz = WcmDlgFactory.getAddDialog(this.parentFrame, libDlgItem, null, (InputStream)stream, (long)buf.length, this.pubTemplClassDesc, props);
                addWiz.setTitle(PublishAuthResource.s_addTemplateTitle);
                int stat = addWiz.showDialog(this.parentFrame);
                if (stat == 0) {
                    WcmDlgItem dlgItem = addWiz.getSelectedItem();
                    try {
                        dlgItem.getParent().getWcmObject().refresh();
                    }
                    catch (ClassCastException c) {
                        // empty catch block
                    }
                    ReadableMetadataObject wcmObj = dlgItem.getWcmObject();
                    if (!(wcmObj instanceof PublishTemplate)) {
                        throw new RuntimeException("Add Wizard didn't return Publish Template!");
                    }
                    result.updatedTemplate = new VerbosePublishTemplate((PublishTemplate)wcmObj);
                    break block11;
                }
                if (stat == -1) {
                    // empty if block
                }
                result.successful = false;
            }
            catch (Exception ex) {
                String errMsg = PublishAuthResource.s_errorAdd.toString(ex.getLocalizedMessage());
                WcmErrorUtil.showErrorMessage(this.parentFrame, errMsg, PublishAuthResource.s_publishAuthTitle);
                ex.printStackTrace();
                result.successful = false;
            }
        }
        return result;
    }

    private boolean testAssumeCheckout(VerbosePublishTemplate pubTempl) {
        boolean assumeCheckout = false;
        try {
            VerbosePublishTemplate resPubTempl;
            boolean isReserved = pubTempl.getIsReserved();
            if (isReserved && (resPubTempl = pubTempl.getReservation()) != null) {
                int asMask;
                String resvUser = resPubTempl.getPublishTemplate().getPropertyStringValue("Creator");
                int resvType = resPubTempl.getPublishTemplate().getPropertyIntValue("ReservationType");
                if ((resvType == 32 && WcmString.compareIgnoreCase(resvUser, this.m_userName) == 0 || resvType == 16) && ((asMask = resPubTempl.getPublishTemplate().getAccessMask()) & 2) != 0 && (asMask & 4) != 0) {
                    assumeCheckout = true;
                    String msg = PublishAuthResource.s_assumeCheckoutMsg;
                    Object[] options = new Object[]{WcmResourceString.s_yes, WcmResourceString.s_no};
                    int answer = JOptionPane.showOptionDialog(this.parentFrame, msg, PublishAuthResource.s_publishAuthTitle, 0, 3, null, options, options[0]);
                    if (answer != 0) {
                        assumeCheckout = false;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            assumeCheckout = false;
        }
        return assumeCheckout;
    }

    private void tempTrace(String str) {
        if (this.debugOutput) {
            System.out.println(str);
        }
    }

    private static class CurrentTemplateHandlingResult {
        boolean successful;
        VerbosePublishTemplate updatedTemplate;

        private CurrentTemplateHandlingResult() {
        }
    }

    private class PublishAuthTabsSelectionModel
    extends DefaultSingleSelectionModel {
        private PublishAuthTabsSelectionModel() {
        }

        public void setSelectedIndex(int index) {
            boolean canSwitch = true;
            if (this.getSelectedIndex() != index && index >= 0 && WcmPublishAuthCore.this.tabPanels != null) {
                int curIndex = this.getSelectedIndex();
                if (curIndex >= 0) {
                    canSwitch = WcmPublishAuthCore.this.tabPanels[curIndex].canSwitchFrom();
                }
                if (canSwitch) {
                    canSwitch = WcmPublishAuthCore.this.tabPanels[index].canSwitchTo();
                }
            }
            if (canSwitch) {
                super.setSelectedIndex(index);
            }
        }

        public void setSelectedIndexDirect(int index) {
            super.setSelectedIndex(index);
        }
    }
}

