/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.api.Group;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Permission;
import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.SecurityGrantee;
import com.filenet.wcm.api.SecurityPolicies;
import com.filenet.wcm.api.SecurityPolicy;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.User;
import com.filenet.wcm.apps.client.publish.PublishTemplateContentConverter;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthController;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthData;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataEvent;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataListener;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthPanel;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthResource;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthUtil;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerboseClassDescription;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.ui.security.WcmSecurityPanel;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class SecurityToApplyPanel
extends PublishAuthPanel
implements ActionListener,
PublishAuthDataListener {
    private PublishAuthController controller;
    private PublishAuthData data;
    private VerboseLibrary currentLibrary;
    private VerboseClassDescription defaultSecurityClassDesc;
    private JRadioButton optionUseDestFolderBtn;
    private JRadioButton optionUseSourceDocBtn;
    private JRadioButton optionUseDefaultBtn;
    private SpecifySecurityButtonModel specifySecurityButtonModel;
    private JRadioButton optionSpecifySecurityBtn;
    private ButtonGroup applySecurityOptionsBtnGroup;
    private JCheckBox securityPolicyChk;
    private JCheckBox securityPermissionsChk;
    private JComboBox securityPolicyComboBox;
    private DefaultComboBoxModel securityPolicyModel;
    private JPanel securityPlaceHolderComponent;
    private WcmSecurityPanel securityPanel;
    private Permissions initialPermissions;
    private Permissions initialReservationPerms;
    private String creatorOwnerFromGroups;
    private static final String creatorOwnerStr = "CREATOR OWNER";
    private static final String AuthenticatedUsersStr = "AUTHENTICATED USERS";
    private final int SID_TO_NAME_CONVERT = 1;
    private final int NAME_TO_SID_CONVERT = 2;
    private SecurityPolicy currentSecPolicy;

    SecurityToApplyPanel(PublishAuthController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private SecurityToApplyPanel() {
    }

    void setData(PublishAuthData data) {
        this.tempTrace("SecurityToApply.setData() called");
        PublishTemplateContentConverter converter = data.getContentConverter();
        if (data.getLibrary() != null) {
            if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(data.getLibrary().getId()) != 0) {
                this.invalidateCurrentLibrary();
            }
        } else {
            this.invalidateCurrentLibrary();
        }
        PublishTemplateContentConverter.NameOrId secPolicyFromTempl = converter.getSecurityPolicyClassKey(null);
        if (secPolicyFromTempl.key != null && this.currentSecPolicy != null) {
            String currentKey = null;
            currentKey = secPolicyFromTempl.isNameOrId ? this.currentSecPolicy.getName() : this.currentSecPolicy.getId();
            if (currentKey != null && currentKey.compareToIgnoreCase(secPolicyFromTempl.key) != 0) {
                this.invalidateSecurityPolicy();
            }
        } else {
            this.invalidateSecurityPolicy();
        }
        if (converter.getNewPublishApplySecurityFrom() == 0) {
            this.removeSecurityPanel();
        }
        if (data.getApplyPropsClassDesc() != null && this.securityPanel != null && !this.securityPanel.isModified() && this.defaultSecurityClassDesc.getId().compareToIgnoreCase(data.getApplyPropsClassDesc().getId()) != 0) {
            this.removeSecurityPanel();
        }
        try {
            if (this.currentLibrary == null && data.getLibrary() != null) {
                this.currentLibrary = data.getLibrary();
            }
            if (this.currentSecPolicy == null && secPolicyFromTempl.key != null) {
                String keyFromTemplate = secPolicyFromTempl.key;
                this.currentSecPolicy = (SecurityPolicy)this.currentLibrary.getLibrary().getObject(1170, keyFromTemplate);
            }
            if (this.currentLibrary != null && this.securityPanel == null) {
                Permissions perms = null;
                if (converter.getNewPublishApplySecurityFrom() == 0 && converter.getApplySecurityPermissionCount() > 0) {
                    this.SIDAndNameConverter(converter, 1);
                    perms = ObjectFactory.getPermissions();
                    int permCount = converter.getApplySecurityPermissionCount();
                    boolean convertedCreatorOwner = false;
                    boolean convertedAuthUsers = false;
                    for (int i = 0; i < permCount; ++i) {
                        String granteeName = converter.getApplySecurityPermissionGranteeName(i);
                        short granteeType = converter.getApplySecurityPermissionGranteeType(i);
                        int access = converter.getApplySecurityPermissionAccess(i);
                        short accessType = converter.getApplySecurityPermissionAccessType(i);
                        if (granteeName == null || granteeName.length() <= 0) continue;
                        Permission perm = ObjectFactory.getPermission((int)access, (int)accessType, (String)granteeName, (int)granteeType);
                        this.tempTrace("Adding permission: access=" + access + "; type=" + accessType + "; name=" + granteeName + "; type=" + granteeType);
                        perms.add((Object)perm);
                    }
                } else {
                    this.defaultSecurityClassDesc = data.getApplyPropsClassDesc() != null ? data.getApplyPropsClassDesc() : data.getLibrary().getDocumentClassDescriptionFromId("{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}");
                }
                this.loadSecurityPanel(perms);
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
        }
        if (this.securityPanel == null && this.securityPlaceHolderComponent.getParent() != this) {
            this.loadSecurityPlaceHolderComponent();
        }
        if (converter.getNewPublishApplySecurityFrom() == 2) {
            this.setButtonSelectedDisarmModifiedFire(this.optionUseDestFolderBtn, true);
        } else if (converter.getNewPublishApplySecurityFrom() == 1) {
            this.setButtonSelectedDisarmModifiedFire(this.optionUseSourceDocBtn, true);
        } else if (converter.getNewPublishApplySecurityFrom() == 4) {
            this.setButtonSelectedDisarmModifiedFire(this.optionUseDefaultBtn, true);
        } else {
            this.specifySecurityButtonModel.setSelectedDirect(true);
            if (this.securityPanel != null && converter.getApplySecurityPermissionCount() > 0) {
                this.securityPermissionsChk.setSelected(true);
            }
            if (this.currentSecPolicy != null) {
                this.securityPolicyChk.setSelected(true);
            }
            if (this.securityPanel == null && this.currentSecPolicy == null) {
                this.setButtonSelectedDisarmModifiedFire(this.optionUseDestFolderBtn, true);
            }
        }
        if (this.data != null) {
            this.data.removePublishAuthDataListener(this);
        }
        data.addPublishAuthDataListener(this);
        this.data = data;
        this.configureComponents();
    }

    boolean calculateModified() {
        boolean calculatedModified = false;
        if (this.optionSpecifySecurityBtn.isSelected() && this.securityPanel.isModified()) {
            calculatedModified = true;
        }
        return calculatedModified;
    }

    public boolean applyChanges() {
        this.tempTrace("SecurityToApply.applyChanges() called.");
        boolean successful = true;
        PublishTemplateContentConverter converter = this.data.getContentConverter();
        if (this.optionUseDestFolderBtn.isSelected()) {
            converter.setNewPublishApplySecurityFrom((short)2);
        } else if (this.optionUseSourceDocBtn.isSelected()) {
            converter.setNewPublishApplySecurityFrom((short)1);
        } else if (this.optionUseDefaultBtn.isSelected()) {
            converter.setNewPublishApplySecurityFrom((short)4);
        } else {
            if (!this.securityPermissionsChk.isSelected() && !this.securityPolicyChk.isSelected()) {
                JOptionPane.showMessageDialog(this.controller.getParentFrame(), PublishAuthResource.s_errorSecuritySelected, PublishAuthResource.s_publishAuthTitle, 0);
                return false;
            }
            converter.setNewPublishApplySecurityFrom((short)0);
            successful = this.updateSecurityPolicy(converter);
            if (successful) {
                if (this.securityPermissionsChk.isSelected()) {
                    this.writeSecurityPermissions(converter);
                } else {
                    converter.clearApplySecurityPermissions();
                }
            }
        }
        return successful;
    }

    private boolean updateSecurityPolicy(PublishTemplateContentConverter converter) {
        boolean successful = true;
        if (this.securityPolicyChk.isSelected()) {
            if (this.currentSecPolicy == null) {
                JOptionPane.showMessageDialog(this.controller.getParentFrame(), PublishAuthResource.s_errorNoSecurityPolicySelected, PublishAuthResource.s_publishAuthTitle, 0);
                successful = false;
            } else {
                converter.setSecurityPolicyClassKey(this.currentSecPolicy.getId(), false);
            }
        } else {
            converter.setSecurityPolicyClassKey(null, false);
        }
        return successful;
    }

    private void writeSecurityPermissions(PublishTemplateContentConverter converter) {
        converter.clearApplySecurityPermissions();
        Permissions perms = this.securityPanel.isModified() ? this.securityPanel.getPermissions() : this.initialPermissions;
        Iterator it = perms.iterator();
        boolean convertedCreatorOwner = false;
        boolean convertedAuthUsers = false;
        while (it.hasNext()) {
            Permission perm = (Permission)it.next();
            if (perm.getAccess() == 0) continue;
            String granteeName = perm.getGranteeName();
            converter.addApplySecurityPermission(granteeName, (short)perm.getGranteeType(), perm.getAccess(), (short)perm.getAccessType());
        }
        this.SIDAndNameConverter(converter, 2);
    }

    private void SIDAndNameConverter(PublishTemplateContentConverter converter, int nConvertFlag) {
        int nPermCount = converter.getApplySecurityPermissionCount();
        if (nPermCount > 0) {
            for (int i = 0; i < nPermCount; ++i) {
                SecurityGrantee sg;
                short nGranteeType = converter.getApplySecurityPermissionGranteeType(i);
                if (nConvertFlag == 2) {
                    String strGranteeName = converter.getApplySecurityPermissionGranteeName(i);
                    sg = null;
                    String strSID = "";
                    if (strGranteeName.compareTo("#CREATOR-OWNER") == 0 && nGranteeType == 2000) {
                        converter.setApplySecurityPermissionSID("S-1-3-0", i);
                        continue;
                    }
                    if (strGranteeName.compareTo("#AUTHENTICATED-USERS") == 0 && nGranteeType == 2001) {
                        converter.setApplySecurityPermissionSID("S-1-5-11", i);
                        continue;
                    }
                    try {
                        sg = ObjectFactory.getGrantee((String)strGranteeName, (int)nGranteeType, (Session)this.controller.getSession());
                        if (sg != null) {
                            if (nGranteeType == 2000) {
                                User user = (User)sg;
                                strSID = user.getPropertyStringValue("Id");
                            } else if (nGranteeType == 2001) {
                                Group grp = (Group)sg;
                                strSID = grp.getPropertyStringValue("Id");
                            }
                            converter.setApplySecurityPermissionSID(strSID, i);
                            continue;
                        }
                        converter.setApplySecurityPermissionSID("", i);
                    }
                    catch (Exception e) {
                        converter.setApplySecurityPermissionSID("", i);
                    }
                    continue;
                }
                if (nConvertFlag != 1) continue;
                String strSID = converter.getApplySecurityPermissionSID(i);
                if (strSID.compareTo("S-1-3-0") == 0 && nGranteeType == 2000) {
                    converter.setApplySecurityPermissionGranteeName("#CREATOR-OWNER", i);
                    continue;
                }
                if (strSID.compareTo("S-1-5-11") == 0 && nGranteeType == 2001) {
                    converter.setApplySecurityPermissionGranteeName("#AUTHENTICATED-USERS", i);
                    continue;
                }
                sg = null;
                try {
                    sg = ObjectFactory.getGrantee((String)strSID, (int)nGranteeType, (Session)this.controller.getSession());
                    if (sg != null) {
                        converter.setApplySecurityPermissionGranteeName(sg.getName(), i);
                        continue;
                    }
                    converter.setApplySecurityPermissionGranteeName("", i);
                    continue;
                }
                catch (Exception e) {
                    converter.setApplySecurityPermissionGranteeName("", i);
                }
            }
        }
    }

    boolean validateObjectStoreChangingTo(VerboseLibrary vlib) {
        boolean valid = true;
        try {
            vlib.getDocumentClassDescriptionFromId("{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = ex.getLocalizedMessage();
            if (msg != null && msg.length() > 0) {
                WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), msg, PublishAuthResource.s_publishAuthTitle);
            }
            valid = false;
        }
        return valid;
    }

    public void actionPerformed(ActionEvent event) {
        Object evtSrc = event.getSource();
        if (evtSrc == this.optionUseDestFolderBtn || evtSrc == this.optionUseSourceDocBtn || evtSrc == this.optionUseDefaultBtn || evtSrc == this.optionSpecifySecurityBtn || evtSrc == this.securityPolicyChk || evtSrc == this.securityPermissionsChk) {
            this.fireModified();
            this.configureComponents();
            if (evtSrc == this.securityPermissionsChk || evtSrc == this.securityPolicyChk) {
                this.checkPreserveDirectPerms();
            }
        } else if (evtSrc == this.securityPolicyComboBox && this.securityPolicyModel != null && this.securityPolicyModel.getSelectedItem() != null) {
            this.currentSecPolicy = (SecurityPolicy)this.securityPolicyModel.getSelectedItem();
            this.checkPreserveDirectPerms();
        }
    }

    public void dataChanged(PublishAuthDataEvent e) {
        if (e.getSource() == this.data) {
            this.tempTrace("SecurityToApplyPanel.dataChanged() called for data");
            int changeType = e.getType();
            if (changeType == 0) {
                if (this.securityPanel != null) {
                    this.securityPanel.clearModified();
                }
            } else {
                if ((changeType & 0x10) != 0) {
                    if (this.data.getLibrary() != null) {
                        if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(this.data.getLibrary().getId()) != 0) {
                            this.invalidateCurrentLibrary();
                        }
                    } else {
                        this.invalidateCurrentLibrary();
                    }
                    if (this.currentLibrary == null) {
                        this.setButtonSelectedDisarmModifiedFire(this.optionUseDestFolderBtn, true);
                    }
                }
                if ((changeType & 4) != 0 && this.data.getApplyPropsClassDesc() != null && this.securityPanel != null && !this.securityPanel.isModified() && this.defaultSecurityClassDesc != null && this.defaultSecurityClassDesc.getId().compareToIgnoreCase(this.data.getApplyPropsClassDesc().getId()) != 0) {
                    this.removeSecurityPanel();
                }
                try {
                    if ((changeType & 0x10) != 0 && this.currentLibrary == null && this.data.getLibrary() != null) {
                        this.currentLibrary = this.data.getLibrary();
                    }
                    if (this.currentLibrary != null && this.securityPanel == null) {
                        this.defaultSecurityClassDesc = this.data.getApplyPropsClassDesc() != null ? this.data.getApplyPropsClassDesc() : this.currentLibrary.getDocumentClassDescriptionFromId("{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}");
                        this.loadSecurityPanel(null);
                    }
                }
                catch (Exception ex) {
                    WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
                    ex.printStackTrace();
                }
                if (this.securityPanel == null) {
                    if (this.securityPlaceHolderComponent.getParent() != this) {
                        this.loadSecurityPlaceHolderComponent();
                    }
                    if (this.optionSpecifySecurityBtn.isSelected()) {
                        this.setButtonSelectedDisarmModifiedFire(this.optionUseDestFolderBtn, true);
                    }
                }
                this.configureComponents();
            }
        }
    }

    protected PublishAuthData getData() {
        return this.data;
    }

    boolean canSwitchFrom() {
        boolean successful = true;
        if (this.optionSpecifySecurityBtn.isSelected()) {
            boolean bl = successful = this.securityPolicyChk.isSelected() && this.securityPolicyComboBox.getSelectedItem() != null;
            if (!successful) {
                successful = this.securityPermissionsChk.isSelected();
            }
            if (!successful) {
                WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), PublishAuthResource.s_errorSecuritySelected, PublishAuthResource.s_publishAuthTitle);
                Frame parentFrame = this.controller.getParentFrame();
                if (parentFrame != null) {
                    parentFrame.requestFocus();
                }
            }
        }
        return successful;
    }

    boolean canSwitchTo() {
        return true;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JComponent directionsFld = PublishAuthUtil.createInstructionsText(WcmStringUtil.concatenateStrings(PublishAuthResource.s_securityToApplyTabDirectionsLabel));
        directionsFld.setBackground(this.getBackground());
        this.applySecurityOptionsBtnGroup = new ButtonGroup();
        this.optionUseDestFolderBtn = new JRadioButton();
        this.optionUseDestFolderBtn.setText(PublishAuthResource.s_applySecurityUsingDestFolderLabel);
        this.optionUseDestFolderBtn.addActionListener(this);
        Insets margin = this.optionUseDestFolderBtn.getMargin();
        this.optionUseDestFolderBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.applySecurityOptionsBtnGroup.add(this.optionUseDestFolderBtn);
        this.optionUseSourceDocBtn = new JRadioButton();
        this.optionUseSourceDocBtn.setText(PublishAuthResource.s_applySecurityUsingSourceDocLabel);
        this.optionUseSourceDocBtn.addActionListener(this);
        margin = this.optionUseSourceDocBtn.getMargin();
        this.optionUseSourceDocBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.applySecurityOptionsBtnGroup.add(this.optionUseSourceDocBtn);
        this.optionUseDefaultBtn = new JRadioButton();
        this.optionUseDefaultBtn.setText(PublishAuthResource.s_applySecurityUsingDefaultLabel);
        this.optionUseDefaultBtn.addActionListener(this);
        margin = this.optionUseDefaultBtn.getMargin();
        this.optionUseDefaultBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.applySecurityOptionsBtnGroup.add(this.optionUseDefaultBtn);
        this.specifySecurityButtonModel = new SpecifySecurityButtonModel();
        this.optionSpecifySecurityBtn = new JRadioButton();
        this.optionSpecifySecurityBtn.setModel(this.specifySecurityButtonModel);
        this.optionSpecifySecurityBtn.setText(PublishAuthResource.s_applySecurityAsSpecifiedLabel);
        this.optionSpecifySecurityBtn.addActionListener(this);
        margin = this.optionSpecifySecurityBtn.getMargin();
        this.optionSpecifySecurityBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.applySecurityOptionsBtnGroup.add(this.optionSpecifySecurityBtn);
        this.securityPolicyChk = new JCheckBox();
        this.securityPolicyChk.setText(PublishAuthResource.s_applySecurityUsingSecurityPolicyLabel);
        Color tmpColor = new Color(102, 102, 153);
        this.securityPolicyChk.setForeground(tmpColor);
        this.securityPolicyChk.addActionListener(this);
        this.securityPermissionsChk = new JCheckBox();
        this.securityPermissionsChk.setForeground(tmpColor);
        this.securityPermissionsChk.setText(PublishAuthResource.s_applySecurityUsingSecurityPermsLabel);
        this.securityPermissionsChk.addActionListener(this);
        this.securityPolicyComboBox = new JComboBox();
        this.securityPolicyComboBox.setRenderer(new SecurityPolicyComboBoxRenderer());
        this.securityPolicyComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.securityPolicyComboBox.setEditable(false);
        this.securityPolicyComboBox.addActionListener(this);
        JLabel secPlaceholderLbl = new JLabel();
        secPlaceholderLbl.setBackground(Color.lightGray);
        secPlaceholderLbl.setOpaque(true);
        secPlaceholderLbl.setHorizontalAlignment(0);
        secPlaceholderLbl.setText("Error initializing the security UI");
        this.securityPlaceHolderComponent = new JPanel();
        this.securityPlaceHolderComponent.setLayout(new BorderLayout());
        this.securityPlaceHolderComponent.add((Component)secPlaceholderLbl, "Center");
        this.add((Component)directionsFld, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 0, 16), 0, 0));
        this.add((Component)this.optionUseDestFolderBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 16, 0, 16), 0, 0));
        this.add((Component)this.optionUseSourceDocBtn, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 16), 0, 0));
        this.add((Component)this.optionUseDefaultBtn, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 16), 0, 0));
        this.add((Component)this.optionSpecifySecurityBtn, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 16), 0, 0));
        this.add((Component)this.securityPolicyChk, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 16), 0, 0));
        this.add((Component)this.securityPolicyComboBox, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 80, 0, 16), 0, 0));
        this.add((Component)this.securityPermissionsChk, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 16), 0, 0));
        this.add((Component)this.securityPlaceHolderComponent, new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 40, 16, 16), 0, 0));
    }

    private void configureComponents() {
        boolean selected = this.optionSpecifySecurityBtn.isSelected();
        this.securityPolicyChk.setEnabled(selected);
        this.securityPermissionsChk.setEnabled(selected);
        if (selected) {
            this.securityPolicyComboBox.setEnabled(this.securityPolicyChk.isSelected());
            this.securityPanel.setEnabled(this.securityPermissionsChk.isSelected());
            if (this.securityPolicyChk.isSelected()) {
                this.loadSecurityPolicy();
            }
        } else {
            this.securityPolicyComboBox.setEnabled(selected);
            if (this.securityPanel != null) {
                this.securityPanel.setEnabled(selected);
            }
        }
    }

    private void checkPreserveDirectPerms() {
        SecurityPolicy secPolicy;
        if (this.securityPolicyChk.isSelected() && this.securityPermissionsChk.isSelected() && (secPolicy = (SecurityPolicy)this.securityPolicyModel.getSelectedItem()) != null) {
            try {
                Property prop;
                Properties props = secPolicy.getProperties(new String[]{"PreserveDirectPermissions"});
                if (props.size() == 1 && !(prop = (Property)props.get(0)).getBooleanValue()) {
                    JOptionPane.showMessageDialog(this.controller.getParentFrame(), PublishAuthResource.s_errorSecurityMismatched, PublishAuthResource.s_publishAuthTitle, -1);
                }
            }
            catch (Exception ex) {
                System.out.println("SecurityToApplyPanel:checkPreserveDirectPerms" + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void invalidateCurrentLibrary() {
        this.currentLibrary = null;
        this.currentSecPolicy = null;
        this.securityPolicyComboBox.removeAllItems();
        this.securityPolicyModel = null;
        this.removeSecurityPanel();
    }

    private void invalidateSecurityPolicy() {
        this.currentSecPolicy = null;
        this.securityPolicyChk.setSelected(false);
    }

    private void removeSecurityPanel() {
        if (this.securityPanel != null) {
            this.remove(this.securityPanel);
            this.securityPanel = null;
            this.initialPermissions = null;
            this.initialReservationPerms = null;
        }
        this.defaultSecurityClassDesc = null;
        this.securityPermissionsChk.setSelected(false);
    }

    private void loadSecurityPanel(Permissions perms) throws Exception {
        if (perms == null) {
            perms = this.defaultSecurityClassDesc.getClassDescription().getDefaultPermissions();
        }
        List customGroupList = null;
        WcmSecurityPanel tempSecurityPanel = new WcmSecurityPanel((Window)this.controller.getParentFrame(), this.controller.getSession(), perms, customGroupList, 1, false);
        tempSecurityPanel.setSitePrefs(this.controller.getSitePreferences());
        tempSecurityPanel.showCreatorOwner();
        if (this.securityPlaceHolderComponent.getParent() == this) {
            this.remove(this.securityPlaceHolderComponent);
        }
        this.add((Component)tempSecurityPanel, new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 40, 16, 16), 0, 0));
        this.securityPanel = tempSecurityPanel;
        this.initialPermissions = perms;
        this.creatorOwnerFromGroups = "#CREATOR-OWNER";
    }

    private void loadSecurityPlaceHolderComponent() {
        this.add((Component)this.securityPlaceHolderComponent, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 40, 16, 16), 0, 0));
    }

    private void loadSecurityPolicy() {
        int i;
        SecurityPolicy secPolicy;
        if (this.securityPolicyModel == null) {
            DefaultComboBoxModel<SecurityPolicy> tempModel = new DefaultComboBoxModel<SecurityPolicy>();
            SecurityPolicies secPolicies = this.currentLibrary.getLibrary().getSecurityPolicies();
            try {
                PropertyUtil.sort(secPolicies);
            }
            catch (Exception ex) {
                System.out.println("SecurityToApplyPanel:loadSecurityPolicy" + ex.getMessage());
                ex.printStackTrace();
            }
            secPolicy = null;
            for (i = 0; i < secPolicies.size(); ++i) {
                secPolicy = (SecurityPolicy)secPolicies.get(i);
                tempModel.addElement(secPolicy);
            }
            this.securityPolicyComboBox.setModel(tempModel);
            this.securityPolicyModel = tempModel;
        }
        if (this.securityPolicyModel != null) {
            SecurityPolicy modelInfo = null;
            if (this.currentSecPolicy != null) {
                int tolItems = this.securityPolicyModel.getSize();
                secPolicy = null;
                for (i = 0; i < tolItems; ++i) {
                    secPolicy = (SecurityPolicy)this.securityPolicyModel.getElementAt(i);
                    if (WcmString.compareIgnoreCase(secPolicy.getId(), this.currentSecPolicy.getId()) != 0) continue;
                    modelInfo = secPolicy;
                    break;
                }
            }
            this.securityPolicyModel.setSelectedItem(modelInfo);
        }
    }

    private class SecurityPolicyComboBoxRenderer
    extends DefaultListCellRenderer {
        private SecurityPolicyComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof SecurityPolicy) {
                SecurityPolicy secPolicy = (SecurityPolicy)value;
                this.setText(secPolicy.getName());
            }
            return this;
        }
    }

    private class SpecifySecurityButtonModel
    extends JToggleButton.ToggleButtonModel {
        private SpecifySecurityButtonModel() {
        }

        public void setSelected(boolean selected) {
            boolean canSelect = true;
            if (selected && !this.isSelected() && SecurityToApplyPanel.this.securityPanel == null) {
                canSelect = false;
            }
            if (canSelect) {
                super.setSelected(selected);
            }
        }

        public void setSelectedDirect(boolean selected) {
            SecurityToApplyPanel.this.tempTrace("SpecifySecurityButtonModel.setSelectedDirect() called");
            SecurityToApplyPanel.this.disarmModifiedFire();
            super.setSelected(selected);
            SecurityToApplyPanel.this.armModifiedFire();
            SecurityToApplyPanel.this.tempTrace("setSelectedDirect() exit");
        }
    }
}

