/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.api.EventAction;
import com.filenet.wcm.apps.client.publish.PublishTemplateContentConverter;
import com.filenet.wcm.apps.client.publish.ui.ChooseEventActionDlg;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthController;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthData;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataEvent;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataListener;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthPanel;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthResource;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthUtil;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class RepublishInstructionsPanel
extends PublishAuthPanel
implements ActionListener,
PublishAuthDataListener {
    private PublishAuthController controller;
    private PublishAuthData data;
    private ButtonGroup repubVersionableDocOptionsBtnGroup;
    private JRadioButton optionVersionAndKeepBtn;
    private JRadioButton optionVersionAndRemoveBtn;
    private JRadioButton optionVersAddAndKeepBtn;
    private JRadioButton optionVersAddAndRemoveBtn;
    private ButtonGroup repubNonVersionableDocOptionsBtnGroup;
    private JRadioButton optionNonVersAddAndKeepBtn;
    private JRadioButton optionNonVersAddAndRemoveBtn;
    private ButtonGroup repubApplyPropsOptionsBtnGroup;
    private JRadioButton optionApplyPropsUsingDestDocBtn;
    private JRadioButton optionApplyPropsUsingPubInstrBtn;
    private ButtonGroup repubApplySecOptionsBtnGroup;
    private JRadioButton optionApplySecUsingDestDocBtn;
    private JRadioButton optionApplySecUsingPubInstrBtn;
    private ButtonGroup repubEventActionOptionsBtnGroup;
    private JRadioButton optionRepubEventActionFromPubBtn;
    private JRadioButton optionRepubEventActionNoneBtn;
    private JRadioButton optionRepubEventActionBtn;
    private JPanel eventActionPanel;
    private JTextField eventActionText;
    private JButton eventActionBrowseBtn;
    private UseEventActionButtonModel useEventActionButtonModel;
    private List eventActions;
    private EventAction selectedEventAction;
    private VerboseLibrary currentLibrary;

    RepublishInstructionsPanel(PublishAuthController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private RepublishInstructionsPanel() {
    }

    void setData(PublishAuthData data) {
        this.tempTrace("RepublishInstructionsPanel.setData() called");
        if (data.getLibrary() != null) {
            if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(data.getLibrary().getId()) != 0) {
                this.invalidateCurrentLibrary();
            }
        } else {
            this.invalidateCurrentLibrary();
        }
        if (data.getRepublishEventAction() != null) {
            if (this.selectedEventAction != null && WcmString.compareIgnoreCase(this.selectedEventAction.getName(), data.getRepublishEventAction().getName()) != 0) {
                this.invalidateSelectedEventAction();
            }
        } else {
            this.invalidateSelectedEventAction();
        }
        if (this.currentLibrary == null && data.getLibrary() != null) {
            this.currentLibrary = data.getLibrary();
        }
        if (this.selectedEventAction == null && data.getRepublishEventAction() != null) {
            this.selectedEventAction = data.getRepublishEventAction();
        }
        PublishTemplateContentConverter converter = data.getContentConverter();
        if (converter.getVersionableRepublishType() == 0) {
            this.setButtonSelectedDisarmModifiedFire(this.optionVersionAndKeepBtn, true);
        } else if (converter.getVersionableRepublishType() == 1) {
            this.setButtonSelectedDisarmModifiedFire(this.optionVersionAndRemoveBtn, true);
        } else if (converter.getVersionableRepublishType() == 2) {
            this.setButtonSelectedDisarmModifiedFire(this.optionVersAddAndKeepBtn, true);
        } else if (converter.getVersionableRepublishType() == 3) {
            this.setButtonSelectedDisarmModifiedFire(this.optionVersAddAndRemoveBtn, true);
        }
        if (converter.getNonversionableRepublishType() == 2) {
            this.setButtonSelectedDisarmModifiedFire(this.optionNonVersAddAndKeepBtn, true);
        } else if (converter.getNonversionableRepublishType() == 3) {
            this.setButtonSelectedDisarmModifiedFire(this.optionNonVersAddAndRemoveBtn, true);
        }
        if (converter.getRepublishApplyPropertiesFrom() == 3) {
            this.setButtonSelectedDisarmModifiedFire(this.optionApplyPropsUsingDestDocBtn, true);
        } else if (converter.getRepublishApplyPropertiesFrom() == 5) {
            this.setButtonSelectedDisarmModifiedFire(this.optionApplyPropsUsingPubInstrBtn, true);
        }
        if (converter.getRepublishApplySecurityFrom() == 3) {
            this.setButtonSelectedDisarmModifiedFire(this.optionApplySecUsingDestDocBtn, true);
        } else if (converter.getRepublishApplySecurityFrom() == 5) {
            this.setButtonSelectedDisarmModifiedFire(this.optionApplySecUsingPubInstrBtn, true);
        }
        if (converter.getRepublishEventActionFrom() == 0) {
            this.setButtonSelectedDisarmModifiedFire(this.optionRepubEventActionFromPubBtn, true);
        } else if (converter.getRepublishEventActionFrom() == 2) {
            this.setButtonSelectedDisarmModifiedFire(this.optionRepubEventActionBtn, true);
        } else if (converter.getRepublishEventActionFrom() == 1) {
            this.setButtonSelectedDisarmModifiedFire(this.optionRepubEventActionNoneBtn, true);
        }
        if (this.data != null) {
            this.data.removePublishAuthDataListener(this);
        }
        data.addPublishAuthDataListener(this);
        this.data = data;
        this.configureComponents();
    }

    public boolean applyChanges() {
        this.tempTrace("RepublishInstructionsPanel.applyChanges() called.");
        boolean successful = true;
        PublishTemplateContentConverter converter = this.data.getContentConverter();
        if (this.optionVersionAndKeepBtn.isSelected()) {
            converter.setVersionableRepublishType((short)0);
        } else if (this.optionVersionAndRemoveBtn.isSelected()) {
            converter.setVersionableRepublishType((short)1);
        } else if (this.optionVersAddAndKeepBtn.isSelected()) {
            converter.setVersionableRepublishType((short)2);
        } else if (this.optionVersAddAndRemoveBtn.isSelected()) {
            converter.setVersionableRepublishType((short)3);
        }
        if (this.optionNonVersAddAndKeepBtn.isSelected()) {
            converter.setNonversionableRepublishType((short)2);
        } else if (this.optionNonVersAddAndRemoveBtn.isSelected()) {
            converter.setNonversionableRepublishType((short)3);
        }
        if (this.optionApplyPropsUsingDestDocBtn.isSelected()) {
            converter.setRepublishApplyPropertiesFrom((short)3);
        } else if (this.optionApplyPropsUsingPubInstrBtn.isSelected()) {
            converter.setRepublishApplyPropertiesFrom((short)5);
        }
        if (this.optionApplySecUsingDestDocBtn.isSelected()) {
            converter.setRepublishApplySecurityFrom((short)3);
        } else if (this.optionApplySecUsingPubInstrBtn.isSelected()) {
            converter.setRepublishApplySecurityFrom((short)5);
        }
        if (this.optionRepubEventActionFromPubBtn.isSelected()) {
            converter.setRepublishEventActionFrom((short)0);
            converter.setRepubEventActionClassKey(null, false);
        } else if (this.optionRepubEventActionNoneBtn.isSelected()) {
            converter.setRepublishEventActionFrom((short)1);
            converter.setRepubEventActionClassKey("", true);
        } else if (this.optionRepubEventActionBtn.isSelected()) {
            converter.setRepublishEventActionFrom((short)2);
            if (!converter.getRepubEventActionClassKey(null).isNameOrId) {
                converter.setRepubEventActionClassKey(this.selectedEventAction.getId(), false);
            } else {
                converter.setRepubEventActionClassKey(this.selectedEventAction.getName(), true);
            }
            if (this.selectedEventAction != null) {
                this.data.setRepublishEventAction(this.selectedEventAction);
            } else {
                this.data.setRepublishEventAction(null);
            }
        }
        return successful;
    }

    public void actionPerformed(ActionEvent event) {
        Object evtSrc = event.getSource();
        if (evtSrc == this.optionVersionAndKeepBtn || evtSrc == this.optionVersionAndRemoveBtn || evtSrc == this.optionVersAddAndKeepBtn || evtSrc == this.optionVersAddAndRemoveBtn || evtSrc == this.optionNonVersAddAndKeepBtn || evtSrc == this.optionNonVersAddAndRemoveBtn || evtSrc == this.optionApplyPropsUsingDestDocBtn || evtSrc == this.optionApplyPropsUsingPubInstrBtn || evtSrc == this.optionApplySecUsingDestDocBtn || evtSrc == this.optionApplySecUsingPubInstrBtn || evtSrc == this.optionRepubEventActionBtn || evtSrc == this.optionRepubEventActionFromPubBtn || evtSrc == this.optionRepubEventActionNoneBtn) {
            this.fireModified();
            this.configureComponents();
        } else if (evtSrc == this.eventActionBrowseBtn) {
            this.performChooseEventAction();
        }
        Frame parentFrame = this.controller.getParentFrame();
        if (parentFrame != null) {
            parentFrame.requestFocus();
        }
    }

    private void performChooseEventAction() {
        this.eventActions = this.data.getEventActions();
        if (this.eventActions != null && this.eventActions.size() > 0) {
            ChooseEventActionDlg dlg = new ChooseEventActionDlg(this.controller.getParentFrame(), PublishAuthResource.s_chooseEventActionTitle, this.eventActions);
            dlg.show();
            if (dlg.getStatus() == 0) {
                this.selectedEventAction = dlg.getEventAction();
                if (!this.useEventActionButtonModel.isSelected()) {
                    this.useEventActionButtonModel.setSelectedDirect(true);
                }
                this.data.setRepublishEventAction(this.selectedEventAction);
                this.configureComponents();
                this.fireModified();
            }
        } else {
            this.eventActionBrowseBtn.setEnabled(false);
            JOptionPane.showMessageDialog(this.controller.getParentFrame(), PublishAuthResource.s_noEventActionsMsg, PublishAuthResource.s_publishAuthTitle, 0);
        }
    }

    private void configureComponents() {
        if (this.optionRepubEventActionBtn.isSelected()) {
            this.eventActionBrowseBtn.setEnabled(true);
            if (this.selectedEventAction != null) {
                this.eventActionText.setText(this.selectedEventAction.getName());
                this.eventActionText.setCaretPosition(0);
            } else {
                this.eventActionText.setText("");
            }
        } else {
            this.eventActionBrowseBtn.setEnabled(false);
        }
    }

    public void dataChanged(PublishAuthDataEvent e) {
        if (e.getSource() == this.data) {
            if ((e.getType() & 0x10) != 0) {
                if (this.data.getLibrary() != null) {
                    if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(this.data.getLibrary().getId()) != 0) {
                        this.invalidateCurrentLibrary();
                    }
                } else {
                    this.invalidateCurrentLibrary();
                }
                if (this.currentLibrary == null) {
                    this.setButtonSelectedDisarmModifiedFire(this.optionRepubEventActionFromPubBtn, true);
                }
                if (this.currentLibrary == null && this.data.getLibrary() != null) {
                    this.currentLibrary = this.data.getLibrary();
                }
            }
            this.configureComponents();
        }
    }

    protected PublishAuthData getData() {
        return this.data;
    }

    private void initComponents() {
        this.tempTrace("Entering initComponents");
        this.setLayout(new GridBagLayout());
        JComponent directionsFld = PublishAuthUtil.createInstructionsText(PublishAuthResource.s_republishInstructionsTabDirectionsLabel);
        directionsFld.setBackground(this.getBackground());
        JPanel repubVersionableOptionsHeader = PublishAuthUtil.createHeaderPanel(PublishAuthResource.s_republishVersionableDocLabel);
        this.repubVersionableDocOptionsBtnGroup = new ButtonGroup();
        this.optionVersionAndKeepBtn = new JRadioButton();
        this.optionVersionAndKeepBtn.setText(PublishAuthResource.s_versionAndKeepLabel);
        this.optionVersionAndKeepBtn.addActionListener(this);
        Insets margin = this.optionVersionAndKeepBtn.getMargin();
        this.optionVersionAndKeepBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubVersionableDocOptionsBtnGroup.add(this.optionVersionAndKeepBtn);
        this.optionVersionAndRemoveBtn = new JRadioButton();
        this.optionVersionAndRemoveBtn.setText(PublishAuthResource.s_versionAndRemoveLabel);
        this.optionVersionAndRemoveBtn.addActionListener(this);
        margin = this.optionVersionAndRemoveBtn.getMargin();
        this.optionVersionAndRemoveBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubVersionableDocOptionsBtnGroup.add(this.optionVersionAndRemoveBtn);
        this.optionVersAddAndKeepBtn = new JRadioButton();
        this.optionVersAddAndKeepBtn.setText(PublishAuthResource.s_addAndKeepVersionLabel);
        this.optionVersAddAndKeepBtn.addActionListener(this);
        margin = this.optionVersAddAndKeepBtn.getMargin();
        this.optionVersAddAndKeepBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubVersionableDocOptionsBtnGroup.add(this.optionVersAddAndKeepBtn);
        this.optionVersAddAndRemoveBtn = new JRadioButton();
        this.optionVersAddAndRemoveBtn.setText(PublishAuthResource.s_addAndRemoveVersionLabel);
        this.optionVersAddAndRemoveBtn.addActionListener(this);
        margin = this.optionVersAddAndRemoveBtn.getMargin();
        this.optionVersAddAndRemoveBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubVersionableDocOptionsBtnGroup.add(this.optionVersAddAndRemoveBtn);
        JPanel repubNonVersionableOptionsHeader = PublishAuthUtil.createHeaderPanel(PublishAuthResource.s_republishNonVersionableDocLabel);
        this.repubNonVersionableDocOptionsBtnGroup = new ButtonGroup();
        this.optionNonVersAddAndKeepBtn = new JRadioButton();
        this.optionNonVersAddAndKeepBtn.setText(PublishAuthResource.s_nonVersAddAndKeepLabel);
        this.optionNonVersAddAndKeepBtn.addActionListener(this);
        margin = this.optionNonVersAddAndKeepBtn.getMargin();
        this.optionNonVersAddAndKeepBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubNonVersionableDocOptionsBtnGroup.add(this.optionNonVersAddAndKeepBtn);
        this.optionNonVersAddAndRemoveBtn = new JRadioButton();
        this.optionNonVersAddAndRemoveBtn.setText(PublishAuthResource.s_nonVersAddAndRemoveLabel);
        this.optionNonVersAddAndRemoveBtn.addActionListener(this);
        margin = this.optionNonVersAddAndRemoveBtn.getMargin();
        this.optionNonVersAddAndRemoveBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubNonVersionableDocOptionsBtnGroup.add(this.optionNonVersAddAndRemoveBtn);
        JPanel repubApplyPropsOptionsHeader = PublishAuthUtil.createHeaderPanel(PublishAuthResource.s_republishApplyPropsLabel);
        this.repubApplyPropsOptionsBtnGroup = new ButtonGroup();
        this.optionApplyPropsUsingDestDocBtn = new JRadioButton();
        this.optionApplyPropsUsingDestDocBtn.setText(PublishAuthResource.s_republishApplyPropsUsingDestDocLabel);
        this.optionApplyPropsUsingDestDocBtn.addActionListener(this);
        margin = this.optionApplyPropsUsingDestDocBtn.getMargin();
        this.optionApplyPropsUsingDestDocBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubApplyPropsOptionsBtnGroup.add(this.optionApplyPropsUsingDestDocBtn);
        this.optionApplyPropsUsingPubInstrBtn = new JRadioButton();
        this.optionApplyPropsUsingPubInstrBtn.setText(PublishAuthResource.s_republishApplyPropsUsingSameAsPublishLabel);
        this.optionApplyPropsUsingPubInstrBtn.addActionListener(this);
        margin = this.optionApplyPropsUsingPubInstrBtn.getMargin();
        this.optionApplyPropsUsingPubInstrBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubApplyPropsOptionsBtnGroup.add(this.optionApplyPropsUsingPubInstrBtn);
        JPanel repubApplySecurityOptionsHeader = PublishAuthUtil.createHeaderPanel(PublishAuthResource.s_republishApplySecurityLabel);
        this.repubApplySecOptionsBtnGroup = new ButtonGroup();
        this.optionApplySecUsingDestDocBtn = new JRadioButton();
        this.optionApplySecUsingDestDocBtn.setText(PublishAuthResource.s_republishApplySecurityUsingDestDocLabel);
        this.optionApplySecUsingDestDocBtn.addActionListener(this);
        margin = this.optionApplySecUsingDestDocBtn.getMargin();
        this.optionApplySecUsingDestDocBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubApplySecOptionsBtnGroup.add(this.optionApplySecUsingDestDocBtn);
        this.optionApplySecUsingPubInstrBtn = new JRadioButton();
        this.optionApplySecUsingPubInstrBtn.setText(PublishAuthResource.s_republishApplySecurityUsingSameAsPublishLabel);
        this.optionApplySecUsingPubInstrBtn.addActionListener(this);
        margin = this.optionApplySecUsingPubInstrBtn.getMargin();
        this.optionApplySecUsingPubInstrBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubApplySecOptionsBtnGroup.add(this.optionApplySecUsingPubInstrBtn);
        JPanel repubEvtActNameOptionsHeader = PublishAuthUtil.createHeaderPanel(PublishAuthResource.s_republishEventNotificationLabel);
        this.repubEventActionOptionsBtnGroup = new ButtonGroup();
        this.optionRepubEventActionFromPubBtn = new JRadioButton();
        this.optionRepubEventActionFromPubBtn.setText(PublishAuthResource.s_republishEventActionSameAsPublishLabel);
        this.optionRepubEventActionFromPubBtn.addActionListener(this);
        margin = this.optionRepubEventActionFromPubBtn.getMargin();
        this.optionRepubEventActionFromPubBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubEventActionOptionsBtnGroup.add(this.optionRepubEventActionFromPubBtn);
        this.optionRepubEventActionNoneBtn = new JRadioButton();
        this.optionRepubEventActionNoneBtn.setText(PublishAuthResource.s_republishEventActionNoneLabel);
        this.optionRepubEventActionNoneBtn.addActionListener(this);
        margin = this.optionRepubEventActionNoneBtn.getMargin();
        this.optionRepubEventActionNoneBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubEventActionOptionsBtnGroup.add(this.optionRepubEventActionNoneBtn);
        this.optionRepubEventActionBtn = new JRadioButton();
        this.useEventActionButtonModel = new UseEventActionButtonModel();
        this.optionRepubEventActionBtn.setModel(this.useEventActionButtonModel);
        this.optionRepubEventActionBtn.setText(PublishAuthResource.s_republishEventActionLabel);
        this.optionRepubEventActionBtn.addActionListener(this);
        margin = this.optionRepubEventActionBtn.getMargin();
        this.optionRepubEventActionBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.repubEventActionOptionsBtnGroup.add(this.optionRepubEventActionBtn);
        this.eventActionPanel = this.createEventActionPanel();
        this.add((Component)directionsFld, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 0, 8), 0, 0));
        this.add((Component)repubVersionableOptionsHeader, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 16, 0, 16), 0, 0));
        this.add((Component)this.optionVersionAndKeepBtn, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionVersionAndRemoveBtn, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionVersAddAndKeepBtn, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionVersAddAndRemoveBtn, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)repubNonVersionableOptionsHeader, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 16, 0, 16), 0, 0));
        this.add((Component)this.optionNonVersAddAndKeepBtn, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionNonVersAddAndRemoveBtn, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)repubApplyPropsOptionsHeader, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 16, 0, 16), 0, 0));
        this.add((Component)this.optionApplyPropsUsingDestDocBtn, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionApplyPropsUsingPubInstrBtn, new GridBagConstraints(0, 11, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)repubApplySecurityOptionsHeader, new GridBagConstraints(0, 12, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 16, 0, 16), 0, 0));
        this.add((Component)this.optionApplySecUsingDestDocBtn, new GridBagConstraints(0, 13, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionApplySecUsingPubInstrBtn, new GridBagConstraints(0, 14, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)repubEvtActNameOptionsHeader, new GridBagConstraints(0, 15, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 16, 0, 16), 0, 0));
        this.add((Component)this.optionRepubEventActionFromPubBtn, new GridBagConstraints(0, 16, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionRepubEventActionNoneBtn, new GridBagConstraints(0, 17, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.optionRepubEventActionBtn, new GridBagConstraints(0, 18, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 16), 0, 0));
        this.add((Component)this.eventActionPanel, new GridBagConstraints(0, 19, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 16), 0, 0));
        JLabel tempLabel = new JLabel();
        this.add((Component)tempLabel, new GridBagConstraints(0, 20, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tempTrace("Exiting initComponents");
    }

    private JPanel createEventActionPanel() {
        JPanel eventActionPanel = new JPanel();
        eventActionPanel.setLayout(new GridBagLayout());
        this.eventActionText = new JTextField(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.eventActionText.setEditable(false);
        this.eventActionText.setBackground(this.getBackground());
        this.eventActionText.setColumns(40);
        this.eventActionBrowseBtn = new JButton();
        this.eventActionBrowseBtn.setEnabled(false);
        this.eventActionBrowseBtn.addActionListener(this);
        this.eventActionBrowseBtn.setMargin(new Insets(0, 4, 0, 4));
        this.eventActionBrowseBtn.setText(PublishAuthResource.s_selectStyleTemplateCaption);
        this.eventActionBrowseBtn.setMnemonic(WcmStringUtil.stringToMnemonic(PublishAuthResource.s_selectMonic));
        eventActionPanel.add((Component)this.eventActionText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        eventActionPanel.add((Component)this.eventActionBrowseBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        return eventActionPanel;
    }

    private void invalidateCurrentLibrary() {
        this.currentLibrary = null;
        this.invalidateSelectedEventAction();
    }

    private void invalidateSelectedEventAction() {
        this.selectedEventAction = null;
        this.eventActionText.setText("");
    }

    private class UseEventActionButtonModel
    extends JToggleButton.ToggleButtonModel {
        private UseEventActionButtonModel() {
        }

        public void setSelected(boolean selected) {
            boolean canSelect = true;
            Frame parentFrame = RepublishInstructionsPanel.this.controller.getParentFrame();
            if (selected && !this.isSelected() && RepublishInstructionsPanel.this.selectedEventAction == null) {
                List eventActions = RepublishInstructionsPanel.this.data.getEventActions();
                if (eventActions != null && eventActions.size() > 0) {
                    ChooseEventActionDlg dlg = new ChooseEventActionDlg(parentFrame, PublishAuthResource.s_chooseEventActionTitle, eventActions);
                    dlg.show();
                    if (dlg.getStatus() == 0) {
                        RepublishInstructionsPanel.this.selectedEventAction = dlg.getEventAction();
                        super.setSelected(true);
                        canSelect = false;
                        RepublishInstructionsPanel.this.data.setRepublishEventAction(RepublishInstructionsPanel.this.selectedEventAction);
                        RepublishInstructionsPanel.this.configureComponents();
                    } else {
                        canSelect = false;
                    }
                } else {
                    canSelect = false;
                    RepublishInstructionsPanel.this.eventActionBrowseBtn.setEnabled(false);
                    JOptionPane.showMessageDialog(RepublishInstructionsPanel.this.controller.getParentFrame(), PublishAuthResource.s_noEventActionsMsg, PublishAuthResource.s_publishAuthTitle, 0);
                }
                if (parentFrame != null) {
                    parentFrame.requestFocus();
                }
            }
            if (canSelect) {
                super.setSelected(selected);
            }
        }

        void setSelectedDirect(boolean selected) {
            RepublishInstructionsPanel.this.disarmModifiedFire();
            super.setSelected(selected);
            RepublishInstructionsPanel.this.armModifiedFire();
        }
    }
}

