/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.api.BadReferenceException;
import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.EventAction;
import com.filenet.wcm.api.EventActions;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.TransportInputStream;
import com.filenet.wcm.apps.client.publish.PublishTemplateContentConverter;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataEvent;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataListener;
import com.filenet.wcm.apps.client.util.api.VerboseClassDescription;
import com.filenet.wcm.apps.client.util.api.VerboseFolder;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.apps.client.util.api.VerbosePublishTemplate;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.xml.sax.SAXException;

class PublishAuthData {
    private EventListenerList listenerList;
    private Session session;
    private WcmSitePrefs sitePreferences;
    private VerbosePublishTemplate vpubTempl;
    private PublishTemplateContentConverter contentConverter;
    private VerboseLibrary vlibrary;
    private VerboseFolder vlocationFolder;
    private VerboseClassDescription vapplyPropsClassDesc;
    private String description;
    private String title;
    private EventAction pubEventAction;
    private EventAction repubEventAction;
    private List eventActions;
    private HashMap eventActionsMapByName;
    private HashMap eventActionsMapById;
    private boolean modified;

    public PublishAuthData(Session sess, WcmSitePrefs sitePrefs, VerbosePublishTemplate vpubTempl, boolean maintainTemplate) throws BaseException, SAXException, Exception {
        String docNamePropName;
        this.commonInit(sess, sitePrefs);
        String libId = vpubTempl.getPublishTemplate().getObjectStoreId();
        ObjectStore lib = ObjectFactory.getObjectStore((String)libId, (Session)sess);
        this.vlibrary = new VerboseLibrary(lib);
        this.description = vpubTempl.getDescription();
        if (this.sitePreferences != null && (docNamePropName = this.sitePreferences.getObjectStorePrefs(lib.getName()).getDocumentNameProperty()) != null) {
            this.title = vpubTempl.getPublishTemplate().getPropertyStringValue(docNamePropName);
        }
        if (this.title == null) {
            this.title = vpubTempl.getName();
        }
        TransportInputStream stream = vpubTempl.getPublishTemplate().getContent();
        this.contentConverter = new PublishTemplateContentConverter((InputStream)stream);
        String folderId = this.contentConverter.getOutputFolderId();
        if (folderId != null) {
            Folder fold = (Folder)this.vlibrary.getLibrary().getObject(2, folderId);
            this.vlocationFolder = new VerboseFolder(fold);
        } else {
            String folderName = this.contentConverter.getOutputFolderName();
            if (folderName != null) {
                try {
                    Folder fold = (Folder)this.vlibrary.getLibrary().getObject(2, folderName);
                    this.vlocationFolder = new VerboseFolder(fold);
                }
                catch (BadReferenceException e) {
                    this.vlocationFolder = null;
                }
            }
        }
        PublishTemplateContentConverter.NameOrId classNameOrId = this.contentConverter.getApplyPropertiesClassKey(null);
        if (classNameOrId != null && classNameOrId.key != null) {
            this.vapplyPropsClassDesc = classNameOrId.isNameOrId ? this.vlibrary.getDocumentClassDescriptionFromName(classNameOrId.key) : this.vlibrary.getDocumentClassDescriptionFromId(classNameOrId.key);
        }
        if ((classNameOrId = this.contentConverter.getPubEventActionClassKey(null)) != null && classNameOrId.key != null) {
            this.pubEventAction = !classNameOrId.isNameOrId ? this.getEventActionFromId(classNameOrId.key) : this.getEventActionFromName(classNameOrId.key);
        }
        if ((classNameOrId = this.contentConverter.getRepubEventActionClassKey(null)) != null && classNameOrId.key != null) {
            this.repubEventAction = !classNameOrId.isNameOrId ? this.getEventActionFromId(classNameOrId.key) : this.getEventActionFromName(classNameOrId.key);
        }
        if (maintainTemplate) {
            this.vpubTempl = vpubTempl;
        }
    }

    public PublishAuthData(Session sess, WcmSitePrefs sitePrefs) {
        this.commonInit(sess, sitePrefs);
        this.contentConverter = new PublishTemplateContentConverter();
    }

    private PublishAuthData() {
    }

    private void commonInit(Session sess, WcmSitePrefs sitePrefs) {
        this.session = sess;
        this.sitePreferences = sitePrefs;
        this.listenerList = new EventListenerList();
    }

    public void addPublishAuthDataListener(PublishAuthDataListener listener) {
        this.listenerList.add(PublishAuthDataListener.class, listener);
    }

    public void removePublishAuthDataListener(PublishAuthDataListener listener) {
        this.listenerList.remove(PublishAuthDataListener.class, listener);
    }

    public PublishTemplateContentConverter getContentConverter() {
        return this.contentConverter;
    }

    public List getEventActions() {
        if (this.eventActions == null) {
            this.loadEventActions();
        }
        return this.eventActions;
    }

    public EventAction getEventActionFromName(String eventActionName) {
        Object index;
        if (this.eventActions == null) {
            this.loadEventActions();
        }
        if (this.eventActionsMapByName != null && this.eventActionsMapByName.size() > 0 && (index = this.eventActionsMapByName.get(eventActionName)) != null) {
            return (EventAction)this.eventActions.get((Integer)index);
        }
        return null;
    }

    public EventAction getEventActionFromId(String eventActionId) {
        Object index;
        if (this.eventActions == null) {
            this.loadEventActions();
        }
        if (this.eventActionsMapById != null && this.eventActionsMapById.size() > 0 && (index = this.eventActionsMapById.get(eventActionId)) != null) {
            return (EventAction)this.eventActions.get((Integer)index);
        }
        return null;
    }

    private List loadEventActions() {
        if (this.eventActions == null) {
            try {
                EventActions wcmEventActions = this.vlibrary.getLibrary().getEventActions();
                if (wcmEventActions != null) {
                    ArrayList<EventAction> evtActionList = new ArrayList<EventAction>(wcmEventActions.size());
                    EventAction evtAction = null;
                    HashMap<String, Integer> evtActionsMapByName = new HashMap<String, Integer>(wcmEventActions.size() + 1, 1.0f);
                    HashMap<String, Integer> evtActionsMapById = new HashMap<String, Integer>(wcmEventActions.size() + 1, 1.0f);
                    for (int i = 0; i < wcmEventActions.size(); ++i) {
                        evtAction = (EventAction)wcmEventActions.get(i);
                        evtActionList.add(evtAction);
                        evtActionsMapByName.put(evtAction.getName(), new Integer(i));
                        evtActionsMapById.put(evtAction.getId(), new Integer(i));
                    }
                    this.eventActions = evtActionList;
                    this.eventActionsMapByName = evtActionsMapByName;
                    this.eventActionsMapById = evtActionsMapById;
                }
                if (this.eventActions == null) {
                    this.eventActions = new ArrayList();
                }
            }
            catch (Exception ex) {
                System.out.println("Error " + ex.getMessage() + " event actions.");
            }
        }
        return this.eventActions;
    }

    public void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.fireEvent(1);
        }
    }

    public void clearModified() {
        this.modified = false;
        this.fireEvent(0);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setLibrary(VerboseLibrary vlib) {
        this.doNewLibrary(vlib);
        this.modified = true;
        this.fireEvent(31);
    }

    public VerboseLibrary getLibrary() {
        return this.vlibrary;
    }

    private void doNewLibrary(VerboseLibrary vlib) {
        this.vlibrary = vlib;
        this.vpubTempl = null;
        this.vapplyPropsClassDesc = null;
        this.vlocationFolder = null;
        this.pubEventAction = null;
        this.repubEventAction = null;
        this.eventActions = null;
        this.eventActionsMapByName = null;
        this.eventActionsMapById = null;
    }

    public void setPublishTemplate(VerbosePublishTemplate vpubTempl) {
        this.setPublishTemplate(vpubTempl, true);
    }

    public void setPublishTemplate(VerbosePublishTemplate vpubTempl, boolean modify) {
        this.vpubTempl = vpubTempl;
        this.description = vpubTempl.getDescription();
        this.title = null;
        if (this.sitePreferences != null) {
            try {
                String docNamePropName = this.sitePreferences.getObjectStorePrefs(this.vlibrary.getLibrary().getName()).getDocumentNameProperty();
                if (docNamePropName != null) {
                    this.title = vpubTempl.getPublishTemplate().getPropertyStringValue(docNamePropName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.title == null) {
            this.title = vpubTempl.getName();
        }
        this.modified = modify;
        this.fireEvent(3);
    }

    public VerbosePublishTemplate getPublishTemplate() {
        return this.vpubTempl;
    }

    public void setLocationFolder(VerboseFolder vfold, VerboseLibrary vlib) throws BaseException, Exception {
        if (vlib == null) {
            if (vfold.getFolder().getObjectStoreId().compareToIgnoreCase(this.vlibrary.getLibrary().getId()) != 0) {
                ObjectStore lib = ObjectFactory.getObjectStore((String)vfold.getFolder().getObjectStoreId(), (Session)this.session);
                vlib = new VerboseLibrary(lib);
            }
        } else if (this.vlibrary != null && vlib.getId().compareToIgnoreCase(this.vlibrary.getId()) == 0) {
            vlib = null;
        }
        if (vlib != null) {
            this.doNewLibrary(vlib);
        }
        this.vlocationFolder = vfold;
        this.modified = true;
        if (vlib != null) {
            this.fireEvent(31);
        } else {
            this.fireEvent(9);
        }
    }

    public VerboseFolder getLocationFolder() {
        return this.vlocationFolder;
    }

    public void setApplyPropsClassDesc(VerboseClassDescription vclassDesc) {
        this.vapplyPropsClassDesc = vclassDesc;
        this.modified = true;
        this.fireEvent(5);
    }

    public VerboseClassDescription getApplyPropsClassDesc() {
        return this.vapplyPropsClassDesc;
    }

    public void setPublishEventAction(EventAction eventAction) {
        this.pubEventAction = eventAction;
        this.modified = true;
        this.fireEvent(5);
    }

    public EventAction getPublishEventAction() {
        return this.pubEventAction;
    }

    public void setRepublishEventAction(EventAction eventAction) {
        this.repubEventAction = eventAction;
        this.modified = true;
        this.fireEvent(5);
    }

    public EventAction getRepublishEventAction() {
        return this.repubEventAction;
    }

    public void setDescription(String description) {
        this.description = description;
        this.modified = true;
        this.fireEvent(1);
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    private void fireEvent(int changeType) {
        if (this.listenerList.getListenerCount() != 0) {
            PublishAuthDataEvent e = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PublishAuthDataListener.class) continue;
                if (e == null) {
                    e = new PublishAuthDataEvent(this, changeType);
                }
                ((PublishAuthDataListener)listeners[i + 1]).dataChanged(e);
            }
        }
    }
}

