/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.publish.PublishTemplateContentConverter;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthController;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthData;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataEvent;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataListener;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthPanel;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthResource;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthUtil;
import com.filenet.wcm.apps.client.util.BooleanRef;
import com.filenet.wcm.apps.client.util.ISODateUtil;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerboseClassDescription;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.apps.client.util.api.VerboseList;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.DescribedValue;
import com.filenet.wcm.toolkit.client.ui.WcmPropertiesGridPanel;
import com.filenet.wcm.toolkit.client.ui.common.WcmNonEditableTextField;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassDescItem;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgClassTreeDialog;
import com.filenet.wcm.toolkit.client.util.WcmClassDescsDom;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertiesToApplyPanel
extends PublishAuthPanel
implements ActionListener,
PublishAuthDataListener {
    private PublishAuthController controller;
    private PublishAuthData data;
    private VerboseLibrary currentLibrary;
    private VerboseClassDescription selectedDocClassDesc;
    private JRadioButton optionUseSourceBtn;
    private SpecifyPropsButtonModel specifyPropsButtonModel;
    private JRadioButton optionSpecifyPropsBtn;
    private ButtonGroup applyPropsOptionsBtnGroup;
    private WcmNonEditableTextField classTextField;
    private JButton classBrowseButton;
    private boolean oDocIsNew = true;
    private WcmDlgClassTreeDialog browseTreeDlg;
    Document oDoc;
    private WcmPropertiesGridPanel propsGridPanel;
    private String[] filteredOutNames = new String[]{"MimeType"};

    PropertiesToApplyPanel(PublishAuthController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private PropertiesToApplyPanel() {
    }

    void setData(PublishAuthData data) {
        this.tempTrace("PropertiesToApplyPanel.setData() called");
        PublishTemplateContentConverter converter = data.getContentConverter();
        if (data.getLibrary() != null) {
            if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(data.getLibrary().getId()) != 0) {
                this.invalidateCurrentLibrary();
            }
        } else {
            this.invalidateCurrentLibrary();
        }
        if (data.getApplyPropsClassDesc() != null) {
            if (this.selectedDocClassDesc != null && this.selectedDocClassDesc.getId().compareToIgnoreCase(data.getApplyPropsClassDesc().getId()) != 0) {
                this.invalidateSelectedDocClassDesc();
            }
        } else {
            this.invalidateSelectedDocClassDesc();
        }
        if (converter.getNewPublishApplyPropertiesFrom() == 0) {
            this.propsGridPanel.clear();
            this.propsGridPanel.setMode(8 | 1 | 0x10 | 0x40);
        }
        if (this.currentLibrary == null && data.getLibrary() != null) {
            this.currentLibrary = data.getLibrary();
        }
        if (this.selectedDocClassDesc == null && data.getApplyPropsClassDesc() != null) {
            this.selectedDocClassDesc = data.getApplyPropsClassDesc();
        }
        if (converter.getNewPublishApplyPropertiesFrom() == 1 || this.selectedDocClassDesc == null) {
            this.setButtonSelectedDisarmModifiedFire(this.optionUseSourceBtn, true);
        } else {
            boolean successful = true;
            try {
                ArrayList<DescribedValue> descValList = new ArrayList<DescribedValue>();
                int propCount = converter.getApplyPropertiesCount();
                for (int iprop = 0; iprop < propCount; ++iprop) {
                    Object val;
                    String strVal;
                    PublishTemplateContentConverter.NameOrId propNameOrId = converter.getApplyPropertyKey(iprop, null);
                    VerbosePropertyDescription vpropdesc = propNameOrId.isNameOrId ? this.selectedDocClassDesc.getPropertyDescriptionFromName(propNameOrId.key) : this.selectedDocClassDesc.getPropertyDescriptionFromId(propNameOrId.key);
                    if (!converter.isApplyPropertyMultiValue(iprop)) {
                        strVal = converter.getApplyPropertyValue(iprop);
                        val = strVal != null ? this.convertValueFromText(strVal, vpropdesc.getDataType()) : null;
                    } else {
                        Values vals = ObjectFactory.getValues();
                        int mvcnt = converter.getApplyPropertyMultiValueCount(iprop);
                        for (int imv = 0; imv < mvcnt; ++imv) {
                            strVal = converter.getApplyPropertyMultiValueItem(iprop, imv);
                            Value wcmVal = ObjectFactory.getValue();
                            Object objVal = this.convertValueFromText(strVal, vpropdesc.getDataType());
                            PropertyUtil.setValueObjectValue(wcmVal, objVal);
                            vals.add((Object)wcmVal);
                        }
                        val = vals;
                    }
                    descValList.add(new DescribedValue(vpropdesc.getPropertyDescription(), val));
                }
                DescribedValue[] descVals = new DescribedValue[descValList.size()];
                for (int i = 0; i < descValList.size(); ++i) {
                    descVals[i] = (DescribedValue)descValList.get(i);
                }
                this.loadPropsGridPanel(descVals);
                if (this.selectedDocClassDesc != null) {
                    this.classTextField.setText(this.selectedDocClassDesc.getDisplayName());
                }
            }
            catch (Exception ex) {
                WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
                ex.printStackTrace();
                successful = false;
            }
            if (successful) {
                this.specifyPropsButtonModel.setSelectedDirect(true);
            } else {
                this.setButtonSelectedDisarmModifiedFire(this.optionUseSourceBtn, true);
            }
        }
        if (this.data != null) {
            this.data.removePublishAuthDataListener(this);
        }
        data.addPublishAuthDataListener(this);
        this.data = data;
        this.configureComponents();
    }

    boolean canSwitchFrom() {
        boolean successful = true;
        if (this.optionSpecifyPropsBtn.isSelected()) {
            Frame parentFrame;
            successful = this.checkClassSelected();
            if (successful) {
                successful = this.propsGridPanel.validateProperties();
            }
            if (!successful && (parentFrame = this.controller.getParentFrame()) != null) {
                parentFrame.requestFocus();
            }
        }
        return successful;
    }

    boolean canSwitchTo() {
        return true;
    }

    boolean calculateModified() {
        boolean calculatedModified = false;
        if (this.optionSpecifyPropsBtn.isSelected() && this.propsGridPanel.isPropertyValueModified()) {
            calculatedModified = true;
        }
        return calculatedModified;
    }

    public boolean applyChanges() {
        this.tempTrace("PropertiesToApplyPanel.applyChanges() called");
        boolean successful = true;
        try {
            Properties props = null;
            if (this.optionSpecifyPropsBtn.isSelected()) {
                successful = this.checkClassSelected();
                if (successful) {
                    successful = this.propsGridPanel.validateProperties();
                }
                if (successful) {
                    props = this.propsGridPanel.getProperties(1 | 8);
                }
            }
            if (successful) {
                PublishTemplateContentConverter converter = this.data.getContentConverter();
                if (this.optionUseSourceBtn.isSelected()) {
                    converter.setNewPublishApplyPropertiesFrom((short)1);
                } else {
                    converter.setNewPublishApplyPropertiesFrom((short)0);
                    converter.setApplyPropertiesClassKey(this.selectedDocClassDesc.getName(), true);
                    converter.clearApplyProperties();
                    ListIterator it = props.listIterator();
                    int propi = 0;
                    while (it.hasNext()) {
                        Property prop = (Property)it.next();
                        Object val2 = prop.getValue();
                        if (val2 != null) {
                            this.tempTrace("Value from API Property " + prop.getName() + ": " + val2.getClass().getName() + ": " + val2);
                        } else {
                            this.tempTrace("Value from API Property " + prop.getName() + " is null");
                        }
                        if (val2 != null) {
                            Values vals = null;
                            if (val2 instanceof Values) {
                                this.tempTrace("Value of " + prop.getName() + " is Values");
                                vals = (Values)val2;
                            }
                            if (vals == null) {
                                this.tempTrace("Adding single value property for " + prop.getName());
                                converter.addApplyProperty(prop.getName(), true, this.convertValueToText(val2));
                            } else {
                                this.tempTrace("Adding multi-value property for " + prop.getName());
                                converter.addMultiValueApplyProperty(prop.getName(), true);
                                for (Object val2 : vals) {
                                    converter.addApplyPropertyMultiValueItem(propi, this.convertValueToText(val2));
                                }
                            }
                        } else {
                            converter.addApplyProperty(prop.getName(), true, null);
                        }
                        ++propi;
                    }
                }
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
            successful = false;
        }
        return successful;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.optionUseSourceBtn || event.getSource() == this.optionSpecifyPropsBtn) {
            this.fireModified();
            this.configureComponents();
        } else if (event.getSource() == this.classBrowseButton) {
            this.performBrowseClassTree();
        }
        Frame parentFrame = this.controller.getParentFrame();
        if (parentFrame != null) {
            parentFrame.requestFocus();
        }
    }

    public void dataChanged(PublishAuthDataEvent e) {
        if (e.getSource() == this.data) {
            this.tempTrace("PropertiesToApplyPanel.dataChanged() called for data");
            int changeType = e.getType();
            if (changeType == 0) {
                if (this.propsGridPanel != null) {
                    this.propsGridPanel.clearModified();
                }
            } else {
                if ((changeType & 0x10) != 0) {
                    if (this.data.getLibrary() != null) {
                        if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(this.data.getLibrary().getId()) != 0) {
                            this.invalidateCurrentLibrary();
                        }
                    } else {
                        this.invalidateCurrentLibrary();
                    }
                    if (this.currentLibrary == null) {
                        this.setButtonSelectedDisarmModifiedFire(this.optionUseSourceBtn, true);
                    }
                    if (this.currentLibrary == null && this.data.getLibrary() != null) {
                        this.currentLibrary = this.data.getLibrary();
                    }
                }
                this.configureComponents();
            }
        }
    }

    protected PublishAuthData getData() {
        return this.data;
    }

    private String convertValueToText(Object val) {
        String str = null;
        if (val instanceof Value) {
            val = ((Value)val).getValue();
        }
        if (val instanceof Date) {
            Date valDate = (Date)val;
            str = ISODateUtil.convertDateToW3CDate(valDate, false);
        } else if (val != null) {
            str = val.toString();
        }
        return str;
    }

    private Object convertValueFromText(String strVal, int dataType) throws WcmException {
        Object val;
        switch (dataType) {
            case 8: {
                val = strVal;
                break;
            }
            case 6: {
                val = PropertyUtil.getInteger(strVal);
                break;
            }
            case 4: {
                val = PropertyUtil.getDouble(strVal);
                break;
            }
            case 2: {
                val = PropertyUtil.getBoolean(strVal);
                break;
            }
            case 3: {
                Date dateVal = null;
                try {
                    BooleanRef isDateOnly = new BooleanRef();
                    dateVal = ISODateUtil.convertW3CDateToDate(strVal, isDateOnly);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (dateVal == null) {
                    try {
                        dateVal = ISODateUtil.convertISODateToDate(strVal);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (dateVal == null) {
                    dateVal = PropertyUtil.getDate(strVal);
                }
                val = dateVal;
                break;
            }
            case 5: {
                val = strVal;
                break;
            }
            default: {
                val = strVal;
            }
        }
        return val;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JComponent directionsFld = PublishAuthUtil.createInstructionsText(PublishAuthResource.s_propertiesToApplyTabDirectionsLabel);
        directionsFld.setBackground(this.getBackground());
        this.applyPropsOptionsBtnGroup = new ButtonGroup();
        this.optionUseSourceBtn = new JRadioButton();
        this.optionUseSourceBtn.addActionListener(this);
        this.optionUseSourceBtn.setText(PublishAuthResource.s_applyPropsUsingSourceLabel);
        Insets margin = this.optionUseSourceBtn.getMargin();
        this.optionUseSourceBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.applyPropsOptionsBtnGroup.add(this.optionUseSourceBtn);
        this.specifyPropsButtonModel = new SpecifyPropsButtonModel();
        this.optionSpecifyPropsBtn = new JRadioButton();
        this.optionSpecifyPropsBtn.setModel(this.specifyPropsButtonModel);
        this.optionSpecifyPropsBtn.addActionListener(this);
        this.optionSpecifyPropsBtn.setText(PublishAuthResource.s_applyPropsAsSpecifiedLabel);
        margin = this.optionSpecifyPropsBtn.getMargin();
        this.optionSpecifyPropsBtn.setMargin(new Insets(1, margin.left, 1, margin.right));
        this.applyPropsOptionsBtnGroup.add(this.optionSpecifyPropsBtn);
        JPanel classPanel = new JPanel();
        classPanel.setLayout(new GridBagLayout());
        JLabel classLabel = new JLabel(PublishAuthResource.s_classLabel);
        this.classTextField = new WcmNonEditableTextField();
        this.classBrowseButton = new JButton(PublishAuthResource.s_browseDestinationCaption);
        this.classBrowseButton.setMnemonic(WcmStringUtil.stringToMnemonic(PublishAuthResource.s_browseMonic));
        this.classBrowseButton.setMargin(new Insets(0, 4, 0, 4));
        this.classBrowseButton.addActionListener(this);
        classPanel.add((Component)classLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        classPanel.add((Component)this.classTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        classPanel.add((Component)this.classBrowseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.propsGridPanel = new WcmPropertiesGridPanel(this.controller.getParentFrame());
        this.propsGridPanel.setMode(8 | 1 | 0x10 | 0x40);
        this.add((Component)directionsFld, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 0, 16), 0, 0));
        this.add((Component)this.optionUseSourceBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 16, 0, 16), 0, 0));
        this.add((Component)this.optionSpecifyPropsBtn, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 16), 0, 0));
        this.add((Component)classPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 16), 0, 0));
        this.add((Component)this.propsGridPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 40, 16, 16), 0, 0));
    }

    private void configureComponents() {
        if (this.optionUseSourceBtn.isSelected()) {
            this.classBrowseButton.setEnabled(false);
            this.propsGridPanel.setEnabled(false);
        } else if (this.optionSpecifyPropsBtn.isSelected()) {
            this.classBrowseButton.setEnabled(true);
            this.propsGridPanel.setEnabled(true);
        }
    }

    private void invalidateCurrentLibrary() {
        this.currentLibrary = null;
        this.invalidateSelectedDocClassDesc();
    }

    private void invalidateSelectedDocClassDesc() {
        this.selectedDocClassDesc = null;
        this.classTextField.setText("");
        this.oDocIsNew = true;
        this.propsGridPanel.clear();
        this.propsGridPanel.setMode(8 | 1 | 0x10 | 0x40);
    }

    protected void performBrowseClassTree() {
        Cursor curCursor = this.controller.setWaitCursor();
        try {
            WcmDlgClassDescItem cdItem;
            int retVal;
            boolean isFirstTime = false;
            if (this.browseTreeDlg == null || this.oDocIsNew) {
                if (this.oDoc == null) {
                    this.oDoc = WcmClassDescsDom.getObjectStoreClassesDOM(this.controller.getSession(), this.currentLibrary.getId(), 1, false);
                }
                if (this.selectedDocClassDesc == null) {
                    isFirstTime = true;
                    this.selectedDocClassDesc = new VerboseClassDescription(this.getTopFirstClass(this.currentLibrary.getLibrary(), this.oDoc));
                }
                this.browseTreeDlg = new WcmDlgClassTreeDialog(this.controller.getParentFrame(), this.currentLibrary.getLibrary(), this.oDoc, this.selectedDocClassDesc.getClassDescription(), true);
                this.oDocIsNew = false;
            }
            if ((retVal = this.browseTreeDlg.showDialog()) == 0 && (cdItem = this.browseTreeDlg.getSelected()) != null && (cdItem.getId().compareToIgnoreCase(this.selectedDocClassDesc.getId()) != 0 || isFirstTime)) {
                try {
                    this.selectedDocClassDesc = new VerboseClassDescription(cdItem.getClassDescription());
                    this.classTextField.setText(cdItem.getClassName());
                    this.loadPropsGridPanel(null);
                    this.data.setApplyPropsClassDesc(this.selectedDocClassDesc);
                }
                catch (Exception ex) {
                    WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
                    this.invalidateSelectedDocClassDesc();
                    this.data.setApplyPropsClassDesc(null);
                }
            }
            if (curCursor != null) {
                this.controller.setAppCursor(curCursor);
            }
        }
        catch (Exception ex) {
            if (curCursor != null) {
                this.controller.setAppCursor(curCursor);
            }
            WcmErrorUtil.showErrorMessage(this, ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
        }
    }

    private ClassDescription getTopFirstClass(ObjectStore os, Document oDoc) throws Exception {
        ClassDescription cd = null;
        Element oRoot = oDoc.getDocumentElement();
        Element oCD = WcmClassDescsDom.getChildElement(oRoot, "classdesc");
        if (oCD != null) {
            Element oId = WcmClassDescsDom.getChildElement(oCD, "id");
            String sGuid = WcmClassDescsDom.getValue(oId);
            cd = (ClassDescription)os.getObject(25, sGuid);
        }
        return cd;
    }

    private void loadPropsGridPanel(DescribedValue[] descVals) throws BaseException, Exception {
        if (descVals == null) {
            VerboseList vpropDescs = this.selectedDocClassDesc.getPropertyDescriptions();
            ArrayList<DescribedValue> descValsList = new ArrayList<DescribedValue>();
            ListIterator it = vpropDescs.listIterator();
            while (it.hasNext()) {
                VerbosePropertyDescription vpropDesc = (VerbosePropertyDescription)it.next();
                if (vpropDesc.getDataType() == 1 || vpropDesc.getDataType() == 7 || vpropDesc.getIsHidden() || vpropDesc.getIsSystemGenerated() || vpropDesc.getIsReadOnly()) continue;
                boolean bFilteredOut = false;
                for (int i = 0; i < this.filteredOutNames.length; ++i) {
                    if (!vpropDesc.getSymbolicName().equalsIgnoreCase(this.filteredOutNames[i])) continue;
                    bFilteredOut = true;
                    break;
                }
                if (bFilteredOut) continue;
                descValsList.add(new DescribedValue(vpropDesc.getPropertyDescription(), null));
            }
            descVals = new DescribedValue[descValsList.size()];
            for (int i = 0; i < descValsList.size(); ++i) {
                descVals[i] = (DescribedValue)descValsList.get(i);
            }
        }
        WcmSitePrefs sitePreferences = this.controller.getSitePreferences();
        String nameProperty = null;
        if (sitePreferences != null) {
            try {
                String osName = this.currentLibrary.getLibrary().getName();
                if (osName != null && (nameProperty = sitePreferences.getObjectStorePrefs(osName).getDocumentNameProperty()) != null) {
                    this.propsGridPanel.setNameProperty(nameProperty, false);
                }
            }
            catch (Exception ex) {
                System.out.print("Problem getting name property. Error is: " + ex.getMessage());
            }
        }
        this.propsGridPanel.loadProperties(descVals);
    }

    private boolean checkClassSelected() {
        boolean successful = true;
        if (this.selectedDocClassDesc == null || !this.propsGridPanel.isLoaded()) {
            JOptionPane.showMessageDialog(this.controller.getParentFrame(), PublishAuthResource.s_errorNoClassSelected, PublishAuthResource.s_publishAuthTitle, 0);
            successful = false;
        }
        return successful;
    }

    private class SpecifyPropsButtonModel
    extends JToggleButton.ToggleButtonModel {
        private SpecifyPropsButtonModel() {
        }

        public void setSelected(boolean selected) {
            boolean canSelect = true;
            if (selected && !this.isSelected()) {
                try {
                    PropertiesToApplyPanel.this.oDoc = WcmClassDescsDom.getObjectStoreClassesDOM(PropertiesToApplyPanel.this.controller.getSession(), PropertiesToApplyPanel.this.currentLibrary.getId(), 1, false);
                    if (PropertiesToApplyPanel.this.selectedDocClassDesc != null) {
                        PropertiesToApplyPanel.this.classTextField.setText(PropertiesToApplyPanel.this.selectedDocClassDesc.getName());
                    }
                }
                catch (Exception ex) {
                    WcmErrorUtil.showErrorMessage(PropertiesToApplyPanel.this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
                    ex.printStackTrace();
                    canSelect = false;
                }
            }
            if (canSelect) {
                super.setSelected(selected);
            }
        }

        public void setSelectedDirect(boolean selected) {
            PropertiesToApplyPanel.this.disarmModifiedFire();
            super.setSelected(selected);
            PropertiesToApplyPanel.this.armModifiedFire();
        }
    }
}

