/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.Domain;
import com.filenet.wcm.api.EntireNetwork;
import com.filenet.wcm.api.EventAction;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.StyleTemplate;
import com.filenet.wcm.api.StyleTemplates;
import com.filenet.wcm.apps.client.publish.PublishTemplateContentConverter;
import com.filenet.wcm.apps.client.publish.ui.ChooseEventActionDlg;
import com.filenet.wcm.apps.client.publish.ui.ChooseStyleTemplateDlg;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthController;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthData;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataEvent;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthDataListener;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthPanel;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthResource;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthUtil;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerboseClassDescription;
import com.filenet.wcm.apps.client.util.api.VerboseFolder;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePublishTemplate;
import com.filenet.wcm.apps.client.util.api.VerboseStyleTemplate;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.WcmDlg;
import com.filenet.wcm.toolkit.client.ui.WcmDlgFactory;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.Document;

public class GeneralPublishPanel
extends PublishAuthPanel
implements ActionListener,
PublishAuthDataListener {
    private PublishAuthController controller;
    private PublishAuthData data;
    private VerboseLibrary currentLibrary;
    private String currentLocationFolderId;
    private String currentLocationPath;
    private String currentStyleTemplateId;
    private String currentStyleTemplateName;
    private List styleTemplates;
    private EventAction currentEventAction;
    private JComboBox librarySelectionComboBox;
    private LibrarySelectionComboBoxModel librarySelectionComboBoxModel;
    private JButton locationBrowseBtn;
    private JTextField locationText;
    private WcmDlgItem startBrowseLoc;
    private JCheckBox useStyleTemplateChk;
    private UseStyleTemplateButtonModel useStyleTemplateButtonModel;
    private JCheckBox isSourceDependentChk;
    private JTextField styleTemplateText;
    private JButton styleTemplateBrowseBtn;
    private JTextArea descriptionText;
    private Document descriptionTextDoc;
    private JCheckBox useEventActionChk;
    private UseEventActionButtonModel useEventActionButtonModel;
    private JTextField eventActionText;
    private JButton eventActionBrowseBtn;

    GeneralPublishPanel(PublishAuthController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private GeneralPublishPanel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadComponents() {
        String curStatusBarMsg;
        block11: {
            Cursor curCursor = null;
            curStatusBarMsg = null;
            try {
                LibrarySelectionComboBoxModel tempModel = new LibrarySelectionComboBoxModel();
                curStatusBarMsg = this.controller.setStatusBarMsg(PublishAuthResource.s_loadingLibsMsg);
                curCursor = this.controller.setWaitCursor();
                WcmDlgItemImpl enwItem = (WcmDlgItemImpl)this.controller.getEntireNetworkDlgItem();
                EntireNetwork enw = enwItem.getEntireNetworkObject();
                Domain p8domain = null;
                ObjectStores libs = null;
                Iterator itDom = enw.getDomains().iterator();
                if (itDom.hasNext()) {
                    p8domain = (Domain)itDom.next();
                }
                if (p8domain != null) {
                    libs = p8domain.getObjectStores();
                }
                enwItem.initObjectStores(libs);
                libs = PropertyUtil.sort(libs);
                for (ObjectStore lib : libs) {
                    VerboseLibrary vlib = new VerboseLibrary(lib);
                    tempModel.addElement(vlib);
                }
                this.librarySelectionComboBox.setModel(tempModel);
                tempModel.setSelectedItemDirect(null);
                this.librarySelectionComboBoxModel = tempModel;
                if (curCursor == null) break block11;
                this.controller.setAppCursor(curCursor);
            }
            catch (Exception ex) {
                block12: {
                    try {
                        System.out.println("generalpublishpanel:loadComponent:" + ex.getMessage());
                        ex.printStackTrace();
                        if (curCursor == null) break block12;
                        this.controller.setAppCursor(curCursor);
                    }
                    catch (Throwable throwable) {
                        if (curCursor != null) {
                            this.controller.setAppCursor(curCursor);
                        }
                        if (curStatusBarMsg != null) {
                            this.controller.setStatusBarMsg(curStatusBarMsg);
                        }
                        throw throwable;
                    }
                }
                if (curStatusBarMsg != null) {
                    this.controller.setStatusBarMsg(curStatusBarMsg);
                }
            }
        }
        if (curStatusBarMsg != null) {
            this.controller.setStatusBarMsg(curStatusBarMsg);
        }
    }

    void setData(PublishAuthData data) {
        this.tempTrace("GeneralPublishPanel.setData() called");
        PublishTemplateContentConverter converter = data.getContentConverter();
        this.tempTrace("Checking whether to invalidate library");
        if (data.getLibrary() != null) {
            if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(data.getLibrary().getId()) != 0) {
                this.invalidateCurrentLibrary();
            }
        } else {
            this.invalidateCurrentLibrary();
        }
        this.tempTrace("Checking whether to invalidate folder");
        if (data.getLocationFolder() != null) {
            if (this.currentLocationFolderId != null && this.currentLocationFolderId.compareToIgnoreCase(data.getLocationFolder().getId()) != 0) {
                this.invalidateCurrentLocationFolder();
            }
        } else {
            this.invalidateCurrentLocationFolder();
        }
        this.tempTrace("Checking whether to invalidate style template");
        if (converter.getStyleTemplateId() != null && this.currentStyleTemplateId != null && this.currentStyleTemplateId.compareToIgnoreCase(converter.getStyleTemplateId()) != 0) {
            this.invalidateCurrentStyleTemplate();
        }
        boolean chooseStyleTemplate = false;
        this.tempTrace("Checking whether to invalidate event action");
        EventAction eventAction = data.getPublishEventAction();
        if (eventAction != null && this.currentEventAction != null && WcmString.compareIgnoreCase(this.currentEventAction.getName(), eventAction.getName()) != 0) {
            this.currentEventAction = null;
            this.eventActionText.setText("");
        }
        boolean chooseEventAction = false;
        try {
            if (this.currentLibrary == null && data.getLibrary() != null) {
                this.currentLibrary = data.getLibrary();
            }
            if (this.currentLocationPath == null && data.getLocationFolder() != null) {
                this.loadCurrentLocationPathFromFolder(data.getLocationFolder());
                this.currentLocationFolderId = data.getLocationFolder().getId();
            }
            if (converter.getStyleTemplateId() != null) {
                chooseStyleTemplate = true;
            }
            if (this.currentStyleTemplateName == null && converter.getStyleTemplateId() != null) {
                VerboseLibrary vlib = data.getLibrary();
                StyleTemplate styleTempl = (StyleTemplate)vlib.getLibrary().getObject(-103, converter.getStyleTemplateId());
                VerboseStyleTemplate vstyleTempl = new VerboseStyleTemplate(styleTempl);
                this.currentStyleTemplateName = vstyleTempl.getName();
                this.currentStyleTemplateId = converter.getStyleTemplateId();
            }
            if (eventAction != null) {
                this.currentEventAction = eventAction;
                chooseEventAction = true;
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
        }
        if (converter.getStyleTemplateId() != null && this.currentStyleTemplateId != null) {
            chooseStyleTemplate = true;
        }
        this.setButtonSelectedDisarmModifiedFire(this.isSourceDependentChk, converter.getIsSourceDependent());
        if (chooseStyleTemplate) {
            this.useStyleTemplateButtonModel.setSelectedDirect(true);
        } else {
            this.useStyleTemplateButtonModel.setSelectedDirect(false);
        }
        if (chooseEventAction) {
            this.useEventActionButtonModel.setSelectedDirect(true);
        } else {
            this.useEventActionButtonModel.setSelectedDirect(false);
        }
        if (this.data != null) {
            this.data.removePublishAuthDataListener(this);
        }
        data.addPublishAuthDataListener(this);
        this.data = data;
        this.configureComponents();
    }

    boolean validateDescriptionText() {
        boolean successful = true;
        Cursor curCursor = null;
        try {
            curCursor = this.controller.setWaitCursor();
            VerboseLibrary vlib = this.data.getLibrary();
            VerboseClassDescription vcd = vlib.getDocumentClassDescriptionFromId("{FBA25CE9-A06A-4F79-8A23-E09AE54DD7CD}");
            VerbosePropertyDescription vpropDesc = vcd.getPropertyDescriptionFromName("Description");
            Integer maxLength = new Integer(0);
            maxLength = vpropDesc.getMaximumLength();
            int lenght = this.descriptionText.getText().length();
            if (lenght > maxLength) {
                WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), PublishAuthResource.s_errorPublishTemplateDescriptionTooLong.toString(maxLength.toString()), PublishAuthResource.s_publishAuthTitle);
                successful = false;
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
            successful = false;
        }
        if (curCursor != null) {
            this.controller.setAppCursor(curCursor);
        }
        return successful;
    }

    public boolean applyChanges() {
        boolean successful = true;
        this.tempTrace("GeneralPublishPanel.applyChanges() called.");
        PublishTemplateContentConverter converter = this.data.getContentConverter();
        converter.setOutputFolderId(this.currentLocationFolderId);
        converter.setIsSourceDependent(this.isSourceDependentChk.isSelected());
        if (this.useStyleTemplateChk.isSelected() && this.currentStyleTemplateId != null) {
            converter.setStyleTemplateId(this.currentStyleTemplateId);
        } else {
            converter.setStyleTemplateId(null);
        }
        PublishTemplateContentConverter.NameOrId nameOrId = converter.getPubEventActionClassKey(null);
        if (this.useEventActionChk.isSelected() && this.currentEventAction != null) {
            if (!nameOrId.isNameOrId) {
                converter.setPubEventActionClassKey(this.currentEventAction.getId(), false);
            } else {
                converter.setPubEventActionClassKey(this.currentEventAction.getName(), true);
            }
        } else {
            converter.setPubEventActionClassKey(null, nameOrId.isNameOrId);
        }
        return successful;
    }

    boolean canSwitchFrom() {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.locationBrowseBtn) {
            this.performBrowseLocation();
        } else if (event.getSource() == this.styleTemplateBrowseBtn) {
            this.performChooseStyleTemplate();
        } else if (event.getSource() == this.eventActionBrowseBtn) {
            this.performChooseEventAction();
        } else if (event.getSource() == this.useStyleTemplateChk || event.getSource() == this.useEventActionChk || event.getSource() == this.isSourceDependentChk) {
            this.fireModified();
        } else if (event.getSource() == this.librarySelectionComboBox) {
            this.librarySelectionComboBox.hidePopup();
        }
        Frame parentFrame = this.controller.getParentFrame();
        if (parentFrame != null) {
            parentFrame.requestFocus();
        }
    }

    public void dataChanged(PublishAuthDataEvent e) {
        if (e.getSource() == this.data) {
            this.tempTrace("GeneralPublishPanel.dataChanged() called for data: " + e.getType());
            int changeType = e.getType();
            if ((changeType & 0x10) != 0) {
                if (this.data.getLibrary() != null) {
                    if (this.currentLibrary != null && this.currentLibrary.getId().compareToIgnoreCase(this.data.getLibrary().getId()) != 0) {
                        this.invalidateCurrentLibrary();
                    }
                } else {
                    this.invalidateCurrentLibrary();
                }
            }
            if ((changeType & 8) != 0) {
                if (this.data.getLocationFolder() != null) {
                    if (this.currentLocationFolderId != null && this.currentLocationFolderId.compareToIgnoreCase(this.data.getLocationFolder().getId()) != 0) {
                        this.invalidateCurrentLocationFolder();
                    }
                } else {
                    this.invalidateCurrentLocationFolder();
                }
            }
            try {
                if ((changeType & 0x10) != 0 && this.currentLibrary == null && this.data.getLibrary() != null) {
                    this.currentLibrary = this.data.getLibrary();
                }
                if ((changeType & 8) != 0 && this.currentLocationPath == null && this.data.getLocationFolder() != null) {
                    this.currentLocationFolderId = this.data.getLocationFolder().getId();
                    this.loadCurrentLocationPathFromFolder(this.data.getLocationFolder());
                }
            }
            catch (Exception ex) {
                WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
                ex.printStackTrace();
            }
            this.configureComponents();
        }
    }

    protected PublishAuthData getData() {
        return this.data;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JComponent directionsTxt = PublishAuthUtil.createInstructionsText(WcmStringUtil.concatenateStrings(PublishAuthResource.s_generalPublishTabDirectionsLabel));
        directionsTxt.setBackground(this.getBackground());
        directionsTxt.setRequestFocusEnabled(false);
        ImageIcon requiredIcon = WcmImageLoader.createImageIcon("state/Required16.gif");
        JLabel hostLibraryLbl = new JLabel(PublishAuthResource.s_hostLibraryLabel, requiredIcon, 2);
        this.librarySelectionComboBox = new JComboBox();
        this.librarySelectionComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.librarySelectionComboBox.addActionListener(this);
        DefaultComboBoxModel tempComboModel = new DefaultComboBoxModel();
        this.librarySelectionComboBox.setModel(tempComboModel);
        this.librarySelectionComboBox.setRenderer(new LibrarySelectionComboBoxRenderer());
        Dimension tempDim = this.librarySelectionComboBox.getPreferredSize();
        tempDim.width = 320;
        this.librarySelectionComboBox.setPreferredSize(tempDim);
        JLabel destLocLbl = new JLabel(PublishAuthResource.s_destinationLocationLabel, requiredIcon, 2);
        JPanel locPanel = new JPanel();
        locPanel.setLayout(new GridBagLayout());
        this.locationText = new JTextField(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.locationText.setEditable(false);
        this.locationText.setBackground(this.getBackground());
        this.locationText.setColumns(40);
        this.locationBrowseBtn = new JButton();
        this.locationBrowseBtn.setText(PublishAuthResource.s_browseDestinationCaption);
        this.locationBrowseBtn.setMnemonic(WcmStringUtil.stringToMnemonic(PublishAuthResource.s_browseMonic));
        this.locationBrowseBtn.setMargin(new Insets(0, 4, 0, 4));
        this.locationBrowseBtn.addActionListener(this);
        locPanel.add((Component)this.locationText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        locPanel.add((Component)this.locationBrowseBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.isSourceDependentChk = new JCheckBox();
        this.isSourceDependentChk.setText(PublishAuthResource.s_isSourceDependentLabel);
        this.isSourceDependentChk.addActionListener(this);
        this.useStyleTemplateButtonModel = new UseStyleTemplateButtonModel();
        this.useStyleTemplateChk = new JCheckBox();
        this.useStyleTemplateChk.setModel(this.useStyleTemplateButtonModel);
        this.useStyleTemplateChk.setText(PublishAuthResource.s_useStyleTemplateLabel);
        this.useStyleTemplateChk.addActionListener(this);
        JPanel styleTemplPanel = new JPanel();
        styleTemplPanel.setLayout(new GridBagLayout());
        this.styleTemplateText = new JTextField(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.styleTemplateText.setEditable(false);
        this.styleTemplateText.setBackground(this.getBackground());
        this.styleTemplateText.setColumns(40);
        this.styleTemplateBrowseBtn = new JButton();
        this.styleTemplateBrowseBtn.addActionListener(this);
        this.styleTemplateBrowseBtn.setMargin(new Insets(0, 4, 0, 4));
        this.styleTemplateBrowseBtn.setText(PublishAuthResource.s_selectStyleTemplateCaption);
        this.styleTemplateBrowseBtn.setMnemonic(WcmStringUtil.stringToMnemonic(PublishAuthResource.s_selectMonic));
        styleTemplPanel.add((Component)this.styleTemplateText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        styleTemplPanel.add((Component)this.styleTemplateBrowseBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        JPanel eventActionPanel = this.createEventActionPanel();
        this.add((Component)directionsTxt, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 4, 12, 16), 0, 0));
        this.add((Component)hostLibraryLbl, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 16, 0, 16), 0, 0));
        this.add((Component)this.librarySelectionComboBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 16), 0, 0));
        this.add((Component)destLocLbl, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 16, 0, 16), 0, 0));
        this.add((Component)locPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 16, 0, 16), 0, 0));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createTitledBorder(PublishAuthResource.s_optionSettingsLabel));
        optionsPanel.add((Component)this.isSourceDependentChk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 16, 0, 16), 0, 0));
        optionsPanel.add((Component)this.useStyleTemplateChk, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 16, 0, 16), 0, 0));
        optionsPanel.add((Component)styleTemplPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 0, 16), 0, 0));
        optionsPanel.add((Component)this.useEventActionChk, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 16, 0, 16), 0, 0));
        optionsPanel.add((Component)eventActionPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 40, 20, 16), 0, 0));
        this.add((Component)optionsPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(20, 16, 0, 16), 0, 0));
        JLabel tempLabel = new JLabel();
        this.add((Component)tempLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel createEventActionPanel() {
        this.useEventActionButtonModel = new UseEventActionButtonModel();
        this.useEventActionChk = new JCheckBox();
        this.useEventActionChk.setModel(this.useEventActionButtonModel);
        this.useEventActionChk.setText(PublishAuthResource.s_useEventActionLabel);
        this.useEventActionChk.addActionListener(this);
        this.useEventActionChk.setEnabled(false);
        JPanel eventActionPanel = new JPanel();
        eventActionPanel.setLayout(new GridBagLayout());
        this.eventActionText = new JTextField(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.eventActionText.setEditable(false);
        this.eventActionText.setBackground(this.getBackground());
        this.eventActionText.setColumns(40);
        this.eventActionBrowseBtn = new JButton();
        this.eventActionBrowseBtn.setEnabled(false);
        this.eventActionBrowseBtn.addActionListener(this);
        this.eventActionBrowseBtn.setMargin(new Insets(0, 4, 0, 4));
        this.eventActionBrowseBtn.setText(PublishAuthResource.s_selectEventActionCaption);
        this.eventActionBrowseBtn.setMnemonic(WcmStringUtil.stringToMnemonic(PublishAuthResource.s_selectMonic2));
        eventActionPanel.add((Component)this.eventActionText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        eventActionPanel.add((Component)this.eventActionBrowseBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        return eventActionPanel;
    }

    private void configureComponents() {
        if (this.currentLibrary == null) {
            this.locationBrowseBtn.setEnabled(false);
            this.useStyleTemplateChk.setEnabled(false);
            this.styleTemplateBrowseBtn.setEnabled(false);
            this.useEventActionChk.setEnabled(false);
            this.eventActionBrowseBtn.setEnabled(false);
        } else {
            this.locationBrowseBtn.setEnabled(true);
            this.useStyleTemplateChk.setEnabled(true);
            this.styleTemplateBrowseBtn.setEnabled(true);
            this.useEventActionChk.setEnabled(true);
            this.eventActionBrowseBtn.setEnabled(true);
        }
        if (this.librarySelectionComboBoxModel != null) {
            if (this.currentLibrary != null) {
                if (this.librarySelectionComboBoxModel.getSelectedItem() == null || this.librarySelectionComboBoxModel.getSelectedItem() != null && ((VerboseLibrary)this.librarySelectionComboBoxModel.getSelectedItem()).getId().compareToIgnoreCase(this.currentLibrary.getId()) != 0) {
                    int numItems = this.librarySelectionComboBoxModel.getSize();
                    VerboseLibrary modelLib = null;
                    for (int iItem = 0; iItem < numItems; ++iItem) {
                        VerboseLibrary libItem = (VerboseLibrary)this.librarySelectionComboBoxModel.getElementAt(iItem);
                        if (libItem.getId().compareToIgnoreCase(this.currentLibrary.getId()) != 0) continue;
                        modelLib = libItem;
                        break;
                    }
                    this.librarySelectionComboBoxModel.setSelectedItemDirect(modelLib);
                }
            } else {
                this.librarySelectionComboBoxModel.setSelectedItemDirect(null);
            }
        }
        if (this.currentLocationPath != null) {
            this.locationText.setText(this.currentLocationPath);
        } else {
            this.locationText.setText("");
        }
        if (this.currentStyleTemplateName != null) {
            this.styleTemplateText.setText(this.currentStyleTemplateName);
            this.styleTemplateText.setCaretPosition(0);
        } else {
            this.styleTemplateText.setText("");
        }
        if (this.currentStyleTemplateName == null && this.useStyleTemplateChk.isSelected()) {
            this.useStyleTemplateButtonModel.setSelectedDirect(false);
        }
        this.configureEventActionComponent();
    }

    private void configureEventActionComponent() {
        if (this.currentEventAction != null) {
            this.eventActionText.setText(this.currentEventAction.getName());
            this.eventActionText.setCaretPosition(0);
        } else {
            this.eventActionText.setText("");
        }
        if (this.currentEventAction == null && this.useEventActionChk.isSelected()) {
            this.useEventActionButtonModel.setSelectedDirect(false);
        }
    }

    private void performChooseStyleTemplate() {
        if (this.styleTemplates == null) {
            this.loadStyleTemplatesCheckNone();
        }
        if (this.styleTemplates != null && this.styleTemplates.size() > 0) {
            ChooseStyleTemplateDlg dlg = new ChooseStyleTemplateDlg(this.controller.getParentFrame(), PublishAuthResource.s_chooseStyleTemplateTitle, this.styleTemplates);
            dlg.show();
            if (dlg.getStatus() == 0) {
                VerboseStyleTemplate vstyleTemplate = dlg.getStyleTemplate();
                this.invalidateCurrentStyleTemplate();
                this.currentStyleTemplateId = vstyleTemplate.getId();
                this.currentStyleTemplateName = vstyleTemplate.getName();
                if (!this.useStyleTemplateButtonModel.isSelected()) {
                    this.useStyleTemplateButtonModel.setSelectedDirect(true);
                }
                this.configureComponents();
                this.fireModified();
            }
        } else {
            this.styleTemplateBrowseBtn.setEnabled(false);
            JOptionPane.showMessageDialog(this.controller.getParentFrame(), PublishAuthResource.s_noStyleTemplatesMsg, PublishAuthResource.s_publishAuthTitle, 0);
        }
    }

    private void performChooseEventAction() {
        List eventActions = this.data.getEventActions();
        if (eventActions != null && eventActions.size() > 0) {
            ChooseEventActionDlg dlg = new ChooseEventActionDlg(this.controller.getParentFrame(), PublishAuthResource.s_chooseEventActionTitle, eventActions);
            dlg.show();
            if (dlg.getStatus() == 0) {
                this.currentEventAction = dlg.getEventAction();
                if (!this.useEventActionButtonModel.isSelected()) {
                    this.useEventActionButtonModel.setSelectedDirect(true);
                }
                this.data.setPublishEventAction(this.currentEventAction);
                this.configureComponents();
                this.fireModified();
            }
        } else {
            this.eventActionBrowseBtn.setEnabled(false);
            JOptionPane.showMessageDialog(this.controller.getParentFrame(), PublishAuthResource.s_noEventActionsMsg, PublishAuthResource.s_publishAuthTitle, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performBrowseLocation() {
        boolean successful = true;
        Cursor curCursor = null;
        try {
            curCursor = this.controller.setWaitCursor();
            WcmDlgItem enwDlgItem = this.controller.getEntireNetworkDlgItem();
            WcmDlgItem currentDirItem = enwDlgItem.getChildById(this.currentLibrary.getId());
            WcmDlg browseDlg = WcmDlgFactory.getBrowseDialog(currentDirItem, this.startBrowseLoc, WcmResourceString.s_open, new int[]{2});
            browseDlg.setBrowseMode(1);
            browseDlg.setTitle(PublishAuthResource.s_chooseLocationTitle);
            Frame parentFrame = this.controller.getParentFrame();
            int stat = browseDlg.showDialog(parentFrame);
            if (stat == 0) {
                WcmDlgItem dlgItem = browseDlg.getSelectedItem();
                ReadableMetadataObject wcmObj = dlgItem.getWcmObject();
                if (!(wcmObj instanceof Folder)) {
                    throw new RuntimeException("Browse dialog didn't return folder!");
                }
                Folder fold = (Folder)wcmObj;
                this.startBrowseLoc = dlgItem;
                this.tempTrace("WcmDlgItem returned folder: " + fold.getId());
                VerboseFolder vfold = new VerboseFolder(fold);
                if (this.currentLocationFolderId != null && this.currentLocationFolderId.compareToIgnoreCase(vfold.getId()) != 0) {
                    this.invalidateCurrentLocationFolder();
                }
                if (this.currentLocationPath == null) {
                    this.currentLocationPath = dlgItem.getPathnameWithoutOS();
                    this.currentLocationFolderId = vfold.getId();
                }
                this.data.setLocationFolder(vfold, this.currentLibrary);
            } else if (stat == -1) {
                successful = false;
            }
        }
        catch (Exception ex) {
            WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), ex.getLocalizedMessage(), PublishAuthResource.s_publishAuthTitle);
            ex.printStackTrace();
            successful = false;
        }
        finally {
            if (curCursor != null) {
                this.controller.setAppCursor(curCursor);
            }
        }
        if (!successful) {
            this.configureComponents();
        }
    }

    private void invalidateCurrentLibrary() {
        this.currentLibrary = null;
        this.styleTemplates = null;
        this.currentEventAction = null;
        this.invalidateCurrentLocationFolder();
        this.invalidateCurrentStyleTemplate();
    }

    private void invalidateCurrentLocationFolder() {
        this.currentLocationFolderId = null;
        this.currentLocationPath = null;
    }

    private void invalidateCurrentStyleTemplate() {
        this.currentStyleTemplateId = null;
        this.currentStyleTemplateName = null;
    }

    private void loadCurrentLocationPathFromFolder(VerboseFolder vfold) throws BaseException {
        Folder rootFold = this.currentLibrary.getLibrary().getRootFolder();
        VerboseFolder vrootFold = new VerboseFolder(rootFold);
        StringBuffer buff = new StringBuffer();
        if (vfold.getId().compareToIgnoreCase(vrootFold.getId()) == 0) {
            buff.insert(0, "\\");
        } else {
            WcmSitePrefs sitePreferences = this.controller.getSitePreferences();
            String foldNamePropName = null;
            if (sitePreferences != null) {
                try {
                    foldNamePropName = sitePreferences.getObjectStorePrefs(this.currentLibrary.getLibrary().getName()).getFolderNameProperty();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            while (vfold.getId().compareToIgnoreCase("RootFolder") != 0 && vfold.getId().compareToIgnoreCase(vrootFold.getId()) != 0) {
                if (foldNamePropName != null) {
                    buff.insert(0, "\\" + vfold.getFolder().getPropertyStringValue(foldNamePropName));
                } else {
                    buff.insert(0, "\\" + vfold.getName());
                }
                try {
                    vfold = vfold.getParent();
                }
                catch (Exception ex) {
                    this.tempTrace("Couldn't get folder parent");
                    ex.printStackTrace();
                    buff.insert(0, "\\CANTGETPARENTFOLDER");
                    break;
                }
            }
        }
        this.currentLocationPath = buff.toString();
    }

    private boolean loadStyleTemplatesCheckNone() {
        boolean succeeded = true;
        if (this.styleTemplates == null) {
            succeeded = this.loadStyleTemplates();
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadStyleTemplates() {
        boolean succeeded = true;
        if (this.styleTemplates == null) {
            String curStatusBarMsg;
            block12: {
                Cursor curCursor = null;
                curStatusBarMsg = null;
                try {
                    curStatusBarMsg = this.controller.setStatusBarMsg(PublishAuthResource.s_loadingStyleTemplatesMsg);
                    curCursor = this.controller.setWaitCursor();
                    StyleTemplates wcmStyleTempls = null;
                    wcmStyleTempls = this.currentLibrary.getLibrary().getStyleTemplates();
                    if (wcmStyleTempls != null) {
                        ArrayList<VerboseStyleTemplate> sts = new ArrayList<VerboseStyleTemplate>(wcmStyleTempls.size());
                        Iterator it = wcmStyleTempls.iterator();
                        while (it.hasNext()) {
                            sts.add(new VerboseStyleTemplate((StyleTemplate)it.next()));
                        }
                        this.styleTemplates = sts;
                    }
                    if (this.styleTemplates == null) {
                        this.styleTemplates = new ArrayList();
                    }
                    if (curCursor == null) break block12;
                    this.controller.setAppCursor(curCursor);
                }
                catch (Exception ex) {
                    block13: {
                        try {
                            WcmErrorUtil.showErrorMessage(this.controller.getParentFrame(), PublishAuthResource.s_errorLoadStyleTemplates.toString(ex.getLocalizedMessage()), PublishAuthResource.s_publishAuthTitle);
                            succeeded = false;
                            if (curCursor == null) break block13;
                            this.controller.setAppCursor(curCursor);
                        }
                        catch (Throwable throwable) {
                            if (curCursor != null) {
                                this.controller.setAppCursor(curCursor);
                                curCursor = null;
                            }
                            if (curStatusBarMsg != null) {
                                this.controller.setStatusBarMsg(curStatusBarMsg);
                                curStatusBarMsg = null;
                            }
                            throw throwable;
                        }
                        curCursor = null;
                    }
                    if (curStatusBarMsg != null) {
                        this.controller.setStatusBarMsg(curStatusBarMsg);
                        curStatusBarMsg = null;
                    }
                }
                curCursor = null;
            }
            if (curStatusBarMsg != null) {
                this.controller.setStatusBarMsg(curStatusBarMsg);
                curStatusBarMsg = null;
            }
        }
        return succeeded;
    }

    private class UseEventActionButtonModel
    extends JToggleButton.ToggleButtonModel {
        private UseEventActionButtonModel() {
        }

        public void setSelected(boolean selected) {
            boolean canSelect = true;
            Frame parentFrame = GeneralPublishPanel.this.controller.getParentFrame();
            if (selected && !this.isSelected() && GeneralPublishPanel.this.currentEventAction == null) {
                List eventActions = GeneralPublishPanel.this.data.getEventActions();
                if (eventActions != null && eventActions.size() > 0) {
                    ChooseEventActionDlg dlg = new ChooseEventActionDlg(parentFrame, PublishAuthResource.s_chooseEventActionTitle, eventActions);
                    dlg.show();
                    if (dlg.getStatus() == 0) {
                        GeneralPublishPanel.this.currentEventAction = dlg.getEventAction();
                        super.setSelected(true);
                        canSelect = false;
                        GeneralPublishPanel.this.data.setPublishEventAction(GeneralPublishPanel.this.currentEventAction);
                        GeneralPublishPanel.this.configureEventActionComponent();
                    } else {
                        canSelect = false;
                    }
                } else {
                    canSelect = false;
                    GeneralPublishPanel.this.eventActionBrowseBtn.setEnabled(false);
                    JOptionPane.showMessageDialog(GeneralPublishPanel.this.controller.getParentFrame(), PublishAuthResource.s_noEventActionsMsg, PublishAuthResource.s_publishAuthTitle, 0);
                }
                if (parentFrame != null) {
                    parentFrame.requestFocus();
                }
            }
            if (canSelect) {
                super.setSelected(selected);
            }
        }

        void setSelectedDirect(boolean selected) {
            GeneralPublishPanel.this.disarmModifiedFire();
            super.setSelected(selected);
            GeneralPublishPanel.this.armModifiedFire();
        }
    }

    private class UseStyleTemplateButtonModel
    extends JToggleButton.ToggleButtonModel {
        private UseStyleTemplateButtonModel() {
        }

        public void setSelected(boolean selected) {
            boolean canSelect = true;
            if (selected && !this.isSelected() && GeneralPublishPanel.this.currentStyleTemplateId == null) {
                if (GeneralPublishPanel.this.styleTemplates == null) {
                    GeneralPublishPanel.this.loadStyleTemplatesCheckNone();
                }
                if (GeneralPublishPanel.this.styleTemplates != null && GeneralPublishPanel.this.styleTemplates.size() > 0) {
                    Frame parentFrame = GeneralPublishPanel.this.controller.getParentFrame();
                    ChooseStyleTemplateDlg dlg = new ChooseStyleTemplateDlg(parentFrame, PublishAuthResource.s_chooseStyleTemplateTitle, GeneralPublishPanel.this.styleTemplates);
                    dlg.show();
                    if (dlg.getStatus() == 0) {
                        VerboseStyleTemplate vstyleTemplate = dlg.getStyleTemplate();
                        GeneralPublishPanel.this.currentStyleTemplateId = vstyleTemplate.getId();
                        GeneralPublishPanel.this.currentStyleTemplateName = vstyleTemplate.getName();
                        super.setSelected(true);
                        canSelect = false;
                        GeneralPublishPanel.this.configureComponents();
                    } else {
                        canSelect = false;
                    }
                    if (parentFrame != null) {
                        parentFrame.requestFocus();
                    }
                } else {
                    canSelect = false;
                    GeneralPublishPanel.this.styleTemplateBrowseBtn.setEnabled(false);
                    JOptionPane.showMessageDialog(GeneralPublishPanel.this.controller.getParentFrame(), PublishAuthResource.s_noStyleTemplatesMsg, PublishAuthResource.s_publishAuthTitle, 0);
                    Frame parentFrame = GeneralPublishPanel.this.controller.getParentFrame();
                    if (parentFrame != null) {
                        parentFrame.requestFocus();
                    }
                }
            }
            if (canSelect) {
                super.setSelected(selected);
            }
        }

        void setSelectedDirect(boolean selected) {
            GeneralPublishPanel.this.disarmModifiedFire();
            super.setSelected(selected);
            GeneralPublishPanel.this.armModifiedFire();
        }
    }

    private class LibrarySelectionComboBoxRenderer
    extends DefaultListCellRenderer {
        private LibrarySelectionComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof VerboseLibrary) {
                VerboseLibrary verboseLib = (VerboseLibrary)value;
                this.setText(verboseLib.getName());
                if (verboseLib.getIsOSAvailable()) {
                    this.setIcon(WcmImageLoader.createImageIcon("type/ObjectStore16.gif"));
                } else {
                    this.setIcon(WcmImageLoader.createImageIcon("type/ObjectStoreError16.gif"));
                }
            }
            return this;
        }
    }

    private class LibrarySelectionComboBoxModel
    extends DefaultComboBoxModel {
        private LibrarySelectionComboBoxModel() {
        }

        public void setSelectedItem(Object item) {
            boolean canSelect = true;
            if (GeneralPublishPanel.this.librarySelectionComboBoxModel == this && item != null && this.getSelectedItem() != item) {
                Cursor curCursor = GeneralPublishPanel.this.controller.setWaitCursor();
                VerboseLibrary vselLib = null;
                if (this.getSelectedItem() != null && this.getSelectedItem() instanceof VerboseLibrary) {
                    vselLib = (VerboseLibrary)this.getSelectedItem();
                }
                if (item instanceof VerboseLibrary) {
                    VerboseLibrary vlib = (VerboseLibrary)item;
                    ObjectStore os = vlib.getLibrary();
                    try {
                        os.getRootFolder().getAccessMask();
                    }
                    catch (Exception ex) {
                        vlib.setOSAvailable(false);
                        GeneralPublishPanel.this.librarySelectionComboBox.updateUI();
                        int boType = os.getObjectType();
                        String osName = os.getName() + "(" + ex.getMessage() + ")";
                        WcmErrorUtil.showErrorMessage(GeneralPublishPanel.this.controller.getParentFrame(), PublishAuthResource.s_errorNoBrowsePermission.toString(osName), PublishAuthResource.s_publishAuthTitle);
                        if (curCursor != null) {
                            GeneralPublishPanel.this.controller.setAppCursor(curCursor);
                        }
                        return;
                    }
                    if (vselLib == null || vselLib != null && vlib.getId().compareToIgnoreCase(vselLib.getId()) != 0) {
                        boolean valid;
                        VerbosePublishTemplate vpubTempl;
                        int opt;
                        boolean successful = true;
                        VerbosePublishTemplate updatedTemplate = null;
                        if (vselLib != null && (opt = JOptionPane.showConfirmDialog(GeneralPublishPanel.this.controller.getParentFrame(), PublishAuthResource.s_askChangeLibraryLocation, PublishAuthResource.s_publishAuthTitle, 0)) != 0) {
                            successful = false;
                        }
                        if (successful && (vpubTempl = GeneralPublishPanel.this.data.getPublishTemplate()) != null && vpubTempl.getIsReserved()) {
                            int opt2 = JOptionPane.showConfirmDialog(GeneralPublishPanel.this.controller.getParentFrame(), PublishAuthResource.s_askCancelCheckout, PublishAuthResource.s_publishAuthTitle, 1);
                            if (opt2 == 0) {
                                successful = GeneralPublishPanel.this.controller.cancelCurrentTemplateCheckout();
                                if (successful) {
                                    updatedTemplate = vpubTempl;
                                }
                            } else if (opt2 == 2) {
                                successful = false;
                            }
                        }
                        if (successful && !(valid = GeneralPublishPanel.this.controller.validateObjectStoreChangingToWithTabs(vlib))) {
                            JOptionPane.showMessageDialog(GeneralPublishPanel.this.controller.getParentFrame(), PublishAuthResource.s_errorInvalidLibraryChosen.toString(vlib.getName()), PublishAuthResource.s_publishAuthTitle, 0);
                            successful = false;
                        }
                        if (successful) {
                            GeneralPublishPanel.this.invalidateCurrentLibrary();
                            GeneralPublishPanel.this.currentLibrary = vlib;
                            GeneralPublishPanel.this.data.setLibrary(vlib);
                            canSelect = false;
                        } else {
                            if (updatedTemplate != null) {
                                try {
                                    updatedTemplate.refresh(true);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                GeneralPublishPanel.this.data.setPublishTemplate(updatedTemplate);
                            }
                            canSelect = false;
                        }
                    }
                } else {
                    canSelect = false;
                }
                if (curCursor != null) {
                    GeneralPublishPanel.this.controller.setAppCursor(curCursor);
                }
            }
            if (canSelect) {
                super.setSelectedItem(item);
            }
        }

        public void setSelectedItemDirect(Object item) {
            GeneralPublishPanel.this.disarmModifiedFire();
            super.setSelectedItem(item);
            GeneralPublishPanel.this.armModifiedFire();
        }
    }
}

