/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.apps.client.publish.ui.PublishAuthResource;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthUtil;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerboseStyleTemplate;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.util.WcmString;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

class ChooseStyleTemplateDlg
extends VWModalDialog
implements ActionListener,
ListSelectionListener,
IVWFrameInterface {
    public static final int ERROR = -1;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static final String dimensionString = WcmString.localize("client.ChooseStyleTemplateDialog.dimension", "640, 400");
    private static final String instructionsText = WcmString.localize("client.ChooseStyleTemplateDialog.instructionsText", "Choose a Style Template from the list below.");
    private static final String nameColumnName = WcmString.localize("client.ChooseStyleTemplateDialog.nameColumnName", "Name");
    private static final String outputFormatColumnName = WcmString.localize("client.ChooseStyleTemplateDialog.outputFormatColumnName", "Output Format");
    private static final String inputFormatsColumnName = WcmString.localize("client.ChooseStyleTemplateDialog.inputFormatsColumnName", "Input Formats");
    private static final String detailsLabelText = WcmString.localize("client.ChooseStyleTemplateDialog.detailsLabelText", "Details:");
    private static final String detailsNameStr = WcmString.localize("client.ChooseStyleTemplateDialog.detailsNameStr", "Name:");
    private static final String detailsDescriptionStr = WcmString.localize("client.ChooseStyleTemplateDialog.detailsDescriptionStr", "Description:");
    private static final String detailsOutputFormatStr = WcmString.localize("client.ChooseStyleTemplateDialog.detailsOutputFormatStr", "Output Format:");
    private static final String detailsInputFormatsStr = WcmString.localize("client.ChooseStyleTemplateDialog.detailsInputFormatsStr", "Input Formats:");
    private List styleTemplates;
    private String[] inputFormatsStrings;
    private JTable styleTemplatesTable;
    private StyleTemplatesTableModel styleTemplatesTableModel;
    private ListSelectionModel styleTemplatesSelectionModel;
    private VerboseStyleTemplate selectedStyleTemplate;
    private JPanel detailsPanel;
    private JScrollPane detailsScrollPane;
    private JTextArea titleText;
    private JTextArea descriptionText;
    private JTextArea outputFormatText;
    private JTextArea inputFormatsText;
    private JButton okBtn;
    private JButton cancelBtn;
    private int rtnStatus;
    private boolean debugOutput;

    public ChooseStyleTemplateDlg(Frame frame, String title, List styleTempls) {
        super(frame);
        this.setTitle(title);
        this.styleTemplates = styleTempls;
        this.rtnStatus = -1;
        try {
            this.initComponents();
            Dimension dim = VWStringUtils.stringToDimension((String)dimensionString);
            if (dim == null) {
                dim = new Dimension(500, 400);
            }
            this.setSize(dim);
            this.configureComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ChooseStyleTemplateDlg() {
        this(null, null, null);
    }

    public int getStatus() {
        return this.rtnStatus;
    }

    public VerboseStyleTemplate getStyleTemplate() {
        return this.selectedStyleTemplate;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            this.rtnStatus = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelBtn) {
            this.rtnStatus = 1;
            this.setVisible(false);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.styleTemplatesSelectionModel) {
            this.configureComponents();
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    private void configureComponents() {
        VerboseStyleTemplate styleTempl = null;
        int selectedIndex = this.styleTemplatesSelectionModel.getMinSelectionIndex();
        this.tempTrace("Selected index: " + selectedIndex);
        if (selectedIndex >= 0) {
            styleTempl = (VerboseStyleTemplate)this.styleTemplates.get(selectedIndex);
        }
        if (this.selectedStyleTemplate != null && this.selectedStyleTemplate != styleTempl) {
            this.tempTrace("Clearing current selected style template");
            this.selectedStyleTemplate = null;
            if (this.titleText != null) {
                this.clearDetailsPanel();
            }
        }
        if (this.selectedStyleTemplate == null && styleTempl != null) {
            this.tempTrace("Loading new selected style template");
            this.selectedStyleTemplate = styleTempl;
            if (this.titleText == null) {
                this.initDetailsPanel();
            }
            this.configureDetailsPanel();
        }
        this.okBtn.setEnabled(this.selectedStyleTemplate != null);
    }

    private void initComponents() throws Exception {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        JComponent instructionsTxtFld = PublishAuthUtil.createInstructionsText(instructionsText);
        instructionsTxtFld.setBackground(contentPane.getBackground());
        this.styleTemplatesTableModel = new StyleTemplatesTableModel();
        this.styleTemplatesTable = new JTable(this.styleTemplatesTableModel);
        this.styleTemplatesTable.addKeyListener(new TabKeyListener());
        JTableHeader tableHeader = this.styleTemplatesTable.getTableHeader();
        StyleTemplatesTableModel styleTemplatesTableModel = this.styleTemplatesTableModel;
        styleTemplatesTableModel.getClass();
        tableHeader.addMouseListener(styleTemplatesTableModel.new StyleTemplatesTableModel.ColumnListener(this.styleTemplatesTable));
        this.styleTemplatesTable.setShowGrid(false);
        this.styleTemplatesSelectionModel = this.styleTemplatesTable.getSelectionModel();
        this.styleTemplatesSelectionModel.setSelectionMode(0);
        JScrollPane styleTemplatesTableScrollPane = new JScrollPane(this.styleTemplatesTable, 22, 30);
        this.styleTemplatesSelectionModel.addListSelectionListener(this);
        JLabel detailsLbl = new JLabel(detailsLabelText);
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new GridBagLayout());
        this.detailsPanel.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.detailsScrollPane = new JScrollPane(this.detailsPanel, 22, 30);
        this.okBtn = new JButton();
        this.okBtn.setText(WcmResourceString.ok_wouthkey);
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton();
        this.cancelBtn.setText(WcmResourceString.cancel_wouthkey);
        this.cancelBtn.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.okBtn);
        buttonsPanel.add(this.cancelBtn);
        contentPane.add((Component)instructionsTxtFld, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 0, 8), 0, 0));
        contentPane.add((Component)styleTemplatesTableScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(8, 8, 0, 8), 0, 0));
        contentPane.add((Component)detailsLbl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 8), 0, 0));
        contentPane.add((Component)this.detailsScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 8), 0, 64));
        contentPane.add((Component)buttonsPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(8, 8, 8, 8), 0, 0));
    }

    private void initDetailsPanel() {
        JLabel titleLabel = new JLabel(detailsNameStr);
        this.titleText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.titleText.setEditable(false);
        this.titleText.setWrapStyleWord(true);
        this.titleText.setBackground(this.detailsPanel.getBackground());
        this.titleText.setColumns(40);
        this.titleText.setRows(1);
        JLabel descriptionLabel = new JLabel(detailsDescriptionStr);
        this.descriptionText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.descriptionText.setEditable(false);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionText.setBackground(this.detailsPanel.getBackground());
        this.descriptionText.setColumns(40);
        this.descriptionText.setRows(1);
        JLabel outputFormatLabel = new JLabel(detailsOutputFormatStr);
        this.outputFormatText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.outputFormatText.setEditable(false);
        this.outputFormatText.setWrapStyleWord(true);
        this.outputFormatText.setBackground(this.detailsPanel.getBackground());
        this.outputFormatText.setColumns(40);
        this.outputFormatText.setRows(1);
        JLabel inputFormatsLabel = new JLabel(detailsInputFormatsStr);
        this.inputFormatsText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.inputFormatsText.setEditable(false);
        this.inputFormatsText.setWrapStyleWord(true);
        this.inputFormatsText.setBackground(this.detailsPanel.getBackground());
        this.inputFormatsText.setColumns(40);
        this.inputFormatsText.setRows(2);
        this.detailsPanel.removeAll();
        this.detailsPanel.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.titleText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.descriptionText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)outputFormatLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.outputFormatText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)inputFormatsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.inputFormatsText, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 8, 0, 8), 0, 0));
    }

    private void clearDetailsPanel() {
        this.titleText.setText("");
        this.descriptionText.setText("");
        this.outputFormatText.setText("");
        this.inputFormatsText.setText("");
    }

    private void configureDetailsPanel() {
        List inputFormats = this.selectedStyleTemplate.getInputFormats();
        Iterator it = inputFormats.iterator();
        StringBuffer inputFormatsStrBuff = new StringBuffer();
        while (it.hasNext()) {
            Object inpFmtVal = it.next();
            String inputFormatStr = "";
            try {
                inputFormatStr = PropertyUtil.getString(inpFmtVal);
            }
            catch (Exception ex) {
                System.out.println("Couldn't convert input format value to string");
                ex.printStackTrace();
            }
            if (inputFormatsStrBuff.length() != 0) {
                inputFormatsStrBuff.append("\n");
            }
            if (inputFormatStr.compareToIgnoreCase("*/*") == 0) {
                inputFormatsStrBuff.append(PublishAuthResource.allInputFormatsString);
                continue;
            }
            inputFormatsStrBuff.append(inputFormatStr);
        }
        this.inputFormatsText.setText(inputFormatsStrBuff.toString());
        this.inputFormatsText.setCaretPosition(0);
        this.outputFormatText.setText(this.selectedStyleTemplate.getOutputFormat());
        this.outputFormatText.setCaretPosition(0);
        this.descriptionText.setText(this.selectedStyleTemplate.getDescription());
        this.descriptionText.setCaretPosition(0);
        this.titleText.setText(this.selectedStyleTemplate.getName());
        this.titleText.setCaretPosition(0);
    }

    private void tempTrace(String s) {
        if (this.debugOutput) {
            System.out.println(s);
        }
    }

    static /* synthetic */ String[] access$602(ChooseStyleTemplateDlg x0, String[] x1) {
        x0.inputFormatsStrings = x1;
        return x1;
    }

    private class StyleTemplateComparator
    implements Comparator {
        protected int sortCol;
        protected boolean sortAsc;

        public StyleTemplateComparator(int col, boolean order) {
            this.sortCol = col;
            this.sortAsc = order;
        }

        public int compare(Object obj1, Object obj2) {
            int result = 0;
            if (!(obj1 instanceof VerboseStyleTemplate) || !(obj2 instanceof VerboseStyleTemplate)) {
                return 0;
            }
            VerboseStyleTemplate sTempl1 = (VerboseStyleTemplate)obj1;
            VerboseStyleTemplate sTempl2 = (VerboseStyleTemplate)obj2;
            switch (this.sortCol) {
                case 0: {
                    String name1 = sTempl1.getName();
                    String name2 = sTempl2.getName();
                    result = WcmString.compare(name1, name2);
                    break;
                }
                case 1: {
                    String outFmt1 = sTempl1.getOutputFormat();
                    String outFmt2 = sTempl2.getOutputFormat();
                    result = WcmString.compare(outFmt1, outFmt2);
                    break;
                }
                case 2: {
                    String inFmt1 = (String)PublishAuthUtil.getInputFormatsString(sTempl1);
                    String inFmt2 = (String)PublishAuthUtil.getInputFormatsString(sTempl2);
                    result = WcmString.compare(inFmt1, inFmt2);
                }
            }
            if (!this.sortAsc) {
                result = -result;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StyleTemplateComparator) {
                StyleTemplateComparator compObj = (StyleTemplateComparator)obj;
                return compObj.sortAsc == this.sortAsc && compObj.sortCol == this.sortCol;
            }
            return false;
        }
    }

    private class TabKeyListener
    extends KeyAdapter {
        private int prevSelRow;

        private TabKeyListener() {
        }

        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 9) {
                if (evt.isShiftDown()) {
                    this.moveToNewRow(false);
                } else {
                    this.moveToNewRow(true);
                }
                evt.consume();
            }
        }

        private void moveToNewRow(boolean forward) {
            int row = ChooseStyleTemplateDlg.this.styleTemplatesTable.getSelectedRow();
            int column = ChooseStyleTemplateDlg.this.styleTemplatesTable.getSelectedColumn();
            if (column == -1) {
                column = 0;
            }
            if (forward) {
                if (++row == ChooseStyleTemplateDlg.this.styleTemplatesTable.getRowCount()) {
                    row = 0;
                }
            } else if (--row < 0) {
                row = ChooseStyleTemplateDlg.this.styleTemplatesTable.getRowCount() - 1;
            }
            this.prevSelRow = row;
            ListSelectionModel rowSelection = ChooseStyleTemplateDlg.this.styleTemplatesTable.getSelectionModel();
            ListSelectionModel colSelection = ChooseStyleTemplateDlg.this.styleTemplatesTable.getColumnModel().getSelectionModel();
            rowSelection.setSelectionInterval(row, row);
            colSelection.setSelectionInterval(column, column);
        }
    }

    private class StyleTemplatesTableModel
    extends AbstractTableModel {
        protected int sortCol = -1;
        protected boolean sortAsc = true;

        private StyleTemplatesTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int index) {
            String name = null;
            switch (index) {
                case 0: {
                    name = nameColumnName;
                    break;
                }
                case 1: {
                    name = outputFormatColumnName;
                    break;
                }
                case 2: {
                    name = inputFormatsColumnName;
                }
            }
            return name;
        }

        public int getRowCount() {
            return ChooseStyleTemplateDlg.this.styleTemplates.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String val = null;
            if (rowIndex < ChooseStyleTemplateDlg.this.styleTemplates.size()) {
                VerboseStyleTemplate vstyleTempl = (VerboseStyleTemplate)ChooseStyleTemplateDlg.this.styleTemplates.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        val = vstyleTempl.getName();
                        break;
                    }
                    case 1: {
                        val = vstyleTempl.getOutputFormat();
                        break;
                    }
                    case 2: {
                        if (ChooseStyleTemplateDlg.this.inputFormatsStrings == null) {
                            ChooseStyleTemplateDlg.access$602(ChooseStyleTemplateDlg.this, new String[ChooseStyleTemplateDlg.this.styleTemplates.size()]);
                        }
                        ((ChooseStyleTemplateDlg)ChooseStyleTemplateDlg.this).inputFormatsStrings[rowIndex] = (String)PublishAuthUtil.getInputFormatsString(vstyleTempl);
                        val = ChooseStyleTemplateDlg.this.inputFormatsStrings[rowIndex];
                    }
                }
            }
            return val;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        class ColumnListener
        extends MouseAdapter {
            protected JTable table;

            public ColumnListener(JTable table) {
                this.table = table;
            }

            public void mouseClicked(MouseEvent e) {
                int colModelIdx;
                TableColumnModel colModel = this.table.getColumnModel();
                int modelIdx = colModel.getColumn(colModelIdx = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
                if (modelIdx < 0) {
                    return;
                }
                if (StyleTemplatesTableModel.this.sortCol == modelIdx) {
                    StyleTemplatesTableModel.this.sortAsc = !StyleTemplatesTableModel.this.sortAsc;
                } else {
                    StyleTemplatesTableModel.this.sortCol = modelIdx;
                }
                Collections.sort(ChooseStyleTemplateDlg.this.styleTemplates, new StyleTemplateComparator(modelIdx, StyleTemplatesTableModel.this.sortAsc));
                this.table.tableChanged(new TableModelEvent(StyleTemplatesTableModel.this));
                this.table.repaint();
            }
        }
    }
}

