/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish.ui;

import com.filenet.wcm.api.EventAction;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.apps.client.publish.ui.PublishAuthUtil;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.util.WcmString;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

class ChooseEventActionDlg
extends VWModalDialog
implements ActionListener,
ListSelectionListener,
IVWFrameInterface {
    public static final int ERROR = -1;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private static final String dimensionString = WcmString.localize("client.ChooseEventActionDialog.dimension", "640, 400");
    private static final String instructionsText = WcmString.localize("client.ChooseEventActionDialog.instructionsText", "Choose an event action from the list below.");
    private static final String nameColumnName = WcmString.localize("client.ChooseEventActionDialog.nameColumnName", "Name");
    private static final String descriptionColumnName = WcmString.localize("client.ChooseEventActionDialog.descriptionColumnName", "Description");
    private static final String commaString = WcmString.localize("client.ChooseEventActionDialog.commaString", ",");
    private static final String detailsLabelText = WcmString.localize("client.ChooseEventActionDialog.detailsLabelText", "Details:");
    private static final String detailsNameStr = WcmString.localize("client.ChooseEventActionDialog.detailsNameStr", "Name:");
    private static final String detailsDescriptionStr = WcmString.localize("client.ChooseEventActionDialog.detailsDescriptionStr", "Description:");
    private static final String detailsEnabledStr = WcmString.localize("client.ChooseEventActionDialog.detailsEnabledStr", "Enabled:");
    private static final String detailsProgIdStr = WcmString.localize("client.ChooseEventActionDialog.detailsProgIdStr", "Prog ID:");
    private static final String detailsScriptTypeStr = WcmString.localize("client.ChooseEventActionDialog.detailsScriptTypeStr", "Script:");
    private static final String detailsWorkflowStr = WcmString.localize("client.ChooseEventActionDialog.detailsWorkflowStr", "Workflow:");
    private static final String WORKFLOWEVENTACTIONID = "{A8A9A512-F479-43E1-BCDC-9EB395C54F3B}";
    private List eventActions;
    private JTable eventActionsTable;
    private EventActionsTableModel eventActionsTableModel;
    private ListSelectionModel eventActionsSelectionModel;
    private EventAction selectedEventAction;
    private JPanel detailsPanel;
    private JScrollPane detailsScrollPane;
    private JTextArea titleText;
    private JTextArea descriptionText;
    private JTextArea enabledText;
    private JTextArea progIdText;
    private JTextArea scriptTypeText;
    private JTextArea workflowText;
    private JButton okBtn;
    private JButton cancelBtn;
    private int rtnStatus;

    public ChooseEventActionDlg(Frame frame, String title, List eventActions) {
        super(frame);
        this.setTitle(title);
        this.eventActions = eventActions;
        this.rtnStatus = -1;
        try {
            this.initComponents();
            Dimension dim = VWStringUtils.stringToDimension((String)dimensionString);
            if (dim == null) {
                dim = new Dimension(500, 400);
            }
            this.setSize(dim);
            this.configureComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ChooseEventActionDlg() {
        this(null, null, null);
    }

    public int getStatus() {
        return this.rtnStatus;
    }

    public EventAction getEventAction() {
        return this.selectedEventAction;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okBtn) {
            this.rtnStatus = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelBtn) {
            this.rtnStatus = 1;
            this.setVisible(false);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.eventActionsSelectionModel) {
            this.configureComponents();
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    private void configureComponents() {
        EventAction eventAction = null;
        int selectedIndex = this.eventActionsSelectionModel.getMinSelectionIndex();
        if (selectedIndex >= 0) {
            eventAction = (EventAction)this.eventActions.get(selectedIndex);
        }
        if (this.selectedEventAction != null && this.selectedEventAction != eventAction) {
            this.selectedEventAction = null;
            if (this.titleText != null) {
                this.clearDetailsPanel();
            }
        }
        if (this.selectedEventAction == null && eventAction != null) {
            this.selectedEventAction = eventAction;
            if (this.titleText == null) {
                this.initDetailsPanel();
            }
            this.configureDetailsPanel();
        }
        this.okBtn.setEnabled(this.selectedEventAction != null);
    }

    private void initComponents() throws Exception {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        JComponent instructionsTxtFld = PublishAuthUtil.createInstructionsText(instructionsText);
        instructionsTxtFld.setBackground(contentPane.getBackground());
        this.eventActionsTableModel = new EventActionsTableModel();
        this.eventActionsTable = new JTable(this.eventActionsTableModel);
        this.eventActionsTable.addKeyListener(new TabKeyListener());
        this.eventActionsTable.setShowGrid(false);
        this.eventActionsSelectionModel = this.eventActionsTable.getSelectionModel();
        this.eventActionsSelectionModel.setSelectionMode(0);
        JScrollPane eventActionsTableScrollPane = new JScrollPane(this.eventActionsTable, 22, 30);
        this.eventActionsSelectionModel.addListSelectionListener(this);
        JLabel detailsLbl = new JLabel(detailsLabelText);
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new GridBagLayout());
        this.detailsPanel.add((Component)new JLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.detailsScrollPane = new JScrollPane(this.detailsPanel, 22, 30);
        this.okBtn = new JButton();
        this.okBtn.setText(WcmResourceString.s_ok);
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton();
        this.cancelBtn.setText(WcmResourceString.s_cancel);
        this.cancelBtn.addActionListener(this);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout());
        buttonsPanel.add(this.okBtn);
        buttonsPanel.add(this.cancelBtn);
        contentPane.add((Component)instructionsTxtFld, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 0, 8), 0, 0));
        contentPane.add((Component)eventActionsTableScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(8, 8, 0, 8), 0, 0));
        contentPane.add((Component)detailsLbl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 8), 0, 0));
        contentPane.add((Component)this.detailsScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 0, 8), 0, 128));
        contentPane.add((Component)buttonsPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 0, new Insets(8, 8, 8, 8), 0, 0));
    }

    private void initDetailsPanel() {
        JLabel titleLabel = new JLabel(detailsNameStr);
        this.titleText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.titleText.setEditable(false);
        this.titleText.setWrapStyleWord(true);
        this.titleText.setBackground(this.detailsPanel.getBackground());
        this.titleText.setColumns(40);
        this.titleText.setRows(1);
        JLabel descriptionLabel = new JLabel(detailsDescriptionStr);
        this.descriptionText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.descriptionText.setEditable(false);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionText.setBackground(this.detailsPanel.getBackground());
        this.descriptionText.setColumns(40);
        this.descriptionText.setRows(1);
        JLabel enabledLabel = new JLabel(detailsEnabledStr);
        this.enabledText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.enabledText.setEditable(false);
        this.enabledText.setWrapStyleWord(true);
        this.enabledText.setBackground(this.detailsPanel.getBackground());
        this.enabledText.setColumns(40);
        this.enabledText.setRows(1);
        JLabel progIdLabel = new JLabel(detailsProgIdStr);
        this.progIdText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.progIdText.setEditable(false);
        this.progIdText.setWrapStyleWord(true);
        this.progIdText.setBackground(this.detailsPanel.getBackground());
        this.progIdText.setColumns(40);
        this.progIdText.setRows(1);
        JLabel scriptTypeLabel = new JLabel(detailsScriptTypeStr);
        this.scriptTypeText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.scriptTypeText.setEditable(false);
        this.scriptTypeText.setWrapStyleWord(true);
        this.scriptTypeText.setBackground(this.detailsPanel.getBackground());
        this.scriptTypeText.setColumns(40);
        this.scriptTypeText.setRows(1);
        JLabel workflowLabel = new JLabel(detailsWorkflowStr);
        this.workflowText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.workflowText.setEditable(false);
        this.workflowText.setWrapStyleWord(true);
        this.workflowText.setBackground(this.detailsPanel.getBackground());
        this.workflowText.setColumns(40);
        this.workflowText.setRows(1);
        this.detailsPanel.removeAll();
        this.detailsPanel.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.titleText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.descriptionText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)enabledLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.enabledText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)progIdLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.progIdText, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)scriptTypeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.scriptTypeText, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 8, 0, 8), 0, 0));
        this.detailsPanel.add((Component)workflowLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.detailsPanel.add((Component)this.workflowText, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 8, 0, 8), 0, 0));
    }

    private void clearDetailsPanel() {
        this.titleText.setText("");
        this.descriptionText.setText("");
        this.enabledText.setText("");
        this.progIdText.setText("");
        this.scriptTypeText.setText("");
        this.workflowText.setText("");
    }

    private void configureDetailsPanel() {
        try {
            this.titleText.setText(this.selectedEventAction.getName());
            this.titleText.setCaretPosition(0);
            this.descriptionText.setText(this.selectedEventAction.getPropertyStringValue("DescriptiveText"));
            this.descriptionText.setCaretPosition(0);
            this.enabledText.setText(this.selectedEventAction.getPropertyStringValue("IsEnabled"));
            this.progIdText.setText(this.selectedEventAction.getPropertyStringValue("ProgId"));
            String tmpStr = this.selectedEventAction.getPropertyStringValue("ScriptText");
            if (tmpStr != null && tmpStr.length() > 0) {
                this.scriptTypeText.setText("Script");
            } else {
                this.scriptTypeText.setText("Class");
            }
            if (this.selectedEventAction.getClassId().compareToIgnoreCase(WORKFLOWEVENTACTIONID) == 0) {
                this.workflowText.setText("true");
            } else {
                this.workflowText.setText("false");
            }
        }
        catch (PropertyNotFoundException ex) {
            System.out.println("configureDetailsPanel:" + ex.getMessage());
        }
    }

    private class TabKeyListener
    extends KeyAdapter {
        private int prevSelRow;

        private TabKeyListener() {
        }

        public void keyPressed(KeyEvent evt) {
            int keyCode = evt.getKeyCode();
            if (keyCode == 9) {
                if (evt.isShiftDown()) {
                    this.moveToNewRow(false);
                } else {
                    this.moveToNewRow(true);
                }
                evt.consume();
            }
        }

        private void moveToNewRow(boolean forward) {
            int row = ChooseEventActionDlg.this.eventActionsTable.getSelectedRow();
            int column = ChooseEventActionDlg.this.eventActionsTable.getSelectedColumn();
            if (column == -1) {
                column = 0;
            }
            if (forward) {
                if (++row == ChooseEventActionDlg.this.eventActionsTable.getRowCount()) {
                    row = 0;
                }
            } else if (--row < 0) {
                row = ChooseEventActionDlg.this.eventActionsTable.getRowCount() - 1;
            }
            this.prevSelRow = row;
            ListSelectionModel rowSelection = ChooseEventActionDlg.this.eventActionsTable.getSelectionModel();
            ListSelectionModel colSelection = ChooseEventActionDlg.this.eventActionsTable.getColumnModel().getSelectionModel();
            rowSelection.setSelectionInterval(row, row);
            colSelection.setSelectionInterval(column, column);
        }
    }

    private class EventActionsTableModel
    extends AbstractTableModel {
        private EventActionsTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int index) {
            String name = null;
            switch (index) {
                case 0: {
                    name = nameColumnName;
                    break;
                }
                case 1: {
                    name = descriptionColumnName;
                }
            }
            return name;
        }

        public int getRowCount() {
            return ChooseEventActionDlg.this.eventActions.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String val = null;
            if (rowIndex < ChooseEventActionDlg.this.eventActions.size()) {
                EventAction evtAction = (EventAction)ChooseEventActionDlg.this.eventActions.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        val = evtAction.getName();
                        break;
                    }
                    case 1: {
                        try {
                            val = evtAction.getPropertyStringValue("DescriptiveText");
                            break;
                        }
                        catch (PropertyNotFoundException ex) {
                            System.out.println("ChooseEventActionDlg:getValueAt: " + ex.getMessage());
                        }
                    }
                }
            }
            return val;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

