/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.publish;

import com.filenet.wcm.toolkit.server.util.xml.WcmXMLUtil;
import com.filenet.wcm.toolkit.util.WcmXMLEncode;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class PublishTemplateContentConverter {
    public static final short APPLYFROMNONE = 0;
    public static final short APPLYFROMSOURCE = 1;
    public static final short APPLYFROMOUTPUTFOLDER = 2;
    public static final short APPLYFROMDESTINATION = 3;
    public static final short APPLYFROMDEFAULT = 4;
    public static final short APPLYFROMSAMEASPUBLISH = 5;
    public static final short VERSIONANDKEEP = 0;
    public static final short VERSIONANDREMOVE = 1;
    public static final short ADDANDKEEP = 2;
    public static final short ADDANDREMOVE = 3;
    public static final short EVENTACTIONSAMEASPUBLISH = 0;
    public static final short EVENTACTIONNONE = 1;
    public static final short EVENTACTIONREPUBLISH = 2;
    public static final boolean KEYISID = false;
    public static final boolean KEYISNAME = true;
    public static final String CURRENTVERSION = "2.0.1";
    protected static final String ATTR_ENCODING = "encoding";
    protected static final String ENCODING_BASE64 = "base64";
    protected static final String LIT_ROOT = "publishtemplatecontent";
    protected static final String LIT_VERSION = "version";
    protected static final String LIT_NEWINSTRUCTIONS = "newinstructions";
    protected static final String LIT_ISSOURCEDEPENDENT = "issourcedependent";
    protected static final String LIT_STYLETEMPLATEID = "styletemplateid";
    protected static final String LIT_EVENTACTIONID = "eventactionid";
    protected static final String LIT_EVENTACTIONNAME = "eventactionname";
    protected static final String LIT_OUTPUTFOLDERID = "outputfolderid";
    protected static final String LIT_OUTPUTFOLDERNAME = "outputfoldername";
    protected static final String LIT_APPLYPROPERTIES = "applyproperties";
    protected static final String LIT_FROM = "from";
    protected static final String LIT_APPLYSECURITY = "applysecurity";
    protected static final String LIT_REPUBLISHINSTRUCTIONS = "republishinstructions";
    protected static final String LIT_VERSIONABLEREPUBLISHTYPE = "versionablerepublishtype";
    protected static final String LIT_VERSIONANDKEEP = "versionandkeep";
    protected static final String LIT_VERSIONANDREMOVE = "versionandremove";
    protected static final String LIT_ADDANDKEEP = "addandkeep";
    protected static final String LIT_ADDANDREMOVE = "addandremove";
    protected static final String LIT_NONVERSIONABLEREPUBLISHTYPE = "nonversionablerepublishtype";
    protected static final String LIT_SOURCE = "source";
    protected static final String LIT_OUTPUTFOLDER = "outputfolder";
    protected static final String LIT_DESTINATION = "destination";
    protected static final String LIT_DEFAULT = "default";
    protected static final String LIT_CLASSDEFAULT = "classdefault";
    protected static final String LIT_APPLYPROPERTIESFROM = "applypropertiesfrom";
    protected static final String LIT_APPLYSECURITYFROM = "applysecurityfrom";
    protected static final String LIT_SAMEASPUBLISH = "sameaspublish";
    protected static final String LIT_CLASSDESCRIPTIONID = "classdescriptionid";
    protected static final String LIT_CLASSDESCRIPTIONNAME = "classdescriptionname";
    protected static final String LIT_PROPERTIES = "properties";
    protected static final String LIT_PROPERTY = "property";
    protected static final String LIT_ID = "id";
    protected static final String LIT_NAME = "name";
    protected static final String LIT_VALUE = "value";
    protected static final String LIT_VALUES = "values";
    protected static final String LIT_PERMISSIONS = "permissions";
    protected static final String LIT_PERMISSION = "permission";
    protected static final String LIT_ACCESS = "access";
    protected static final String LIT_ACCESSTYPE = "accesstype";
    protected static final String LIT_GRANTEEID = "granteeid";
    protected static final String LIT_GRANTEETYPE = "granteetype";
    protected static final String LIT_SECURITYPOLICYID = "securitypolicyid";
    protected static final String LIT_SECURITYPOLICYNAME = "securitypolicyname";
    private Document document;
    private String documentXml;
    private String pTemplVersion;
    private boolean isSourceDependent;
    private String styleTemplateId;
    private String outputFolderId;
    private String outputFolderName;
    private short newPublishApplyPropertiesFrom;
    private short newPublishApplySecurityFrom;
    private short versionableRepublishType;
    private short nonversionableRepublishType;
    private short republishApplyPropertiesFrom;
    private short republishApplySecurityFrom;
    private short republishApplyEventActionFrom;
    private short republishEventActionFrom;
    private String applyPropertiesClassKey;
    private boolean applyPropertiesClassKeyIsNameOrId;
    private ArrayList propertiesList;
    private ArrayList permissionsList;
    private String pubEventActionClassKey;
    private boolean pubEventActionClassKeyIsNameOrId;
    private String repubEventActionClassKey;
    private boolean repubEventActionClassKeyIsNameOrId;
    private String securityPolicyClassKey;
    private boolean securityPolicyClassKeyIsNameOrId;

    public PublishTemplateContentConverter(FileInputStream fileInputStream) throws Exception {
        this(new InputSource(fileInputStream));
    }

    public PublishTemplateContentConverter(InputStream inputStream) throws Exception {
        this(new InputSource(inputStream));
    }

    public PublishTemplateContentConverter(String inputString) throws Exception {
        this(new InputSource(new StringReader(inputString)));
    }

    public PublishTemplateContentConverter(InputSource inputSource) throws Exception {
        this.initWithExistingXML(inputSource);
    }

    public PublishTemplateContentConverter() {
        this.initNew();
    }

    public String getPublishTemplateVersion() {
        return this.pTemplVersion;
    }

    public boolean getIsSourceDependent() {
        return this.isSourceDependent;
    }

    public void setIsSourceDependent(boolean val) {
        this.isSourceDependent = val;
        this.documentXml = null;
    }

    public String getStyleTemplateId() {
        return this.styleTemplateId;
    }

    public void setStyleTemplateId(String id) {
        this.styleTemplateId = id;
        this.documentXml = null;
    }

    public String getOutputFolderId() {
        return this.outputFolderId;
    }

    public String getOutputFolderName() {
        return this.outputFolderName;
    }

    public void setOutputFolderId(String id) {
        this.outputFolderId = id;
        this.documentXml = null;
    }

    public short getNewPublishApplyPropertiesFrom() {
        return this.newPublishApplyPropertiesFrom;
    }

    public void setNewPublishApplyPropertiesFrom(short applyFrom) {
        this.newPublishApplyPropertiesFrom = applyFrom;
        this.documentXml = null;
    }

    public NameOrId getApplyPropertiesClassKey() {
        return this.getApplyPropertiesClassKey(null);
    }

    public NameOrId getApplyPropertiesClassKey(NameOrId nameOrId) {
        if (nameOrId == null) {
            nameOrId = new NameOrId();
        }
        nameOrId.key = this.applyPropertiesClassKey;
        nameOrId.isNameOrId = this.applyPropertiesClassKeyIsNameOrId;
        return nameOrId;
    }

    public void setApplyPropertiesClassKey(String key, boolean isNameOrId) {
        this.applyPropertiesClassKey = key;
        this.applyPropertiesClassKeyIsNameOrId = isNameOrId;
        this.documentXml = null;
    }

    public int getApplyPropertiesCount() {
        if (this.propertiesList != null) {
            return this.propertiesList.size();
        }
        return 0;
    }

    public NameOrId getApplyPropertyKey(int index) {
        return this.getApplyPropertyKey(index, null);
    }

    public NameOrId getApplyPropertyKey(int index, NameOrId nameOrId) {
        if (nameOrId == null) {
            nameOrId = new NameOrId();
        }
        if (this.propertiesList == null || index >= this.propertiesList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PropInfo info = (PropInfo)this.propertiesList.get(index);
        nameOrId.key = info.key;
        nameOrId.isNameOrId = info.isNameOrId;
        return nameOrId;
    }

    public String getApplyPropertyValue(int index) {
        if (this.propertiesList == null || index >= this.propertiesList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PropInfo info = (PropInfo)this.propertiesList.get(index);
        if (info.value instanceof String || info.value == null) {
            return (String)info.value;
        }
        System.out.println("Possible wrong usage: PublishTemplateContentConverter.getApplyPropertyValue returning probably multi-val item as single value.");
        return info.value.toString();
    }

    public NameOrId getPubEventActionClassKey(NameOrId nameOrId) {
        if (nameOrId == null) {
            nameOrId = new NameOrId();
        }
        nameOrId.key = this.pubEventActionClassKey;
        nameOrId.isNameOrId = this.pubEventActionClassKeyIsNameOrId;
        return nameOrId;
    }

    public void setPubEventActionClassKey(String key, boolean isNameOrId) {
        this.pubEventActionClassKey = key;
        this.pubEventActionClassKeyIsNameOrId = isNameOrId;
        this.documentXml = null;
    }

    public NameOrId getRepubEventActionClassKey(NameOrId nameOrId) {
        if (nameOrId == null) {
            nameOrId = new NameOrId();
        }
        nameOrId.key = this.repubEventActionClassKey;
        nameOrId.isNameOrId = this.repubEventActionClassKeyIsNameOrId;
        return nameOrId;
    }

    public void setRepubEventActionClassKey(String key, boolean isNameOrId) {
        this.repubEventActionClassKey = key;
        this.repubEventActionClassKeyIsNameOrId = isNameOrId;
        this.documentXml = null;
    }

    public NameOrId getSecurityPolicyClassKey(NameOrId nameOrId) {
        if (nameOrId == null) {
            nameOrId = new NameOrId();
        }
        nameOrId.key = this.securityPolicyClassKey;
        nameOrId.isNameOrId = this.securityPolicyClassKeyIsNameOrId;
        return nameOrId;
    }

    public void setSecurityPolicyClassKey(String key, boolean isNameOrId) {
        this.securityPolicyClassKey = key;
        this.securityPolicyClassKeyIsNameOrId = isNameOrId;
        this.documentXml = null;
    }

    public boolean isApplyPropertyMultiValue(int index) {
        if (this.propertiesList == null || index >= this.propertiesList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        boolean isMultiValue = false;
        PropInfo info = (PropInfo)this.propertiesList.get(index);
        if (info.value instanceof List) {
            isMultiValue = true;
        }
        return isMultiValue;
    }

    public int getApplyPropertyMultiValueCount(int index) {
        if (this.propertiesList == null || index >= this.propertiesList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        int multiValueCount = 0;
        PropInfo info = (PropInfo)this.propertiesList.get(index);
        if (info.value instanceof List) {
            multiValueCount = ((List)info.value).size();
        }
        return multiValueCount;
    }

    public String getApplyPropertyMultiValueItem(int index, int mvindex) {
        if (this.propertiesList == null || index >= this.propertiesList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PropInfo info = (PropInfo)this.propertiesList.get(index);
        String mvitem = null;
        if (info.value instanceof List) {
            List mvitems = (List)info.value;
            if (mvindex >= 0 && mvindex < mvitems.size()) {
                mvitem = (String)mvitems.get(mvindex);
            }
        }
        if (mvitem == null) {
            String errmsg = "Unexpected: Invalid multi-value index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        return mvitem;
    }

    public void clearApplyProperties() {
        this.propertiesList = null;
        this.documentXml = null;
    }

    public void addApplyProperty(String propKey, boolean keyIsNameOrId, String val) {
        if (this.propertiesList == null) {
            this.propertiesList = new ArrayList();
        }
        this.propertiesList.add(new PropInfo(propKey, keyIsNameOrId, val));
        this.documentXml = null;
    }

    public void addMultiValueApplyProperty(String propKey, boolean keyIsNameOrId) {
        if (this.propertiesList == null) {
            this.propertiesList = new ArrayList();
        }
        this.propertiesList.add(new PropInfo(propKey, keyIsNameOrId, new ArrayList()));
        this.documentXml = null;
    }

    public void addApplyPropertyMultiValueItem(int index, String mvval) {
        if (this.propertiesList == null || index >= this.propertiesList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PropInfo info = (PropInfo)this.propertiesList.get(index);
        if (!(info.value instanceof List)) {
            throw new RuntimeException("Unexpected: property doesn't have multiple values!");
        }
        List mvitems = (List)info.value;
        mvitems.add(mvval);
        this.documentXml = null;
    }

    public short getNewPublishApplySecurityFrom() {
        return this.newPublishApplySecurityFrom;
    }

    public void setNewPublishApplySecurityFrom(short val) {
        this.newPublishApplySecurityFrom = val;
        this.documentXml = null;
    }

    public int getApplySecurityPermissionCount() {
        if (this.permissionsList != null) {
            return this.permissionsList.size();
        }
        return 0;
    }

    public String getApplySecurityPermissionGranteeName(int index) {
        if (this.permissionsList == null || index >= this.permissionsList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PermInfo info = (PermInfo)this.permissionsList.get(index);
        return info.granteeName;
    }

    public String getApplySecurityPermissionSID(int index) {
        if (this.permissionsList == null || index >= this.permissionsList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PermInfo info = (PermInfo)this.permissionsList.get(index);
        return info.SID;
    }

    public short getApplySecurityPermissionGranteeType(int index) {
        if (this.permissionsList == null || index >= this.permissionsList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PermInfo info = (PermInfo)this.permissionsList.get(index);
        return info.granteeType;
    }

    public int getApplySecurityPermissionAccess(int index) {
        if (this.permissionsList == null || index >= this.permissionsList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PermInfo info = (PermInfo)this.permissionsList.get(index);
        return info.access;
    }

    public short getApplySecurityPermissionAccessType(int index) {
        if (this.permissionsList == null || index >= this.permissionsList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PermInfo info = (PermInfo)this.permissionsList.get(index);
        return info.accessType;
    }

    public void setApplySecurityPermissionGranteeName(String granteeName, int index) {
        if (this.permissionsList == null || index >= this.permissionsList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PermInfo info = (PermInfo)this.permissionsList.get(index);
        info.granteeName = granteeName;
    }

    public void setApplySecurityPermissionSID(String SID, int index) {
        if (this.permissionsList == null || index >= this.permissionsList.size() || index < 0) {
            String errmsg = "Unexpected: Invalid index!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        PermInfo info = (PermInfo)this.permissionsList.get(index);
        info.SID = SID;
    }

    public void clearApplySecurityPermissions() {
        this.permissionsList = null;
        this.documentXml = null;
    }

    public void addApplySecurityPermission(String granteeName, short granteeType, int access, short accessType) {
        if (this.permissionsList == null) {
            this.permissionsList = new ArrayList();
        }
        this.permissionsList.add(new PermInfo(granteeName, null, granteeType, access, accessType));
        this.documentXml = null;
    }

    public short getVersionableRepublishType() {
        return this.versionableRepublishType;
    }

    public void setVersionableRepublishType(short val) {
        this.versionableRepublishType = val;
        this.documentXml = null;
    }

    public short getNonversionableRepublishType() {
        return this.nonversionableRepublishType;
    }

    public void setNonversionableRepublishType(short val) {
        this.nonversionableRepublishType = val;
        this.documentXml = null;
    }

    public short getRepublishApplyPropertiesFrom() {
        return this.republishApplyPropertiesFrom;
    }

    public void setRepublishApplyPropertiesFrom(short val) {
        this.republishApplyPropertiesFrom = val;
        this.documentXml = null;
    }

    public short getRepublishApplySecurityFrom() {
        return this.republishApplySecurityFrom;
    }

    public void setRepublishApplySecurityFrom(short val) {
        this.republishApplySecurityFrom = val;
        this.documentXml = null;
    }

    public short getRepublishEventActionFrom() {
        return this.republishEventActionFrom;
    }

    public void setRepublishEventActionFrom(short val) {
        this.republishEventActionFrom = val;
        this.documentXml = null;
    }

    public String toString() {
        try {
            if (this.documentXml == null) {
                this.rewriteDocument();
            }
            return this.documentXml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void initWithExistingXML(InputSource inputSource) throws Exception {
        String val;
        String val2;
        Element propertiesEl;
        NodeList propertyNodes;
        String txtVal;
        this.document = WcmXMLUtil.getDocumentFromInputSource(inputSource);
        Element rootNode = this.document.getDocumentElement();
        if (rootNode.getNodeName().compareToIgnoreCase(LIT_ROOT) != 0) {
            String errmsg = "XML document doesn't have correct root element!";
            System.out.println(errmsg);
            throw new RuntimeException(errmsg);
        }
        NodeList topLevelNodes = rootNode.getChildNodes();
        Node pTemplVersionNode = this.getNodeNamed(topLevelNodes, LIT_VERSION);
        if (pTemplVersionNode != null) {
            txtVal = this.getNodeTextValue(pTemplVersionNode);
            this.pTemplVersion = txtVal != null ? txtVal.trim() : null;
        }
        Node newInstructionsNode = this.getNodeNamed(topLevelNodes, LIT_NEWINSTRUCTIONS);
        NodeList newInstructionsChildNodes = newInstructionsNode.getChildNodes();
        this.isSourceDependent = true;
        Node isSourceDependentNode = this.getNodeNamed(newInstructionsChildNodes, LIT_ISSOURCEDEPENDENT);
        if (isSourceDependentNode != null && (txtVal = this.getNodeTextValue(isSourceDependentNode)) != null) {
            txtVal = txtVal.trim();
            Boolean boolVal = Boolean.valueOf(txtVal);
            this.isSourceDependent = boolVal;
        }
        this.styleTemplateId = null;
        Node styleTemplateIdNode = this.getNodeNamed(newInstructionsChildNodes, LIT_STYLETEMPLATEID);
        if (styleTemplateIdNode != null && (txtVal = this.getNodeTextValue(styleTemplateIdNode)) != null) {
            this.styleTemplateId = txtVal.trim();
        }
        this.pubEventActionClassKey = null;
        this.pubEventActionClassKeyIsNameOrId = false;
        Node eventActionNode = this.getNodeNamed(newInstructionsChildNodes, LIT_EVENTACTIONID);
        if (eventActionNode == null && (eventActionNode = this.getNodeNamed(newInstructionsChildNodes, LIT_EVENTACTIONNAME)) != null) {
            this.pubEventActionClassKeyIsNameOrId = true;
        }
        if (eventActionNode != null) {
            this.pubEventActionClassKey = this.getNodeTextValue(eventActionNode);
            if (this.pubEventActionClassKey != null) {
                this.pubEventActionClassKey = this.pubEventActionClassKey.trim();
            }
        }
        this.outputFolderId = null;
        Node outputFolderIdNode = this.getNodeNamed(newInstructionsChildNodes, LIT_OUTPUTFOLDERID);
        if (outputFolderIdNode != null && (txtVal = this.getNodeTextValue(outputFolderIdNode)) != null) {
            this.outputFolderId = txtVal.trim();
        }
        this.outputFolderName = null;
        Node outputFolderNameNode = this.getNodeNamed(newInstructionsChildNodes, LIT_OUTPUTFOLDERNAME);
        if (outputFolderNameNode != null && (txtVal = this.getNodeTextValue(outputFolderNameNode)) != null) {
            this.outputFolderName = txtVal.trim();
        }
        Node applyPropertiesNode = this.getNodeNamed(newInstructionsChildNodes, LIT_APPLYPROPERTIES);
        NodeList applyPropertiesChildNodes = applyPropertiesNode.getChildNodes();
        this.newPublishApplyPropertiesFrom = 0;
        Node applyFromNode = this.getNodeNamed(applyPropertiesChildNodes, LIT_FROM);
        if (applyFromNode != null && (txtVal = this.getNodeTextValue(applyFromNode)) != null) {
            String val3 = txtVal.trim();
            if (val3.compareToIgnoreCase(LIT_SOURCE) == 0) {
                this.newPublishApplyPropertiesFrom = 1;
            } else {
                throw new RuntimeException("Unexpected: Invalid literal in XML for new publish ApplyProperties from!");
            }
        }
        this.applyPropertiesClassKey = null;
        this.applyPropertiesClassKeyIsNameOrId = true;
        Node classKeyNode = this.getNodeNamed(applyPropertiesChildNodes, LIT_CLASSDESCRIPTIONNAME);
        if (classKeyNode == null && (classKeyNode = this.getNodeNamed(applyPropertiesChildNodes, LIT_CLASSDESCRIPTIONID)) != null) {
            this.applyPropertiesClassKeyIsNameOrId = false;
        }
        if (classKeyNode != null) {
            this.applyPropertiesClassKey = this.getNodeTextValue(classKeyNode);
            if (this.applyPropertiesClassKey != null) {
                this.applyPropertiesClassKey = this.applyPropertiesClassKey.trim();
            }
        }
        this.propertiesList = null;
        Node propsNode = this.getNodeNamed(applyPropertiesChildNodes, LIT_PROPERTIES);
        if (propsNode != null && (propertyNodes = (propertiesEl = (Element)propsNode).getElementsByTagName(LIT_PROPERTY)) != null) {
            this.propertiesList = new ArrayList();
            int numProps = propertyNodes.getLength();
            for (int iProp = 0; iProp < numProps; ++iProp) {
                String key = null;
                boolean isNameOrId = true;
                Node propNode = propertyNodes.item(iProp);
                NodeList propChildNodes = propNode.getChildNodes();
                Node propKeyNode = this.getNodeNamed(propChildNodes, LIT_NAME);
                if (propKeyNode == null && (propKeyNode = this.getNodeNamed(propChildNodes, LIT_ID)) != null) {
                    isNameOrId = false;
                }
                if (propKeyNode != null && (key = this.getNodeTextValue(propKeyNode)) != null) {
                    key = key.trim();
                }
                Object val4 = null;
                Node valueNode = this.getNodeNamed(propChildNodes, LIT_VALUE);
                if (valueNode != null) {
                    val4 = this.getNodeTextValue(valueNode);
                } else {
                    Node valuesNode = this.getNodeNamed(propChildNodes, LIT_VALUES);
                    if (valuesNode != null) {
                        Element valuesEl = (Element)valuesNode;
                        NodeList valueNodes = valuesEl.getElementsByTagName(LIT_VALUE);
                        int multiValCount = valueNodes.getLength();
                        ArrayList<String> valuesList = new ArrayList<String>();
                        for (int iMV = 0; iMV < multiValCount; ++iMV) {
                            Node valNode = valueNodes.item(iMV);
                            String mvItem = this.getNodeTextValue(valNode);
                            if (mvItem == null) continue;
                            valuesList.add(mvItem);
                        }
                        val4 = valuesList;
                    }
                }
                this.propertiesList.add(new PropInfo(key, isNameOrId, val4));
            }
        }
        this.initSecurityToApplyInfo(newInstructionsChildNodes);
        Node republishInstructionsNode = this.getNodeNamed(topLevelNodes, LIT_REPUBLISHINSTRUCTIONS);
        NodeList republishInstructionsChildNodes = republishInstructionsNode.getChildNodes();
        this.versionableRepublishType = 0;
        Node versionableRepublishTypeNode = this.getNodeNamed(republishInstructionsChildNodes, LIT_VERSIONABLEREPUBLISHTYPE);
        if (versionableRepublishTypeNode != null && (val2 = this.getNodeTextValue(versionableRepublishTypeNode)) != null) {
            if ((val2 = val2.trim()).compareToIgnoreCase(LIT_VERSIONANDKEEP) == 0) {
                this.versionableRepublishType = 0;
            } else if (val2.compareToIgnoreCase(LIT_VERSIONANDREMOVE) == 0) {
                this.versionableRepublishType = 1;
            } else if (val2.compareToIgnoreCase(LIT_ADDANDKEEP) == 0) {
                this.versionableRepublishType = (short)2;
            } else if (val2.compareToIgnoreCase(LIT_ADDANDREMOVE) == 0) {
                this.versionableRepublishType = (short)3;
            } else {
                throw new RuntimeException("Unexpected: Invalid literal in XML for versionablerepublishtype!");
            }
        }
        this.nonversionableRepublishType = (short)2;
        Node nonversionableRepublishTypeNode = this.getNodeNamed(republishInstructionsChildNodes, LIT_NONVERSIONABLEREPUBLISHTYPE);
        if (nonversionableRepublishTypeNode != null && (val = this.getNodeTextValue(nonversionableRepublishTypeNode)) != null) {
            if ((val = val.trim()).compareToIgnoreCase(LIT_ADDANDKEEP) == 0) {
                this.nonversionableRepublishType = (short)2;
            } else if (val.compareToIgnoreCase(LIT_ADDANDREMOVE) == 0) {
                this.nonversionableRepublishType = (short)3;
            } else {
                throw new RuntimeException("Unexpected: Invalid literal in XML for nonversionablerepublishtype!");
            }
        }
        this.republishApplyPropertiesFrom = (short)3;
        applyFromNode = this.getNodeNamed(republishInstructionsChildNodes, LIT_APPLYPROPERTIESFROM);
        if (applyFromNode != null && (val = this.getNodeTextValue(applyFromNode)) != null) {
            if ((val = val.trim()).compareToIgnoreCase(LIT_DESTINATION) == 0) {
                this.republishApplyPropertiesFrom = (short)3;
            } else if (val.compareToIgnoreCase(LIT_SAMEASPUBLISH) == 0) {
                this.republishApplyPropertiesFrom = (short)5;
            } else {
                throw new RuntimeException("Unexpected: Invalid literal in XML for republish applypropertiesfrom!");
            }
        }
        this.republishApplySecurityFrom = (short)3;
        applyFromNode = this.getNodeNamed(republishInstructionsChildNodes, LIT_APPLYSECURITYFROM);
        if (applyFromNode != null && (val = this.getNodeTextValue(applyFromNode)) != null) {
            if ((val = val.trim()).compareToIgnoreCase(LIT_DESTINATION) == 0) {
                this.republishApplySecurityFrom = (short)3;
            } else if (val.compareToIgnoreCase(LIT_SAMEASPUBLISH) == 0) {
                this.republishApplySecurityFrom = (short)5;
            } else {
                throw new RuntimeException("Unexpected: Invalid literal in XML for republish applysecurityfrom!");
            }
        }
        this.repubEventActionClassKey = null;
        this.repubEventActionClassKeyIsNameOrId = false;
        eventActionNode = this.getNodeNamed(republishInstructionsChildNodes, LIT_EVENTACTIONID);
        if (eventActionNode == null && (eventActionNode = this.getNodeNamed(republishInstructionsChildNodes, LIT_EVENTACTIONNAME)) != null) {
            this.repubEventActionClassKeyIsNameOrId = true;
        }
        if (eventActionNode != null) {
            this.repubEventActionClassKey = this.getNodeTextValue(eventActionNode);
            if (this.repubEventActionClassKey != null) {
                this.repubEventActionClassKey = this.repubEventActionClassKey.trim();
                this.republishEventActionFrom = this.repubEventActionClassKey.length() == 0 ? (short)1 : (short)2;
            } else {
                this.republishEventActionFrom = 1;
            }
        }
        this.documentXml = null;
    }

    private void initSecurityToApplyInfo(NodeList newInstructionsChildNodes) {
        Node applySecurityNode = this.getNodeNamed(newInstructionsChildNodes, LIT_APPLYSECURITY);
        NodeList applySecurityChildNodes = applySecurityNode.getChildNodes();
        this.initSecurityToApplyOption(applySecurityChildNodes);
        this.initSecurityPermissions(applySecurityChildNodes);
        this.initSecurityPolicy(applySecurityChildNodes);
    }

    private void initSecurityToApplyOption(NodeList applySecurityChildNodes) {
        String val;
        this.newPublishApplySecurityFrom = 0;
        Node applyFromNode = this.getNodeNamed(applySecurityChildNodes, LIT_FROM);
        if (applyFromNode != null && (val = this.getNodeTextValue(applyFromNode)) != null) {
            if ((val = val.trim()).equalsIgnoreCase(LIT_SOURCE)) {
                this.newPublishApplySecurityFrom = 1;
            } else if (val.equalsIgnoreCase(LIT_OUTPUTFOLDER)) {
                this.newPublishApplySecurityFrom = (short)2;
            } else if (val.equalsIgnoreCase(LIT_DEFAULT) || val.equalsIgnoreCase(LIT_CLASSDEFAULT)) {
                this.newPublishApplySecurityFrom = (short)4;
            } else {
                throw new RuntimeException("Unexpected: Invalid literal in XML for new publish ApplySecurity from!");
            }
        }
    }

    private void initSecurityPolicy(NodeList applySecurityChildNodes) {
        this.securityPolicyClassKey = null;
        this.securityPolicyClassKeyIsNameOrId = false;
        Node securityPolicyNode = this.getNodeNamed(applySecurityChildNodes, LIT_SECURITYPOLICYNAME);
        if (securityPolicyNode == null && (securityPolicyNode = this.getNodeNamed(applySecurityChildNodes, LIT_SECURITYPOLICYID)) != null) {
            this.securityPolicyClassKeyIsNameOrId = true;
        }
        if (securityPolicyNode != null) {
            this.securityPolicyClassKey = this.getNodeTextValue(securityPolicyNode);
            if (this.securityPolicyClassKey != null) {
                this.securityPolicyClassKey = this.securityPolicyClassKey.trim();
            }
        }
    }

    private void initSecurityPermissions(NodeList applySecurityChildNodes) {
        Element permissionsEl;
        NodeList permissionNodes;
        String txtVal = null;
        Node permissionsNode = this.getNodeNamed(applySecurityChildNodes, LIT_PERMISSIONS);
        if (permissionsNode != null && (permissionNodes = (permissionsEl = (Element)permissionsNode).getElementsByTagName(LIT_PERMISSION)) != null) {
            this.permissionsList = new ArrayList();
            int numPerms = permissionNodes.getLength();
            for (int iPerm = 0; iPerm < numPerms; ++iPerm) {
                Node permNode = permissionNodes.item(iPerm);
                NodeList permChildNodes = permNode.getChildNodes();
                String SID = null;
                Node granteeNameNode = this.getNodeNamed(permChildNodes, LIT_GRANTEEID);
                if (granteeNameNode != null && (SID = this.getNodeTextValue(granteeNameNode)) != null) {
                    SID = SID.trim();
                }
                short granteeType = 0;
                Node granteeTypeNode = this.getNodeNamed(permChildNodes, LIT_GRANTEETYPE);
                if (granteeTypeNode != null && (txtVal = this.getNodeTextValue(granteeTypeNode)) != null) {
                    txtVal = txtVal.trim();
                    granteeType = Short.parseShort(txtVal);
                }
                int access = 0;
                Node accessNode = this.getNodeNamed(permChildNodes, LIT_ACCESS);
                if (accessNode != null && (txtVal = this.getNodeTextValue(accessNode)) != null) {
                    txtVal = txtVal.trim();
                    access = Integer.parseInt(txtVal);
                }
                short accessType = 0;
                Node accessTypeNode = this.getNodeNamed(permChildNodes, LIT_ACCESSTYPE);
                if (accessTypeNode != null && (txtVal = this.getNodeTextValue(accessTypeNode)) != null) {
                    txtVal = txtVal.trim();
                    accessType = Short.parseShort(txtVal);
                }
                this.permissionsList.add(new PermInfo(null, SID, granteeType, access, accessType));
            }
        }
    }

    protected void initNew() {
        try {
            this.document = WcmXMLUtil.getNewDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.documentXml = null;
        this.pTemplVersion = CURRENTVERSION;
        this.isSourceDependent = true;
        this.styleTemplateId = null;
        this.outputFolderId = null;
        this.outputFolderName = null;
        this.newPublishApplyPropertiesFrom = 1;
        this.propertiesList = null;
        this.newPublishApplySecurityFrom = (short)2;
        this.permissionsList = null;
        this.versionableRepublishType = 0;
        this.nonversionableRepublishType = (short)2;
        this.republishApplyPropertiesFrom = (short)3;
        this.republishApplySecurityFrom = (short)3;
        this.republishEventActionFrom = 0;
        this.applyPropertiesClassKeyIsNameOrId = true;
        this.pubEventActionClassKeyIsNameOrId = false;
        this.repubEventActionClassKeyIsNameOrId = false;
        this.securityPolicyClassKeyIsNameOrId = false;
    }

    protected Node appendElementTextValue(Element el, String txt) {
        WcmXMLEncode.XmlEncodeResult result = WcmXMLEncode.encodeForXml(txt, null);
        if (result.encoding == 1) {
            el.setAttribute(ATTR_ENCODING, ENCODING_BASE64);
        }
        Text txtNode = this.document.createTextNode(result.outString);
        el.appendChild(txtNode);
        return txtNode;
    }

    protected String getNodeTextValue(Node n) {
        Element el;
        String enc;
        String txtVal = null;
        Node txtNode = this.getFirstNodeOfType(n.getChildNodes(), (short)3);
        if (txtNode != null && (txtVal = txtNode.getNodeValue()) != null && n instanceof Element && (enc = (el = (Element)n).getAttribute(ATTR_ENCODING)) != null && enc.compareToIgnoreCase(ENCODING_BASE64) == 0) {
            try {
                txtVal = WcmXMLEncode.decodeFromXml(1, txtVal);
            }
            catch (WcmXMLEncode.XmlDecodeException ex) {
                System.out.println("PublishTemplateContentConverter.getNodeTextValue couldn't decode base64 text!");
                System.out.println("Error generated: " + ex.getMessage());
                System.out.println("Using non-decoded text.");
            }
        }
        return txtVal;
    }

    protected Node createInterNodePrettyTextNode(Document doc) {
        Text n = doc.createTextNode("\r\n");
        return n;
    }

    protected void rewriteDocument() throws Exception {
        if (this.documentXml == null) {
            String val;
            Element rootNode = this.document.getDocumentElement();
            if (rootNode != null) {
                this.document.removeChild(rootNode);
            }
            rootNode = this.document.createElement(LIT_ROOT);
            rootNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            if (this.pTemplVersion != null) {
                this.pTemplVersion = CURRENTVERSION;
                Element versionEl = this.document.createElement(LIT_VERSION);
                this.appendElementTextValue(versionEl, this.pTemplVersion);
                rootNode.appendChild(versionEl);
                rootNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            }
            Element newInstructionsNode = this.document.createElement(LIT_NEWINSTRUCTIONS);
            newInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            Element isSourceDependentEl = this.document.createElement(LIT_ISSOURCEDEPENDENT);
            this.appendElementTextValue(isSourceDependentEl, new Boolean(this.isSourceDependent).toString());
            newInstructionsNode.appendChild(isSourceDependentEl);
            newInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            if (this.styleTemplateId != null) {
                Element styleTemplateIdEl = this.document.createElement(LIT_STYLETEMPLATEID);
                this.appendElementTextValue(styleTemplateIdEl, this.styleTemplateId);
                newInstructionsNode.appendChild(styleTemplateIdEl);
                newInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            }
            if (this.pubEventActionClassKey != null) {
                Element eventActionEl = null;
                eventActionEl = this.pubEventActionClassKeyIsNameOrId ? this.document.createElement(LIT_EVENTACTIONNAME) : this.document.createElement(LIT_EVENTACTIONID);
                this.appendElementTextValue(eventActionEl, this.pubEventActionClassKey);
                newInstructionsNode.appendChild(eventActionEl);
                newInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            }
            if (this.outputFolderId != null) {
                Element outputFolderIdEl = this.document.createElement(LIT_OUTPUTFOLDERID);
                this.appendElementTextValue(outputFolderIdEl, this.outputFolderId);
                newInstructionsNode.appendChild(outputFolderIdEl);
                newInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            }
            Element applyPropertiesNode = this.document.createElement(LIT_APPLYPROPERTIES);
            applyPropertiesNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            if (this.newPublishApplyPropertiesFrom != 0) {
                String val2;
                Element fromEl = this.document.createElement(LIT_FROM);
                switch (this.newPublishApplyPropertiesFrom) {
                    case 1: {
                        val2 = LIT_SOURCE;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected: invalid value for newPublishApplyPropertiesFrom!");
                    }
                }
                this.appendElementTextValue(fromEl, val2);
                applyPropertiesNode.appendChild(fromEl);
                applyPropertiesNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            } else {
                if (this.applyPropertiesClassKey != null) {
                    Element classKeyEl = this.applyPropertiesClassKeyIsNameOrId ? this.document.createElement(LIT_CLASSDESCRIPTIONNAME) : this.document.createElement(LIT_CLASSDESCRIPTIONID);
                    this.appendElementTextValue(classKeyEl, this.applyPropertiesClassKey);
                    applyPropertiesNode.appendChild(classKeyEl);
                    applyPropertiesNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                }
                Element propertiesNode = this.document.createElement(LIT_PROPERTIES);
                propertiesNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                if (this.propertiesList != null) {
                    for (PropInfo info : this.propertiesList) {
                        Element propNode = this.document.createElement(LIT_PROPERTY);
                        propNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                        Element keyEl = !info.isNameOrId ? this.document.createElement(LIT_ID) : this.document.createElement(LIT_NAME);
                        this.appendElementTextValue(keyEl, info.key);
                        propNode.appendChild(keyEl);
                        propNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                        if (info.value != null) {
                            Element valNode = null;
                            if (info.value instanceof String) {
                                WcmXMLEncode.XmlEncodeResult result = WcmXMLEncode.encodeForXml((String)info.value, null);
                                Element valEl = this.document.createElement(LIT_VALUE);
                                this.appendElementTextValue(valEl, (String)info.value);
                                valNode = valEl;
                            } else if (info.value instanceof List) {
                                Element valsNode = this.document.createElement(LIT_VALUES);
                                valsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                                for (String mvitem : (List)info.value) {
                                    if (mvitem == null) continue;
                                    Element mvItemEl = this.document.createElement(LIT_VALUE);
                                    this.appendElementTextValue(mvItemEl, mvitem);
                                    valsNode.appendChild(mvItemEl);
                                    valsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                                }
                                valNode = valsNode;
                            } else {
                                throw new RuntimeException("Unexpected: PublishTemplateContentConverter.rewriteDocument encountered value not String or List!");
                            }
                            if (valNode != null) {
                                propNode.appendChild(valNode);
                                propNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                            }
                        }
                        propertiesNode.appendChild(propNode);
                        propertiesNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                    }
                }
                applyPropertiesNode.appendChild(propertiesNode);
                applyPropertiesNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            }
            newInstructionsNode.appendChild(applyPropertiesNode);
            newInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            Element applySecurityNode = this.document.createElement(LIT_APPLYSECURITY);
            applySecurityNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            if (this.newPublishApplySecurityFrom != 0) {
                String val3;
                Element fromEl = this.document.createElement(LIT_FROM);
                switch (this.newPublishApplySecurityFrom) {
                    case 1: {
                        val3 = LIT_SOURCE;
                        break;
                    }
                    case 2: {
                        val3 = LIT_OUTPUTFOLDER;
                        break;
                    }
                    case 4: {
                        val3 = LIT_DEFAULT;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected: invalid value for newPublishApplySecurityFrom!");
                    }
                }
                this.appendElementTextValue(fromEl, val3);
                applySecurityNode.appendChild(fromEl);
                applySecurityNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            } else {
                this.writeSecurityPolicy(applySecurityNode);
                Element permissionsNode = this.document.createElement(LIT_PERMISSIONS);
                permissionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                if (this.permissionsList != null) {
                    for (PermInfo perminfo : this.permissionsList) {
                        if (perminfo.SID == null || perminfo.SID.length() == 0) continue;
                        Element permNode = this.document.createElement(LIT_PERMISSION);
                        permNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                        Element nameEl = this.document.createElement(LIT_GRANTEEID);
                        this.appendElementTextValue(nameEl, perminfo.SID);
                        permNode.appendChild(nameEl);
                        permNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                        Element granteeTypeEl = this.document.createElement(LIT_GRANTEETYPE);
                        this.appendElementTextValue(granteeTypeEl, Short.toString(perminfo.granteeType));
                        permNode.appendChild(granteeTypeEl);
                        permNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                        Element accessEl = this.document.createElement(LIT_ACCESS);
                        this.appendElementTextValue(accessEl, Integer.toString(perminfo.access));
                        permNode.appendChild(accessEl);
                        permNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                        Element accessTypeEl = this.document.createElement(LIT_ACCESSTYPE);
                        this.appendElementTextValue(accessTypeEl, Short.toString(perminfo.accessType));
                        permNode.appendChild(accessTypeEl);
                        permNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                        permissionsNode.appendChild(permNode);
                        permissionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
                    }
                }
                applySecurityNode.appendChild(permissionsNode);
                applySecurityNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            }
            newInstructionsNode.appendChild(applySecurityNode);
            newInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            rootNode.appendChild(newInstructionsNode);
            rootNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            Element republishInstructionsNode = this.document.createElement(LIT_REPUBLISHINSTRUCTIONS);
            republishInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            Element versRepubTypeEl = this.document.createElement(LIT_VERSIONABLEREPUBLISHTYPE);
            switch (this.versionableRepublishType) {
                case 0: {
                    val = LIT_VERSIONANDKEEP;
                    break;
                }
                case 1: {
                    val = LIT_VERSIONANDREMOVE;
                    break;
                }
                case 2: {
                    val = LIT_ADDANDKEEP;
                    break;
                }
                case 3: {
                    val = LIT_ADDANDREMOVE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected: invalid value for versionableRepublishType!");
                }
            }
            this.appendElementTextValue(versRepubTypeEl, val);
            republishInstructionsNode.appendChild(versRepubTypeEl);
            republishInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            Element nonversRepubTypeEl = this.document.createElement(LIT_NONVERSIONABLEREPUBLISHTYPE);
            switch (this.nonversionableRepublishType) {
                case 2: {
                    val = LIT_ADDANDKEEP;
                    break;
                }
                case 3: {
                    val = LIT_ADDANDREMOVE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected: invalid value for nonversionableRepublishType!");
                }
            }
            this.appendElementTextValue(nonversRepubTypeEl, val);
            republishInstructionsNode.appendChild(nonversRepubTypeEl);
            republishInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            Element repubApplyPropsFromEl = this.document.createElement(LIT_APPLYPROPERTIESFROM);
            switch (this.republishApplyPropertiesFrom) {
                case 3: {
                    val = LIT_DESTINATION;
                    break;
                }
                case 5: {
                    val = LIT_SAMEASPUBLISH;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected: invalid value for republishApplyPropertiesFrom!");
                }
            }
            this.appendElementTextValue(repubApplyPropsFromEl, val);
            republishInstructionsNode.appendChild(repubApplyPropsFromEl);
            republishInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            Element repubApplySecurityFromEl = this.document.createElement(LIT_APPLYSECURITYFROM);
            switch (this.republishApplySecurityFrom) {
                case 3: {
                    val = LIT_DESTINATION;
                    break;
                }
                case 5: {
                    val = LIT_SAMEASPUBLISH;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected: invalid value for republishApplyPropertiesFrom!");
                }
            }
            this.appendElementTextValue(repubApplySecurityFromEl, val);
            republishInstructionsNode.appendChild(repubApplySecurityFromEl);
            republishInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            if (this.repubEventActionClassKey != null) {
                Element eventActionIdEl = null;
                eventActionIdEl = this.repubEventActionClassKeyIsNameOrId ? this.document.createElement(LIT_EVENTACTIONNAME) : this.document.createElement(LIT_EVENTACTIONID);
                this.appendElementTextValue(eventActionIdEl, this.repubEventActionClassKey);
                republishInstructionsNode.appendChild(eventActionIdEl);
                republishInstructionsNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            }
            rootNode.appendChild(republishInstructionsNode);
            rootNode.appendChild(this.createInterNodePrettyTextNode(this.document));
            this.document.appendChild(rootNode);
            StringWriter xmlStringWriter = new StringWriter();
            WcmXMLUtil.writeXML(xmlStringWriter, (Node)rootNode);
            StringBuffer result = new StringBuffer();
            result.append("<?xml version=\"1.0\"?>\r\n");
            result.append(xmlStringWriter.toString());
            this.documentXml = result.toString();
        }
    }

    private void writeSecurityPolicy(Node applySecurityNode) {
        if (this.securityPolicyClassKey != null) {
            Element securityPolicyEl = null;
            securityPolicyEl = this.securityPolicyClassKeyIsNameOrId ? this.document.createElement(LIT_SECURITYPOLICYNAME) : this.document.createElement(LIT_SECURITYPOLICYID);
            this.appendElementTextValue(securityPolicyEl, this.securityPolicyClassKey);
            applySecurityNode.appendChild(securityPolicyEl);
            applySecurityNode.appendChild(this.createInterNodePrettyTextNode(this.document));
        }
    }

    protected Node getNodeNamed(NodeList nodeList, String name) {
        Node n = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n2 = nodeList.item(i);
                if (name.compareToIgnoreCase(n2.getNodeName()) != 0) continue;
                n = n2;
            }
        }
        return n;
    }

    protected Node getFirstNodeOfType(NodeList nodeList, short nodeType) {
        Node n = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n2 = nodeList.item(i);
                if (n2.getNodeType() != nodeType) continue;
                n = n2;
            }
        }
        return n;
    }

    public static void main(String[] args) throws Exception {
        String filename = null;
        if (args.length == 0) {
            System.out.println("No filename passed as argument, creating the default.");
        } else {
            filename = args[0];
        }
        try {
            int i;
            PublishTemplateContentConverter myPT;
            if (filename != null) {
                FileInputStream file = new FileInputStream(filename);
                myPT = new PublishTemplateContentConverter(file);
            } else {
                myPT = new PublishTemplateContentConverter();
            }
            PublishTemplateContentConverter.printInfoAboutTemplate(myPT);
            System.out.println("==========");
            System.out.println("Entire tree formatted:");
            System.out.println(myPT.toString());
            PublishTemplateContentConverter pt2 = new PublishTemplateContentConverter();
            pt2.setIsSourceDependent(myPT.getIsSourceDependent());
            pt2.setStyleTemplateId(myPT.getStyleTemplateId());
            pt2.setOutputFolderId(myPT.getOutputFolderId());
            short newPublishApplyPropertiesFrom = myPT.getNewPublishApplyPropertiesFrom();
            pt2.setNewPublishApplyPropertiesFrom(newPublishApplyPropertiesFrom);
            if (newPublishApplyPropertiesFrom == 0) {
                NameOrId nameOrId = myPT.getApplyPropertiesClassKey();
                if (nameOrId.key != null) {
                    pt2.setApplyPropertiesClassKey(nameOrId.key, nameOrId.isNameOrId);
                }
                pt2.clearApplyProperties();
                int propCount = myPT.getApplyPropertiesCount();
                for (i = 0; i < propCount; ++i) {
                    String val;
                    nameOrId = myPT.getApplyPropertyKey(i);
                    boolean isMV = myPT.isApplyPropertyMultiValue(i);
                    if (!isMV) {
                        val = myPT.getApplyPropertyValue(i);
                        pt2.addApplyProperty(nameOrId.key, nameOrId.isNameOrId, val);
                        continue;
                    }
                    pt2.addMultiValueApplyProperty(nameOrId.key, nameOrId.isNameOrId);
                    int mvcnt = myPT.getApplyPropertyMultiValueCount(i);
                    for (int j = 0; j < mvcnt; ++j) {
                        val = myPT.getApplyPropertyMultiValueItem(i, j);
                        pt2.addApplyPropertyMultiValueItem(i, val);
                    }
                }
            }
            short newPublishApplySecurityFrom = myPT.getNewPublishApplySecurityFrom();
            pt2.setNewPublishApplySecurityFrom(newPublishApplySecurityFrom);
            if (newPublishApplySecurityFrom == 0) {
                pt2.clearApplySecurityPermissions();
                int permCnt = myPT.getApplySecurityPermissionCount();
                for (i = 0; i < permCnt; ++i) {
                    String granteeName = myPT.getApplySecurityPermissionGranteeName(i);
                    short granteeType = myPT.getApplySecurityPermissionGranteeType(i);
                    int access = myPT.getApplySecurityPermissionAccess(i);
                    short accessType = myPT.getApplySecurityPermissionAccessType(i);
                    pt2.addApplySecurityPermission(granteeName, granteeType, access, accessType);
                }
            }
            pt2.setVersionableRepublishType(myPT.getVersionableRepublishType());
            pt2.setNonversionableRepublishType(myPT.getNonversionableRepublishType());
            pt2.setRepublishApplyPropertiesFrom(myPT.getRepublishApplyPropertiesFrom());
            pt2.setRepublishApplySecurityFrom(myPT.getRepublishApplySecurityFrom());
            System.out.println("==========");
            System.out.println("Info from copied template:");
            PublishTemplateContentConverter.printInfoAboutTemplate(pt2);
            System.out.println("==========");
            System.out.println("Entire tree of copied template formatted:");
            System.out.println(pt2.toString());
            System.out.println("==========");
            System.out.println("Printing the nodes...");
            PublishTemplateContentConverter.printFormattedNodeTree(1, myPT.document);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in PublishTemplateContentConverter main(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void printTemplateNodeTree(PublishTemplateContentConverter myPT) {
        if (myPT.documentXml == null) {
            myPT.toString();
        }
        PublishTemplateContentConverter.printFormattedNodeTree(1, myPT.document);
    }

    public static void printInfoAboutTemplate(PublishTemplateContentConverter myPT) {
        int i;
        System.out.println("Is source dependent: " + myPT.getIsSourceDependent());
        System.out.println("Style template ID: " + myPT.getStyleTemplateId());
        System.out.println("Output folder ID: " + myPT.getOutputFolderId());
        short applyPropsFrom = myPT.getNewPublishApplyPropertiesFrom();
        System.out.println("For new publish, apply properties from: " + applyPropsFrom);
        if (applyPropsFrom == 0) {
            NameOrId nameOrId = myPT.getApplyPropertiesClassKey();
            nameOrId.isNameOrId = true;
            if (true) {
                System.out.println("Class description name: " + nameOrId.key);
            } else {
                System.out.println("Class description ID: " + nameOrId.key);
            }
            int propCount = myPT.getApplyPropertiesCount();
            System.out.println("Number of properties: " + propCount);
            for (i = 0; i < propCount; ++i) {
                boolean isMultiVal = myPT.isApplyPropertyMultiValue(i);
                nameOrId = myPT.getApplyPropertyKey(i);
                String keyType = nameOrId.isNameOrId ? LIT_NAME : "ID";
                String propValue = !isMultiVal ? myPT.getApplyPropertyValue(i) : "<multiple values>";
                System.out.println("Property #" + i + ": key (" + keyType + ")=" + nameOrId.key + "; value=" + propValue);
                if (!isMultiVal) continue;
                int multiValCount = myPT.getApplyPropertyMultiValueCount(i);
                System.out.println("    Number of multi-values: " + multiValCount);
                for (int imv = 0; imv < multiValCount; ++imv) {
                    propValue = myPT.getApplyPropertyMultiValueItem(i, imv);
                    System.out.println("    Item #" + imv + "=" + propValue);
                }
            }
        }
        short applySecFrom = myPT.getNewPublishApplySecurityFrom();
        System.out.println("For new publish, apply security from: " + applySecFrom);
        if (applySecFrom == 0) {
            int permCount = myPT.getApplySecurityPermissionCount();
            System.out.println("Number of permissions: " + permCount);
            for (i = 0; i < permCount; ++i) {
                String granteeName = myPT.getApplySecurityPermissionGranteeName(i);
                short granteeType = myPT.getApplySecurityPermissionGranteeType(i);
                int access = myPT.getApplySecurityPermissionAccess(i);
                short accessType = myPT.getApplySecurityPermissionAccessType(i);
                System.out.println("Permission #" + i + ": grantee=" + granteeName + "; type=" + granteeType + "; access=" + access + "; type=" + accessType);
            }
        }
        short versRepubType = myPT.getVersionableRepublishType();
        System.out.println("Versionable republish type: " + versRepubType);
        short nonversRepubType = myPT.getNonversionableRepublishType();
        System.out.println("Non-versionable republish type: " + nonversRepubType);
        short repubApplyPropsFrom = myPT.getRepublishApplyPropertiesFrom();
        System.out.println("For a republish, apply properties from: " + repubApplyPropsFrom);
        short repubApplySecFrom = myPT.getRepublishApplySecurityFrom();
        System.out.println("For a republish, apply security from: " + repubApplySecFrom);
    }

    private static void printFormattedNodeTree(int level, Node n) {
        System.out.println("[===== Begin node level " + level + "]");
        System.out.println(PublishTemplateContentConverter.formatNode(n));
        NodeList nodeList = n.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n2 = nodeList.item(i);
            PublishTemplateContentConverter.printFormattedNodeTree(level + 1, n2);
        }
        System.out.println("[===== End node level " + level + "]");
    }

    private static String formatNode(Node n) {
        short nodeType = n.getNodeType();
        String formatted = null;
        if (nodeType == 3) {
            String nodeValue = n.getNodeValue();
            if (nodeValue.length() > 0) {
                formatted = new String("Text: '" + nodeValue + "'");
            }
        } else if (nodeType == 2) {
            formatted = new String("Attribute: " + n.getNodeName() + " = " + n.getNodeValue());
        } else if (nodeType == 1) {
            formatted = new String("Element: " + n.getNodeName() + "(value=" + n.getNodeValue() + ")");
            NamedNodeMap al = n.getAttributes();
            for (int i = 0; i < al.getLength(); ++i) {
                formatted = formatted + " [" + al.item(i).getNodeName() + "=" + al.item(i).getNodeValue() + "]";
            }
        } else {
            formatted = new String(n.getNodeName() + " (value=" + n.getNodeValue() + ") [nodeType=" + nodeType + "] ");
            switch (nodeType) {
                case 4: {
                    formatted = formatted + "CDATA_SECTION_NODE";
                    break;
                }
                case 8: {
                    formatted = formatted + "COMMENT_NODE";
                    break;
                }
                case 11: {
                    formatted = formatted + "DOCUMENT_FRAGMENT_NODE";
                    break;
                }
                case 9: {
                    formatted = formatted + "DOCUMENT_NODE";
                    break;
                }
                case 10: {
                    formatted = formatted + "DOCUMENT_TYPE_NODE";
                    break;
                }
                case 6: {
                    formatted = formatted + "ENTITY_NODE";
                    break;
                }
                case 5: {
                    formatted = formatted + "ENTITY_REFERENCE_NODE";
                    break;
                }
                case 12: {
                    formatted = formatted + "NOTATION_NODE";
                    break;
                }
                case 7: {
                    formatted = formatted + "PROCESSING_INSTRUCTION_NODE";
                }
            }
        }
        return formatted;
    }

    protected static class PermInfo {
        String SID;
        String granteeName;
        short granteeType;
        int access;
        short accessType;

        PermInfo(String granteeName, String SID, short granteeType, int access, short accessType) {
            this.granteeName = granteeName;
            this.SID = SID;
            this.granteeType = granteeType;
            this.access = access;
            this.accessType = accessType;
        }
    }

    protected static class PropInfo {
        String key;
        boolean isNameOrId;
        Object value;

        PropInfo(String key, boolean isNameOrId, Object value) {
            this.key = key;
            this.isNameOrId = isNameOrId;
            this.value = value;
        }
    }

    public static class NameOrId {
        public String key;
        public boolean isNameOrId;

        public NameOrId(String key, boolean isNameOrId) {
            this.key = key;
            this.isNameOrId = isNameOrId;
        }

        public NameOrId() {
            this.isNameOrId = true;
        }
    }
}

