import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

import com.telelogic.rhapsody.core.IRPApplication;
import com.telelogic.rhapsody.core.IRPTableLayout;
import com.telelogic.rhapsody.core.RhapsodyAppServer;

public class TableColumnMain {
	
	static Scanner userInput = new Scanner(System.in);

	public static void main(String[] args) {
		IRPApplication app = RhapsodyAppServer.getActiveRhapsodyApplication();
		if(app.getSelectedElement() instanceof IRPTableLayout)
		{
			IRPTableLayout aTableLayout = (IRPTableLayout)app.getSelectedElement();
			
			// a list of custom objects containing column name and context strings: lTableColumns.
			List<TempColumn> lTableColumns = new ArrayList<TempColumn>();
			
			// get current tablelayout name and context labels for each column, into a temp list lTableColumns
			for(int col=0; col<aTableLayout.getColumnCount();col++)
			{
				TempColumn aTmpCol = new TempColumn(aTableLayout.getColumnName(col),aTableLayout.getColumnContext(col));
				lTableColumns.add(aTmpCol);
				
			}
			
			printColumnSummary(lTableColumns);
			
			Integer firstColtoSwap = null;
			Integer secondColToSwap = null;
			try 
			{
				System.out.println("Enter first column to swap:");
				firstColtoSwap = Integer.valueOf(userInput.next());
				System.out.println("Enter second column to swap:");
				secondColToSwap = Integer.valueOf(userInput.next());
			}
			catch(Exception e) 
			{
				System.out.println("Unable to use this value: " + e.getMessage() + ". Exiting...");
				System.exit(1);
			}
			
			
			// swaps order of two column objects in temp list lTableColumns
			if(lTableColumns.size() > firstColtoSwap && lTableColumns.size() > secondColToSwap)
			{
				Collections.swap(lTableColumns, firstColtoSwap, secondColToSwap);
			}
			else 
			{
				System.out.println("Columns do not exist. Exiting...");
				System.exit(1);
			}
			
			
			// put all the names and context labels back into the tablelayout, effectively overwriting the whole lot with new list order.
			for(int col=0; col<aTableLayout.getColumnCount();col++)
			{
				aTableLayout.setColumnName(col, lTableColumns.get(col).getName());
				aTableLayout.setColumnContext(col, lTableColumns.get(col).getContext());
			}
			
			System.out.print("\n*** Columns " + firstColtoSwap + " and " + secondColToSwap + " swapped ***\n\n");
			printColumnSummary(lTableColumns);
			app.activeProject().save();
			
			
			
		}
		else 
		{
			System.out.println("Selected element must be TableLayout!");
		}
		
	}

	private static void printColumnSummary(List<TempColumn> pListColumns) {
		// print summary
		System.out.print(pListColumns.size() + " columns found: \n{\n");
		for(int col=0; col < pListColumns.size(); col++)
		{
			System.out.println("\t" + col + ". [" + pListColumns.get(col).getName() + "," + pListColumns.get(col).getContext() + "]");
		}
		System.out.println("}");
		
	}

}
