use Switch;

# Modification Date: 10/12/2018

our $Usage_Information_Message = "
Usage information\n
The script has a different behaviour depending on the command line parameter's value: 
'fix': The symbolic links are automatically created if needed
'preview': The commands that need to be manually executed are printed out
'revert': The symbolic links are removed and the original configuration is restored\n
For example: perl solve_gskit_incompatibility_SP_Domino.pl preview\n";

$os_name = $^O;

$arch = `uname -p`;
chomp $arch;

if( ($arch eq "s390") || ($arch eq "s390x") )
{
   $os_name = "zlinux";
}


switch ($os_name)
{
   case "aix"{aix_handle_m();}
   case "linux"{linux_handle_m();}
   case "zlinux"{zlinux_handle_m();}
}

our $Error_Parameters = "If a parameter is set, the only allowed parameter's values are:  
   'fix' to create symbolic links when needed
   'preview' to show the commands that need to be manually executed
   'revert' to remove the symbolic links and restore the original configuration\n
For example: perl solve_gskit_incompatibility_SP_Domino.pl preview\n
By default, if no parameter is set, the script's usage information is printed out\n";

our $Global_GSKIT8_Not_Found = "The command gsk8ver_64 wasn't found, please make sure to have GSKit 8 installed before running this script\n";
if(-e '/bin/gsk8capicmd_64')
{
   our $Version_GSKit_SP = `gsk8capicmd_64 -version | grep -i "productversion" | head -1 | sed 's/[^0-9.]*//g'`;
   chomp $Version_GSKit_SP;
   our $SP_GSKit_Version_Message = "Global GSKit installation detected: $Version_GSKit_SP\n";
}

our $Same_ICC_Version_Message = "IBM Spectrum Protect's ICC lib version is the same as IBM Domino's ICC lib version : Nothing to do\n";
our $Domino_ICC_Version_More_Recent_Message = "You must install a newer version of the IBM Spectrum Protect client\n";
our $SP_ICC_Version_More_Recent_Message = "The version of IBM Spectrum Protect's ICC lib is more recent than IBM Domino's, a symbolic link in IBM Domino's directory to IBM Spectrum Protect's ICC lib needs to be created\n";
our $Symbolic_Links_Created_Message = "The symbolic links were successfully created\n";
	
	
sub aix_handle_m
{
   our $AIX_Kernel = `oslevel`;
   chomp $AIX_Kernel;
   our $AIX_Message = "AIX $AIX_Kernel detected\n"; 

   our $Domino_ICC_Default_Path = "/opt/ibm/domino/notes/latest/ibmpow/libgsk8iccs_64.so"; 
   our $Domino_ICC_Default_Dir = "/opt/ibm/domino/notes/latest/ibmpow";
   our $SP_ICC_Default_Path = "/usr/opt/ibm/gsk8_64/lib64/libgsk8iccs_64.so";
   our $SP_ICC_Default_Dir = "/usr/opt/ibm/gsk8_64/lib64"; 

   our $Lib_Env_Var = 'LIBPATH';
}

sub linux_handle_m
{
   our $Linux_Kernel = `uname -sp`;
   chomp $Linux_Kernel;
   our $Linux_Message = "$Linux_Kernel detected\n";

   our $Domino_ICC_Default_Path = "/opt/ibm/domino/notes/latest/linux/libgsk8iccs_64.so"; 
   our $Domino_ICC_Default_Dir = "/opt/ibm/domino/notes/latest/linux";
   our $SP_ICC_Default_Path = "/usr/local/ibm/gsk8_64/lib64/libgsk8iccs_64.so";
   our $SP_ICC_Default_Dir = "/usr/local/ibm/gsk8_64/lib64";

   our $Lib_Env_Var = 'LD_LIBRARY_PATH';
}


sub zlinux_handle_m
{
   our $zLinux_Kernel = `uname -sp`;
   chomp $zLinux_Kernel;
   our $zLinux_Message = "$zLinux_Kernel detected\n";

   our $Domino_ICC_Default_Path = "/opt/ibm/domino/notes/latest/zlinux/libgsk8iccs_64.so"; 
   our $Domino_ICC_Default_Dir = "/opt/ibm/domino/notes/latest/zlinux";
   our $SP_ICC_Default_Path = "/usr/local/ibm/gsk8_64/lib64/libgsk8iccs_64.so";
   our $SP_ICC_Default_Dir = "/usr/local/ibm/gsk8_64/lib64";

   our $Lib_Env_Var = 'LD_LIBRARY_PATH';
}


if(-e '/bin/gsk8ver_64')
{	
   $ENV{$Lib_Env_Var} = $Domino_ICC_Default_Dir;
   our $Version_ICC_Domino = `gsk8ver_64 | sed -n '/libgsk8iccs_64.so/,/ProductVersion/p' | egrep 'ProductVersion' | sed 's/[^0-9.]*//g'`;
   chomp $Version_ICC_Domino;

   $ENV{$Lib_Env_Var} = $SP_ICC_Default_Dir;
   our $Version_ICC_SP = `gsk8ver_64 | sed -n '/libgsk8iccs_64.so/,/ProductVersion/p' | egrep 'ProductVersion' | sed 's/[^0-9.]*//g'`;
   chomp $Version_ICC_SP;
}

our $Domino_ICC_Not_Found_Message = "$Domino_ICC_Default_Path doesn't exist hence no GSKit ICC used by IBM Domino was found in this directory, there should not be any compatibility issue\n";
our $Domino_C_Folder_Not_Found_Message = "IBM Domino's C folder does not exist\n";
our $Domino_N_Folder_Not_Found_Message = "IBM Domino's N folder does not exist\n";

our $Domino_ICC_old_Not_Found_Message = "$Domino_ICC_Default_Path.old was not found, no changes were made\n";
our $Domino_C_old_Folder_Not_Found_Message = "The $Domino_ICC_Default_Dir/C_old folder was not found, no changes were made\n";
our $Domino_N_old_Folder_Not_Found_Message = "The $Domino_ICC_Default_Dir/N_old folder was not found, no changes were made\n";

our $Domino_ICC_Not_Symbolic_Link_Message = "$Domino_ICC_Default_Path is not a symbolic link, no changes were made\n";

our $Revert_Successful_Message = "The symbolic links were successfully removed, the original configuration was restored\n";

our $SP_ICC_Not_Found_Message = "No GSKit ICC used by IBM Spectrum Protect was found\n";
our $SP_C_Folder_Not_Found_Message = "IBM Spectrum Protect's C folder does not exist\n";
our $SP_N_Folder_Not_Found_Message = "IBM Spectrum Protect's N folder does not exist\n";

our $Domino_ICC_Lib_Version_Message = "Local ICC lib used by IBM Domino:
         Path: $Domino_ICC_Default_Path
         Name: libgsk8iccs_64.so 
         Version: $Version_ICC_Domino\n\n";

our $Domino_ICC_Lib_Symlink_Target_Path = readlink($Domino_ICC_Default_Path);
chomp $Domino_ICC_Lib_Symlink_Target_Path;
our $Domino_ICC_Lib_Symlink_Version_Message = "Local ICC lib used by IBM Domino:
         Path: $Domino_ICC_Default_Path
         Target Path: $Domino_ICC_Lib_Symlink_Target_Path
         Name: libgsk8iccs_64.so
         Version: $Version_ICC_Domino\n\n";

our $SP_ICC_Lib_Version_Message = "Global ICC lib used by IBM Spectrum Protect:
         Path: $SP_ICC_Default_Path
         Name: libgsk8iccs_64.so
         Version: $Version_ICC_SP\n\n";

our $Commands_To_Execute_Message = "The commands below need to be executed to create the required symbolic links:
   cd $Domino_ICC_Default_Dir
   mv libgsk8iccs_64.so libgsk8iccs_64.so.old
   mv C C_old
   mv N N_old
   ln -s $SP_ICC_Default_Path $Domino_ICC_Default_Path
   ln -s $SP_ICC_Default_Dir/C $Domino_ICC_Default_Dir/C
   ln -s $SP_ICC_Default_Dir/N $Domino_ICC_Default_Dir/N\n
Fore more information: http://www-01.ibm.com/support/docview.wss?uid=swg22016067\n";
	

our $Error_rm = "Error while trying to remove IBM Domino ICC lib symbolic link to IBM Spectrum Protect's ICC lib\n";
our $Error_rm_C = "Error while trying to remove $Domino_ICC_Default_Dir/C\n";
our $Error_rm_N = "Error while trying to remove $Domino_ICC_Default_Dir/N\n";

our $Error_rename_ICC_old = "Error while trying to rename $Domino_ICC_Default_Path.old\n";
our $Error_rename_C_old = "Error while trying to rename $Domino_ICC_Default_Dir/C_old\n";
our $Error_rename_N_old = "Error while trying to rename $Domino_ICC_Default_Dir/N_old\n";

our $Error_rename_ICC = "Error while trying to rename $Domino_ICC_Default_Path\n";
our $Error_rename_C = "Error while trying to rename $Domino_ICC_Default_Dir/C\n";
our $Error_rename_N = "Error while trying to rename $Domino_ICC_Default_Dir/N\n";

our $Error_mklink_ICC = "Error while trying to create a symbolic link to IBM Spectrum Protect's ICC library\n";
our $Error_mklink_C = "Error while trying to create a symbolic link to IBM Spectrum Protect's C directory\n";
our $Error_mklink_N = "Error while trying to create a symbolic link to IBM Spectrum Protect's N directory\n";

1;
