use Switch;
use File::Basename; 

use solve_gskit_incompatibility_SP_Domino;

#!/usr/bin/perl
# Modification Date: 10/12/2018 

open (my $logfile, '>>', "./solve_gskit_incompatibility_SP_Domino.log") or die "could not open log file:  $!";

sub printBoth
{
   print $_[0];
   print $logfile $_[0];     
}


my $datestring = localtime();
print $logfile "$datestring:\n";

if(defined $ARGV[0] && (!($ARGV[0] eq "fix")) && (!($ARGV[0] eq "preview")) && (!($ARGV[0] eq "revert")))
{
   printBoth $Error_Parameters;
   exit(0);
}


printBoth"\n";
printBoth"******************************************************************\n";
printBoth"***  IBM Spectrum Protect for Mail Data Protection for Domino  ***\n";
printBoth"***               GSKit compatibility verification             ***\n";
printBoth"******************************************************************\n\n";

if(!(defined $ARGV[0]))
{
   printBoth $Usage_Information_Message;
   exit(0);   
}
	
if(!(-e '/bin/gsk8ver_64'))
{
   printBoth $Global_GSKIT8_Not_Found;
   exit(0);
}	

switch ($os_name)
{
   case "aix"{printBoth $AIX_Message;}
   case "linux"{printBoth $Linux_Message;}
   case "zlinux"{printBoth $zLinux_Message;}
}

print $SP_GSKit_Version_Message;
	
if(-e $Domino_ICC_Default_Path)
{      
   if(-l $Domino_ICC_Default_Path)
   {
      printBoth $Domino_ICC_Lib_Symlink_Version_Message;
   }
   else
   {
      printBoth $Domino_ICC_Lib_Version_Message; 
   } 
}
else
{
   printBoth $Domino_ICC_Not_Found_Message;
   exit(0);
}
if(!(-d "$Domino_ICC_Default_Dir/C"))
{
   printBoth $Domino_C_Folder_Not_Found_Message;
   exit(0);
}
if(!(-d "$Domino_ICC_Default_Dir/N"))
{
   printBoth $Domino_N_Folder_Not_Found_Message;
   exit(0);
}

 
if(-e $SP_ICC_Default_Path)
{      
   printBoth $SP_ICC_Lib_Version_Message;   
}
else
{
   printBoth $SP_ICC_Not_Found_Message;
   exit(0);
}
if(!(-d "$SP_ICC_Default_Dir/C"))
{
   printBoth $SP_C_Folder_Not_Found_Message;
   exit(0);
}
if(!(-d "$SP_ICC_Default_Dir/N"))
{
   printBoth $SP_N_Folder_Not_Found_Message;
   exit(0);
}


if ($ARGV[0] eq "revert")
{
   if (-l $Domino_ICC_Default_Path)
   {
      if(!(-e "$Domino_ICC_Default_Path.old"))
      {
         printBoth $Domino_ICC_old_Not_Found_Message;
	     exit(0);
      }
      if(!(-d "$Domino_ICC_Default_Dir/C_old"))
      {
         printBoth $Domino_C_old_Folder_Not_Found_Message;
         exit(0);
      }
      if(!(-d "$Domino_ICC_Default_Dir/N_old"))
      {
         printBoth $Domino_N_old_Folder_Not_Found_Message;
         exit(0);
      }
      system("mv '$Domino_ICC_Default_Path.old' '$Domino_ICC_Default_Path'");
      if($? != 0)
      {
	     printBoth $Error_rename_ICC_old;
	     exit(12);
      }
      system("rm '$Domino_ICC_Default_Dir/C'");
      if($? != 0)
      {
         printBoth $Error_rm_C;
         exit(12);
      }
      system("mv '$Domino_ICC_Default_Dir/C_old' '$Domino_ICC_Default_Dir/C'");
      if($? != 0)
      {
         printBoth $Error_rename_C_old;
         exit(12);
      }
      system("rm '$Domino_ICC_Default_Dir/N'");
      if($? != 0)
      {
         printBoth $Error_rm_N;
         exit(12);
      }
      system("mv '$Domino_ICC_Default_Dir/N_old' '$Domino_ICC_Default_Dir/N'");
      if($? != 0)
      {
         printBoth $Error_rename_N_old;
         exit(12);
      }
      printBoth "$Revert_Successful_Message";
      exit(0);
   }
   else
   {
      printBoth $Domino_ICC_Not_Symbolic_Link_Message;
      exit(0);
   }
}


#Compare IBM Spectrum Protect's and IBM Domino's ICC lib versions
if($Version_ICC_SP eq $Version_ICC_Domino)
{
   printBoth $Same_ICC_Version_Message;
}
else
{
   my $res;
   switch ($os_name)
   {
      case "aix"{$res = qx(echo "$Version_ICC_SP\n$Version_ICC_Domino" | sort -t. -k 1,1n -k 2,2n -k 3,3n -k 4,4n | head -n 1 |egrep -c "$Version_ICC_SP");}
      case "linux"{$res = qx(echo -e "$Version_ICC_SP\n$Version_ICC_Domino" | sort -t. -k 1,1n -k 2,2n -k 3,3n -k 4,4n | head -n 1 |egrep -c "$Version_ICC_SP");}
      case "zlinux"{$res = qx(echo -e "$Version_ICC_SP\n$Version_ICC_Domino" | sort -t. -k 1,1n -k 2,2n -k 3,3n -k 4,4n | head -n 1 |egrep -c "$Version_ICC_SP");}
   }
   chomp $res;
   if($res eq "1") #$Version_ICC_SP is older than $Version_ICC_Domino
   {
      printBoth $Domino_ICC_Version_More_Recent_Message;
   }
   else
   {
      printBoth $SP_ICC_Version_More_Recent_Message;              
      switch ($ARGV[0])
      {
         case "preview"
         {
            printBoth $Commands_To_Execute_Message;
         }
         case "fix"
         {
            printBoth $Commands_To_Execute_Message;
            my $fix_choice = "";
            while($fix_choice ne "y" && $fix_choice ne "n"){
               printBoth "Do you want the commands above to be executed ? (y/n)\n"; 
               $fix_choice = <STDIN>;
               chomp $fix_choice;
            }
            if($fix_choice eq "n")
            {
               exit(0);
            }
            system("mv '$Domino_ICC_Default_Path' '$Domino_ICC_Default_Path.old'");
            if($? != 0)
            {	
               printBoth $Error_rename_ICC;
               exit(12);     
            } 
            system("mv '$Domino_ICC_Default_Dir/C' '$Domino_ICC_Default_Dir/C_old'");
            if($? != 0)
            {	
               printBoth $Error_rename_C;  
               exit(12);     
            } 
            system("mv '$Domino_ICC_Default_Dir/N' '$Domino_ICC_Default_Dir/N_old'");
            if($? != 0)
            {	
               printBoth $Error_rename_N;  
               exit(12);     
            } 
            system("ln -s $SP_ICC_Default_Path $Domino_ICC_Default_Path");
            if($? != 0)
            {	
               printBoth $Error_mklink_ICC;  
               exit(12);     
            }
            system("ln -s $SP_ICC_Default_Dir/C $Domino_ICC_Default_Dir/C");
            if($? != 0)
            {	
               printBoth $Error_mklink_C;  
               exit(12);     
            } 
            system("ln -s $SP_ICC_Default_Dir/N $Domino_ICC_Default_Dir/N");
            if($? != 0)
            {	
               printBoth $Error_mklink_N;  
               exit(12);     
            } 			   
            printBoth $Symbolic_Links_Created_Message;
         }
      }      
   }
}
