<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:dp="http://www.datapower.com/extensions"
    xmlns:regexp="http://exslt.org/regular-expressions"
    extension-element-prefixes="dp regexp"
    version="1.0">
    
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template
        match="/*[local-name()='definitions']/*[local-name()='types']/*[local-name()='schema']">
        <xsl:for-each select="*[local-name()='import']">
              <xsl:variable name="myURI" select="regexp:replace(dp:variable('var://service/URI'),'(.*)/(.*)?wsdl','i','$1/')"/>
              <xsl:variable name="location" select="concat(dp:variable('var://context/wsdl-fetch/host'),$myURI,@schemaLocation)"/>
              <dp:url-open target="{$location}"/>
        </xsl:for-each>
    </xsl:template>
    
    <!-- Copy everything else -->
    <xsl:template match="@*">
        <xsl:copy/>
    </xsl:template>
    
    <xsl:template match="*">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>
    
</xsl:stylesheet>
