<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:dp="http://www.datapower.com/extensions"
    xmlns:regexp="http://exslt.org/regular-expressions"
    xmlns:dpconfig="http://www.datapower.com/param/config"
    extension-element-prefixes="dp dpconfig regexp"
    version="1.0">
    
    <xsl:param name="dpconfig:mapping-file" select="'off'"/>
    <dp:param name="dpconfig:mapping-file" type="'dmFileToggle'" xmlns="">
    <tab-override>basic</tab-override>
    <display>Mapping file</display>
    <description>Select the mapping file to convert the URL's
    The default is local:///mappings.xml.</description>
    <default>local:///mappings.xml</default>
  </dp:param>

    <xsl:template match="/"> 
        <xsl:variable name="mappings" select="document($dpconfig:mapping-file)"/>
        <xsl:variable name="host_to_find" select="regexp:replace(dp:variable('var://service/URL-in'),'(.*)\?wsdl','i','$1')"/>
        <xsl:variable name="host" select="$mappings/mappings/mapping[@source=$host_to_find]/@target"/>
        <dp:set-variable name="'var://context/wsdl-fetch/host_to_find'" value="$host_to_find"/>
        <dp:set-variable name="'var://context/wsdl-fetch/host'" value="$host"/>
        <dp:set-variable name="'var://context/wsdl-fetch/wsdl-location'" value="concat($host,dp:variable('var://service/URI'))"/>
        <dp:url-open target="{dp:variable('var://context/wsdl-fetch/wsdl-location')}"/>
    </xsl:template>
    
</xsl:stylesheet>
