
/* 
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 * Licensed Materials - Property of IBM
 *
 * (C) Copyright IBM Corp. 2019 All Rights Reserved.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright Office.
 * 
 * THIS IS A SAMPLE PORGRAM, ONLY FOR REFERENCE. NOT RECOMMENDED FOR EXECUITION.
 * ===========================================================================
 */
package com.ibm.sklm.notification.sample;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Properties;

import javax.mail.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SampleEmailNotification {

	private static String smtpIp = null;
	private static String recipeintsMaildId = null;
	private static Properties props = System.getProperties();
	private static Session session = null;
	
	public static void main(String argv[]) {
		try {
			String propertyFileName = argv[0];
			if(propertyFileName == null) {
				throw new RuntimeException("Properties file path missing in arguement.");
			}
			ConfigHelper server = new ConfigHelper(propertyFileName);
			 String notificationFilePath = server.getProperty("notificationFilePath");
		     System.out.println("Notification FilePath : "+notificationFilePath);
			 smtpIp = server.getProperty("smtpServerIp");
			 recipeintsMaildId = server.getProperty("recipientsMailId");
			 System.out.println("Recipients : "+recipeintsMaildId);
			 props.put("mail.smtp.host", smtpIp);
			 session = Session.getInstance(props, null);
			getNewlyCreatedFile(notificationFilePath);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void sendEmailOnNewFile(File fXmlFile)
			throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
		Document doc = dBuilder.parse(fXmlFile);
		doc.getDocumentElement().normalize();

		System.out.println("Root element :" + doc.getDocumentElement().getNodeName());
		NodeList nList = doc.getElementsByTagName("Event");
		System.out.println("----------------------------");
		
		for (int temp = 0; temp < nList.getLength(); temp++) {
			Node nNode = nList.item(temp);
			System.out.println("\nCurrent Element :" + nNode.getNodeName());
			if (nNode.getNodeType() == Node.ELEMENT_NODE) {
				Element eElement = (Element) nNode;
				String eventCode = eElement.getElementsByTagName("EventCode").item(0).getTextContent();
				String eventData = eElement.getElementsByTagName("EventData").item(0).getTextContent();
				String eventSource = eElement.getElementsByTagName("EventSource").item(0).getTextContent();
				String eventTime = eElement.getElementsByTagName("EventDateTime").item(0).getTextContent();
				System.out.println("Event Data:" + eventData);
				System.out.println("Event Code:" + eventCode);
				System.out.println("Event Source:" + eventSource);
				
				System.out.println("Email Start");
				
				
				String Subject = "IMP : MultiMaster Notification " + eventCode + " from SKLM Master " + eventSource;
				String body = "Hello Admin," + "\n\nAn event has occurred on SKLM Master " + eventSource + "  at "
						+ eventTime + " which needs SKLM Administrator attention.\n\n" + eventData
						+ "\n\nPlease consult SKLM MultiMaster guide for further diagnostic" + "\n\nRegards"
						+ "\n\nNote: This is a system generated email, do not reply to this email";

				EmailUtil.sendEmail(session, recipeintsMaildId, Subject, body);

			}
		}
	}

	private static void getNewlyCreatedFile(String filePathToWatch) {
		System.out.println("In getNewlyCreatedFile");
		Path path = Paths.get(filePathToWatch);
		WatchService watchService;
		try {
			watchService = path.getFileSystem().newWatchService();
			path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
			WatchKey key;
			File fXmlFile;
			while ((key = watchService.take()) != null) {
				for (WatchEvent<?> event : key.pollEvents()) {
					System.out.println("Event kind:" + event.kind() + ". File affected: " + event.context() + ".");
					if (event.context().toString().contains(".xml")) {
						String fXmlFileStr = filePathToWatch+File.separator+event.context();
						fXmlFile = new File(fXmlFileStr);
						sendEmailOnNewFile(fXmlFile);
					}
				}
				key.reset();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
