
/* 
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 * Licensed Materials - Property of IBM
 *
 * (C) Copyright IBM Corp. 2019 All Rights Reserved.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright Office.
 * 
 * THIS IS A SAMPLE PORGRAM, ONLY FOR REFERENCE. NOT RECOMMENDED FOR EXECUITION.
 * ===========================================================================
 */
package com.ibm.sklm.notification.sample;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class ConfigHelper {
	
	 private Properties properties = new Properties();	
	 
	 private String propertyFileName = null;
	 
	 public ConfigHelper(String propertyFileName) {
		 this.propertyFileName = propertyFileName;
		 initializeServer();
	 }
	 
	 private void initializeServer() {
		 try {
			
			InputStream inStream = new FileInputStream(this.propertyFileName);
			if(inStream == null) {
				System.out.println("InStream is Null");
			}else {
				System.out.println("Found properties file");
			}
		    this.properties.load(inStream);
		 }catch(Exception ex) {
			 System.out.println("Fail to load Properties");
			 ex.printStackTrace();
			 throw new RuntimeException("Fail to load properties. Please check given path of properties file.");
		 }
	 }
	 
	 public String getProperty(String propName) {
		 return (String) this.properties.get(propName);
	 }
	 
}
