#!/bin/bash
# set -x
rm oc.dat
buildConfigurationCR () {
crtype=$1
crname=$2
crfile=$3
echo "apiVersion: appconnect.ibm.com/v1beta1" >> oc.dat
echo "kind: Configuration" >> oc.dat
echo "metadata:" >> oc.dat
echo "  name: ${crname}" >> oc.dat
echo "spec:" >> oc.dat
(echo -n "  data: "; base64 ${crfile}) >> oc.dat
echo "  type: ${crtype}" >> oc.dat
echo "---" >> oc.dat 
}
# create configurations
# types - type of each configuration to create
# files - name of the local file or directory to use when creating configuration
# names - names to use to reference the configuration by
types=("serverconf"              "keystore"             "policyproject"                  "setdbparms")
files=("https-server.conf.yaml"  "https-keystore.p12"   "forceServerHTTPSecurityProfile" "https-setdbparms.txt")
names=("https-server.conf.yaml"  "https-keystore.p12"   "https-policyproject.zip"        "https-setdbparms.txt")
for i in ${!names[@]}; do
  file=${files[$i]}
  if [[ -d ${files[$i]} ]]
  then
    zip -r ${file} ${file}
    file=${file}.zip 
  fi
  buildConfigurationCR ${types[$i]} ${names[$i]} ${file}
done
oc apply -f oc.dat
rm oc.dat

# patch integration server deployment to cause configuration to get reread.
oc patch deployment https-basic-auth-is --patch "spec: { template: { metadata: { annotations: { restartTime: \"`date`\" } } } }"
